------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                            E X P _ S P A R K                             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--          Copyright (C) 2011-2022, Free Software Foundation, Inc.         --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT; see file COPYING3.  If not, go to --
-- http://www.gnu.org/licenses for a complete copy of the license.          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

--  This package implements a light expansion which is used in GNATprove mode.
--  Instead of a complete expansion of nodes for code generation, this light
--  expansion targets generation of intermediate code for formal verification.

--  Expand_SPARK is called directly by Expander.Expand.

with Types; use Types;

package Exp_SPARK is

   procedure Expand_SPARK (N : Node_Id);

   procedure Expand_SPARK_Potential_Renaming (N : Node_Id);
   --  N must denote an N_Expanded_Name or N_Identifier. If N is a reference to
   --  a renaming, replace N with the renamed object.

end Exp_SPARK;
