/* =============================
 * $Header: /home/users/toyoda/c/tgi/xplotlib/RCS/xplot.h,v 1.1 1996/02/23 17:37:26 toyoda Exp toyoda $
 * ============================= */

#ifndef XPLOT_H
#define XPLOT_H 1

/* ------------------
   X-Window definition
   only needed for library extention source.
------------------ */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

extern Display *_pl_dpy;
extern Window root,_pl_win;
extern GC _pl_gc;

/* ------------------
   function prototype
 * ------------------ */

/* these functions are for library extention. */
extern int Sx();
extern int Sy();
extern int Sdx();
extern int Sdy();
extern int CheckOpenpl();
extern int CheckClosepl();

extern int _pl_black, _pl_white;
extern int _pl_fontload();
extern double _pl_aspect();
extern int _pl_cpx, _pl_cpy;

/* mainbody */
extern int setargument();
extern int setwindowsize();
extern int settitle();
extern int setbackcolor();
extern int setcolor();

/* unixplot compatible */
extern int linemod();
extern int openpl();
extern int erase();
extern int closepl();
extern int space();
extern int move();
extern int cont();
extern int line();
extern int circle();
extern int label();
extern int arc(); 

/* shoji-xplot compatible */
extern int xflush();
extern int xwait();
extern int hako();
extern int peke();
extern int number();
extern int ellip();

/* float_argument-ized unixplot routine */

extern int fmove();
extern int fspace();
extern int fcont();
extern int fpoint();
extern int fline();
extern int fcircle();
extern int farc();

extern int frectangle();
extern int fellip();

/* new definition */
extern int rectangle();

extern int fillmod();
extern int fillellip();
extern int fillarc();
extern int fillcircle();
extern int fillrectangle();

/* macros */
#define radtodeg(deg)   (fmod(deg,2*PI)*180.0/PI)
#define PI              3.141592653589793
#define eputs(s) ((void)fputs(s,stderr))

#endif
    /* XPLOT_H */

/*
 * $Log: xplot.h,v $
 * Revision 1.1  1996/02/23 17:37:26  toyoda
 * Initial revision
 *
 * Revision 1.8  1994/08/11  10:57:33  ss56214
 * Why?
 *
 * Revision 1.7  1994/08/11  09:52:58  ss56214
 * eputs() macro adopted.
 *
 * Revision 1.7  1994/08/11  09:52:58  ss56214
 * eputs() macro adopted.
 *
 * Revision 1.6  1994/08/11  09:24:41  ss56214
 * style check,
 * rename variables.
 *
 * Revision 1.5.1.1  1994/08/11  01:58:08  prasinos
 * Initial revision
 *
 * Revision 1.5  1994/08/10  13:28:16  ss56214
 * style.
 *
 * Revision 1.4  1994/08/10  08:43:56  ss56214
 * rename some var.s:
 * 	adding _pl_
 *
 * Revision 1.3  1994/08/09  13:32:32  ss56214
 * i found keyword substitution of RCS!
 *
 */
