/* ================================================
 * xplot.c --- unixplot library for X
 * $Header: /home/users/toyoda/c/tgi/xplotlib/RCS/xplot.c,v 1.1 1996/02/23 17:37:26 toyoda Exp toyoda $
 * ================================================ */

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <math.h>
#include <string.h>
#include "xplot.h"

#define X_AXIS   600
#define Y_AXIS   600
#define ICONAMELEN 10
#define WINNAMELEN 64
/* exit() value */
#define NO_OPENPL_EXIT 2

/* internal compilation flag */
#define USE_BACKINGSTORE

#define streq(s,ex) (strcmp(s,ex) == 0)

/* =================
 * global variables
 * ================= */

/*
 * used once or a few times
 * mainly for inter-function communication
 */

/*
 * openpl() only, but static-ized for future extention.
 * non-static var. is intentional.
 */
static int			screen;
static XSizeHints	size_hints;
Window				root;
XTextProperty		XTxtPrp_Window, XTxtPrp_Icon;

/*
 * used openpl() closepl() xwait() separately --- idens in nomine.
 */
static XEvent		event;

/*
 * openpl() closepl() --> CheckOpenpl() CheckClosepl()
 * to detect wrong programming that causes coredump
 */
static int			WinOpened = 0;

/*
 * _pl_fontload() --> closepl()
 */
static int			FONTcomeyet = 0;
static XFontStruct	*font;

/*
 * _pl_fontload() only, but static-ized for future extention
 */
static char			*fontname = "fixed";

/*
 * setdisplay() --> openpl()
 */
static char			dpy_location[ WINNAMELEN ] = "";

/*
 * settitle() --> openpl()
 */
static char			_pl_window_name[WINNAMELEN]
						= "Xplot Application";
static char			_pl_icon_name[ICONAMELEN] = "Xplot";

/*
 * setwindowsize() openpl() --> Sx()-series space()
 * the size of the window
 */
static unsigned		xlen = X_AXIS;
static unsigned		ylen = Y_AXIS;

/*
 * space() --> Sx()-series
 */
static int			spx0, spy0;
static int			spdx = X_AXIS;
static int			spdy = Y_AXIS;
static double		aspect_ratio = 1.0;

/*
 * move() --> label() cont()
 * current graphical point
 * having external linkage
 */
int					_pl_cpx, _pl_cpy;

/*
 * for communication with fill library
 */
int					_pl_black, _pl_white;

/*
 * used in many functions
 */
Display				*_pl_dpy;
Window				_pl_win;
GC					_pl_gc;
int			_pl_wait_mouse = 1;

/* ==================
 * library internal function
 * No good user use these functions explicitly.
 * ================== */

/* getaspectratio():
 * the name is taken from Turbo C
 */
	double
getaspectratio()
{ return aspect_ratio; }

/* S*():
 * logical --> pixel coordinate converter
 */
	int
Sx(x)
{ return (int)((float)(x - spx0)* xlen /spdx); }

	int
Sdx(x)
{ return (int)((float)x * xlen / spdx); }

	int
Sy(y)
{ return (int)(ylen - ((float)(y - spy0) * ylen / spdy)); }

	int
Sdy(y)
{ return (int)((float)y * ylen / spdy); }

/*
 * plot-window open/close check
 */
	int
CheckOpenpl()
{
	if (!WinOpened) {
		eputs("xplot fatal: calling X-Window without openpl().\n");
		exit(NO_OPENPL_EXIT);
	};
	return 0;
}

	int
CheckClosepl()
{ return WinOpened; }

/*
 * set... routine
 * alter default settings for openpl()
 */
	int
setwindowsize(yoko, tate)
	unsigned int yoko, tate;
{
	if (CheckClosepl()) {
		eputs("xplot: setwindowsize() after openpl()\n");
		return -1;
	};
	xlen = yoko; ylen = tate; return 0;
}

	int
settitle(wintitle, icotitle)
	char *wintitle, *icotitle;
{
	void setWMInfo();
	if (wintitle != NULL)
		(void)strncpy(_pl_window_name, wintitle, WINNAMELEN);
	if (icotitle != NULL)
		(void)strncpy(_pl_icon_name, icotitle, ICONAMELEN);
	if (CheckClosepl()) {
		setWMInfo();
	};
	return 0;
}

	int
setdisplay(display_loc)
	char *display_loc;
{
	if (CheckClosepl()) {
		eputs("xplot: setdisplay() after openl()\n");
		return -1;
	};
	if (display_loc != NULL)
		(void)strncpy(display_loc, dpy_location, WINNAMELEN);
	return 0;
}

/*	setbackcolor():
 *	return non-zero in case of failure.
 */
	int
setbackcolor(col)
	char *col;
{
	Colormap	colmap;
	XColor		ca,cb;
	
	CheckOpenpl();
	/* Get default color map */
	colmap = XDefaultColormap(_pl_dpy,0);
	/* allocate named color */
	if (XAllocNamedColor(_pl_dpy,colmap,col,&ca,&cb) == 0) {
		eputs("xplot: invalid color name:");
		eputs(col);
		eputs(": background unchanged\n");
		return 1;
	} else {
		XSetBackground(_pl_dpy,_pl_gc,ca.pixel);
		return 0;
	};
}


/*	setcolor():
 *	return non-zero in case of failure.
 */
	int
setcolor(col)
	char *col;
{
	Colormap	colmap;
	XColor		ca,cb;
	
	CheckOpenpl();
	/* Get default color map */
	colmap = XDefaultColormap(_pl_dpy,0);
	/* allocate named color */
	if (XAllocNamedColor(_pl_dpy,colmap,col,&ca,&cb) == 0) {
		eputs("xplot: invalid color name:");
		eputs(col);
		eputs(": foreground unchanged\n");
		return 1;
	} else {
		XSetForeground(_pl_dpy,_pl_gc,ca.pixel);
		return 0;
	};
}

	int
_pl_fontload()
{
	/* FONTcomeyet indicates whether Font is active or not. */
	if (FONTcomeyet == 0 ) {
		FONTcomeyet = 1;    /* Font is on use */
		font = XLoadQueryFont(_pl_dpy,fontname);
		XSetFont(_pl_dpy,_pl_gc,font->fid);
	}
	return 0;
}

label(s)  /* (unixplot compatible) */
char *s;
{
    int sx,sy,width,len;
    sx = Sx(_pl_cpx);
    sy = Sy(_pl_cpy);
    
    CheckOpenpl();
    _pl_fontload();
    width = font->max_bounds.width;
    len = strlen(s);
    XDrawString(_pl_dpy,_pl_win,_pl_gc,sx,sy,s,len);
    _pl_cpx += (float)len * width / xlen * spdx;
    return 0;
}


/* ===================
 * Big-baggage routine
 * =================== */

	static void
setWMInfo()
{
	XWMHints wm_hints;
	XClassHint class_hints;
	char *name;
	/*
	 *	size information
	 */
	size_hints.flags = PPosition | PSize | PMinSize;
	size_hints.min_width = xlen;
	size_hints.min_height = ylen;
	/*
	 *	name info
	 */
	name = _pl_window_name;
	if (XStringListToTextProperty(&name,1,&XTxtPrp_Window)==0) {
		eputs("xplot: X11 library error.\n");
		exit(-1);
	}
	name = _pl_icon_name;
	if (XStringListToTextProperty(&name,1,&XTxtPrp_Icon) == 0) {
		eputs("xplot: X11 library error.\n");
		exit(-1);
	}
	wm_hints.initial_state = NormalState;
	wm_hints.input = True;
	/* wm_hints.icon_pixmap = icon_pixmap; --- undefined */
	wm_hints.flags = StateHint | IconPixmapHint | InputHint;
	class_hints.res_name = "Xplot.o by Anemos Prasinos";
	class_hints.res_class = "Xplot.o by Anemos Prasinos";
	XSetWMProperties(_pl_dpy, _pl_win, &XTxtPrp_Window, &XTxtPrp_Icon,
		NULL, 0, &size_hints, &wm_hints, &class_hints);
}

	int
openpl()  /* (unixplot compatible) */
{
	/* for XGetGeometry dummy variables */
	int x,y;			/* NorthWest pixel coord. */
	unsigned bw,depth;	/* border_width, depth */
	
	if (WinOpened != 0) {
		eputs("xplot: openpl() called twice\n");
		return -1;
	}
	/* connect to X server */ 
	_pl_dpy = XOpenDisplay( dpy_location );
	if( _pl_dpy == NULL ) {
		eputs("cannot open ");
		eputs(getenv("DISPLAY"));
		eputs(" (X-window server)\n");
		exit(1);
	}
	/* set ROOT window as a default */
	root = XDefaultRootWindow(_pl_dpy);
	/* set SCREEN as a default      */
	screen = XDefaultScreen(_pl_dpy);
	_pl_black = XBlackPixel(_pl_dpy,screen);	/* kuro iro  */
	_pl_white = XWhitePixel(_pl_dpy,screen);	/* shiro iro */
	/* Open window for INPUT/OUTPUT(This is normal) */
	_pl_win = XCreateSimpleWindow(_pl_dpy,root,
		0,0,xlen+1,ylen+1,1,_pl_black,_pl_white);
	/* */
	setWMInfo();
	/* */
	XSelectInput(_pl_dpy,_pl_win,
		ExposureMask | ButtonPressMask | ButtonReleaseMask
		| Button1MotionMask );
#ifdef USE_BACKINGSTORE
	{
		XSetWindowAttributes att;
		att.backing_store = Always;
		XChangeWindowAttributes(_pl_dpy,_pl_win,CWBackingStore, &att);
	}
#endif
	_pl_gc = XCreateGC(_pl_dpy,_pl_win,0,NULL);  /* use graphic */
	XSetForeground(_pl_dpy,_pl_gc,_pl_black);
/*	XSetFunction(_pl_dpy,_pl_gc,GXxor);  */
	XMapWindow(_pl_dpy,_pl_win);
	/* wait for the window open in real screen */
    XNextEvent(_pl_dpy,&event);
	XGetGeometry(_pl_dpy,_pl_win,&root,&x,&y,&xlen,&ylen,&bw,&depth);
	WinOpened = 1;
	return 0;
}

closepl()
{
	if (_pl_wait_mouse)
		xwait();
	if (WinOpened == 0) {
		eputs("xplot: closepl() without openpl()\n");
		return -1;
	}
	if(FONTcomeyet) XFreeFont(_pl_dpy,font);
	XFreeGC(_pl_dpy,_pl_gc);
	XDestroyWindow(_pl_dpy,_pl_win);
	XCloseDisplay(_pl_dpy);
	return 0;
}

/* ======================
 * rather-deep commands
 * ====================== */

space(x1,y1,x2,y2)  /* (unixplot compatible) */
int x1,y1,x2,y2;
{
	int dx,dy;
	int retval = 0;
	dx = x2 - x1;
	dy = y2 - y1;
	if ((dx==0)&&(dy==0)) {			/* crasy case...ZENBU OMAKASE */
		dx = xlen;
		dy = ylen;
		retval = 3;
	};
	if (dx==0) {
		dx = dy * xlen / ylen;		/* dy is 0...OMAKASE */
		retval = 1;
	};
	if (dy==0) {
		dy = dx * ylen / xlen;		/* dx is 0 */
		retval = 2;
	};
	/* set result to external variable */
	spdx = dx, spdy = dy, spx0 = x1, spy0 = y1;
	aspect_ratio = (double)xlen/(double)spdx*(double)spdy/(double)ylen;
	if (retval)
		{ aspect_ratio = 1.0; };
	return retval;
}

move(x,y)  /* (unixplot compatible) */
int x,y;
{
	_pl_cpx = x,  _pl_cpy = y;
	return 0;
}

linemod(s)  /* (unixplot compatible) */
char *s;
{
	int type,num;
	/* line style data */
	static char line[5][4]={{10},{3,3},{7,3},{20,5},{20,3,3,3}};
	
	CheckOpenpl();
	/*
	 *	color extension
	 */
	if (strncmp(s,"c.",2) == 0) {
		setcolor(s+2);
		return 0;
	}
	/*
	 *	proper routine - dash length
	 */
	if(streq(s,"dotted")) {
		type=1; num=2;
	} else if(streq(s,"shortdashed")) {
		type=2; num=2;
	} else if(streq(s,"longdashed")) {
		type=3; num=2;
	} else if(streq(s,"dotdashed")) {
		type=4; num=4;
	} else {
		type=0; num=1;
	};
	XSetDashes(_pl_dpy,_pl_gc,0,line[type],num);
	/*
	 *	line attribute corresponding to dash or solid.
	 */
	if( strcmp(s,"solid") == 0 ) {
		XSetLineAttributes(_pl_dpy,_pl_gc,1,LineSolid,CapButt,JoinMiter);
	} else {
		if (type==0) type = -1;
		XSetLineAttributes(_pl_dpy,_pl_gc,1,LineOnOffDash,CapButt,JoinMiter);
	};
	return type;
}

/* mouse button wait routine */
xwait()
{
	CheckOpenpl();
	settitle("Xplot Application(waiting click)", "Xplot");
	XSelectInput(_pl_dpy,_pl_win,ButtonPressMask);
	XNextEvent(_pl_dpy,&event);
	settitle("Xplot Application", "Xplot");
	return 0;
}

/*
 * $Log: xplot.c,v $
 * Revision 1.1  1996/02/23 17:37:26  toyoda
 * Initial revision
 *
 * Revision 1.12  1994/08/12  15:30:10  ss56214
 * window title makes "click Window to exit" when closepl() is called.
 *
 * Revision 1.11  1994/08/11  10:57:33  ss56214
 * Why?
 *
 * Revision 1.10  1994/08/11  10:36:59  ss56214
 * linemod("c.red") ---> setcolor("red") extention.
 *
 * Revision 1.10  1994/08/11  10:36:59  ss56214
 * linemod("c.red") ---> setcolor("red") extention.
 *
 * Revision 1.9  1994/08/11  09:52:58  ss56214
 * eputs() macro adopted.
 *
 * Revision 1.8  1994/08/11  09:24:41  ss56214
 * style check,
 * rename variables.
 *
 * Revision 1.7.1.4  1994/08/11  03:52:00  prasinos
 * style check.
 *
 * Revision 1.7.1.3  94/08/11 03:34:06  prasinos
 * rename inner_window_name to _pl_window_name (unify)
 * 
 * Revision 1.7.1.2  94/08/11 03:26:32  prasinos
 * rename of XTextProperty type var.s.
 * 
 * Revision 1.7.1.1  94/08/11 03:16:08  prasinos
 * Initial revision
 * 
 * Revision 1.7  1994/08/10  12:26:27  ss56214
 * bug fix:
 *  string comparison with "" doesn't work.
 *  "" ---> NULL
 *
 * Revision 1.6  1994/08/10  08:43:56  ss56214
 * rename some var.s:
 * 	adding _pl_
 *
 * Revision 1.5  1994/08/10  02:04:49  ss56214
 * setcolor() implemented.
 * setbackcolor() doesn't work. i wonder why???
 *
 * Revision 1.4  1994/08/09  13:32:32  ss56214
 * i found keyword substitution of RCS!
 *
 */
