/*
 * $Header: /home/users/toyoda/c/tgi/xplotlib/RCS/test.c,v 1.1 1996/02/23 17:37:26 toyoda Exp toyoda $
 */

#include <stdio.h>
#include <math.h>

#define spaceinit()	space(0,0,100,100)

	void
drawsin(color, lmod, ox, oy)
	char *color, *lmod;
	double ox, oy;
{
	double t;
	fspace(-1.1, -1.1, 1.1, 1.1);
	setcolor(color);
	linemod(lmod);
	for (t=0.0; t<100.0; t+=1.0) {
		fcont(sin(ox*t),sin(oy*t));
	}
	spaceinit();
}

	void
roundfan()
{
	int xa,xb,ya,yb;
	double t;
	space(-100,-100,100,100);
	fillmod("solid");
	for (t=0.0; t<6.0; t+=0.5) {
		xa = 80 * sin(t);
		ya = 80 * cos(t);
		xb = 80 * sin(t+2.3);
		yb = 80 * cos(t+2.3);
		setcolor("green");
		fillarc(0,0,xa,ya,xb,yb);
		setcolor("white");
		fillarc(0,0,xb,yb,xa,ya);
		xflush();
	}
	spaceinit();
}

	void
billiard()
{
	int t, x, y, vx, vy;
	vx = 16;  vy = 13;
	x = y = 1;
	spaceinit();
	for (t=0; t<100; t++) {
		if ((x > 100 && vx > 0)
			|| (x < 0 && vx < 0)) {
			vx = -vx;
			setcolor("red");
		};
		if ((y > 100 && vy > 0)
			|| (y < 0 && vy < 0)) {
			vy = -vy;
			setcolor("green");
		}
		x += vx;
		y += vy;
		hako(x,y);
	}
}

main()
{
	settitle("xplot test","test");
	openpl();
	spaceinit();
	arc(50,50,90,50,0,0);
	xwait();
	setcolor("red");
	fillmod("gray");
	fillarc(50,50,90,50,0,0);
	drawsin("black", "dotted", 0.1533, 0.3432);
	xwait();
	erase();
	setbackcolor("red");
	drawsin("green", "longdashed", 1.7, 3.44);
	setcolor("blue");
	fillmod("stripe");
	fillarc(50,50,90,50,0,0);
	xwait();
	erase();
	roundfan();
	erase();
	billiard();
	xwait();
	closepl();
	return 0;
}

/*
 * $Log: test.c,v $
 * Revision 1.1  1996/02/23 17:37:26  toyoda
 * Initial revision
 *
 * Revision 1.7  1994/08/12  15:30:10  ss56214
 * bug fix:
 * xwait() just before closepl().
 *
 * Revision 1.6  1994/08/11  10:57:33  ss56214
 * Why?
 *
 * Revision 1.5  1994/08/11  10:36:59  ss56214
 * linemod("c.red") ---> setcolor("red") extention.
 *
 * Revision 1.5  1994/08/11  10:36:59  ss56214
 * linemod("c.red") ---> setcolor("red") extention.
 *
 * Revision 1.4  1994/08/11  09:24:41  ss56214
 * style check,
 * rename variables.
 *
 * Revision 1.4  1994/08/11  09:24:41  ss56214
 * style check,
 * rename variables.
 *
 * Revision 1.3  1994/08/10  12:26:27  ss56214
 * return 0; !!!
 *
 * Revision 1.2  1994/08/10  08:43:56  ss56214
 * enhancement
 *
 * Revision 1.1  1994/08/10  02:06:33  ss56214
 * Initial revision
 *
 */
