/* geom.c: quick hack to support geometry */

struct _tgi_xconf_t {
	int		screen;
	Display		*dpy;
	Window		root, mywin;
	XEvent		event;
	unsigned long	blackpix, whitepix;
	int		x, y;
	unsigned	xlen, ylen;
} _tgi_xconf;

#define	it _tgi_xconf

#define	DEFAULTSIZE	600
#define	DEFAULTSPACE	10
	static void
setgeometry(geom)
	char	*geom;
{
	int	flags;
	it.x = DisplayWidth(it.dpy, it.screen) - DEFAULTSPACE - DEFAULTSIZE;
	it.y = DEFAULTSPACE;
	it.xlen = DEFAULTSIZE, it.ylen = DEFAULTSIZE;
	flags = XParseGeometry(geom, &it.x, &it.y, &it.xlen, &it.ylen);
	if ((flags & XValue) && (flags & XNegative))
		it.x += DisplayWidth(it.dpy, it.screen) - it.xlen;
	if ((flags & YValue) && (flags & YNegative))
		it.y += DisplayHeight(it.dpy, it.screen) - it.ylen;
	if (it.xlen == 0 || it.ylen == 0)
		it.xlen = DEFAULTSIZE, it.ylen = DEFAULTSIZE;
	fprintf(stderr, "%d %d %d %d\n", it.x, it.y, it.xlen, it.ylen);
}

	static void
setwminfo()
{
	XSizeHints	hint;
	hint.x = it.x;
	hint.y = it.y;
	hint.width = it.xlen;
	hint.height = it.ylen;
	hint.flags = USPosition | USSize;
	XSetWMNormalHints(it.dpy, it.mywin, &hint);
}
