#!/bin/nawk -f
#
# $Header: /home/users/toyoda/c/tgi/xplotlib/RCS/ca.awk,v 1.1 1996/02/23 17:37:26 toyoda Exp toyoda $
#
BEGIN {
	if (list || rm) notmake = 1;
	if (list) notverb = 1;
	if (!notverb) printf "%s:\n", FILENAME;
	outf = tmpf = "/tmp/ca_" rand();
	files = 0;
}

/^=#/ { next }

/^=common/ {
	if (!notverb) printf "common ";
	outf = tmpf;
	next;
}

/^=split/ {
	outf = $2;
	if (!(outf in filelist)) {
		filehdr(outf);
	}
	next;
}

/^=end/ { exit }

/^=/ { next }

{
	if (notmake) next;
	print >> outf;
}

END {
	if (!notverb) print "";
	if (!notmake) system("rm " tmpf);
}

function filehdr(outf)
{
	if (rm) {
		print("/bin/rm " outf);
		system("/bin/rm " outf);
	} else if (notmake) {
		print outf;
	} else {
		system("/bin/cp " tmpf " " outf);
		files++;
		filelist[files] = outf;
		printf "%s ", outf;
	}
}

#
# $Log: ca.awk,v $
# Revision 1.1  1996/02/23 17:37:26  toyoda
# Initial revision
#
# Revision 1.5  1994/08/11  10:57:33  ss56214
# Why?
#
# Revision 1.4  1994/08/11  10:36:59  ss56214
# linemod("c.red") ---> setcolor("red") extention.
#
# Revision 1.4  1994/08/11  10:36:59  ss56214
# linemod("c.red") ---> setcolor("red") extention.
#
# Revision 1.3  1994/08/10  04:21:27  ss56214
# =end is termination.
#
# Revision 1.3  1994/08/10  04:21:27  ss56214
# =end is termination.
#
# Revision 1.2  1994/08/10  04:19:05  ss56214
# bug fix: ignore inacsessible "^=" command.
#
# Revision 1.1  1994/08/10  03:29:40  ss56214
# Initial revision
#
#
