#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

#define	eputs(s)		(void)fputs(s, stderr)

struct _tgi_xconf_t {
	int		screen;
	Display		*dpy;
	Window		root, mywin;
	XEvent		event;
	unsigned long	blackpix, whitepix;
	int		x, y;
	unsigned	xlen, ylen;
} _tgi_xconf;

#define	it _tgi_xconf

#define	DEFAULTSIZE	600
#define	DEFAULTSPACE	10
	static void
setgeometry(geom)
	char	*geom;
{
	int	flags;
	it.x = DisplayWidth(it.dpy, it.screen) - DEFAULTSPACE - DEFAULTSIZE;
	it.y = DEFAULTSPACE;
	it.xlen = DEFAULTSIZE, it.ylen = DEFAULTSIZE;
	flags = XParseGeometry(geom, &it.x, &it.y, &it.xlen, &it.ylen);
	if ((flags & XValue) && (flags & XNegative))
		it.x += DisplayWidth(it.dpy, it.screen) - it.xlen;
	if ((flags & YValue) && (flags & YNegative))
		it.y += DisplayHeight(it.dpy, it.screen) - it.ylen;
	if (it.xlen == 0 || it.ylen == 0)
		it.xlen = DEFAULTSIZE, it.ylen = DEFAULTSIZE;
	fprintf(stderr, "%d %d %d %d\n", it.x, it.y, it.xlen, it.ylen);
}

	static void
setwminfo()
{
	XSizeHints	hint;
	hint.x = it.x;
	hint.y = it.y;
	hint.width = it.xlen;
	hint.height = it.ylen;
	hint.flags = USPosition | USSize;
	XSetWMNormalHints(it.dpy, it.mywin, &hint);
}

	int
main()
{
	unsigned	bw, depth;
	it.dpy = XOpenDisplay(NULL);
	if (it.dpy == NULL) {
		eputs(getenv("DISPLAY"));
		eputs(": cannot open display\n");
		return 1;
	}
	it.screen = XDefaultScreen(it.dpy);
	it.blackpix = BlackPixel(it.dpy, it.screen);
	it.whitepix = WhitePixel(it.dpy, it.screen);
	it.root = XDefaultRootWindow(it.dpy);
	setgeometry((char *)"300x300+100+100");
	it.mywin = XCreateSimpleWindow(it.dpy, it.root,
		it.x, it.y, it.xlen, it.ylen, 1,
		it.blackpix, it.whitepix);
	setwminfo();
	XSelectInput(it.dpy, it.mywin,
		ExposureMask | ButtonPressMask);
/**/
		eputs("press RETURN to continue\n"); (void)getchar();
		eputs("map stage\n");
	XMapWindow(it.dpy, it.mywin);
		eputs("map request...");
	XNextEvent(it.dpy, &it.event);
		eputs("got event\n");
/**/
		eputs("press RETURN to exit\n"); (void)getchar();
	XDestroyWindow(it.dpy, it.mywin);
	XCloseDisplay(it.dpy);
	return 0;
}
