/*
	Reducing Plotter Command
	'plotreduce.c'
		Ver 2.0    (6/17 '89)
			(C) Mik
	X-Window version (v0.0: 94/01/20-)
	$Header: /home/users/toyoda/c/tgi/necplot/RCS/plotreduce.c,v 1.3 1994/08/12 15:56:01 ss56214 Exp toyoda $
		        (C) TOYODA Eizi
*/
#include <stdio.h>

extern	int		p_flag;
extern	char	*t_flag;

/*
 *	flush_output():
 */
	static void
flush_output()
{
#ifdef XPLOT
	if (!p_flag) xflush();
#else
	fflush(stderr);
#endif
}

/*
 Plot main loutine
	input	input file stream pointer
	return	no error	1
		error		-1
*/
plot_main(fp)
	FILE	*fp;
{
	int	c;
	int	i;
	int	data[100];

	/* main loop */
	if (! p_flag) {
#ifdef XPLOT
		if (streq("", t_flag)) {
			settitle("xplot(unixplot viewer)","xplot");
		} else {
			settitle(t_flag, t_flag);
		}
#endif
	   openpl();
	};
	while ((c = getc(fp)) != EOF) {
		switch(c) {
		case 'm':
			for(i = 0; i < 4; i++) {
				data[i] = getc(fp);
			}
			PLT_move(data[0]+data[1]*256,data[2]+data[3]*256);
			break;
		case 'n':
			for(i = 0; i < 4; i++) {
				data[i] = getc(fp);
			}
			PLT_cont(data[0]+data[1]*256,data[2]+data[3]*256);
			break;
		case 'p':
			for(i = 0; i < 4; i++) {
				data[i] = getc(fp);
			}
			PLT_point(data[0]+data[1]*256,data[2]+data[3]*256);
			break;
		case 'l':
			for(i = 0; i < 8; i++) {
				data[i] = getc(fp);
			}
			PLT_line(data[0]+data[1]*256,data[2]+data[3]*256,
			     data[4]+data[5]*256,data[6]+data[7]*256);
			break;
		case 't':
			for(i = 0; (data[i]=getc(fp)) != '\n'; i++);
			PLT_label(data);
			flush_output();
			break;
		case 'a':
			for(i = 0; i < 12; i++) {
				data[i] = getc(fp);
			}
			PLT_arc(data[0]+data[1]*256,data[2]+data[3]*256,
			    data[4]+data[5]*256,data[6]+data[7]*256,
			    data[8]+data[9]*256,data[10]+data[11]*256);
			break;
		case 'c':
			for(i = 0; i < 6; i++) {
				data[i] = getc(fp);
			}
			PLT_circle(data[0]+data[1]*256,data[2]+data[3]*256,
			       data[4]+data[5]*256);
			break;
		case 'e':
			PLT_erase();
			break;
		case 'f':
			for(i = 0; (data[i]=getc(fp)) != '\n'; i++);
			PLT_linemod(data);
			flush_output();
			break;
		case 's':
			for(i = 0; i < 8; i++) {
				data[i] = getc(fp);
			}
			PLT_space(data[0]+data[1]*256,data[2]+data[3]*256,
			      data[4]+data[5]*256,data[6]+data[7]*256);
			flush_output();
			break;
		default:
			fprintf(stderr,"Unkown command '%c'\n",c);
			if (! p_flag) { closepl(); };
			return(-1);
		}
	}
	if (! p_flag) { closepl(); };
	return (1);
}

/*
 * $Log: plotreduce.c,v $
 * Revision 1.3  1994/08/12 15:56:01  ss56214
 * bug fix:
 * 	X version: un-openpl()-ed X access.
 *
 * Revision 1.2  1994/08/11  20:42:50  ss56214
 * style change,
 * flush output to synclonize data, particularly in X version.
 * (xplot library abolished flushing to improve efficiency).
 *
 * Revision 1.1  1994/08/11  13:50:25  ss56214
 * Initial revision
 *
 */
