/*
	$Header: /home/users/toyoda/c/tgi/necplot/RCS/plotmedia.c,v 1.3 1996/02/20 10:48:24 toyoda Exp toyoda $
    plotter command --> X-Window or ascii splitter
	plotmedia.c
	stolen from hterm_draw.c of htermplot
        hterm plotter draw package
                Ver 1.0   (6/17 '89)
                        (C) Mik
*/

#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <math.h>

#define ESC 0x1b

/* Debug print flag */
extern	int	p_flag;

/* output buffer */
static	char	buff[512];

/* Move current point */
PLT_move(x,y)
int	x,y;
{
	if(p_flag) {
	  fprintf(stdout,"move %d %d\n",x,y);
	} else {
	  move(x,y);
	};
}

/* Continue line draw */
PLT_cont(x,y)
int	x,y;
{
	if(p_flag) {
	  fprintf(stdout,"ncont %d %d\n",x,y);
	} else {
	  cont(x,y);
	};
}

/* point draw */
PLT_point(x,y)
int	x,y;
{
	if(p_flag) {
	  fprintf(stdout,"point %d %d\n",x,y);
	} else {
	  point(x,y);
	};
}

/* Line draw */
PLT_line(x1,y1,x2,y2)
int	x1,y1,x2,y2;
{
	if (p_flag) {
		fprintf(stdout,
			"line %d %d %d %d\n",x1,y1,x2,y2);
	 } else {
	   line(x1,y1,x2,y2);
	 };
}

/* label draw */
PLT_label(data)
int	*data;
{
	int	i;
	char	local_label[101];

	for (i = 0; i < 100; i++) {
		if (data[i] == (int)('\n'))
			break;
		local_label[i] = (char)(data[i]);
	};
	local_label[i] = '\0';
	if(p_flag) {
	        fprintf(stdout,"tlabel %s\n",local_label);
	      } else {
		char mimi[100];
		sprintf(mimi,"%s",local_label);
		label(local_label);
	      };
}

/* arc draw */
PLT_arc(xc,yc,xs,ys,xe,ye)
int	xc,yc,xs,ys,xe,ye;
{
	if(p_flag) {
		fprintf(stdout,
			"arc %d %d %d %d %d %d\n",
			xc,yc,xs,ys,xe,ye);
	      } else {
		arc(xc,yc,xs,ys,xe,ye);
	      };
}

/* circle draw */
PLT_circle(x,y,r)
int	x,y,r;
{
	if(p_flag) {
		fprintf(stdout,"circle %d %d %d\n",x,y,r);
	} else {
	  circle(x,y,r);
	};
}

/* erase */
PLT_erase()
{
	if(p_flag) {
		fprintf(stdout,"erase\n");
	}	else {
	  erase();
	};
}

/* Linemode */
PLT_linemod(data)
int	*data;
{
	int	i;
	char	mod[100];

	for(i = 0; i < 100; i++) {
		if(data[i] == (int)('\n'))
			break;
		mod[i] = (char)data[i];
	};
	mod[i] = '\0';
	if (p_flag) {
	  fprintf(stdout,"fmod %s\n",mod); 
	} else {
	    linemod(mod);
	};
}

/* Space */
PLT_space(x1,y1,x2,y2)
int	x1,y1,x2,y2;
{
	if(p_flag) {
		fprintf(stdout,"space %d %d %d %d\n",x1,y1,x2,y2);
	} else {
	  space(x1,y1,x2,y2);
	};
}

/*
 * $Log: plotmedia.c,v $
 * Revision 1.3  1996/02/20 10:48:24  toyoda
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/11  20:42:50  ss56214
 * p_flag message.
 *
 * Revision 1.1  1994/08/11  13:50:25  ss56214
 * Initial revision
 *
 */
