/* ================================================
  necplot.c --- NEC PC-9801 ROM BASIC TERMINAL mode
  unixplot compatibility library
  Version 0.0 (94/05/24)
  by TOYODA Eizi (GHE03056@niftyserve.or.jp)
  $Header: /home/users/toyoda/c/tgi/necplot/RCS/necplot.c,v 1.3 1996/02/20 10:48:24 toyoda Exp toyoda $
================================================= */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#define PI	3.141592653589793
#define radtodeg(deg)	(fmod(deg,2*PI)*180.0/PI)

#define X_AXIS   399
#define Y_AXIS   199

/* exit() value */
#define NO_OPENPL_EXIT -2

static unsigned int xlen = X_AXIS;
static unsigned int ylen = Y_AXIS;         /* the size of the window  */ 
static int spx0,spy0;                   /* space function          */ 
static int spdx = X_AXIS;
static int spdy = 2 * Y_AXIS;

static    int cpx,cpy;                     /* current graphical point */

static int FONTcomeyet = 0;

/* ==================
 * internal function
 * ================== */

/* get window-size */
int Sx(x)  { return (int)((float)(x - spx0) * xlen / spdx); }
int Sdx(x) { return (int)((float)x * xlen / spdx); }
int Sy(y)  { return (int)((float)ylen - ((y - spy0) * ylen / spdy)); }
int Sdy(y) { return (int)((float)y * ylen / spdy); }

static void termdelay(i)
{
  int j;
  for (j=0;j<i;j++) { fputc('\0', stdout); };
}

	static
strhead(s,r)
 char *s, *r;
{
        while (*r) {
                if (0 == *s) return 0;
                if (*r != *s) return 0;
                r++, s++;
        }
        return 1;
}

char *Plot_Linestyle = "&HFFFF";

linemod(s)
 char *s;
{
        char *ls;
        if (strhead(s,"c.")) { setcolor(s+2);  return 1; };
        if (strhead(s,"dotted")) { ls= "&HAAAA";
        } else if (strhead(s,"shortdashed")) { ls= "&HFCFC";
        } else if (strhead(s,"longdashed")) { ls= "&HFFF0";
        } else if (strhead(s,"dotdashed")) { ls= "&HFAFA";
        } else { ls= "&HFFFF";
        };
        Plot_Linestyle = ls;
        return 0;
}

/* ====== colors ====== */

setcolor(s)
 char *s;
{
        char c;
        if (strhead(s,"black")) { c=0;
        } else if (strhead(s,"blue")) {         c=1;
        } else if (strhead(s,"red")) {          c=2;
        } else if (strhead(s,"purple")) {       c=3;
        } else if (strhead(s,"magenta")) {      c=3;
        } else if (strhead(s,"green")) {        c=4;
        } else if (strhead(s,"cyan")) {         c=5;
        } else if (strhead(s,"yellow")) {       c=6;
        } else { c=7;
        };
	fputs("\033.CONSOLE ,,,0\r", stdout);
        fprintf(stdout,"\033.COLOR 0,0,0,%i\r",(int)c);
        return 0;
}


/* ===================
 * Big-baggage routine
 * =================== */

openpl()
{
	fputs("\33>SCREEN 0,0,0,1\r", stdout);
	fputs("\33>VIEW (0,0)-(639,199)\r", stdout);
    return 0;
}

closepl()
{
}

/* ======================
 * miscellaneous commands
 * ====================== */

/* dummy wait routine */
xwait()
{
  return 0;
}

/*      flush routine */
xflush() {
  fflush(stdout); 
  return 0; 
}

erase()                          /* clear the window */
{
  fputs("\33>CLS 2\r", stdout);
  return 0;
}

space(x1,y1,x2,y2)
int x1,y1,x2,y2;
{
    int dx,dy;
    int retval = 0;

    dx = x2 - x1;
    dy = y2 - y1;

    if ((dx==0)&&(dy==0)) {
      dx = xlen;  dy = ylen;   retval = -3;
    };
    if (dx==0) {
      dx = dy * xlen / ylen;   retval = -1;
    };
    if (dy==0) {
      dy = dx * ylen / xlen;   retval = -2;
    };
    spdx = dx;             spdy = dy;
    spx0 = x1;             spy0 = y1;

    return retval;
}

move(x,y)
int x,y;
{
  cpx = x;  cpy = y;
  return 0;
}

/* ===========================
 * High-level plotting routine
 * =========================== */

point(x,y)
int x,y;
{
    int x1,y1;
    x1 = Sx(x);
    y1 = Sy(y);
    move(x,y);
    fprintf(stdout, "\33>PSET (%i,%i)\r",x1,y1);
    return 0;
}

cont(x,y)
int x,y;
{
  int x1,y1,x2,y2;
  x1 = Sx(cpx);   y1 = Sy(cpy);
  x2 = Sx(x);     y2 = Sy(y);
  move(x,y);
  fprintf(stdout,"\33.LINE (%i,%i)-(%i,%i),,, %s\r",
    x1,y1,x2,y2, Plot_Linestyle);
  termdelay(20);
  return 0;
}

line(a,b,c,d)
int a,b,c,d;
{ move(a,b); cont(c,d); return 0;}

rectangle(x1,y1,x2,y2)
int x1,y1,x2,y2;
{
    int x,y,dx,dy;
    x = Sx(x1);
    y = Sy(y1);
    dx = Sdx(x2 - x1);
    dy = Sdy(y2 - y1);
    move(x2,y2);
    fprintf(stdout, "\33>LINE (%i,%i)-STEP(%i,%i),B\r",x,y,dx,dy);
    return 0;
}

circle(x,y,r)
int x,y,r;
{
    int cx,cy,rx;
    cx = Sx(x);
    cy = Sy(y);
    rx = Sdx(r);
    fprintf(stdout,"\33>CIRCLE (%i,%i),%i\r",cx,cy,rx);
    return 0;
}

label(s)
char *s;
{
    int x,y;
    x = Sx(cpx) * 50 / X_AXIS;
    y = Sy(cpy) * 25 / Y_AXIS;
    fputs("\033.Y%=CSRLIN\r\033.X%=POS(0)\r", stdout);
    fprintf(stdout,"\033.LOCATE %i,%i,0\r", x, y);
    fputs(s, stdout);
    fputs("\033.LOCATE X%,Y%,1\r", stdout);
    return 0;
}

arc(x,y,x1,y1,x2,y2)
int x,y,x1,x2,y1,y2;
{
    int cx,cy,rx,r;
    int ang1,ang2;
    double wx,wy;

    r = sqrt( (double) ((x - x1)*(x - x1) + (y - y1)*(y - y1)) );

    cx = ( x - spx0) * xlen / spdx;
    cy = ( y - spy0) * ylen / spdy;

    rx = r * xlen / spdx;

    wx = atan2( (double) (y1 - y), (double) (x1 - x) );
    wy = atan2( (double) (y2 - y), (double) (x2 - x) );
    if( (wy -= wx) < 0.0 ) wy += 2*PI;

    cy = ylen - cy;
    fprintf(stdout, "\33>CIRCLE (%i,%i),%i,,%3.0f,%3.0f\r",cx,cy,rx,wx,wy);

    return 0;
}

/*
 * $Log: necplot.c,v $
 * Revision 1.3  1996/02/20 10:48:24  toyoda
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/11  20:42:50  ss56214
 * bugfix:
 * 	misspelling.[
 *
 * Revision 1.1  1994/08/11  13:50:25  ss56214
 * Initial revision
 *
 */
