/*
 *	hterm plot
 *		Ver 1.0 (6/17 '89)
 *			(C) Mik
 *
 *	N88-BASIC version: TOYODA Eizi (1993-)
 *	$Header: /home/users/toyoda/c/tgi/necplot/RCS/main.c,v 1.4 1996/02/20 10:48:24 toyoda Exp toyoda $
 */

#include <stdio.h>
#include <math.h>

int		p_flag	= 0;			/* output is text or graphic */
char	*t_flag	= "";			/* XPLOT only: window title */

main(argc,argv)
int	argc;
char	*argv[];
{
	int	i=1;
	char	*file=NULL;
	FILE	*fp_in;

	/* parsing commandline option */
	while(i != argc) {
		if (streq("-print",argv[i]) || streq("-p",argv[i])) {
			p_flag = 1;
#ifdef XPLOT
		} else if (streq("-T",argv[i]) || streq("-t",argv[i])) {
			i++;
			if (i != NULL)
				t_flag = argv[i];
			else
				break;
#endif
		} else if (streq("-h",argv[i])) {
			usage();
		} else {
			file = argv[i];
		}
		i++;
	}
	/*
	 * open input file
	 */
	if ((file == NULL) || (streq("-",file))) {
		fp_in = stdin;
	} else {
		if((fp_in = fopen(file,"r")) == 0) {
			fprintf(stderr,"%s: File not found\n",file);
			exit(-1);
		}
	}

	/* main */
	if(plot_main(fp_in) == -1)
		exit(-1);

	/* Terminate */
	exit(0);
}


usage()
{
#ifdef NECPLOT
	fprintf(stderr,"usage: necplot [file] [-print]\n");
#endif
#ifdef HTERMPLOT
	fprintf(stderr,"usage: htermplot [file] [-print]\n");
#endif
#ifdef XPLOT
	fprintf(stderr,"usage: xplot [file] [-print] [-t title]\n");
#endif
	exit(0);
}

send_terminal(s,n)
register char	*s;
register int	n;
{
	for(; n > 0; n--)
		putc(*s++,stdout);
}

/*
 * $Log: main.c,v $
 * Revision 1.4  1996/02/20 10:48:24  toyoda
 * *** empty log message ***
 *
 * Revision 1.3  1994/08/11  20:56:50  ss56214
 * help message.
 *
 * Revision 1.2  1994/08/11  20:42:50  ss56214
 * style.
 * -T flag for title (X version only).
 *
 * Revision 1.1  1994/08/11  13:50:25  ss56214
 * Initial revision
 *
 */
