/*
	hterm plotter draw package
		Ver 1.0   (6/17 '89)
			(C) Mik
 *  modified by TOYODA Eizi (1994.8-)
 *	$Header: /home/users/toyoda/c/tgi/necplot/RCS/htermplot.c,v 1.3 1996/02/20 10:48:24 toyoda Exp toyoda $
 */

#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <math.h>

#define ESC 0x1b

/* output buffer */
static	char	buff[512];

/* Linemode */
linemod(mod)
	char *mod;
{
	if (strncmp(mod,"c.",strlen("c.")) == 0)
		setcolor(mod+2);
	if(streq("solid",mod))
		hterm_linemod(0);	/* L_SOLID */
	else if(streq("dotted",mod))
		hterm_linemod(1);	/* L_DOT */
	else if(streq("shortdashed",mod))
		hterm_linemod(2);	/* L_DASH */
	else if(streq("longdashed",mod))
		hterm_linemod(3);	/* L_LONGDASH */
	else if(streq("dotdashed",mod))
		hterm_linemod(4);	/* L_DOTDASH */
	else
		hterm_linemod(0);	/* L_SOLID */
}

setcolor(mod)
	char *mod;
{
	int c;
	if (streq("black",mod)) {				c=0;
    } else if (streq(mod,"blue")) {       c=1;
    } else if (streq(mod,"red")) {        c=2;
    } else if (streq(mod,"purple")) {     c=3;
    } else if (streq(mod,"magenta")) {    c=3;
    } else if (streq(mod,"green")) {      c=4;
    } else if (streq(mod,"cyan")) {       c=5;
    } else if (streq(mod,"yellow")) {     c=6;
    } else { c=7;
	};
	hterm_setcolor(c);
}

	static
hterm_setcolor(mod)
	int	mod;
{
	sprintf(buff,"%cR%dx",ESC,mod);
	send_terminal(buff,strlen(buff));
}

	static
hterm_linemod(mod)
	int	mod;
{
	sprintf(buff,"%cR%df",ESC,mod);
	send_terminal(buff,strlen(buff));
}

/* generate escape scequence */
move(x,y)
	int	x,y;
{
	sprintf(buff,"%cR%d;%dm",ESC,x,y);
	send_terminal(buff,strlen(buff));
}

cont(x,y)
	int	x,y;
{
	sprintf(buff,"%cR%d;%dn",ESC,x,y);
	send_terminal(buff,strlen(buff));
}

point(x,y)
	int	x,y;
{
	sprintf(buff,"%cR%d;%dp",ESC,x,y);
	send_terminal(buff,strlen(buff));
}

line(x1,y1,x2,y2)
	int	x1,y1,x2,y2;
{
	sprintf(buff,"%cR%d;%d;%d;%dl",ESC,x1,y1,x2,y2);
	send_terminal(buff,strlen(buff));
}

label(str)
	char	*str;
{
	sprintf(buff,"%cRt%s%c",ESC,str,0x01);
	send_terminal(buff,strlen(buff));
}

arc(xc,yc,xs,ys,xe,ye)
	int	xc,yc,xs,ys,xe,ye;
{
	sprintf(buff,"%cR%d;%d;%d;%d;%d;%da",
		ESC,xc,yc,xs,ys,xe,ye);
	send_terminal(buff,strlen(buff));
}

circle(x,y,r)
	int	x,y,r;
{
	sprintf(buff,"%cR%d;%d;%dc",ESC,x,y,r);
	send_terminal(buff,strlen(buff));
}

openpl()
{
	sprintf(buff,"%cRG",ESC);
	send_terminal(buff,strlen(buff));
}

closepl()
{
	sprintf(buff,"%cRT",ESC);
	send_terminal(buff,strlen(buff));
}

erase()
{
	sprintf(buff,"%cRe%c[;H%c[2J",ESC,ESC,ESC);
	send_terminal(buff,strlen(buff));
}

space(x1,y1,x2,y2)
	int	x1,y1,x2,y2;
{
	sprintf(buff,"%cR%d;%d;%d;%ds",ESC,x1,y1,x2,y2);
	send_terminal(buff,strlen(buff));
}

/*
 * $Log: htermplot.c,v $
 * Revision 1.3  1996/02/20 10:48:24  toyoda
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/11  20:42:50  ss56214
 * style.
 *
 * Revision 1.1  1994/08/11  13:50:25  ss56214
 * Initial revision
 *
 */
