#ifndef _TGILOWER_H
#define _TGILOWER_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/************
  structures
 ************/

typedef struct _tgi_devtab_t {
	char	*type;
	char	*path;
	long	attr;
} _tgi_devtab_t;

/* for .attr */
#define	DA_NOCIRCLE	1	/* dumbplot's circle() doesn't work well */
#define	DA_NOLMOD	(1<<1)	/* dumbplot's linemod() doesn't work well */
#define	DA_NOPIPE	(1<<2)	/* open with fopen(), not popen() */
#define	DA_STD		0

extern struct _tgi_stat_t {
	/* device specifying data */
	_tgi_devtab_t	*dev;
	FILE	*inpipe;
	FILE	*outpipe;
	int	x0, y0;
	int	dx, dy;
} _tgi_stat;

#define	tgi	_tgi_stat

/********
  macros
 ********/

#define streq(s,t)	(strcmp(s,t) == 0)
#define strhead(s,t)	(strncmp(s,t,strlen(t)) == 0)
#define	eputs(s)	(void)fputs(s, stderr)

/*********************
  function prototypes
 *********************/

#if defined(__STDC__) || defined(__TURBOC__)
# define _PT(arg)	(arg)
#else
# define _PT(arg)	()
#endif

extern openpl _PT((void));
extern closepl _PT((void));
extern space _PT((void));

extern _tgi_devtab_t *tgiFindDev _PT((char *key));
extern _tgi_devtab_t *tgiDefaultDev _PT((char *key));

#undef _PT

#endif /* _TGILOWER_H */
