#include "tgilower.h"

/* device table */

static _tgi_devtab_t	devtab[] = {
	{ "tek4014",	"tek",		DA_STD },
	{ "hterm",	"htermplot",	DA_STD },
	{ "n88basic",	"necplot",	DA_STD },
	{ "x11",	"xplot",	DA_STD },
	{ "dumb",	"dumbplot",	DA_NOCIRCLE | DA_NOLMOD },
	{ "dump",	"plot.plt",	DA_NOPIPE },
	{ NULL, NULL, 0 }
};

	_tgi_devtab_t *
tgiFindDev(key)
	char	*key;
{
	int	i = 1;
	if (key == NULL)
		return NULL;
	for (i=0; devtab[i].type; i++)
		if (streq(key, devtab[i].type))
			return &devtab[i];
	return NULL;
}

	_tgi_devtab_t *
tgiDefaultDev()
{
	char		*term;
	_tgi_devtab_t	*tab;
	if ((tab = tgiFindDev(getenv("PLOT"))) != NULL)
		return tab;
	if (getenv("DISPLAY") != NULL)
		return tgiFindDev("x11");
	term = getenv("TERM");
	if (term == NULL)
		return tgiFindDev("dumb");
	if (streq(term, "tek") || streq(term, "4014") ||
		strhead(term, "xterm") || strhead(term, "kterm"))
		return tgiFindDev("tek4014");
	if (streq(term, "pc98rom"))
		return tgiFindDev("n88basic");
	if (strhead(term, "hterm"))
		return tgiFindDev(term);
	return tgiFindDev("dumb");
}
