/* tgilower.h (C) TOYODA Eizi, 1996
 * tgi lib inner header
 */

#ifndef _TGILOWER_H
#define	_TGILOWER_H

/****************
  CONFIGURATIOIN
 ****************/
#define	USEDEV_LIO98	/* PC98 - using kouzi's KGLIO.LIB */

/*********
  HEADERS
 *********/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "tgi.h"

#ifdef USEDEV_LIO98
#include <pc98.h>
#include "../misc/kglio.h"
#endif

/*************
  common info
 *************/

extern struct _tgi_stat_t {
	int	devno;		/* device id */
	FILE	*savfile;	/* save file */
	short	xlen;		/* x length of output device */
	short	ylen;		/* (y(upper+1) - y(lower)) of device */
	short	xleft;		/* x of left end of output device */
	short	ylower;		/* y of lower end of output device */
	short	doconv;		/* whether apply conversion */
	short	x0, y0;		/* logical location of SouthWest end */
	short	dx, dy;		/* logical metric of plane */
	short	cpx, cpy;	/* current point in device coord */
} _tgi_stat;	/* at core.c */

extern int _tgi_debug;

#define	tgi	_tgi_stat

/***********************
  device dependent info
 ***********************/

#ifdef USEDEV_LIO98

#define	DEVNO_LIO98	1
#define	LIO98_XLEN	640
#define	LIO98_XLEFT	240
#define	LIO98_YLEN	400
#define	LIO98_COLORS	8
#define	LIO98_DASH	4
#define	LIO98_WIDTH	5

extern struct _lio98_t {
	char	used;
	char	mouse;
	char	origfkey;
	char	fgcol;
	char	bgcol;
	char	width;
	char	lmod[2];
} _lio98_stat; /* at core.c */

#define	lio98	_lio98_stat

#endif /* USEDEV_LIO98 */

/*******************
  functional macros
 *******************/

#define	tgiMoveCP(x,y)	tgi.cpx = (x), tgi.cpy = (y)
#define	eputs(s)	(void)fputs(s,stderr)
#define	streq(s,t)	(strcmp(s,t)==0)

#endif	/* _TGILOWER_H */

/* EOF */
/*
 * $Log: RCS/tgilower.hv $
 * Revision 1.2  96/02/20 07:40:18  prasinos
 * x scaling bugfix
 * 
 */
