/* ---------------------------------------------------------------
 *  unixplot assembler
 *  plotas.c 1994.5.20 (C) by Anemos Prasinos
 */

#include <stdio.h>
#include <string.h>
#ifdef DEBUG
#include <ctype.h>
#endif

#define elif else if
#define BUFLEN 256

disphelp()
{
  fputs("available commands:\n", stderr);
  fputs("m X Y                Move\n", stderr);
  fputs("n X Y                Cont\n", stderr);
  fputs("p X Y                Point\n", stderr);
  fputs("l Xa Ya Xb Yb        Line\n", stderr);
  fputs("t STR                Label\n", stderr);
  fputs("a Xc Yc Xb Yb Xd Yd  Arc\n", stderr);
  fputs("c Xc Yc r            Circle\n", stderr);
  fputs("s Xa Ya Xb Yb        Space\n", stderr);
  fputs("f MOD                Linemod\n", stderr);
  fputs("e                    Erase\n", stderr);
  fputs("q or EOF             Quit\n", stderr);

  fputs(
"\nlinemod: solid,dotted,shortdashed,longdashed,dotdashed.\n",
    stderr);
  fputs(
"c.black, c.red, w.wide, w.thin... may be supported.\n", stderr);
  return 0;
}

asln(buf)
 char *buf;
{
  char *cmd, *tok[6], c;
  int d[6], i;

  cmd = strtok(buf, " \t");
  for (i=0; i<6; i++) {
    if ((tok[i] = strtok(NULL, " \t")) == NULL) break;
    d[i] = atoi(tok[i]);
  };
  c = *cmd;
  if (c == 'm') {     move(d[0],d[1]);
  } elif (c == 'p') { point(d[0], d[1]);
  } elif (c == 'l') { line(d[0], d[1], d[2], d[3]);
  } elif (c == 'n') { cont(d[0], d[1]);
  } elif (c == 'a') { arc(d[0], d[1], d[2], d[3], d[4], d[5]);
  } elif (c == 'c') { circle(d[0], d[1], d[2]);
  } elif (c == 'e') { erase();
  } elif (c == 't') { label(tok[0]);
  } elif (c == 'f') { linemod(tok[0]);
  } elif (c == 's') { space(d[0], d[1], d[2], d[3]);
  } elif (c == 'h') { disphelp();
  } elif (c == '#') { 
  } elif (c == 'q') { return 1;
  };
  fflush(stdout);
  return 0;
}

asfile(inf)
 FILE *inf;
{
  static char buf[BUFLEN];
  openpl();
  while (!feof(inf)) {
    if (NULL == fgets(buf, BUFLEN, inf)) break;
    if (asln(buf)) break;
  };
  closepl();
  return 0;
}


main(argc,argv)
 int argc; char **argv;
{
  FILE *inf = stdin;
  int i;
  for (i=1; i<argc; i++) {
    inf = fopen(argv[i], "rt");
    if (inf == NULL) {
      fputs("plotas:", stderr);
      fputs(argv[i], stderr);
      fputs(": No such file or directory\n", stderr);
    } else {
      asfile(inf);
      close(inf);
    };
  };
  if (argc==1) { asfile(stdin); };
  return 0;
}
