/* plot.c: (C) TOYODA Eizi, 1996
 * core routine for tgi low level lib
 */

#include "tgilower.h"

static char *rcsid = "$Header: core.cv  1.3  96/02/20 07:47:18  prasinos  Exp $";

struct _tgi_stat_t	tgi = {
	-1,	/* int	 devno; */
	NULL,	/* FILE	 *savfile; */
	4096,	/* short xlen; */
	4096,	/* short ylen; */
	0,	/* short xleft; */
	0,	/* short ylower; */
	0,	/* short doconv; */
	0, 0,	/* short x0, y0; */
	4096,	/* short dx; */
	4096,	/* short dy; */
	0, 0	/* short cpx, cpy */
};

int	_tgi_debug = 0;

#ifdef USEDEV_LIO98
struct _lio98_t		lio98 = {
	0,	/* char used; */
	0,	/* char mouse; */
	1,	/* char origfkey; */
	7,	/* char fgcol; */
	0,	/* char bgcol; */
	1,	/* char width; */
	{ 0xFF, 0xFF }, /* char lmod[2]; */
};

	static int
InitLio98()
{
	int	r;
	/* check whether MOUSE.SYS installed */
	lio98.mouse = pc98mouse(0x00, NULL);
	lio98.origfkey = pc98fkeychk();
	pc98fkeyoff();
	ginit();
	gscreen(0x03,0x01,0x00,0x01);
	gview(0,0,LIO98_XLEN-1,LIO98_YLEN-1,0xFF,0xFF);
	r = gcolor1(lio98.bgcol,0xFF,lio98.fgcol,0x00);
	gcolor2(7, 0xFFFF);
	gcolor2(0, 0x0000);
	tgi.xlen = LIO98_XLEN - LIO98_XLEFT;
	tgi.ylen = 0-LIO98_YLEN;
	tgi.xleft = LIO98_XLEFT;
	tgi.ylower = LIO98_YLEN;
	return (tgi.devno = DEVNO_LIO98);
}

	static void
TermLio98(void)
{
	/* function keys restore */
	if (lio98.origfkey)
		pc98fkeyon();
	gexit(); 
}

#endif /* USEDEV_LIO98 */

/*
 * public functions
 */

	int
openpl(void)
{
#ifdef USEDEV_LIO98
	if (tgi.devno == DEVNO_LIO98 || tgi.devno == -1)
		return InitLio98();
#endif /* USEDEV_LIO98 */
	eputs("openpl: unknown device\n");
	return -1;
}

	int
closepl(void)
{
#ifdef USEDEV_LIO98
	if (tgi.devno == DEVNO_LIO98)
		TermLio98();
	tgi.devno = -1;
#endif /* USEDEV_LIO98 */
	return 0;
}

	void
tgiConv(xp, yp)
	int	*xp, *yp;
{
	long	tmp;
	if (xp) {
		tmp = *xp - tgi.x0;
		tmp *= tgi.xlen;
		tmp /= tgi.dx;
		*xp = (int)tmp + tgi.xleft;
	}
	if (yp) {
		tmp = *yp - tgi.y0;
		tmp *= tgi.ylen;
		tmp /= tgi.dy;
		*yp = (int)tmp + tgi.ylower;
	}
}

/* EOF */
/*
 * $Log: RCS/core.cv $
 * Revision 1.3  96/02/20 07:47:18  prasinos
 * x scaling bugfix
 * 
 * Revision 1.2  96/02/20 03:26:06  prasinos
 * enable log message
 * 
 */
