/* popen.c: (C) TOYODA Eizi, 1996
 * simple (write only) popen() (of unix) emulation
 * for TURBO C++ 1.01 on MS-DOS
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <fcntl.h>
#include <io.h>
#include <sys/stat.h>

#define	DEV_TTY_NAME	"CON"
#define	eputs(s)	fputs(s, stderr)

static struct _pipe_ {
	char	*path;
	char	*arg;
	char	*fnam;
	FILE	*fp;
	char	mod;
} p = {
	NULL, NULL, NULL, NULL, 0
};

	FILE *
popen(char cmd[], char mod[])
{
	int	n;
	if (p.fp)
		return NULL;		/* only one pipe at one time */
	if (*mod != 'w')
		return NULL;		/* bad mod */
	p.mod = mod[0];
	p.path = strdup(cmd);
	if (sscanf(cmd, "%s%n", p.path, &n) < 1) {
		free(p.path);
		return NULL;
	}
	p.arg = strdup(cmd+n);
	p.fnam = strdup(tmpnam(NULL));
	fprintf(stderr, "<%s><%s>\n", p.path, p.arg);
	p.fp = fopen(p.fnam, mod);
	return p.fp;
}

	int
pclose(FILE *fp)
{
	int	r, fd;
	r = -1;
	if (p.fp == NULL || fp != p.fp)
		return -1;
	fclose(fp);
	if (p.mod == 'w') {
		fd = open(p.fnam, O_RDONLY);
		dup2(fd, 0);
		close(fd);
		r = spawnlp(P_WAIT, p.path, p.arg, NULL);
		fd = open(DEV_TTY_NAME, O_RDONLY);
		dup2(fd, 0);
		close(fd);
	}
	remove(p.fnam);
	free(p.fnam);
	free(p.path);
	free(p.arg);
	return r;
}

#ifdef TEST_W
	int
main()
{
	FILE	*fp;
	int	i;
	fp = popen("more", "wt");
	if (fp == NULL) {
		fputs("popen error\n", stderr);
		return 1;
	}
	for (i=' '; i<127; i++)
		fprintf(fp, "char %d = %c\n", i, i);
	printf("retcode %d\n", pclose(fp));
	getchar();
	return 0;
}
#endif
