set key left Left reverse

unset logscale

set xlabel  "loop #"
set ylabel  "RMSEs with respect to k-dist. model"
set y2label "RMSEs with respect to LBL model"
set ytics nomirror
set y2tics nomirror

plot \
     "../dir_optimize.old/dir_optimize_band-3/out/loss.txt"u 1:2 t "sum" w lp, \
     "../dir_optimize.old/dir_optimize_band-3/out/loss.txt"u 1:4 t "UR.upflx" w lp, \
     "../dir_optimize.old/dir_optimize_band-3/out/loss.txt"u 1:5 t "SR.upflx" w lp, \
     "../dir_optimize.old/dir_optimize_band-3/out/loss.txt"u 1:6 t "PR.dnflx" w lp, \
     "../dir_optimize.old/dir_optimize_band-3/out/loss.txt"u 1:7 t "SR.dnflx" w lp, \
     "../dir_optimize.old/dir_optimize_band-3/out/loss_lbl.txt"u 1:2 axes x1y2 t "sum (LBL)" w lp lw 3

pause -1

set logscale y

set xlabel  "# of bands"
set ylabel  "RMSEs with respect to k-dist. model"
set y2label ""
set ytics mirror

plot \
     "../dir_optimize.old/dir_optimize_band-1/out/loss.txt"u (10-$1):2 t " 10 bands" w lp, \
     "../dir_optimize.old/dir_optimize_band-2/out/loss.txt"u (18-$1):2 t " 18 bands" w lp, \
     "../dir_optimize.old/dir_optimize_band-3/out/loss.txt"u (42-$1):2 t " 42 bands" w lp, \
     "../dir_optimize.old/dir_optimize_band-6/out/loss.txt"u (55-$1):2 t " 55 bands" w lp, \
     "../dir_optimize.old/dir_optimize_band-4/out/loss.txt"u (82-$1):2 t " 82 bands" w lp, \
     "../dir_optimize_band-5/out/loss.txt"u (162-$1):2 t "162 bands" w lp

pause -1

set logscale y

set xlabel  "# of bands"
set ylabel  "RMSEs with respect to LBL model"
set y2label ""
set ytics mirror

plot \
     "../dir_optimize.old/dir_optimize_band-1/out/loss_lbl.txt"u (10-$1):2 t " 10 bands" w lp, \
     "../dir_optimize.old/dir_optimize_band-2/out/loss_lbl.txt"u (18-$1):2 t " 18 bands" w lp, \
     "../dir_optimize.old/dir_optimize_band-3/out/loss_lbl.txt"u (42-$1):2 t " 42 bands" w lp, \
     "../dir_optimize.old/dir_optimize_band-6/out/loss_lbl.txt"u (55-$1):2 t " 55 bands" w lp, \
     "../dir_optimize.old/dir_optimize_band-4/out/loss_lbl.txt"u (82-$1):2 t " 82 bands" w lp, \
     "../dir_optimize_band-5/out/loss_lbl.txt"u (162-$1):2 t "162 bands" w lp, \
     "../dir_optimize.old/dir_optimize_band-3-2/out/loss_lbl.txt"u (42-$1):2 t " 42 bands (12 IPs)" w lp, \
     "../dir_optimize.old/dir_optimize_band-3-3/out/loss_lbl.txt"u (42-$1):2 t " 42 bands (16 IPs)" w lp, \
     "../dir_optimize.old/dir_optimize_band-6-2/out/loss_lbl.txt"u (55-$1):2 t " 55 bands (12 IPs)" w lp

