/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import java.lang.reflect.Array;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.data.hdf5.hdf5objects.HDF5Dataspace;
import visad.data.hdf5.hdf5objects.HDF5Datatype;
import visad.data.hdf5.hdf5objects.HDF5Object;

public class HDF5Dataset
extends HDF5Object {
    protected Object data;
    protected HDF5Datatype datatype;
    protected HDF5Dataspace dataspace;
    protected int rank;
    protected long[] dims;
    protected long[] maxdims;
    protected long[] count;
    protected Vector member_names;

    public HDF5Dataset() {
        this.type = 2;
    }

    public HDF5Dataset(String name) {
        super(name);
        this.type = 2;
    }

    public HDF5Dataset(int loc_id, String set_name, int type_id, int space_id, int create_plist_id) {
        super(set_name);
        this.type = 2;
        try {
            this.id = H5.H5Dcreate((int)loc_id, (String)set_name, (int)type_id, (int)space_id, (int)create_plist_id);
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Dataset: " + (Object)((Object)e));
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Dataset: " + (Object)((Object)e));
        }
    }

    public HDF5Dataset(int loc_id, String set_name) {
        super(set_name);
        this.type = 2;
        try {
            this.id = H5.H5Dopen((int)loc_id, (String)set_name);
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Dataset: " + (Object)((Object)e));
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Dataset.init(): " + (Object)((Object)e));
        }
    }

    public void init() throws HDF5Exception {
        if (this.id < 0) {
            return;
        }
        this.datatype = new HDF5Datatype();
        this.datatype.setID(H5.H5Dget_type((int)this.id));
        this.dataspace = new HDF5Dataspace();
        this.dataspace.setID(H5.H5Dget_space((int)this.id));
        this.rank = this.dataspace.getRank();
        this.dims = this.dataspace.getDims();
        this.maxdims = this.dataspace.getMaxdims();
        this.count = this.dataspace.getCount();
    }

    public Object readData() throws HDF5Exception, NullPointerException {
        int space = -2;
        return this.readData(space, space);
    }

    public Object readData(int mspace, int fspace) throws HDF5Exception, NullPointerException {
        this.data = null;
        System.gc();
        if (H5.H5Tget_class((int)this.datatype.getID()) == 6) {
            this.data = this.readCompoundData(mspace, fspace);
            return this.data;
        }
        this.data = this.datatype.defineData(this.count);
        if (this.data == null) {
            return null;
        }
        if (this.data.getClass().getName().endsWith("Ljava.lang.String;")) {
            int no_lines = Array.getLength(this.data);
            long tsize = H5.H5Dget_storage_size((int)this.id);
            int max_length = (int)(tsize / (long)no_lines);
            byte[][] bdata = new byte[no_lines][max_length];
            H5.H5Dread((int)this.id, (int)H5.H5Dget_type((int)this.id), (int)mspace, (int)fspace, (int)-2, (Object)bdata);
            for (int i = 0; i < no_lines; ++i) {
                Array.set(this.data, i, new String(bdata[i]));
            }
        } else {
            H5.H5Dread((int)this.id, (int)H5.H5Dget_type((int)this.id), (int)mspace, (int)fspace, (int)-2, (Object)this.data);
            boolean isUnsigned = false;
            int tid = this.datatype.getID();
            int class_t = H5.H5Tget_class((int)tid);
            if (class_t == 0 && H5.H5Tget_sign((int)tid) == 0) {
                Object new_data;
                this.data = new_data = HDF5Dataset.convertUnsignedData(this.data);
            }
        }
        return this.data;
    }

    private Object readCompoundData(int mspace, int fspace) throws HDF5Exception, NullPointerException {
        String member_name = "";
        int member_tid = -1;
        int read_tid = -1;
        int member_class_t = -1;
        int member_class_s = -1;
        int member_sign = -1;
        int p = -2;
        Object[] member_data = null;
        int size = 0;
        long lsize = 1L;
        if (this.count == null) {
            return null;
        }
        for (int i = 0; i < this.count.length; ++i) {
            lsize *= this.count[i];
        }
        size = (int)lsize;
        int tid = this.datatype.getID();
        int num_members = H5.H5Tget_nmembers((int)tid);
        Vector<Object> theData = new Vector<Object>();
        this.member_names = new Vector();
        for (int i = 0; i < num_members; ++i) {
            member_data = null;
            member_sign = -1;
            member_name = H5.H5Tget_member_name((int)tid, (int)i);
            member_tid = H5.H5Tget_member_type((int)tid, (int)i);
            member_class_t = H5.H5Tget_class((int)member_tid);
            member_class_s = H5.H5Tget_size((int)member_tid);
            read_tid = H5.H5Tcreate((int)6, (int)member_class_s);
            if (member_class_t == 0) {
                member_sign = H5.H5Tget_sign((int)member_tid);
                if (member_class_s == 1) {
                    byte[] bdata = new byte[size];
                    H5.H5Tinsert((int)read_tid, (String)member_name, (long)0L, (int)H5.J2C((int)72));
                    H5.H5Dread((int)this.id, (int)read_tid, (int)mspace, (int)fspace, (int)p, (byte[])bdata);
                    member_data = bdata;
                } else if (member_class_s == 2) {
                    short[] sdata = new short[size];
                    H5.H5Tinsert((int)read_tid, (String)member_name, (long)0L, (int)H5.J2C((int)69));
                    H5.H5Dread((int)this.id, (int)read_tid, (int)mspace, (int)fspace, (int)p, (Object)sdata);
                    member_data = sdata;
                } else if (member_class_s == 4) {
                    int[] idata = new int[size];
                    H5.H5Tinsert((int)read_tid, (String)member_name, (long)0L, (int)H5.J2C((int)70));
                    H5.H5Dread((int)this.id, (int)read_tid, (int)mspace, (int)fspace, (int)p, (Object)idata);
                    member_data = idata;
                } else if (member_class_s == 8) {
                    long[] ldata = new long[size];
                    H5.H5Tinsert((int)read_tid, (String)member_name, (long)0L, (int)H5.J2C((int)71));
                    H5.H5Dread((int)this.id, (int)read_tid, (int)mspace, (int)fspace, (int)p, (Object)ldata);
                    member_data = ldata;
                }
            } else if (member_class_t == 1) {
                if (member_class_s == 4) {
                    float[] fdata = new float[size];
                    H5.H5Tinsert((int)read_tid, (String)member_name, (long)0L, (int)H5.J2C((int)55));
                    H5.H5Dread((int)this.id, (int)read_tid, (int)mspace, (int)fspace, (int)p, (Object)fdata);
                    member_data = fdata;
                } else if (member_class_s == 8) {
                    double[] ddata = new double[size];
                    H5.H5Tinsert((int)read_tid, (String)member_name, (long)0L, (int)H5.J2C((int)54));
                    H5.H5Dread((int)this.id, (int)read_tid, (int)mspace, (int)fspace, (int)p, (Object)ddata);
                    member_data = ddata;
                }
            } else {
                member_data = null;
            }
            if (member_data == null) continue;
            this.member_names.add(member_name);
            if (member_sign == 0) {
                theData.add(HDF5Dataset.convertUnsignedData(member_data));
                continue;
            }
            theData.add(member_data);
        }
        return theData;
    }

    public static Object convertUnsignedData(Object data_in) throws HDF5Exception {
        Object data_out = null;
        String cname = data_in.getClass().getName();
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        int size = Array.getLength(data_in);
        if (dname == 'B') {
            short[] sdata = new short[size];
            short value = 0;
            for (int i = 0; i < size; ++i) {
                value = Array.getByte(data_in, i);
                if (value < 0) {
                    value = (short)(value + 256);
                }
                sdata[i] = value;
            }
            data_out = sdata;
            data_in = null;
        } else if (dname == 'S') {
            int[] idata = new int[size];
            int value = 0;
            for (int i = 0; i < size; ++i) {
                value = Array.getShort(data_in, i);
                if (value < 0) {
                    value += 65536;
                }
                idata[i] = value;
            }
            data_out = idata;
            data_in = null;
        } else if (dname == 'I') {
            long[] ldata = new long[size];
            long value = 0L;
            for (int i = 0; i < size; ++i) {
                value = Array.getInt(data_in, i);
                if (value < 0L) {
                    value += 0x100000000L;
                }
                ldata[i] = value;
            }
            data_out = ldata;
            data_in = null;
        } else {
            data_out = data_in;
        }
        return data_out;
    }

    public void writeData(Object buf) throws HDF5Exception, NullPointerException {
        int space = -2;
        this.writeData(space, space, buf);
    }

    public void writeData(int mspace, int fspace, Object buf) throws HDF5Exception, NullPointerException {
        int num_type = -1;
        int plist = -2;
        String cname = buf.getClass().getName();
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        num_type = dname == 'B' ? H5.J2C((int)72) : (dname == 'C' ? H5.J2C((int)53) : (dname == 'D' ? H5.J2C((int)54) : (dname == 'F' ? H5.J2C((int)55) : (dname == 'I' ? H5.J2C((int)70) : (dname == 'J' ? H5.J2C((int)71) : (dname == 'S' ? H5.J2C((int)69) : (dname == 'Z' ? H5.J2C((int)56) : H5.H5Dget_type((int)this.id))))))));
        int status = H5.H5Dwrite((int)this.id, (int)num_type, (int)mspace, (int)fspace, (int)plist, (Object)buf);
    }

    public Object getData() {
        return this.data;
    }

    public HDF5Datatype getDatatype() {
        return this.datatype;
    }

    public HDF5Dataspace getDataspace() {
        return this.dataspace;
    }

    public int getRank() {
        return this.rank;
    }

    public long[] getDims() {
        return this.dims;
    }

    public long[] getMaxdims() {
        return this.maxdims;
    }

    public long[] getCount() {
        return this.count;
    }

    public String toString() {
        if (this.datatype == null || this.dataspace == null) {
            return super.toString();
        }
        String d_str = "";
        for (int i = 0; i < this.rank; ++i) {
            d_str = d_str + this.dims[i] + "x";
        }
        int l = d_str.length();
        if (l > 1) {
            d_str = d_str.substring(0, l - 1);
        }
        return this.getClass().getName() + "[name=" + this.name + ",type=" + this.datatype + ",dimensions=" + d_str + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            H5.H5Dclose((int)this.id);
        }
    }
}

