/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5;

import java.rmi.RemoteException;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.DataImpl;
import visad.MathType;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.data.hdf5.HDF5DataAdaptable;
import visad.data.hdf5.HDF5DatasetAdapted;
import visad.data.hdf5.hdf5objects.HDF5Group;

public class HDF5GroupAdapted
extends HDF5Group
implements HDF5DataAdaptable {
    private MathType mathtype = null;
    private DataImpl tuple = null;
    private DataImpl[] datas = null;

    public HDF5GroupAdapted() {
    }

    public HDF5GroupAdapted(int loc_id, String gname, int name_length) throws HDF5Exception {
        super(loc_id, gname, name_length);
        try {
            this.init();
        }
        catch (HDF5Exception e) {
            throw new HDF5Exception("HDF5GroupAdapted: " + (Object)((Object)e));
        }
    }

    public HDF5GroupAdapted(int loc_id, String name) throws HDF5Exception {
        super(loc_id, name);
        try {
            this.init();
        }
        catch (HDF5Exception e) {
            throw new HDF5Exception("HDF5GroupAdapted: " + (Object)((Object)e));
        }
    }

    public void init() throws HDF5Exception {
        if (this.id < 0) {
            return;
        }
        int pid = this.id;
        int pgroup = -1;
        String gname = this.name;
        int[] oType = new int[]{0};
        int nelems = H5.H5Gn_members((int)pid, (String)gname);
        if (nelems <= 0) {
            return;
        }
        String[] oName = new String[]{" "};
        for (int i = 0; i < nelems; ++i) {
            H5.H5Gget_obj_info_idx((int)pid, (String)gname, (int)i, (String[])oName, (int[])oType);
            if (oType[0] == 1) {
                pgroup = H5.H5Gopen((int)pid, (String)gname);
                HDF5GroupAdapted g = new HDF5GroupAdapted(pgroup, this.name + "/" + oName[0]);
                this.addMember(g);
            } else if (oType[0] == 2) {
                HDF5DatasetAdapted d = new HDF5DatasetAdapted(pid, this.name + "/" + oName[0]);
                this.addMember(d);
            }
            oName[0] = null;
            oType[0] = -1;
        }
        try {
            this.getMathType();
        }
        catch (VisADException e) {
            throw new HDF5Exception("HDF5GroupAdapted: " + e);
        }
    }

    public MathType getMathType() throws VisADException {
        MathType mt = null;
        HDF5DataAdaptable theMember = null;
        int size = this.getMemberCount();
        int new_size = 0;
        if (size <= 0) {
            this.mathtype = null;
            return null;
        }
        if (this.mathtype == null) {
            MathType[] m_types = new MathType[size];
            for (int i = 0; i < size; ++i) {
                theMember = (HDF5DataAdaptable)this.getMemberAt(i);
                mt = theMember.getMathType();
                if (mt == null) {
                    this.removeMember(theMember);
                    continue;
                }
                m_types[new_size++] = mt;
            }
            new_size = this.getMemberCount();
            MathType[] new_types = m_types;
            if (new_size < size) {
                if (new_size <= 0) {
                    this.mathtype = null;
                    return null;
                }
                new_types = new MathType[new_size];
                for (int i = 0; i < new_size; ++i) {
                    new_types[i] = m_types[i];
                }
            }
            this.mathtype = new TupleType(new_types);
        }
        return this.mathtype;
    }

    public DataImpl getAdaptedData() throws VisADException, RemoteException {
        int size = this.getMemberCount();
        if (size <= 0) {
            return null;
        }
        if (this.datas == null) {
            this.datas = new DataImpl[size];
        }
        HDF5DataAdaptable theData = null;
        if (this.tuple == null) {
            for (int i = 0; i < size; ++i) {
                theData = (HDF5DataAdaptable)this.getMemberAt(i);
                this.datas[i] = theData.getAdaptedData();
            }
            this.tuple = new Tuple((TupleType)this.mathtype, this.datas, false);
        }
        return this.tuple;
    }

    public DataImpl getAdaptedData(int[] indexes) throws VisADException, RemoteException {
        int size = this.getMemberCount();
        if (size <= 0) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            this.datas[i] = ((HDF5DataAdaptable)this.getMemberAt(i)).getAdaptedData(indexes);
        }
        Tuple tuple = new Tuple((TupleType)this.mathtype, this.datas, false);
        return tuple;
    }

    public HDF5DataAdaptable getElement(int i) {
        return (HDF5DataAdaptable)this.getMemberAt(i);
    }
}

