/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.Delaunay;
import visad.DisplayException;
import visad.ErrorEstimate;
import visad.IrregularSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADLineArray;
import visad.VisADTriangleStripArray;

public class Irregular3DSet
extends IrregularSet {
    private float LowX;
    private float HiX;
    private float LowY;
    private float HiY;
    private float LowZ;
    private float HiZ;
    static final float EPS_0 = 1.0E-5f;
    static final int[] NTAB = new int[]{0, 1, 2, 1, 2, 0, 2, 0, 1, 0, 1, 3, 2, 1, 2, 0, 3, 2, 3, 1, 0, 3, 0, 2, 1, 0, 1, 4, 2, 3, 1, 2, 0, 3, 4, 2, 3, 1, 4, 0, 3, 4, 2, 0, 1, 4, 0, 3, 1, 2, 0, 1, 5, 2, 4, 3, 1, 2, 0, 3, 5, 4, 2, 3, 1, 4, 0, 5, 3, 4, 2, 5, 1, 0, 4, 5, 3, 0, 2, 1, 5, 0, 4, 1, 3, 2};
    static final int[] ITAB = new int[]{0, 2, 1, 1, 0, 2, 2, 1, 0, 0, 3, 1, 2, 1, 0, 2, 3, 2, 1, 3, 0, 3, 2, 0, 1, 0, 4, 1, 3, 2, 1, 0, 2, 4, 3, 2, 1, 3, 0, 4, 3, 2, 4, 1, 0, 4, 3, 0, 2, 1, 0, 5, 1, 4, 2, 3, 1, 0, 2, 5, 3, 4, 2, 1, 3, 0, 4, 5, 3, 2, 4, 1, 5, 0, 4, 3, 5, 2, 0, 1, 5, 4, 0, 3, 1, 2};
    static final int[] STAB = new int[]{0, 9, 25, 50};

    public Irregular3DSet(MathType type, float[][] samples) throws VisADException {
        this(type, samples, null, null, null, null, true);
    }

    public Irregular3DSet(MathType type, float[][] samples, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, Delaunay delan) throws VisADException {
        this(type, samples, coord_sys, units, errors, delan, true);
    }

    public Irregular3DSet(MathType type, float[][] samples, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, Delaunay delan, boolean copy) throws VisADException {
        super(type, samples, delan == null ? samples.length : delan.Tri[0].length - 1, coord_sys, units, errors, delan, copy);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LowZ = this.Low[2];
        this.HiZ = this.Hi[2];
        this.oldToNew = null;
        this.newToOld = null;
    }

    public Irregular3DSet(MathType type, float[][] samples, int[] new2old, int[] old2new) throws VisADException {
        this(type, samples, new2old, old2new, null, null, null, true);
    }

    public Irregular3DSet(MathType type, float[][] samples, int[] new2old, int[] old2new, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, new2old, old2new, coord_sys, units, errors, true);
    }

    public Irregular3DSet(MathType type, float[][] samples, int[] new2old, int[] old2new, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, samples, 1, coord_sys, units, errors, null, copy);
        if (this.Length != new2old.length || this.Length != old2new.length) {
            throw new SetException("Irregular3DSet: sort lengths do not match");
        }
        this.newToOld = new int[this.Length];
        this.oldToNew = new int[this.Length];
        System.arraycopy(new2old, 0, this.newToOld, 0, this.Length);
        System.arraycopy(old2new, 0, this.oldToNew, 0, this.Length);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LowZ = this.Low[2];
        this.HiZ = this.Hi[2];
        this.Delan = null;
    }

    public Set makeSpatial(SetType type, float[][] samples) throws VisADException {
        if (samples.length == 3) {
            if (this.ManifoldDimension == 1) {
                return new Irregular3DSet((MathType)type, samples, this.newToOld, this.oldToNew, null, null, null, false);
            }
            if (this.Delan.Tri == null || this.Delan.Tri.length == 0) {
                return null;
            }
            return new Irregular3DSet((MathType)type, samples, null, null, null, this.Delan, false);
        }
        throw new SetException("Irregular3DSet.makeSpatial: bad samples length");
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        float[][] value = new float[3][index.length];
        float[][] mySamples = this.getMySamples();
        for (int i = 0; i < index.length; ++i) {
            if (index[i] >= 0 && index[i] < this.Length) {
                value[0][i] = mySamples[0][index[i]];
                value[1][i] = mySamples[1][index[i]];
                value[2][i] = mySamples[2][index[i]];
                continue;
            }
            value[2][i] = Float.NaN;
            value[1][i] = Float.NaN;
            value[0][i] = Float.NaN;
        }
        return value;
    }

    public int[] valueToTri(float[][] value) throws VisADException {
        if (this.ManifoldDimension != 3) {
            throw new SetException("Irregular3DSet.valueToTri: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        int length = value[0].length;
        if (length != value[1].length || length != value[2].length) {
            throw new SetException("Irregular3DSet.valueToTri: lengths don't match");
        }
        boolean nonConvex = this.Delan.getNonConvex();
        float[] PA = new float[3];
        float[] PB = new float[3];
        float[] PC = new float[3];
        float[] PD = new float[3];
        float[] BAxCB = new float[3];
        float[] CBxDC = new float[3];
        float[] DCxAD = new float[3];
        float[] ADxBA = new float[3];
        boolean[] fail_tri = new boolean[this.Delan.Tri.length];
        for (int kk = 0; kk < fail_tri.length; ++kk) {
            fail_tri[kk] = false;
        }
        int[] fail_list = null;
        int fail_length = 0;
        int[] tri = new int[length];
        int curtri = 0;
        float[][] mySamples = this.getMySamples();
        for (int i = 0; i < length; ++i) {
            tri[i] = -1;
            boolean foundit = false;
            if (curtri < 0) {
                curtri = 0;
            }
            for (int itnum = 0; itnum < this.Delan.Tri.length && !foundit; ++itnum) {
                boolean test4;
                boolean test3;
                boolean test2;
                boolean test1;
                int t0 = this.Delan.Tri[curtri][0];
                int t1 = this.Delan.Tri[curtri][1];
                int t2 = this.Delan.Tri[curtri][2];
                int t3 = this.Delan.Tri[curtri][3];
                float Ax = mySamples[0][t0];
                float Ay = mySamples[1][t0];
                float Az = mySamples[2][t0];
                float Bx = mySamples[0][t1];
                float By = mySamples[1][t1];
                float Bz = mySamples[2][t1];
                float Cx = mySamples[0][t2];
                float Cy = mySamples[1][t2];
                float Cz = mySamples[2][t2];
                float Dx = mySamples[0][t3];
                float Dy = mySamples[1][t3];
                float Dz = mySamples[2][t3];
                float Px = value[0][i];
                float Py = value[1][i];
                float Pz = value[2][i];
                PA[0] = Px - Ax;
                PA[1] = Py - Ay;
                PA[2] = Pz - Az;
                PB[0] = Px - Bx;
                PB[1] = Py - By;
                PB[2] = Pz - Bz;
                PC[0] = Px - Cx;
                PC[1] = Py - Cy;
                PC[2] = Pz - Cz;
                PD[0] = Px - Dx;
                PD[1] = Py - Dy;
                PD[2] = Pz - Dz;
                BAxCB[0] = (By - Ay) * (Cz - Bz) - (Bz - Az) * (Cy - By);
                BAxCB[1] = (Bz - Az) * (Cx - Bx) - (Bx - Ax) * (Cz - Bz);
                BAxCB[2] = (Bx - Ax) * (Cy - By) - (By - Ay) * (Cx - Bx);
                float sum_BAxCB = Math.abs(BAxCB[0]) + Math.abs(BAxCB[1]) + Math.abs(BAxCB[2]);
                CBxDC[0] = (Cy - By) * (Dz - Cz) - (Cz - Bz) * (Dy - Cy);
                CBxDC[1] = (Cz - Bz) * (Dx - Cx) - (Cx - Bx) * (Dz - Cz);
                CBxDC[2] = (Cx - Bx) * (Dy - Cy) - (Cy - By) * (Dx - Cx);
                float sum_CBxDC = Math.abs(CBxDC[0]) + Math.abs(CBxDC[1]) + Math.abs(CBxDC[2]);
                DCxAD[0] = (Dy - Cy) * (Az - Dz) - (Dz - Cz) * (Ay - Dy);
                DCxAD[1] = (Dz - Cz) * (Ax - Dx) - (Dx - Cx) * (Az - Dz);
                DCxAD[2] = (Dx - Cx) * (Ay - Dy) - (Dy - Cy) * (Ax - Dx);
                float sum_DCxAD = Math.abs(DCxAD[0]) + Math.abs(DCxAD[1]) + Math.abs(DCxAD[2]);
                ADxBA[0] = (Ay - Dy) * (Bz - Az) - (Az - Dz) * (By - Ay);
                ADxBA[1] = (Az - Dz) * (Bx - Ax) - (Ax - Dx) * (Bz - Az);
                ADxBA[2] = (Ax - Dx) * (By - Ay) - (Ay - Dy) * (Bx - Ax);
                float sum_ADxBA = Math.abs(ADxBA[0]) + Math.abs(ADxBA[1]) + Math.abs(ADxBA[2]);
                float tval1 = BAxCB[0] * PA[0] + BAxCB[1] * PA[1] + BAxCB[2] * PA[2];
                float tval2 = CBxDC[0] * PB[0] + CBxDC[1] * PB[1] + CBxDC[2] * PB[2];
                float tval3 = DCxAD[0] * PC[0] + DCxAD[1] * PC[1] + DCxAD[2] * PC[2];
                float tval4 = ADxBA[0] * PD[0] + ADxBA[1] * PD[1] + ADxBA[2] * PD[2];
                boolean bl = (tval1 == 0.0f || tval1 > 0.0f == BAxCB[0] * (Dx - Ax) + BAxCB[1] * (Dy - Ay) + BAxCB[2] * (Dz - Az) > 0.0f) && sum_BAxCB != 0.0f ? true : (test1 = false);
                boolean bl2 = (tval2 == 0.0f || tval2 > 0.0f == CBxDC[0] * (Ax - Bx) + CBxDC[1] * (Ay - By) + CBxDC[2] * (Az - Bz) > 0.0f) && sum_CBxDC != 0.0f ? true : (test2 = false);
                boolean bl3 = (tval3 == 0.0f || tval3 > 0.0f == DCxAD[0] * (Bx - Cx) + DCxAD[1] * (By - Cy) + DCxAD[2] * (Bz - Cz) > 0.0f) && sum_DCxAD != 0.0f ? true : (test3 = false);
                boolean bl4 = (tval4 == 0.0f || tval4 > 0.0f == ADxBA[0] * (Cx - Dx) + ADxBA[1] * (Cy - Dy) + ADxBA[2] * (Cz - Dz) > 0.0f) && sum_ADxBA != 0.0f ? true : (test4 = false);
                if (!(test1 && test2 && test3 && test4)) {
                    fail_tri[curtri] = true;
                    if (fail_list == null) {
                        fail_list = new int[4];
                        fail_length = 0;
                    } else if (fail_length >= fail_list.length) {
                        int[] new_fail_list = new int[2 * fail_list.length];
                        System.arraycopy(fail_list, 0, new_fail_list, 0, fail_list.length);
                        fail_list = new_fail_list;
                    }
                    fail_list[fail_length] = curtri;
                    ++fail_length;
                    int t = -1;
                    boolean fail = true;
                    if (!test1 && fail && (t = this.Delan.Walk[curtri][0]) != -1) {
                        fail = fail_tri[t];
                    }
                    if (!test2 && fail && (t = this.Delan.Walk[curtri][1]) != -1) {
                        fail = fail_tri[t];
                    }
                    if (!test3 && fail && (t = this.Delan.Walk[curtri][2]) != -1) {
                        fail = fail_tri[t];
                    }
                    if (!test4 && fail && (t = this.Delan.Walk[curtri][3]) != -1) {
                        fail = fail_tri[t];
                    }
                    if (!fail || t == -1) {
                        curtri = t;
                    }
                    if (fail) {
                        curtri = -1;
                    }
                    if (nonConvex && curtri == -1) {
                        for (int jj = 0; jj < fail_tri.length; ++jj) {
                            if (fail_tri[jj]) continue;
                            curtri = jj;
                            break;
                        }
                    }
                } else {
                    foundit = true;
                }
                if (curtri < 0) {
                    foundit = true;
                }
                if (!foundit) continue;
                tri[i] = curtri;
            }
            if (fail_list == null) continue;
            for (int ii = 0; ii < fail_length; ++ii) {
                fail_tri[fail_list[ii]] = false;
            }
            fail_list = null;
        }
        return tri;
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        if (value.length < this.DomainDimension) {
            throw new SetException("Irregular3DSet.valueToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        float[][] mySamples = this.getMySamples();
        int[] tri = this.valueToTri(value);
        int[] index = new int[tri.length];
        for (int i = 0; i < tri.length; ++i) {
            if (tri[i] < 0) {
                index[i] = -1;
                continue;
            }
            float x = value[0][i];
            float y = value[1][i];
            float z = value[2][i];
            int t = tri[i];
            int t0 = this.Delan.Tri[t][0];
            int t1 = this.Delan.Tri[t][1];
            int t2 = this.Delan.Tri[t][2];
            int t3 = this.Delan.Tri[t][3];
            float D00 = mySamples[0][t0] - x;
            float D01 = mySamples[1][t0] - y;
            float D02 = mySamples[2][t0] - z;
            float D10 = mySamples[0][t1] - x;
            float D11 = mySamples[1][t1] - y;
            float D12 = mySamples[2][t1] - z;
            float D20 = mySamples[0][t2] - x;
            float D21 = mySamples[1][t2] - y;
            float D22 = mySamples[2][t2] - z;
            float D30 = mySamples[0][t3] - x;
            float D31 = mySamples[1][t3] - y;
            float D32 = mySamples[2][t3] - z;
            float Dsq0 = D00 * D00 + D01 * D01 + D02 * D02;
            float Dsq1 = D10 * D10 + D11 * D11 + D12 * D12;
            float Dsq2 = D20 * D20 + D21 * D21 + D22 * D22;
            float Dsq3 = D30 * D30 + D31 * D31 + D32 * D32;
            float min = Math.min(Dsq0, Dsq1);
            min = Math.min(min, Dsq2);
            index[i] = (min = Math.min(min, Dsq3)) == Dsq0 ? t0 : (min == Dsq1 ? t1 : (min == Dsq2 ? t2 : t3));
        }
        return index;
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        if (value.length < this.DomainDimension) {
            throw new SetException("Irregular3DSet.valueToInterp: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        if (indices.length < length || weights.length < length) {
            throw new SetException("Irregular3DSet.valueToInterp: lengths don't match");
        }
        float[][] mySamples = this.getMySamples();
        int[] tri = this.valueToTri(value);
        for (int i = 0; i < tri.length; ++i) {
            if (tri[i] < 0) {
                indices[i] = null;
                weights[i] = null;
                continue;
            }
            int[] ival = new int[4];
            float[] wval = new float[4];
            float x = value[0][i];
            float y = value[1][i];
            float z = value[2][i];
            int t = tri[i];
            int t0 = this.Delan.Tri[t][0];
            int t1 = this.Delan.Tri[t][1];
            int t2 = this.Delan.Tri[t][2];
            int t3 = this.Delan.Tri[t][3];
            ival[0] = t0;
            ival[1] = t1;
            ival[2] = t2;
            ival[3] = t3;
            float x0 = mySamples[0][t0];
            float y0 = mySamples[1][t0];
            float z0 = mySamples[2][t0];
            float x1 = mySamples[0][t1];
            float y1 = mySamples[1][t1];
            float z1 = mySamples[2][t1];
            float x2 = mySamples[0][t2];
            float y2 = mySamples[1][t2];
            float z2 = mySamples[2][t2];
            float x3 = mySamples[0][t3];
            float y3 = mySamples[1][t3];
            float z3 = mySamples[2][t3];
            float C0x = (y3 - y1) * (z2 - z1) - (z3 - z1) * (y2 - y1);
            float C0y = (z3 - z1) * (x2 - x1) - (x3 - x1) * (z2 - z1);
            float C0z = (x3 - x1) * (y2 - y1) - (y3 - y1) * (x2 - x1);
            float C1x = (y3 - y0) * (z2 - z0) - (z3 - z0) * (y2 - y0);
            float C1y = (z3 - z0) * (x2 - x0) - (x3 - x0) * (z2 - z0);
            float C1z = (x3 - x0) * (y2 - y0) - (y3 - y0) * (x2 - x0);
            float C2x = (y3 - y0) * (z1 - z0) - (z3 - z0) * (y1 - y0);
            float C2y = (z3 - z0) * (x1 - x0) - (x3 - x0) * (z1 - z0);
            float C2z = (x3 - x0) * (y1 - y0) - (y3 - y0) * (x1 - x0);
            float C3x = (y2 - y0) * (z1 - z0) - (z2 - z0) * (y1 - y0);
            float C3y = (z2 - z0) * (x1 - x0) - (x2 - x0) * (z1 - z0);
            float C3z = (x2 - x0) * (y1 - y0) - (y2 - y0) * (x1 - x0);
            wval[0] = ((x - x1) * C0x + (y - y1) * C0y + (z - z1) * C0z) / ((x0 - x1) * C0x + (y0 - y1) * C0y + (z0 - z1) * C0z);
            wval[1] = ((x - x0) * C1x + (y - y0) * C1y + (z - z0) * C1z) / ((x1 - x0) * C1x + (y1 - y0) * C1y + (z1 - z0) * C1z);
            wval[2] = ((x - x0) * C2x + (y - y0) * C2y + (z - z0) * C2z) / ((x2 - x0) * C2x + (y2 - y0) * C2y + (z2 - z0) * C2z);
            wval[3] = ((x - x0) * C3x + (y - y0) * C3y + (z - z0) * C3z) / ((x3 - x0) * C3x + (y3 - y0) * C3y + (z3 - z0) * C3z);
            indices[i] = ival;
            weights[i] = wval;
        }
    }

    public VisADGeometryArray[][] makeIsoLines(float[] intervals, float lowlimit, float highlimit, float base, float[] fieldValues, byte[][] color_values, boolean[] swap, boolean dash, boolean fill, ScalarMap[] smap, double scale_ratio, double label_size, boolean sphericalDisplayCS) throws VisADException {
        if (this.ManifoldDimension != 2) {
            throw new DisplayException("Irregular3DSet.makeIsoLines: ManifoldDimension must be 2, not " + this.ManifoldDimension);
        }
        if (intervals == null) {
            return null;
        }
        int[][] Tri = this.Delan.Tri;
        float[][] samples = this.getSamples(false);
        int npolygons = Tri.length;
        int nvertex = this.Delan.Vertices.length;
        if (npolygons < 1 || nvertex < 3) {
            return null;
        }
        int maxv = 4 * this.Length;
        int color_length = color_values != null ? color_values.length : 0;
        byte[][] color_levels = null;
        if (color_length > 0) {
            if (color_length > 3) {
                color_length = 3;
            }
            color_levels = new byte[color_length][maxv];
        }
        float[] vx = new float[maxv];
        float[] vy = new float[maxv];
        float[] vz = new float[maxv];
        int numv = 0;
        block5: for (int jj = 0; jj < npolygons; ++jj) {
            float gc;
            float gb;
            int va = Tri[jj][0];
            int vb = Tri[jj][1];
            int vc = Tri[jj][2];
            float ga = fieldValues[va];
            if (ga != ga || (gb = fieldValues[vb]) != gb || (gc = fieldValues[vc]) != gc) continue;
            byte[] auxa = null;
            byte[] auxb = null;
            byte[] auxc = null;
            if (color_length > 0) {
                auxa = new byte[color_length];
                auxb = new byte[color_length];
                auxc = new byte[color_length];
                for (int i = 0; i < color_length; ++i) {
                    auxa[i] = color_values[i][va];
                    auxb[i] = color_values[i][vb];
                    auxc[i] = color_values[i][vc];
                }
            }
            float gn = ga < gb ? ga : gb;
            gn = gc < gn ? gc : gn;
            float gx = ga > gb ? ga : gb;
            gx = gc > gx ? gc : gx;
            block7: for (int il = 0; il < intervals.length; ++il) {
                float gg = intervals[il];
                if (numv + 8 >= maxv) {
                    maxv = 2 * maxv;
                    byte[][] t = color_levels;
                    color_levels = new byte[color_length][maxv];
                    for (int i = 0; i < color_length; ++i) {
                        System.arraycopy(t[i], 0, color_levels[i], 0, numv);
                    }
                    float[] tx = vx;
                    float[] ty = vy;
                    float[] tz = vz;
                    vx = new float[maxv];
                    vy = new float[maxv];
                    vz = new float[maxv];
                    System.arraycopy(tx, 0, vx, 0, numv);
                    System.arraycopy(ty, 0, vy, 0, numv);
                    System.arraycopy(tz, 0, vz, 0, numv);
                }
                if (gg < gn) continue;
                if (gg > gx) continue block5;
                if (gg < lowlimit) continue;
                if (gg > highlimit) continue block5;
                int ii = 0;
                if (gg > ga) {
                    ii = 1;
                }
                if (gg > gb) {
                    ii += 2;
                }
                if (gg > gc) {
                    ii += 4;
                }
                if (ii > 3) {
                    ii = 7 - ii;
                }
                if (ii <= 0) continue;
                switch (ii) {
                    case 1: {
                        int t;
                        int i;
                        float gba = gb - ga;
                        float gca = gc - ga;
                        float ratioba = (gg - ga) / gba;
                        float ratioca = (gg - ga) / gca;
                        if (color_length > 0) {
                            for (i = 0; i < color_length; ++i) {
                                t = (int)((1.0f - ratioba) * (auxa[i] < 0 ? (float)auxa[i] + 256.0f : (float)auxa[i]) + ratioba * (auxb[i] < 0 ? (float)auxb[i] + 256.0f : (float)auxb[i]));
                                color_levels[i][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                t = (int)((1.0f - ratioca) * (auxa[i] < 0 ? (float)auxa[i] + 256.0f : (float)auxa[i]) + ratioca * (auxc[i] < 0 ? (float)auxc[i] + 256.0f : (float)auxc[i]));
                                color_levels[i][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                            }
                        }
                        vx[numv] = samples[0][va] + (samples[0][vb] - samples[0][va]) * ratioba;
                        vy[numv] = samples[1][va] + (samples[1][vb] - samples[1][va]) * ratioba;
                        vz[numv] = samples[2][va] + (samples[2][vb] - samples[2][va]) * ratioba;
                        vx[++numv] = samples[0][va] + (samples[0][vc] - samples[0][va]) * ratioca;
                        vy[numv] = samples[1][va] + (samples[1][vc] - samples[1][va]) * ratioca;
                        vz[numv] = samples[2][va] + (samples[2][vc] - samples[2][va]) * ratioca;
                        ++numv;
                        continue block7;
                    }
                    case 2: {
                        int t;
                        int i;
                        float gba = gb - ga;
                        float gcb = gc - gb;
                        float ratioba = (gg - ga) / gba;
                        float ratiocb = (gg - gb) / gcb;
                        if (color_length > 0) {
                            for (i = 0; i < color_length; ++i) {
                                t = (int)((1.0f - ratioba) * (auxa[i] < 0 ? (float)auxa[i] + 256.0f : (float)auxa[i]) + ratioba * (auxb[i] < 0 ? (float)auxb[i] + 256.0f : (float)auxb[i]));
                                color_levels[i][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                t = (int)((1.0f - ratiocb) * (auxb[i] < 0 ? (float)auxb[i] + 256.0f : (float)auxb[i]) + ratiocb * (auxc[i] < 0 ? (float)auxc[i] + 256.0f : (float)auxc[i]));
                                color_levels[i][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                            }
                        }
                        vx[numv] = samples[0][va] + (samples[0][vb] - samples[0][va]) * ratioba;
                        vy[numv] = samples[1][va] + (samples[1][vb] - samples[1][va]) * ratioba;
                        vz[numv] = samples[2][va] + (samples[2][vb] - samples[2][va]) * ratioba;
                        vx[++numv] = samples[0][vb] + (samples[0][vc] - samples[0][vb]) * ratiocb;
                        vy[numv] = samples[1][vb] + (samples[1][vc] - samples[1][vb]) * ratiocb;
                        vz[numv] = samples[2][vb] + (samples[2][vc] - samples[2][vb]) * ratiocb;
                        ++numv;
                        continue block7;
                    }
                    case 3: {
                        int t;
                        int i;
                        float gca = gc - ga;
                        float gcb = gc - gb;
                        float ratioca = (gg - ga) / gca;
                        float ratiocb = (gg - gb) / gcb;
                        if (color_length > 0) {
                            for (i = 0; i < color_length; ++i) {
                                t = (int)((1.0f - ratioca) * (auxa[i] < 0 ? (float)auxa[i] + 256.0f : (float)auxa[i]) + ratioca * (auxc[i] < 0 ? (float)auxc[i] + 256.0f : (float)auxc[i]));
                                color_levels[i][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                t = (int)((1.0f - ratiocb) * (auxb[i] < 0 ? (float)auxb[i] + 256.0f : (float)auxb[i]) + ratiocb * (auxc[i] < 0 ? (float)auxc[i] + 256.0f : (float)auxc[i]));
                                color_levels[i][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                            }
                        }
                        vx[numv] = samples[0][va] + (samples[0][vc] - samples[0][va]) * ratioca;
                        vy[numv] = samples[1][va] + (samples[1][vc] - samples[1][va]) * ratioca;
                        vz[numv] = samples[2][va] + (samples[2][vc] - samples[2][va]) * ratioca;
                        vx[++numv] = samples[0][vb] + (samples[0][vc] - samples[0][vb]) * ratiocb;
                        vy[numv] = samples[1][vb] + (samples[1][vc] - samples[1][vb]) * ratiocb;
                        vz[numv] = samples[2][vb] + (samples[2][vc] - samples[2][vb]) * ratiocb;
                        ++numv;
                    }
                }
            }
        }
        VisADLineArray lineArray = new VisADLineArray();
        float[][] coordinates = new float[3][numv];
        System.arraycopy(vx, 0, coordinates[0], 0, numv);
        System.arraycopy(vy, 0, coordinates[1], 0, numv);
        System.arraycopy(vz, 0, coordinates[2], 0, numv);
        vx = null;
        vy = null;
        vz = null;
        byte[][] colors = null;
        if (color_length > 0) {
            colors = new byte[3][numv];
            System.arraycopy(color_levels[0], 0, colors[0], 0, numv);
            System.arraycopy(color_levels[1], 0, colors[1], 0, numv);
            System.arraycopy(color_levels[2], 0, colors[2], 0, numv);
            color_levels = null;
        }
        Irregular3DSet.setGeometryArray(lineArray, coordinates, 4, colors);
        return new VisADLineArray[][]{{lineArray}, null, null};
    }

    public VisADGeometryArray makeIsoSurface(float isolevel, float[] fieldValues, byte[][] color_values, boolean indexed) throws VisADException {
        int i;
        if (this.ManifoldDimension != 3) {
            throw new DisplayException("Irregular3DSet.main_isosurf: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        Object fieldVertices = new float[3][];
        Object color_levels = null;
        if (color_values != null) {
            color_levels = new byte[color_values.length][];
        }
        Object polyToVert = new int[1][][];
        Object vertToPoly = new int[1][][];
        this.makeIsosurface(isolevel, fieldValues, color_values, (float[][])fieldVertices, (byte[][])color_levels, (int[][][])polyToVert, (int[][][])vertToPoly);
        int nvertex = vertToPoly[0].length;
        int npolygons = polyToVert[0].length;
        float[] NX = new float[nvertex];
        float[] NY = new float[nvertex];
        float[] NZ = new float[nvertex];
        if (nvertex == 0 || npolygons == 0) {
            return null;
        }
        float[] NxA = new float[npolygons];
        float[] NxB = new float[npolygons];
        float[] NyA = new float[npolygons];
        float[] NyB = new float[npolygons];
        float[] NzA = new float[npolygons];
        float[] NzB = new float[npolygons];
        float[] Pnx = new float[npolygons];
        float[] Pny = new float[npolygons];
        float[] Pnz = new float[npolygons];
        Irregular3DSet.make_normals(fieldVertices[0], fieldVertices[1], fieldVertices[2], NX, NY, NZ, nvertex, npolygons, Pnx, Pny, Pnz, NxA, NxB, NyA, NyB, NzA, NzB, vertToPoly[0], polyToVert[0]);
        Pnz = null;
        Pny = null;
        Pnx = null;
        NzB = null;
        NzA = null;
        NyB = null;
        NyA = null;
        NxB = null;
        NxA = null;
        float[] normals = new float[3 * nvertex];
        int j = 0;
        for (int i2 = 0; i2 < nvertex; ++i2) {
            normals[j++] = NX[i2];
            normals[j++] = NY[i2];
            normals[j++] = NZ[i2];
        }
        NZ = null;
        NY = null;
        NX = null;
        int[] stripe = new int[6 * npolygons];
        int size_stripe = Irregular3DSet.poly_triangle_stripe(stripe, nvertex, npolygons, vertToPoly[0], polyToVert[0]);
        vertToPoly = null;
        polyToVert = null;
        if (indexed) {
            VisADIndexedTriangleStripArray array = new VisADIndexedTriangleStripArray();
            array.indexCount = size_stripe;
            array.indices = new int[size_stripe];
            System.arraycopy(stripe, 0, array.indices, 0, size_stripe);
            array.stripVertexCounts = new int[1];
            array.stripVertexCounts[0] = size_stripe;
            stripe = null;
            Irregular3DSet.setGeometryArray(array, fieldVertices, 4, color_levels);
            fieldVertices = null;
            color_levels = null;
            array.normals = normals;
            return array;
        }
        VisADTriangleStripArray array = new VisADTriangleStripArray();
        array.stripVertexCounts = new int[]{size_stripe};
        array.vertexCount = size_stripe;
        array.normals = new float[3 * size_stripe];
        int k = 0;
        for (i = 0; i < 3 * size_stripe; i += 3) {
            j = 3 * stripe[k];
            array.normals[i] = normals[j];
            array.normals[i + 1] = normals[j + 1];
            array.normals[i + 2] = normals[j + 2];
            ++k;
        }
        normals = null;
        array.coordinates = new float[3 * size_stripe];
        k = 0;
        for (i = 0; i < 3 * size_stripe; i += 3) {
            j = stripe[k];
            array.coordinates[i] = fieldVertices[0][j];
            array.coordinates[i + 1] = fieldVertices[1][j];
            array.coordinates[i + 2] = fieldVertices[2][j];
            ++k;
        }
        fieldVertices = null;
        if (color_levels != null) {
            int color_length = ((byte[][])color_levels).length;
            array.colors = new byte[color_length * size_stripe];
            k = 0;
            if (color_length == 4) {
                for (int i3 = 0; i3 < color_length * size_stripe; i3 += color_length) {
                    j = stripe[k];
                    array.colors[i3] = color_levels[0][j];
                    array.colors[i3 + 1] = color_levels[1][j];
                    array.colors[i3 + 2] = color_levels[2][j];
                    array.colors[i3 + 3] = color_levels[3][j];
                    ++k;
                }
            } else {
                for (int i4 = 0; i4 < color_length * size_stripe; i4 += color_length) {
                    j = stripe[k];
                    array.colors[i4] = color_levels[0][j];
                    array.colors[i4 + 1] = color_levels[1][j];
                    array.colors[i4 + 2] = color_levels[2][j];
                    ++k;
                }
            }
        }
        color_levels = null;
        stripe = null;
        return array;
    }

    private void makeIsosurface(float isolevel, float[] fieldValues, byte[][] auxValues, float[][] fieldVertices, byte[][] auxLevels, int[][][] polyToVert, int[][][] vertToPoly) throws VisADException {
        int j;
        int i;
        int j2;
        int i2;
        int i3;
        int naux;
        boolean DEBUG = false;
        if (this.ManifoldDimension != 3) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        if (fieldValues.length != this.Length) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: fieldValues length does't match");
        }
        if (Double.isNaN(isolevel)) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: isolevel cannot be missing");
        }
        if (fieldVertices.length != 3 || polyToVert.length != 1 || vertToPoly.length != 1) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: return value arrays not correctly initialized " + fieldVertices.length + " " + polyToVert.length + " " + vertToPoly.length);
        }
        int n = naux = auxValues != null ? auxValues.length : 0;
        if (naux > 0) {
            if (auxLevels == null || auxLevels.length != naux) {
                throw new DisplayException("Irregular3DSet.makeIsosurface: auxLevels length doesn't match");
            }
            for (i3 = 0; i3 < naux; ++i3) {
                if (auxValues[i3].length == this.Length) continue;
                throw new DisplayException("Irregular3DSet.makeIsosurface: auxValues lengths don't match");
            }
        } else if (auxLevels != null) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: auxValues null but auxLevels not null");
        }
        if (DEBUG) {
            System.out.println("isolevel = " + isolevel + "\n");
            System.out.println("fieldValues " + fieldValues.length);
            for (i3 = 0; i3 < fieldValues.length; ++i3) {
                System.out.println("  " + i3 + " -> " + fieldValues[i3]);
            }
            System.out.println(this.Delan.sampleString(this.getMySamples()));
        }
        int trilength = this.Delan.Tri.length;
        int[][] polys = new int[trilength][4];
        int[] globalToVertex = new int[this.Delan.NumEdges];
        for (int i4 = 0; i4 < this.Delan.NumEdges; ++i4) {
            globalToVertex[i4] = -1;
        }
        float[][] edgeInterp = new float[this.DomainDimension][this.Delan.NumEdges];
        for (int i5 = 0; i5 < this.Delan.NumEdges; ++i5) {
            edgeInterp[0][i5] = Float.NaN;
        }
        byte[][] auxInterp = naux > 0 ? new byte[naux][this.Delan.NumEdges] : (byte[][])null;
        int nvertex = 0;
        int npolygons = 0;
        float[][] mySamples = this.getMySamples();
        block14: for (i2 = 0; i2 < trilength; ++i2) {
            int v0 = this.Delan.Tri[i2][0];
            int v1 = this.Delan.Tri[i2][1];
            int v2 = this.Delan.Tri[i2][2];
            int v3 = this.Delan.Tri[i2][3];
            float f0 = fieldValues[v0];
            float f1 = fieldValues[v1];
            float f2 = fieldValues[v2];
            float f3 = fieldValues[v3];
            float vx = mySamples[0][v3] - mySamples[0][v0];
            float vy = mySamples[1][v3] - mySamples[1][v0];
            float vz = mySamples[2][v3] - mySamples[2][v0];
            float sx = mySamples[0][v2] - mySamples[0][v0];
            float sy = mySamples[1][v2] - mySamples[1][v0];
            float sz = mySamples[2][v2] - mySamples[2][v0];
            float tx = mySamples[0][v1] - mySamples[0][v0];
            float ty = mySamples[1][v1] - mySamples[1][v0];
            float tz = mySamples[2][v1] - mySamples[2][v0];
            float cx = sy * tz - sz * ty;
            float cy = sz * tx - sx * tz;
            float cz = sx * ty - sy * tx;
            float sig = vx * cx + vy * cy + vz * cz;
            int index = (f0 > isolevel ? 1 : 0) + (f1 > isolevel ? 2 : 0) + (f2 > isolevel ? 4 : 0) + (f3 > isolevel ? 8 : 0);
            if (sig < 0.0f) {
                index = 15 - index;
            }
            switch (index) {
                case 0: 
                case 15: {
                    continue block14;
                }
                case 1: 
                case 14: {
                    int t;
                    int j3;
                    float a;
                    int e0 = this.Delan.Edges[i2][0];
                    int e1 = this.Delan.Edges[i2][1];
                    int e2 = this.Delan.Edges[i2][2];
                    if (edgeInterp[0][e0] != edgeInterp[0][e0]) {
                        a = (isolevel - f1) / (f0 - f1);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e0] = a * mySamples[0][v0] + (1.0f - a) * mySamples[0][v1];
                        edgeInterp[1][e0] = a * mySamples[1][v0] + (1.0f - a) * mySamples[1][v1];
                        edgeInterp[2][e0] = a * mySamples[2][v0] + (1.0f - a) * mySamples[2][v1];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v0] < 0 ? (float)auxValues[j3][v0] + 256.0f : (float)auxValues[j3][v0]) + (1.0f - a) * (auxValues[j3][v1] < 0 ? (float)auxValues[j3][v1] + 256.0f : (float)auxValues[j3][v1]));
                            auxInterp[j3][e0] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e0] = nvertex++;
                    }
                    if (edgeInterp[0][e1] != edgeInterp[0][e1]) {
                        a = (isolevel - f2) / (f0 - f2);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e1] = a * mySamples[0][v0] + (1.0f - a) * mySamples[0][v2];
                        edgeInterp[1][e1] = a * mySamples[1][v0] + (1.0f - a) * mySamples[1][v2];
                        edgeInterp[2][e1] = a * mySamples[2][v0] + (1.0f - a) * mySamples[2][v2];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v0] < 0 ? (float)auxValues[j3][v0] + 256.0f : (float)auxValues[j3][v0]) + (1.0f - a) * (auxValues[j3][v2] < 0 ? (float)auxValues[j3][v2] + 256.0f : (float)auxValues[j3][v2]));
                            auxInterp[j3][e1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e1] = nvertex++;
                    }
                    if (edgeInterp[0][e2] != edgeInterp[0][e2]) {
                        a = (isolevel - f3) / (f0 - f3);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e2] = a * mySamples[0][v0] + (1.0f - a) * mySamples[0][v3];
                        edgeInterp[1][e2] = a * mySamples[1][v0] + (1.0f - a) * mySamples[1][v3];
                        edgeInterp[2][e2] = a * mySamples[2][v0] + (1.0f - a) * mySamples[2][v3];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v0] < 0 ? (float)auxValues[j3][v0] + 256.0f : (float)auxValues[j3][v0]) + (1.0f - a) * (auxValues[j3][v3] < 0 ? (float)auxValues[j3][v3] + 256.0f : (float)auxValues[j3][v3]));
                            auxInterp[j3][e2] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e2] = nvertex++;
                    }
                    polys[npolygons][0] = e0;
                    if (index == 1) {
                        polys[npolygons][1] = e1;
                        polys[npolygons][2] = e2;
                    } else {
                        polys[npolygons][1] = e2;
                        polys[npolygons][2] = e1;
                    }
                    polys[npolygons][3] = -1;
                    ++npolygons;
                    continue block14;
                }
                case 2: 
                case 13: {
                    int t;
                    int j3;
                    float a;
                    int e0 = this.Delan.Edges[i2][0];
                    int e3 = this.Delan.Edges[i2][3];
                    int e4 = this.Delan.Edges[i2][4];
                    if (edgeInterp[0][e0] != edgeInterp[0][e0]) {
                        a = (isolevel - f1) / (f0 - f1);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e0] = a * mySamples[0][v0] + (1.0f - a) * mySamples[0][v1];
                        edgeInterp[1][e0] = a * mySamples[1][v0] + (1.0f - a) * mySamples[1][v1];
                        edgeInterp[2][e0] = a * mySamples[2][v0] + (1.0f - a) * mySamples[2][v1];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v0] < 0 ? (float)auxValues[j3][v0] + 256.0f : (float)auxValues[j3][v0]) + (1.0f - a) * (auxValues[j3][v1] < 0 ? (float)auxValues[j3][v1] + 256.0f : (float)auxValues[j3][v1]));
                            auxInterp[j3][e0] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e0] = nvertex++;
                    }
                    if (edgeInterp[0][e3] != edgeInterp[0][e3]) {
                        a = (isolevel - f2) / (f1 - f2);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e3] = a * mySamples[0][v1] + (1.0f - a) * mySamples[0][v2];
                        edgeInterp[1][e3] = a * mySamples[1][v1] + (1.0f - a) * mySamples[1][v2];
                        edgeInterp[2][e3] = a * mySamples[2][v1] + (1.0f - a) * mySamples[2][v2];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v1] < 0 ? (float)auxValues[j3][v1] + 256.0f : (float)auxValues[j3][v1]) + (1.0f - a) * (auxValues[j3][v2] < 0 ? (float)auxValues[j3][v2] + 256.0f : (float)auxValues[j3][v2]));
                            auxInterp[j3][e3] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e3] = nvertex++;
                    }
                    if (edgeInterp[0][e4] != edgeInterp[0][e4]) {
                        a = (isolevel - f3) / (f1 - f3);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e4] = a * mySamples[0][v1] + (1.0f - a) * mySamples[0][v3];
                        edgeInterp[1][e4] = a * mySamples[1][v1] + (1.0f - a) * mySamples[1][v3];
                        edgeInterp[2][e4] = a * mySamples[2][v1] + (1.0f - a) * mySamples[2][v3];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v1] < 0 ? (float)auxValues[j3][v1] + 256.0f : (float)auxValues[j3][v1]) + (1.0f - a) * (auxValues[j3][v3] < 0 ? (float)auxValues[j3][v3] + 256.0f : (float)auxValues[j3][v3]));
                            auxInterp[j3][e4] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e4] = nvertex++;
                    }
                    polys[npolygons][0] = e0;
                    if (index == 2) {
                        polys[npolygons][1] = e4;
                        polys[npolygons][2] = e3;
                    } else {
                        polys[npolygons][1] = e3;
                        polys[npolygons][2] = e4;
                    }
                    polys[npolygons][3] = -1;
                    ++npolygons;
                    continue block14;
                }
                case 3: 
                case 12: {
                    int t;
                    int j3;
                    float a;
                    int e1 = this.Delan.Edges[i2][1];
                    int e2 = this.Delan.Edges[i2][2];
                    int e3 = this.Delan.Edges[i2][3];
                    int e4 = this.Delan.Edges[i2][4];
                    if (edgeInterp[0][e1] != edgeInterp[0][e1]) {
                        a = (isolevel - f2) / (f0 - f2);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e1] = a * mySamples[0][v0] + (1.0f - a) * mySamples[0][v2];
                        edgeInterp[1][e1] = a * mySamples[1][v0] + (1.0f - a) * mySamples[1][v2];
                        edgeInterp[2][e1] = a * mySamples[2][v0] + (1.0f - a) * mySamples[2][v2];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v0] < 0 ? (float)auxValues[j3][v0] + 256.0f : (float)auxValues[j3][v0]) + (1.0f - a) * (auxValues[j3][v2] < 0 ? (float)auxValues[j3][v2] + 256.0f : (float)auxValues[j3][v2]));
                            auxInterp[j3][e1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e1] = nvertex++;
                    }
                    if (edgeInterp[0][e2] != edgeInterp[0][e2]) {
                        a = (isolevel - f3) / (f0 - f3);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e2] = a * mySamples[0][v0] + (1.0f - a) * mySamples[0][v3];
                        edgeInterp[1][e2] = a * mySamples[1][v0] + (1.0f - a) * mySamples[1][v3];
                        edgeInterp[2][e2] = a * mySamples[2][v0] + (1.0f - a) * mySamples[2][v3];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v0] < 0 ? (float)auxValues[j3][v0] + 256.0f : (float)auxValues[j3][v0]) + (1.0f - a) * (auxValues[j3][v3] < 0 ? (float)auxValues[j3][v3] + 256.0f : (float)auxValues[j3][v3]));
                            auxInterp[j3][e2] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e2] = nvertex++;
                    }
                    if (edgeInterp[0][e4] != edgeInterp[0][e4]) {
                        a = (isolevel - f3) / (f1 - f3);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e4] = a * mySamples[0][v1] + (1.0f - a) * mySamples[0][v3];
                        edgeInterp[1][e4] = a * mySamples[1][v1] + (1.0f - a) * mySamples[1][v3];
                        edgeInterp[2][e4] = a * mySamples[2][v1] + (1.0f - a) * mySamples[2][v3];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v1] < 0 ? (float)auxValues[j3][v1] + 256.0f : (float)auxValues[j3][v1]) + (1.0f - a) * (auxValues[j3][v3] < 0 ? (float)auxValues[j3][v3] + 256.0f : (float)auxValues[j3][v3]));
                            auxInterp[j3][e4] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e4] = nvertex++;
                    }
                    if (edgeInterp[0][e3] != edgeInterp[0][e3]) {
                        a = (isolevel - f2) / (f1 - f2);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e3] = a * mySamples[0][v1] + (1.0f - a) * mySamples[0][v2];
                        edgeInterp[1][e3] = a * mySamples[1][v1] + (1.0f - a) * mySamples[1][v2];
                        edgeInterp[2][e3] = a * mySamples[2][v1] + (1.0f - a) * mySamples[2][v2];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v1] < 0 ? (float)auxValues[j3][v1] + 256.0f : (float)auxValues[j3][v1]) + (1.0f - a) * (auxValues[j3][v2] < 0 ? (float)auxValues[j3][v2] + 256.0f : (float)auxValues[j3][v2]));
                            auxInterp[j3][e3] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e3] = nvertex++;
                    }
                    polys[npolygons][0] = e1;
                    if (index == 3) {
                        polys[npolygons][1] = e2;
                        polys[npolygons][2] = e4;
                        polys[npolygons][3] = e3;
                    } else {
                        polys[npolygons][1] = e3;
                        polys[npolygons][2] = e4;
                        polys[npolygons][3] = e2;
                    }
                    ++npolygons;
                    continue block14;
                }
                case 4: 
                case 11: {
                    int t;
                    int j3;
                    float a;
                    int e1 = this.Delan.Edges[i2][1];
                    int e3 = this.Delan.Edges[i2][3];
                    int e5 = this.Delan.Edges[i2][5];
                    if (edgeInterp[0][e1] != edgeInterp[0][e1]) {
                        a = (isolevel - f2) / (f0 - f2);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e1] = a * mySamples[0][v0] + (1.0f - a) * mySamples[0][v2];
                        edgeInterp[1][e1] = a * mySamples[1][v0] + (1.0f - a) * mySamples[1][v2];
                        edgeInterp[2][e1] = a * mySamples[2][v0] + (1.0f - a) * mySamples[2][v2];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v0] < 0 ? (float)auxValues[j3][v0] + 256.0f : (float)auxValues[j3][v0]) + (1.0f - a) * (auxValues[j3][v2] < 0 ? (float)auxValues[j3][v2] + 256.0f : (float)auxValues[j3][v2]));
                            auxInterp[j3][e1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e1] = nvertex++;
                    }
                    if (edgeInterp[0][e3] != edgeInterp[0][e3]) {
                        a = (isolevel - f2) / (f1 - f2);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e3] = a * mySamples[0][v1] + (1.0f - a) * mySamples[0][v2];
                        edgeInterp[1][e3] = a * mySamples[1][v1] + (1.0f - a) * mySamples[1][v2];
                        edgeInterp[2][e3] = a * mySamples[2][v1] + (1.0f - a) * mySamples[2][v2];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v1] < 0 ? (float)auxValues[j3][v1] + 256.0f : (float)auxValues[j3][v1]) + (1.0f - a) * (auxValues[j3][v2] < 0 ? (float)auxValues[j3][v2] + 256.0f : (float)auxValues[j3][v2]));
                            auxInterp[j3][e3] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e3] = nvertex++;
                    }
                    if (edgeInterp[0][e5] != edgeInterp[0][e5]) {
                        a = (isolevel - f3) / (f2 - f3);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e5] = a * mySamples[0][v2] + (1.0f - a) * mySamples[0][v3];
                        edgeInterp[1][e5] = a * mySamples[1][v2] + (1.0f - a) * mySamples[1][v3];
                        edgeInterp[2][e5] = a * mySamples[2][v2] + (1.0f - a) * mySamples[2][v3];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v2] < 0 ? (float)auxValues[j3][v2] + 256.0f : (float)auxValues[j3][v2]) + (1.0f - a) * (auxValues[j3][v3] < 0 ? (float)auxValues[j3][v3] + 256.0f : (float)auxValues[j3][v3]));
                            auxInterp[j3][e5] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e5] = nvertex++;
                    }
                    polys[npolygons][0] = e1;
                    if (index == 4) {
                        polys[npolygons][1] = e3;
                        polys[npolygons][2] = e5;
                    } else {
                        polys[npolygons][1] = e5;
                        polys[npolygons][2] = e3;
                    }
                    polys[npolygons][3] = -1;
                    ++npolygons;
                    continue block14;
                }
                case 5: 
                case 10: {
                    int t;
                    int j3;
                    float a;
                    int e0 = this.Delan.Edges[i2][0];
                    int e2 = this.Delan.Edges[i2][2];
                    int e3 = this.Delan.Edges[i2][3];
                    int e5 = this.Delan.Edges[i2][5];
                    if (edgeInterp[0][e0] != edgeInterp[0][e0]) {
                        a = (isolevel - f1) / (f0 - f1);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e0] = a * mySamples[0][v0] + (1.0f - a) * mySamples[0][v1];
                        edgeInterp[1][e0] = a * mySamples[1][v0] + (1.0f - a) * mySamples[1][v1];
                        edgeInterp[2][e0] = a * mySamples[2][v0] + (1.0f - a) * mySamples[2][v1];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v0] < 0 ? (float)auxValues[j3][v0] + 256.0f : (float)auxValues[j3][v0]) + (1.0f - a) * (auxValues[j3][v1] < 0 ? (float)auxValues[j3][v1] + 256.0f : (float)auxValues[j3][v1]));
                            auxInterp[j3][e0] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e0] = nvertex++;
                    }
                    if (edgeInterp[0][e2] != edgeInterp[0][e2]) {
                        a = (isolevel - f3) / (f0 - f3);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e2] = a * mySamples[0][v0] + (1.0f - a) * mySamples[0][v3];
                        edgeInterp[1][e2] = a * mySamples[1][v0] + (1.0f - a) * mySamples[1][v3];
                        edgeInterp[2][e2] = a * mySamples[2][v0] + (1.0f - a) * mySamples[2][v3];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v0] < 0 ? (float)auxValues[j3][v0] + 256.0f : (float)auxValues[j3][v0]) + (1.0f - a) * (auxValues[j3][v3] < 0 ? (float)auxValues[j3][v3] + 256.0f : (float)auxValues[j3][v3]));
                            auxInterp[j3][e2] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e2] = nvertex++;
                    }
                    if (edgeInterp[0][e5] != edgeInterp[0][e5]) {
                        a = (isolevel - f3) / (f2 - f3);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e5] = a * mySamples[0][v2] + (1.0f - a) * mySamples[0][v3];
                        edgeInterp[1][e5] = a * mySamples[1][v2] + (1.0f - a) * mySamples[1][v3];
                        edgeInterp[2][e5] = a * mySamples[2][v2] + (1.0f - a) * mySamples[2][v3];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v2] < 0 ? (float)auxValues[j3][v2] + 256.0f : (float)auxValues[j3][v2]) + (1.0f - a) * (auxValues[j3][v3] < 0 ? (float)auxValues[j3][v3] + 256.0f : (float)auxValues[j3][v3]));
                            auxInterp[j3][e5] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e5] = nvertex++;
                    }
                    if (edgeInterp[0][e3] != edgeInterp[0][e3]) {
                        a = (isolevel - f2) / (f1 - f2);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e3] = a * mySamples[0][v1] + (1.0f - a) * mySamples[0][v2];
                        edgeInterp[1][e3] = a * mySamples[1][v1] + (1.0f - a) * mySamples[1][v2];
                        edgeInterp[2][e3] = a * mySamples[2][v1] + (1.0f - a) * mySamples[2][v2];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v1] < 0 ? (float)auxValues[j3][v1] + 256.0f : (float)auxValues[j3][v1]) + (1.0f - a) * (auxValues[j3][v2] < 0 ? (float)auxValues[j3][v2] + 256.0f : (float)auxValues[j3][v2]));
                            auxInterp[j3][e3] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e3] = nvertex++;
                    }
                    polys[npolygons][0] = e0;
                    if (index == 5) {
                        polys[npolygons][1] = e3;
                        polys[npolygons][2] = e5;
                        polys[npolygons][3] = e2;
                    } else {
                        polys[npolygons][1] = e2;
                        polys[npolygons][2] = e5;
                        polys[npolygons][3] = e3;
                    }
                    ++npolygons;
                    continue block14;
                }
                case 6: 
                case 9: {
                    int t;
                    int j3;
                    float a;
                    int e0 = this.Delan.Edges[i2][0];
                    int e1 = this.Delan.Edges[i2][1];
                    int e4 = this.Delan.Edges[i2][4];
                    int e5 = this.Delan.Edges[i2][5];
                    if (edgeInterp[0][e0] != edgeInterp[0][e0]) {
                        a = (isolevel - f1) / (f0 - f1);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e0] = a * mySamples[0][v0] + (1.0f - a) * mySamples[0][v1];
                        edgeInterp[1][e0] = a * mySamples[1][v0] + (1.0f - a) * mySamples[1][v1];
                        edgeInterp[2][e0] = a * mySamples[2][v0] + (1.0f - a) * mySamples[2][v1];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v0] < 0 ? (float)auxValues[j3][v0] + 256.0f : (float)auxValues[j3][v0]) + (1.0f - a) * (auxValues[j3][v1] < 0 ? (float)auxValues[j3][v1] + 256.0f : (float)auxValues[j3][v1]));
                            auxInterp[j3][e0] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e0] = nvertex++;
                    }
                    if (edgeInterp[0][e1] != edgeInterp[0][e1]) {
                        a = (isolevel - f2) / (f0 - f2);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e1] = a * mySamples[0][v0] + (1.0f - a) * mySamples[0][v2];
                        edgeInterp[1][e1] = a * mySamples[1][v0] + (1.0f - a) * mySamples[1][v2];
                        edgeInterp[2][e1] = a * mySamples[2][v0] + (1.0f - a) * mySamples[2][v2];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v0] < 0 ? (float)auxValues[j3][v0] + 256.0f : (float)auxValues[j3][v0]) + (1.0f - a) * (auxValues[j3][v2] < 0 ? (float)auxValues[j3][v2] + 256.0f : (float)auxValues[j3][v2]));
                            auxInterp[j3][e1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e1] = nvertex++;
                    }
                    if (edgeInterp[0][e5] != edgeInterp[0][e5]) {
                        a = (isolevel - f3) / (f2 - f3);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e5] = a * mySamples[0][v2] + (1.0f - a) * mySamples[0][v3];
                        edgeInterp[1][e5] = a * mySamples[1][v2] + (1.0f - a) * mySamples[1][v3];
                        edgeInterp[2][e5] = a * mySamples[2][v2] + (1.0f - a) * mySamples[2][v3];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v2] < 0 ? (float)auxValues[j3][v2] + 256.0f : (float)auxValues[j3][v2]) + (1.0f - a) * (auxValues[j3][v3] < 0 ? (float)auxValues[j3][v3] + 256.0f : (float)auxValues[j3][v3]));
                            auxInterp[j3][e5] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e5] = nvertex++;
                    }
                    if (edgeInterp[0][e4] != edgeInterp[0][e4]) {
                        a = (isolevel - f3) / (f1 - f3);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e4] = a * mySamples[0][v1] + (1.0f - a) * mySamples[0][v3];
                        edgeInterp[1][e4] = a * mySamples[1][v1] + (1.0f - a) * mySamples[1][v3];
                        edgeInterp[2][e4] = a * mySamples[2][v1] + (1.0f - a) * mySamples[2][v3];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v1] < 0 ? (float)auxValues[j3][v1] + 256.0f : (float)auxValues[j3][v1]) + (1.0f - a) * (auxValues[j3][v3] < 0 ? (float)auxValues[j3][v3] + 256.0f : (float)auxValues[j3][v3]));
                            auxInterp[j3][e4] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e4] = nvertex++;
                    }
                    polys[npolygons][0] = e0;
                    if (index == 6) {
                        polys[npolygons][1] = e4;
                        polys[npolygons][2] = e5;
                        polys[npolygons][3] = e1;
                    } else {
                        polys[npolygons][1] = e1;
                        polys[npolygons][2] = e5;
                        polys[npolygons][3] = e4;
                    }
                    ++npolygons;
                    continue block14;
                }
                case 7: 
                case 8: {
                    int t;
                    int j3;
                    float a;
                    int e2 = this.Delan.Edges[i2][2];
                    int e4 = this.Delan.Edges[i2][4];
                    int e5 = this.Delan.Edges[i2][5];
                    if (edgeInterp[0][e2] != edgeInterp[0][e2]) {
                        a = (isolevel - f3) / (f0 - f3);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e2] = a * mySamples[0][v0] + (1.0f - a) * mySamples[0][v3];
                        edgeInterp[1][e2] = a * mySamples[1][v0] + (1.0f - a) * mySamples[1][v3];
                        edgeInterp[2][e2] = a * mySamples[2][v0] + (1.0f - a) * mySamples[2][v3];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v0] < 0 ? (float)auxValues[j3][v0] + 256.0f : (float)auxValues[j3][v0]) + (1.0f - a) * (auxValues[j3][v3] < 0 ? (float)auxValues[j3][v3] + 256.0f : (float)auxValues[j3][v3]));
                            auxInterp[j3][e2] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e2] = nvertex++;
                    }
                    if (edgeInterp[0][e4] != edgeInterp[0][e4]) {
                        a = (isolevel - f3) / (f1 - f3);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e4] = a * mySamples[0][v1] + (1.0f - a) * mySamples[0][v3];
                        edgeInterp[1][e4] = a * mySamples[1][v1] + (1.0f - a) * mySamples[1][v3];
                        edgeInterp[2][e4] = a * mySamples[2][v1] + (1.0f - a) * mySamples[2][v3];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v1] < 0 ? (float)auxValues[j3][v1] + 256.0f : (float)auxValues[j3][v1]) + (1.0f - a) * (auxValues[j3][v3] < 0 ? (float)auxValues[j3][v3] + 256.0f : (float)auxValues[j3][v3]));
                            auxInterp[j3][e4] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e4] = nvertex++;
                    }
                    if (edgeInterp[0][e5] != edgeInterp[0][e5]) {
                        a = (isolevel - f3) / (f2 - f3);
                        if (a < 0.0f) {
                            a = -a;
                        }
                        edgeInterp[0][e5] = a * mySamples[0][v2] + (1.0f - a) * mySamples[0][v3];
                        edgeInterp[1][e5] = a * mySamples[1][v2] + (1.0f - a) * mySamples[1][v3];
                        edgeInterp[2][e5] = a * mySamples[2][v2] + (1.0f - a) * mySamples[2][v3];
                        for (j3 = 0; j3 < naux; ++j3) {
                            t = (int)(a * (auxValues[j3][v2] < 0 ? (float)auxValues[j3][v2] + 256.0f : (float)auxValues[j3][v2]) + (1.0f - a) * (auxValues[j3][v3] < 0 ? (float)auxValues[j3][v3] + 256.0f : (float)auxValues[j3][v3]));
                            auxInterp[j3][e5] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                        }
                        globalToVertex[e5] = nvertex++;
                    }
                    polys[npolygons][0] = e2;
                    if (index == 7) {
                        polys[npolygons][1] = e4;
                        polys[npolygons][2] = e5;
                    } else {
                        polys[npolygons][1] = e5;
                        polys[npolygons][2] = e4;
                    }
                    polys[npolygons][3] = -1;
                    ++npolygons;
                }
            }
        }
        if (DEBUG) {
            System.out.println("\npolys (polys -> global edges) " + npolygons + "\n");
            for (i2 = 0; i2 < npolygons; ++i2) {
                String s = "  " + i2 + " -> ";
                for (j2 = 0; j2 < 4; ++j2) {
                    s = s + " " + polys[i2][j2];
                }
                System.out.println(s + "\n");
            }
        }
        polyToVert[0] = new int[npolygons][];
        for (i2 = 0; i2 < npolygons; ++i2) {
            int n2 = polys[i2][3] < 0 ? 3 : 4;
            polyToVert[0][i2] = new int[n2];
            for (j2 = 0; j2 < n2; ++j2) {
                polyToVert[0][i2][j2] = globalToVertex[polys[i2][j2]];
            }
        }
        if (DEBUG) {
            System.out.println("\npolyToVert (polys -> vertices) " + npolygons + "\n");
            for (i2 = 0; i2 < npolygons; ++i2) {
                String s = "  " + i2 + " -> ";
                for (j2 = 0; j2 < polyToVert[0][i2].length; ++j2) {
                    s = s + " " + polyToVert[0][i2][j2];
                }
                System.out.println(s + "\n");
            }
        }
        int[] nverts = new int[nvertex];
        for (i = 0; i < nvertex; ++i) {
            nverts[i] = 0;
        }
        for (i = 0; i < npolygons; ++i) {
            int n3 = polyToVert[0][i][0];
            nverts[n3] = nverts[n3] + 1;
            int n4 = polyToVert[0][i][1];
            nverts[n4] = nverts[n4] + 1;
            int n5 = polyToVert[0][i][2];
            nverts[n5] = nverts[n5] + 1;
            if (polyToVert[0][i].length <= 3) continue;
            int n6 = polyToVert[0][i][3];
            nverts[n6] = nverts[n6] + 1;
        }
        vertToPoly[0] = new int[nvertex][];
        for (i = 0; i < nvertex; ++i) {
            vertToPoly[0][i] = new int[nverts[i]];
        }
        for (i = 0; i < nvertex; ++i) {
            nverts[i] = 0;
        }
        for (i = 0; i < npolygons; ++i) {
            int d;
            int a = polyToVert[0][i][0];
            int b = polyToVert[0][i][1];
            int c = polyToVert[0][i][2];
            int n7 = a;
            int n8 = nverts[n7];
            nverts[n7] = n8 + 1;
            vertToPoly[0][a][n8] = i;
            int n9 = b;
            int n10 = nverts[n9];
            nverts[n9] = n10 + 1;
            vertToPoly[0][b][n10] = i;
            int n11 = c;
            int n12 = nverts[n11];
            nverts[n11] = n12 + 1;
            vertToPoly[0][c][n12] = i;
            if (polyToVert[0][i].length <= 3 || (d = polyToVert[0][i][3]) == -1) continue;
            int n13 = d;
            int n14 = nverts[n13];
            nverts[n13] = n14 + 1;
            vertToPoly[0][d][n14] = i;
        }
        if (DEBUG) {
            System.out.println("\nvertToPoly (vertices -> polys) " + nvertex + "\n");
            for (i = 0; i < nvertex; ++i) {
                String s = "  " + i + " -> ";
                for (j = 0; j < vertToPoly[0][i].length; ++j) {
                    s = s + " " + vertToPoly[0][i][j];
                }
                System.out.println(s + "\n");
            }
        }
        fieldVertices[0] = new float[nvertex];
        fieldVertices[1] = new float[nvertex];
        fieldVertices[2] = new float[nvertex];
        for (int j4 = 0; j4 < naux; ++j4) {
            auxLevels[j4] = new byte[nvertex];
        }
        for (i = 0; i < this.Delan.NumEdges; ++i) {
            int k = globalToVertex[i];
            if (k < 0) continue;
            fieldVertices[0][k] = edgeInterp[0][i];
            fieldVertices[1][k] = edgeInterp[1][i];
            fieldVertices[2][k] = edgeInterp[2][i];
            for (j = 0; j < naux; ++j) {
                auxLevels[j][k] = auxInterp[j][i];
            }
        }
        if (DEBUG) {
            System.out.println("\nfieldVertices " + nvertex + "\n");
            for (i = 0; i < nvertex; ++i) {
                String s = "  " + i + " -> ";
                for (j = 0; j < 3; ++j) {
                    s = s + " " + fieldVertices[j][i];
                }
                System.out.println(s + "\n");
            }
        }
    }

    private static void make_normals(float[] VX, float[] VY, float[] VZ, float[] NX, float[] NY, float[] NZ, int nvertex, int npolygons, float[] Pnx, float[] Pny, float[] Pnz, float[] NxA, float[] NxB, float[] NyA, float[] NyB, float[] NzA, float[] NzB, int[][] vertToPoly, int[][] polyToVert) throws VisADException {
        int j0;
        int i;
        int[] iv = new int[3];
        if (nvertex <= 0) {
            return;
        }
        for (i = 0; i < nvertex; ++i) {
            NX[i] = 0.0f;
            NY[i] = 0.0f;
            NZ[i] = 0.0f;
        }
        float minimum_area = Float.MIN_VALUE;
        int k = 0;
        while (true) {
            for (i = k + 1; i < npolygons && polyToVert[i].length <= polyToVert[k].length; ++i) {
            }
            if (i >= npolygons) break;
            k = i;
        }
        int max_vert_per_pol = polyToVert[k].length;
        for (i = 0; i < npolygons; ++i) {
            if (polyToVert[i].length <= 0) continue;
            int j1 = polyToVert[i][1];
            j0 = polyToVert[i][0];
            NxA[i] = VX[j1] - VX[j0];
            NyA[i] = VY[j1] - VY[j0];
            NzA[i] = VZ[j1] - VZ[j0];
        }
        boolean swap_flag = false;
        for (k = 2; k < max_vert_per_pol; ++k) {
            int jk;
            if (!swap_flag) {
                for (i = 0; i < npolygons; ++i) {
                    if (k >= polyToVert[i].length) continue;
                    jk = polyToVert[i][k];
                    j0 = polyToVert[i][0];
                    NxB[i] = VX[jk] - VX[j0];
                    NyB[i] = VY[jk] - VY[j0];
                    NzB[i] = VZ[jk] - VZ[j0];
                    Pnx[i] = NyA[i] * NzB[i] - NzA[i] * NyB[i];
                    Pny[i] = NzA[i] * NxB[i] - NxA[i] * NzB[i];
                    Pnz[i] = NxA[i] * NyB[i] - NyA[i] * NxB[i];
                    NxA[i] = Pnx[i] * Pnx[i] + Pny[i] * Pny[i] + Pnz[i] * Pnz[i];
                    if (!(NxA[i] > minimum_area)) continue;
                    int n = i;
                    Pnx[n] = Pnx[n] / NxA[i];
                    int n2 = i;
                    Pny[n2] = Pny[n2] / NxA[i];
                    int n3 = i;
                    Pnz[n3] = Pnz[n3] / NxA[i];
                }
            } else {
                for (i = 0; i < npolygons; ++i) {
                    if (k >= polyToVert[i].length) continue;
                    jk = polyToVert[i][k];
                    j0 = polyToVert[i][0];
                    NxA[i] = VX[jk] - VX[j0];
                    NyA[i] = VY[jk] - VY[j0];
                    NzA[i] = VZ[jk] - VZ[j0];
                    Pnx[i] = NyB[i] * NzA[i] - NzB[i] * NyA[i];
                    Pny[i] = NzB[i] * NxA[i] - NxB[i] * NzA[i];
                    Pnz[i] = NxB[i] * NyA[i] - NyB[i] * NxA[i];
                    NxB[i] = Pnx[i] * Pnx[i] + Pny[i] * Pny[i] + Pnz[i] * Pnz[i];
                    if (!(NxB[i] > minimum_area)) continue;
                    int n = i;
                    Pnx[n] = Pnx[n] / NxB[i];
                    int n4 = i;
                    Pny[n4] = Pny[n4] / NxB[i];
                    int n5 = i;
                    Pnz[n5] = Pnz[n5] / NxB[i];
                }
            }
            for (i = 0; i < npolygons; ++i) {
                if (k >= polyToVert[i].length) continue;
                iv[0] = polyToVert[i][0];
                iv[1] = polyToVert[i][k - 1];
                iv[2] = polyToVert[i][k];
                float x = Pnx[i];
                float y = Pny[i];
                float z = Pnz[i];
                int n = iv[0];
                NX[n] = NX[n] + x;
                int n6 = iv[0];
                NY[n6] = NY[n6] + y;
                int n7 = iv[0];
                NZ[n7] = NZ[n7] + z;
                int n8 = iv[1];
                NX[n8] = NX[n8] + x;
                int n9 = iv[1];
                NY[n9] = NY[n9] + y;
                int n10 = iv[1];
                NZ[n10] = NZ[n10] + z;
                int n11 = iv[2];
                NX[n11] = NX[n11] + x;
                int n12 = iv[2];
                NY[n12] = NY[n12] + y;
                int n13 = iv[2];
                NZ[n13] = NZ[n13] + z;
            }
            swap_flag = !swap_flag;
        }
        for (i = 0; i < nvertex; ++i) {
            float len = (float)Math.sqrt(NX[i] * NX[i] + NY[i] * NY[i] + NZ[i] * NZ[i]);
            if (!(len > 1.0E-5f)) continue;
            int n = i;
            NX[n] = NX[n] / len;
            int n14 = i;
            NY[n14] = NY[n14] / len;
            int n15 = i;
            NZ[n15] = NZ[n15] / len;
        }
    }

    /*
     * Unable to fully structure code
     */
    static int poly_triangle_stripe(int[] Tri_Stripe, int nvertex, int npolygons, int[][] vertToPoly, int[][] polyToVert) throws VisADException {
        f_line_conection = false;
        vet_pol = new boolean[npolygons];
        last_pol = 0;
        npol = 0;
        iST = 0;
        ivB = 0;
        for (i = 0; i < npolygons; ++i) {
            vet_pol[i] = true;
        }
        while (true) lbl-1000:
        // 4 sources

        {
            for (cpol = last_pol; cpol < npolygons && !vet_pol[cpol]; ++cpol) {
            }
            if (cpol == npolygons) {
                cpol = -1;
            } else {
                last_pol = cpol;
            }
            if (cpol < 0) break;
            vet_pol[cpol] = false;
            Nvt = polyToVert[cpol].length;
            for (ivA = 0; ivA < Nvt; ++ivA) {
                ivB = ivA + 1 == Nvt ? 0 : ivA + 1;
                npol = -1;
                if (ivA < polyToVert[cpol].length && ivB < polyToVert[cpol].length) {
                    i = polyToVert[cpol][ivA];
                    ilim = vertToPoly[i].length;
                    k = 0;
                    j = polyToVert[cpol][ivB];
                    jlim = vertToPoly[j].length;
                    m = 0;
                    while (0 < i && k < ilim && 0 < j && m < jlim) {
                        if (vertToPoly[i][k] == vertToPoly[j][m] && vet_pol[vertToPoly[i][k]]) {
                            npol = vertToPoly[i][k];
                            break;
                        }
                        if (vertToPoly[i][k] < vertToPoly[j][m]) {
                            ++k;
                            continue;
                        }
                        ++m;
                    }
                }
                if (npol >= 0) break;
            }
            if (npol < 0) {
                idx = Irregular3DSet.STAB[Nvt - 3];
                if (iST > 0) {
                    Tri_Stripe[iST] = Tri_Stripe[iST - 1];
                    v0 = ++iST;
                    ++iST;
                    Tri_Stripe[v0] = polyToVert[cpol][Irregular3DSet.NTAB[idx]];
                } else {
                    f_line_conection = true;
                }
                ii = 0;
                while (true) {
                    if (ii >= (Nvt < 6 ? Nvt : 6)) ** continue;
                    Tri_Stripe[iST++] = polyToVert[cpol][Irregular3DSet.NTAB[idx++]];
                    ++ii;
                }
            }
            if (ivB != 0 && ivA == ivB - 1 || ivB == 0 && ivA == Nvt - 1) {
                idx = Irregular3DSet.STAB[Nvt - 3] + (ivB + 1) * Nvt;
                if (f_line_conection) {
                    Tri_Stripe[iST] = Tri_Stripe[iST - 1];
                    v1 = ++iST;
                    ++iST;
                    Tri_Stripe[v1] = polyToVert[cpol][Irregular3DSet.ITAB[idx - 1]];
                    f_line_conection = false;
                }
                for (ii = 0; ii < (Nvt < 6 ? Nvt : 6); ++ii) {
                    Tri_Stripe[iST++] = polyToVert[cpol][Irregular3DSet.ITAB[--idx]];
                }
            } else {
                idx = Irregular3DSet.STAB[Nvt - 3] + (ivB + 1) * Nvt;
                if (f_line_conection) {
                    Tri_Stripe[iST] = Tri_Stripe[iST - 1];
                    v2 = ++iST;
                    ++iST;
                    Tri_Stripe[v2] = polyToVert[cpol][Irregular3DSet.NTAB[idx - 1]];
                    f_line_conection = false;
                }
                for (ii = 0; ii < (Nvt < 6 ? Nvt : 6); ++ii) {
                    Tri_Stripe[iST++] = polyToVert[cpol][Irregular3DSet.NTAB[--idx]];
                }
            }
            vB = Tri_Stripe[iST - 1];
            vA = Tri_Stripe[iST - 2];
            cpol = npol;
            while (true) {
                Nvt = polyToVert[cpol].length;
                vet_pol[cpol] = false;
                for (ivA = 0; ivA < Nvt && polyToVert[cpol][ivA] != vA; ++ivA) {
                }
                for (ivB = 0; ivB < Nvt && polyToVert[cpol][ivB] != vB; ++ivB) {
                }
                if (ivB != 0 && ivA == ivB - 1 || ivB == 0 && ivA == Nvt - 1) {
                    idx = Irregular3DSet.STAB[Nvt - 3] + ivA * Nvt + 2;
                    for (ii = 2; ii < (Nvt < 6 ? Nvt : 6); ++ii) {
                        Tri_Stripe[iST++] = polyToVert[cpol][Irregular3DSet.NTAB[idx++]];
                    }
                } else {
                    idx = Irregular3DSet.STAB[Nvt - 3] + ivA * Nvt + 2;
                    for (ii = 2; ii < (Nvt < 6 ? Nvt : 6); ++ii) {
                        Tri_Stripe[iST++] = polyToVert[cpol][Irregular3DSet.ITAB[idx++]];
                    }
                }
                vB = Tri_Stripe[iST - 1];
                vA = Tri_Stripe[iST - 2];
                cpol = -1;
                if (vA >= 0 && vB >= 0) {
                    ilim = vertToPoly[vA].length;
                    k = 0;
                    jlim = vertToPoly[vB].length;
                    m = 0;
                    while (0 < vA && k < ilim && 0 < vB && m < jlim) {
                        if (vertToPoly[vA][k] == vertToPoly[vB][m] && vet_pol[vertToPoly[vA][k]]) {
                            cpol = vertToPoly[vA][k];
                            break;
                        }
                        if (vertToPoly[vA][k] < vertToPoly[vB][m]) {
                            ++k;
                            continue;
                        }
                        ++m;
                    }
                }
                if (cpol >= 0) continue;
                vA = Tri_Stripe[iST - 3];
                cpol = -1;
                if (vA >= 0 && vB >= 0) {
                    ilim = vertToPoly[vA].length;
                    k = 0;
                    jlim = vertToPoly[vB].length;
                    m = 0;
                    while (0 < vA && k < ilim && 0 < vB && m < jlim) {
                        if (vertToPoly[vA][k] == vertToPoly[vB][m] && vet_pol[vertToPoly[vA][k]]) {
                            cpol = vertToPoly[vA][k];
                            break;
                        }
                        if (vertToPoly[vA][k] < vertToPoly[vB][m]) {
                            ++k;
                            continue;
                        }
                        ++m;
                    }
                }
                if (cpol < 0) {
                    f_line_conection = true;
                    ** continue;
                }
                if (iST > 0) {
                    Tri_Stripe[iST] = Tri_Stripe[iST - 1];
                }
                v3 = ++iST;
                ++iST;
                Tri_Stripe[v3] = vA;
                i = vA;
                vA = vB;
                vB = i;
            }
            break;
        }
        return iST;
    }

    public VisADGeometryArray make2DGeometry(byte[][] color_values, boolean indexed) throws VisADException {
        int i;
        if (this.DomainDimension != 3) {
            throw new SetException("Irregular3DSet.make2DGeometry: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 2) {
            throw new SetException("Irregular3DSet.make2DGeometry: ManifoldDimension must be 2, not " + this.ManifoldDimension);
        }
        int npolygons = this.Delan.Tri.length;
        int nvertex = this.Delan.Vertices.length;
        if (npolygons < 1 || nvertex < 3) {
            return null;
        }
        int[][] Tri = this.Delan.Tri;
        int[][] Walk = this.Delan.Walk;
        int dim = Tri[0].length - 1;
        int[][] tri = new int[npolygons][];
        int[] poly_stack = new int[npolygons];
        int[] walk_stack = new int[npolygons];
        for (int ii = 0; ii < npolygons; ++ii) {
            if (tri[ii] != null) continue;
            tri[ii] = new int[3];
            tri[ii][0] = Tri[ii][0];
            tri[ii][1] = Tri[ii][1];
            tri[ii][2] = Tri[ii][2];
            int sp = 0;
            walk_stack[sp] = 0;
            poly_stack[sp] = ii;
            do {
                int w;
                int i2;
                int j;
                if ((j = Walk[i2 = poly_stack[sp]][w = walk_stack[sp]]) >= 0 && tri[j] == null) {
                    int v1 = Tri[i2][w];
                    int v2 = Tri[i2][(w + 1) % 3];
                    int i1 = -1;
                    int i22 = -1;
                    int j1 = -1;
                    int j2 = -1;
                    for (int k = 0; k < 3; ++k) {
                        if (tri[i2][k] == v1) {
                            i1 = k;
                        }
                        if (tri[i2][k] == v2) {
                            i22 = k;
                        }
                        if (Tri[j][k] == v1) {
                            j1 = k;
                        }
                        if (Tri[j][k] != v2) continue;
                        j2 = k;
                    }
                    tri[j] = new int[3];
                    tri[j][0] = Tri[j][0];
                    if ((i1 + 1) % 3 == i22 && (j1 + 1) % 3 == j2 || (i22 + 1) % 3 == i1 && (j2 + 1) % 3 == j1) {
                        tri[j][1] = Tri[j][2];
                        tri[j][2] = Tri[j][1];
                    } else {
                        tri[j][1] = Tri[j][1];
                        tri[j][2] = Tri[j][2];
                    }
                    walk_stack[++sp] = 0;
                    poly_stack[sp] = j;
                    continue;
                }
                do {
                    int n = sp;
                    walk_stack[n] = walk_stack[n] + 1;
                } while (walk_stack[sp] >= 3 && --sp >= 0);
            } while (sp >= 0);
        }
        float[][] samples = this.getSamples(false);
        float[] NxA = new float[npolygons];
        float[] NxB = new float[npolygons];
        float[] NyA = new float[npolygons];
        float[] NyB = new float[npolygons];
        float[] NzA = new float[npolygons];
        float[] NzB = new float[npolygons];
        float[] Pnx = new float[npolygons];
        float[] Pny = new float[npolygons];
        float[] Pnz = new float[npolygons];
        float[] NX = new float[nvertex];
        float[] NY = new float[nvertex];
        float[] NZ = new float[nvertex];
        Irregular3DSet.make_normals(samples[0], samples[1], samples[2], NX, NY, NZ, nvertex, npolygons, Pnx, Pny, Pnz, NxA, NxB, NyA, NyB, NzA, NzB, this.Delan.Vertices, tri);
        Pnz = null;
        Pny = null;
        Pnx = null;
        NzB = null;
        NzA = null;
        NyB = null;
        NyA = null;
        NxB = null;
        NxA = null;
        float[] normals = new float[3 * nvertex];
        int j = 0;
        for (int i3 = 0; i3 < nvertex; ++i3) {
            normals[j++] = NX[i3];
            normals[j++] = NY[i3];
            normals[j++] = NZ[i3];
        }
        NZ = null;
        NY = null;
        NX = null;
        int[] stripe = new int[6 * npolygons];
        int size_stripe = Irregular3DSet.poly_triangle_stripe(stripe, nvertex, npolygons, this.Delan.Vertices, this.Delan.Tri);
        if (indexed) {
            VisADIndexedTriangleStripArray array = new VisADIndexedTriangleStripArray();
            array.normals = normals;
            normals = null;
            array.indexCount = size_stripe;
            array.indices = new int[size_stripe];
            System.arraycopy(stripe, 0, array.indices, 0, size_stripe);
            array.stripVertexCounts = new int[1];
            array.stripVertexCounts[0] = size_stripe;
            stripe = null;
            Irregular3DSet.setGeometryArray(array, samples, 4, color_values);
            samples = null;
            return array;
        }
        VisADTriangleStripArray array = new VisADTriangleStripArray();
        array.stripVertexCounts = new int[]{size_stripe};
        array.vertexCount = size_stripe;
        array.normals = new float[3 * size_stripe];
        int k = 0;
        for (i = 0; i < 3 * size_stripe; i += 3) {
            j = 3 * stripe[k];
            array.normals[i] = normals[j];
            array.normals[i + 1] = normals[j + 1];
            array.normals[i + 2] = normals[j + 2];
            ++k;
        }
        normals = null;
        array.coordinates = new float[3 * size_stripe];
        k = 0;
        for (i = 0; i < 3 * size_stripe; i += 3) {
            j = stripe[k];
            array.coordinates[i] = samples[0][j];
            array.coordinates[i + 1] = samples[1][j];
            array.coordinates[i + 2] = samples[2][j];
            ++k;
        }
        samples = null;
        if (color_values != null) {
            int color_length = color_values.length;
            array.colors = new byte[color_length * size_stripe];
            k = 0;
            if (color_length == 4) {
                for (int i4 = 0; i4 < color_length * size_stripe; i4 += color_length) {
                    j = stripe[k];
                    array.colors[i4] = color_values[0][j];
                    array.colors[i4 + 1] = color_values[1][j];
                    array.colors[i4 + 2] = color_values[2][j];
                    array.colors[i4 + 3] = color_values[3][j];
                    ++k;
                }
            } else {
                for (int i5 = 0; i5 < color_length * size_stripe; i5 += color_length) {
                    j = stripe[k];
                    array.colors[i5] = color_values[0][j];
                    array.colors[i5 + 1] = color_values[1][j];
                    array.colors[i5 + 2] = color_values[2][j];
                    ++k;
                }
            }
        }
        color_values = null;
        stripe = null;
        return array;
    }

    public Object cloneButType(MathType type) throws VisADException {
        if (this.ManifoldDimension == 1) {
            return new Irregular3DSet(type, this.getMySamples(), this.newToOld, this.oldToNew, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        return new Irregular3DSet(type, this.getMySamples(), this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.Delan);
    }

    public static void main(String[] argv) throws VisADException {
        int j;
        int i;
        float[][] samp = new float[][]{{179.0f, 232.0f, 183.0f, 244.0f, 106.0f, 344.0f, 166.0f, 304.0f, 286.0f}, {86.0f, 231.0f, 152.0f, 123.0f, 183.0f, 153.0f, 308.0f, 325.0f, 89.0f}, {121.0f, 301.0f, 346.0f, 352.0f, 123.0f, 125.0f, 187.0f, 101.0f, 142.0f}};
        RealType test1 = RealType.getRealType("x");
        RealType test2 = RealType.getRealType("y");
        RealType test3 = RealType.getRealType("z");
        RealType[] t_array = new RealType[]{test1, test2, test3};
        RealTupleType t_tuple = new RealTupleType(t_array);
        Irregular3DSet iSet3D = new Irregular3DSet((MathType)t_tuple, samp);
        float[][] mySamples = iSet3D.getMySamples();
        System.out.println("Samples:");
        for (int i2 = 0; i2 < mySamples[0].length; ++i2) {
            System.out.println("#" + i2 + ":\t" + mySamples[0][i2] + ", " + mySamples[1][i2] + ", " + mySamples[2][i2]);
        }
        System.out.println(iSet3D.Delan.Tri.length + " tetrahedrons in tetrahedralization.");
        System.out.println("\nvalueToIndex test:");
        float[][] value = new float[][]{{189.0f, 221.0f, 319.0f, 215.0f, 196.0f}, {166.0f, 161.0f, 158.0f, 139.0f, 285.0f}, {207.0f, 300.0f, 127.0f, 287.0f, 194.0f}};
        int[] index = iSet3D.valueToIndex(value);
        for (int i3 = 0; i3 < index.length; ++i3) {
            System.out.println(value[0][i3] + ", " + value[1][i3] + ", " + value[2][i3] + "\t--> #" + index[i3]);
        }
        System.out.println("\nvalueToInterp test:");
        int[][] indices = new int[value[0].length][];
        float[][] weights = new float[value[0].length][];
        iSet3D.valueToInterp(value, indices, weights);
        for (int i4 = 0; i4 < value[0].length; ++i4) {
            System.out.println(value[0][i4] + ", " + value[1][i4] + ", " + value[2][i4] + "\t--> [" + indices[i4][0] + ", " + indices[i4][1] + ", " + indices[i4][2] + ", " + indices[i4][3] + "]\tweight total: " + (weights[i4][0] + weights[i4][1] + weights[i4][2] + weights[i4][3]));
        }
        System.out.println("\nmakeIsosurface test:");
        float[] field = new float[]{100.0f, 300.0f, 320.0f, 250.0f, 80.0f, 70.0f, 135.0f, 110.0f, 105.0f};
        float[][] slice = new float[3][];
        int[][][] polyvert = new int[1][][];
        int[][][] vertpoly = new int[1][][];
        iSet3D.makeIsosurface(288.0f, field, null, slice, null, polyvert, vertpoly);
        for (i = 0; i < slice[0].length; ++i) {
            for (j = 0; j < 3; ++j) {
                slice[j][i] = (float)Math.round(1000.0f * slice[j][i]) / 1000.0f;
            }
        }
        System.out.println("polygons:");
        for (i = 0; i < polyvert[0].length; ++i) {
            System.out.print("#" + i + ":");
            for (j = 0; j < polyvert[0][i].length; ++j) {
                if (j == 1) {
                    if (polyvert[0][i].length == 3) {
                        System.out.print("(tri)");
                    } else {
                        System.out.print("(quad)");
                    }
                }
                System.out.println("\t" + slice[0][polyvert[0][i][j]] + ", " + slice[1][polyvert[0][i][j]] + ", " + slice[2][polyvert[0][i][j]]);
            }
        }
        System.out.println();
        for (i = 0; i < polyvert[0].length; ++i) {
            int j2;
            int a = polyvert[0][i][0];
            int b = polyvert[0][i][1];
            int c = polyvert[0][i][2];
            int d = polyvert[0][i].length == 4 ? polyvert[0][i][3] : -1;
            boolean found = false;
            for (j2 = 0; j2 < vertpoly[0][a].length; ++j2) {
                if (vertpoly[0][a][j2] != i) continue;
                found = true;
            }
            if (!found) {
                System.out.println("vertToPoly array corrupted at triangle #" + i + " vertex #0!");
            }
            found = false;
            for (j2 = 0; j2 < vertpoly[0][b].length; ++j2) {
                if (vertpoly[0][b][j2] != i) continue;
                found = true;
            }
            if (!found) {
                System.out.println("vertToPoly array corrupted at triangle #" + i + " vertex #1!");
            }
            found = false;
            for (j2 = 0; j2 < vertpoly[0][c].length; ++j2) {
                if (vertpoly[0][c][j2] != i) continue;
                found = true;
            }
            if (!found) {
                System.out.println("vertToPoly array corrupted at triangle #" + i + " vertex #2!");
            }
            found = false;
            if (d == -1) continue;
            for (j2 = 0; j2 < vertpoly[0][d].length; ++j2) {
                if (vertpoly[0][d][j2] != i) continue;
                found = true;
            }
            if (found) continue;
            System.out.println("vertToPoly array corrupted at triangle #" + i + " vertex #3!");
        }
    }
}

