/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Font;
import java.text.DecimalFormat;
import visad.ContourLabelGeometry;
import visad.ContourStripSet;
import visad.Gridded3DSet;
import visad.IndexPairList;
import visad.PlotDigits;
import visad.PlotText;
import visad.SampledSet;
import visad.SphericalCoordinateSystem;
import visad.TextControl;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADLineStripArray;
import visad.util.HersheyFont;
import visad.util.Util;

class ContourStrip {
    static final int LBL_ALGM_THRESHHOLD = 20;
    IndexPairList idxs = new IndexPairList();
    int lev_idx;
    private boolean isLabeled = false;
    private int start_break;
    private int stop_break;
    private int n_skip;
    int numLabels;
    boolean isDashed = false;
    PlotDigits plot;
    ContourStripSet css;

    ContourStrip(int mxsize, int lev_idx, int idx0, int idx1, ContourStripSet css) {
        this.lev_idx = lev_idx;
        this.plot = this.plot;
        this.idxs.addFirst(idx0, idx1);
        this.css = css;
    }

    boolean addPair(float[] vx, float[] vy, int idx0, int idx1) {
        float vx0 = vx[idx0];
        float vy0 = vy[idx0];
        float vx1 = vx[idx1];
        float vy1 = vy[idx1];
        float vx_s = vx[this.idxs.first.idx0];
        float vy_s = vy[this.idxs.first.idx0];
        float dist = (vx0 - vx_s) * (vx0 - vx_s) + (vy0 - vy_s) * (vy0 - vy_s);
        if ((double)dist <= 1.0E-5) {
            this.idxs.addFirst(idx1, idx0);
            return true;
        }
        dist = (vx1 - vx_s) * (vx1 - vx_s) + (vy1 - vy_s) * (vy1 - vy_s);
        if ((double)dist <= 1.0E-5) {
            this.idxs.addFirst(idx0, idx1);
            return true;
        }
        vx_s = vx[this.idxs.last.idx1];
        vy_s = vy[this.idxs.last.idx1];
        dist = (vx0 - vx_s) * (vx0 - vx_s) + (vy0 - vy_s) * (vy0 - vy_s);
        if ((double)dist <= 1.0E-5) {
            this.idxs.addLast(idx0, idx1);
            return true;
        }
        dist = (vx1 - vx_s) * (vx1 - vx_s) + (vy1 - vy_s) * (vy1 - vy_s);
        if ((double)dist <= 1.0E-5) {
            this.idxs.addLast(idx1, idx0);
            return true;
        }
        return false;
    }

    void getLabeledLineColorArray(float[] vx, float[] vy, byte[][] colors, byte[] labelColor, Object labelFont, boolean labelAlign, boolean sphericalDisplayCS) throws VisADException {
        float[][] vv = this.getLineArray(vx, vy);
        byte[][] bb = this.getColorArray(colors);
        this.processLineArrays(vv, bb, labelColor, labelFont, labelAlign, sphericalDisplayCS);
    }

    private void processLineArrays(float[][] vv_grid, byte[][] bb, byte[] labelColor, Object labelFont, boolean labelAlign, boolean sphericalDisplayCS) throws VisADException {
        float[][] vv = this.css.spatial_set.gridToValue(vv_grid);
        int clr_dim = 0;
        if (bb != null) {
            clr_dim = bb.length;
        }
        int totalPts = vv[0].length / 2;
        int loc = 0;
        int pos = 0;
        VisADGeometryArray label = null;
        DecimalFormat numFormat = new DecimalFormat();
        numFormat.setMaximumFractionDigits(1);
        numFormat.setGroupingUsed(false);
        String numStr = numFormat.format(this.css.levels[this.lev_idx]);
        float lbl_half = 0.1f;
        if (totalPts > 20 && (this.lev_idx & 1) == 1 || this.css.n_levs == 1) {
            float ctr_dist;
            float dz;
            this.isLabeled = true;
            loc = vv[0].length / 2;
            int n_pairs_b = 1;
            int n_pairs_f = 1;
            boolean found = false;
            pos = loc;
            float del_z = vv[2][pos + 1] - vv[2][pos - 1];
            float del_y = vv[1][pos + 1] - vv[1][pos - 1];
            float del_x = vv[0][pos + 1] - vv[0][pos - 1];
            float mag = (float)Math.sqrt(del_y * del_y + del_x * del_x + del_z * del_z);
            float[] fArray = new float[]{del_x / mag, del_y / mag, del_z / mag};
            float[] ctr_u = fArray;
            if (ctr_u[0] < 0.0f) {
                ctr_u[0] = -ctr_u[0];
                ctr_u[1] = -ctr_u[1];
                ctr_u[2] = -ctr_u[2];
            }
            float ctr_u_dot_lbl = ctr_u[0] * 1.0f + ctr_u[1] * 0.0f + ctr_u[2] * 0.0f;
            label = labelFont instanceof Font ? PlotText.render_font(numStr, (Font)labelFont, new double[]{vv[0][loc], vv[1][loc], vv[2][loc]}, new double[]{1.0, 0.0, 0.0}, new double[]{0.0, 1.0, 0.0}, TextControl.Justification.CENTER, TextControl.Justification.CENTER, 0.0, this.css.labelScale, null) : (labelFont instanceof HersheyFont ? PlotText.render_font(numStr, (HersheyFont)labelFont, new double[]{vv[0][loc], vv[1][loc], vv[2][loc]}, new double[]{1.0, 0.0, 0.0}, new double[]{0.0, 1.0, 0.0}, TextControl.Justification.CENTER, TextControl.Justification.CENTER, 0.0, this.css.labelScale, null) : (labelFont == null ? PlotText.render_font(numStr, new HersheyFont("timesr"), new double[]{vv[0][loc], vv[1][loc], vv[2][loc]}, new double[]{1.0, 0.0, 0.0}, new double[]{0.0, 1.0, 0.0}, TextControl.Justification.CENTER, TextControl.Justification.CENTER, 0.0, this.css.labelScale, null) : PlotText.render_font(numStr, new HersheyFont("timesr"), new double[]{vv[0][loc], vv[1][loc], vv[2][loc]}, new double[]{1.0, 0.0, 0.0}, new double[]{0.0, 1.0, 0.0}, TextControl.Justification.CENTER, TextControl.Justification.CENTER, 0.0, this.css.labelScale, null)));
            float x_min = Float.MAX_VALUE;
            float x_max = -3.4028235E38f;
            float y_min = Float.MAX_VALUE;
            float y_max = -3.4028235E38f;
            float z_min = Float.MAX_VALUE;
            float z_max = -3.4028235E38f;
            for (int k = 0; k < label.vertexCount; ++k) {
                int i = 3 * k;
                float x = label.coordinates[i];
                float y = label.coordinates[i + 1];
                float z = label.coordinates[i + 2];
                if (x > x_max) {
                    x_max = x;
                }
                if (y > y_max) {
                    y_max = y;
                }
                if (z > z_max) {
                    z_max = z;
                }
                if (x < x_min) {
                    x_min = x;
                }
                if (y < y_min) {
                    y_min = y;
                }
                if (!(z < z_min)) continue;
                z_min = z;
            }
            lbl_half = labelAlign ? (x_max - x_min) / 2.0f : ((double)ctr_u_dot_lbl > 0.5 ? (x_max - x_min) / 2.0f : y_max - y_min);
            lbl_half = (float)((double)lbl_half + (double)lbl_half * 0.08);
            while (!found) {
                if ((pos -= 2) < 0 || pos > vv[0].length - 1) {
                    return;
                }
                float dx = vv[0][pos] - vv[0][loc];
                float dy = vv[1][pos] - vv[1][loc];
                dz = vv[2][pos] - vv[2][loc];
                ctr_dist = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                if (ctr_dist > (float)Math.abs((double)lbl_half)) {
                    found = true;
                    continue;
                }
                ++n_pairs_b;
            }
            pos = loc;
            found = false;
            while (!found) {
                if ((pos += 2) < 0 || pos > vv[0].length - 1) {
                    return;
                }
                float dx = vv[0][pos] - vv[0][loc];
                float dy = vv[1][pos] - vv[1][loc];
                dz = vv[2][pos] - vv[2][loc];
                ctr_dist = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                if (ctr_dist > (float)Math.abs((double)lbl_half)) {
                    found = true;
                    continue;
                }
                ++n_pairs_f;
            }
            this.n_skip = (n_pairs_b + n_pairs_f) * 2;
            if ((loc & 1) == 1) {
                this.start_break = loc - (1 + (n_pairs_b - 1) * 2);
                this.stop_break = loc + (2 + (n_pairs_f - 1) * 2);
            } else {
                this.start_break = loc - (2 + (n_pairs_b - 1) * 2);
                this.stop_break = loc + (1 + (n_pairs_f - 1) * 2);
            }
        }
        boolean doLabel = false;
        if (this.start_break >= 4 && this.stop_break <= totalPts * 2 - 3) {
            doLabel = true;
        }
        if (doLabel && (this.lev_idx & 1) == 1) {
            int cc;
            int cc2;
            float[] ctr_u = null;
            float[] norm_x_ctr = null;
            float[][] norm = null;
            Gridded3DSet cg3d = this.css.spatial_set;
            norm = cg3d.getNormals(new float[][]{{vv_grid[0][loc]}, {vv_grid[1][loc]}});
            float[] labelBase = null;
            float[] labelUp = null;
            if (labelAlign) {
                float del_z = vv[2][this.stop_break] - vv[2][this.start_break];
                float del_y = vv[1][this.stop_break] - vv[1][this.start_break];
                float del_x = vv[0][this.stop_break] - vv[0][this.start_break];
                float mag = (float)Math.sqrt(del_y * del_y + del_x * del_x + del_z * del_z);
                float[] fArray = new float[]{del_x / mag, del_y / mag, del_z / mag};
                ctr_u = fArray;
                if (ctr_u[0] < 0.0f) {
                    ctr_u[0] = -ctr_u[0];
                    ctr_u[1] = -ctr_u[1];
                    ctr_u[2] = -ctr_u[2];
                }
                if (sphericalDisplayCS) {
                    float[] newNorm = SphericalCoordinateSystem.getNormal(new float[]{vv[0][pos], vv[1][pos], vv[2][pos]});
                    norm[0][0] = newNorm[0];
                    norm[1][0] = newNorm[1];
                    norm[2][0] = newNorm[2];
                    float[] fArray2 = new float[]{vv[0][pos], vv[1][pos], vv[2][pos]};
                    float[] unitI = SphericalCoordinateSystem.getUnitI(fArray2);
                    float ctr_u_dot_unitI = ctr_u[0] * unitI[0] + ctr_u[1] * unitI[1] + ctr_u[2] * unitI[2];
                    if (ctr_u_dot_unitI < 0.0f) {
                        ctr_u[0] = -ctr_u[0];
                        ctr_u[1] = -ctr_u[1];
                        ctr_u[2] = -ctr_u[2];
                    }
                }
                norm_x_ctr = new float[]{norm[1][0] * ctr_u[2] - norm[2][0] * ctr_u[1], -(norm[0][0] * ctr_u[2] - norm[2][0] * ctr_u[0]), norm[0][0] * ctr_u[1] - norm[1][0] * ctr_u[0]};
                mag = (float)Math.sqrt(norm_x_ctr[0] * norm_x_ctr[0] + norm_x_ctr[1] * norm_x_ctr[1] + norm_x_ctr[2] * norm_x_ctr[2]);
                norm_x_ctr[0] = norm_x_ctr[0] / mag;
                norm_x_ctr[1] = norm_x_ctr[1] / mag;
                norm_x_ctr[2] = norm_x_ctr[2] / mag;
                if (!sphericalDisplayCS) {
                    if (Math.abs((double)norm[2][0]) <= 1.0E-5) {
                        if (norm_x_ctr[2] < 0.0f) {
                            norm_x_ctr[0] = -norm_x_ctr[0];
                            norm_x_ctr[1] = -norm_x_ctr[1];
                            norm_x_ctr[2] = -norm_x_ctr[2];
                        }
                    } else if (norm_x_ctr[1] < 0.0f) {
                        norm_x_ctr[0] = -norm_x_ctr[0];
                        norm_x_ctr[1] = -norm_x_ctr[1];
                        norm_x_ctr[2] = -norm_x_ctr[2];
                    }
                }
                labelBase = ctr_u;
                labelUp = norm_x_ctr;
            } else {
                float a = norm[0][0];
                float b = norm[1][0];
                float c = norm[2][0];
                float[] unitI = null;
                if (sphericalDisplayCS) {
                    float[] newNorm = SphericalCoordinateSystem.getNormal(new float[]{vv[0][pos], vv[1][pos], vv[2][pos]});
                    unitI = SphericalCoordinateSystem.getUnitI(new float[]{vv[0][pos], vv[1][pos], vv[2][pos]});
                    a = newNorm[0];
                    b = newNorm[1];
                    c = newNorm[2];
                }
                if (Util.isApproximatelyEqual(a, 0.0f) && Util.isApproximatelyEqual(b, 0.0f)) {
                    labelBase = new float[]{1.0f, 0.0f, 0.0f};
                    labelUp = new float[]{0.0f, 1.0f, 0.0f};
                } else {
                    float D = -(a * vv[0][loc] + b * vv[1][loc] + c * vv[2][loc]);
                    float K = -D - c * vv[2][loc];
                    float xLine = vv[0][loc] + 0.5f;
                    float yLine = (K - a * xLine) / b;
                    float delX = xLine - vv[0][loc];
                    float delY = yLine - vv[1][loc];
                    float mag = (float)Math.sqrt(delX * delX + delY * delY);
                    float[] uLine = null;
                    uLine = sphericalDisplayCS ? new float[]{unitI[0], unitI[1], unitI[2]} : new float[]{delX / mag, delY / mag, 0.0f};
                    float[] norm_x_uLine = new float[]{b * uLine[2] - c * uLine[1], -(a * uLine[2] - c * uLine[0]), a * uLine[1] - b * uLine[0]};
                    if (norm_x_uLine[2] < 0.0f) {
                        norm_x_uLine[2] = 1.0f;
                        norm_x_uLine[1] = -norm_x_uLine[1];
                        norm_x_uLine[0] = -norm_x_uLine[0];
                    }
                    labelBase = uLine;
                    labelUp = norm_x_uLine;
                }
            }
            label = labelFont instanceof Font ? PlotText.render_font(numStr, (Font)labelFont, new double[]{vv[0][loc], vv[1][loc], vv[2][loc]}, new double[]{labelBase[0], labelBase[1], labelBase[2]}, new double[]{labelUp[0], labelUp[1], labelUp[2]}, TextControl.Justification.CENTER, TextControl.Justification.CENTER, 0.0, this.css.labelScale, null) : (labelFont instanceof HersheyFont ? PlotText.render_font(numStr, (HersheyFont)labelFont, new double[]{vv[0][loc], vv[1][loc], vv[2][loc]}, new double[]{labelBase[0], labelBase[1], labelBase[2]}, new double[]{labelUp[0], labelUp[1], labelUp[2]}, TextControl.Justification.CENTER, TextControl.Justification.CENTER, 0.0, this.css.labelScale, null) : (labelFont == null ? PlotText.render_font(numStr, new HersheyFont("timesr"), new double[]{vv[0][loc], vv[1][loc], vv[2][loc]}, new double[]{labelBase[0], labelBase[1], labelBase[2]}, new double[]{labelUp[0], labelUp[1], labelUp[2]}, TextControl.Justification.CENTER, TextControl.Justification.CENTER, 0.0, this.css.labelScale, null) : PlotText.render_font(numStr, new HersheyFont("timesr"), new double[]{vv[0][loc], vv[1][loc], vv[2][loc]}, new double[]{labelBase[0], labelBase[1], labelBase[2]}, new double[]{labelUp[0], labelUp[1], labelUp[2]}, TextControl.Justification.CENTER, TextControl.Justification.CENTER, 0.0, this.css.labelScale, null)));
            label.normals = null;
            byte[] lblClr = null;
            if (labelColor != null) {
                int clrDim = labelColor.length;
                lblClr = new byte[clrDim * label.vertexCount];
                for (int kk = 0; kk < label.vertexCount; ++kk) {
                    lblClr[kk * clrDim] = labelColor[0];
                    lblClr[kk * clrDim + 1] = labelColor[1];
                    lblClr[kk * clrDim + 2] = labelColor[2];
                    if (clrDim != 4) continue;
                    lblClr[kk * clrDim + 3] = labelColor[3];
                }
            } else if (bb != null) {
                lblClr = new byte[clr_dim * label.vertexCount];
                for (int kk = 0; kk < label.vertexCount; ++kk) {
                    lblClr[kk * clr_dim] = bb[0][loc];
                    lblClr[kk * clr_dim + 1] = bb[1][loc];
                    lblClr[kk * clr_dim + 2] = bb[2][loc];
                    if (clr_dim != 4) continue;
                    lblClr[kk * clr_dim + 3] = bb[3][loc];
                }
            }
            label.colors = lblClr;
            VisADLineArray labelAnchor = new VisADLineArray();
            SampledSet.setGeometryArray(labelAnchor, new float[][]{{vv[0][loc]}, {vv[1][loc]}, {vv[2][loc]}}, clr_dim, null);
            int s_pos = 0;
            int d_pos = 0;
            int cnt = this.start_break;
            float[] lineCoords = new float[3 * (this.start_break / 2 + 1 + (totalPts * 2 - this.start_break - this.n_skip) / 2 + 1)];
            byte[] lineColors = new byte[clr_dim * (this.start_break / 2 + 1 + (totalPts * 2 - this.start_break - this.n_skip) / 2 + 1)];
            float[] fillLineCoords = new float[3 * (this.n_skip / 2 + 1)];
            byte[] fillLineColors = new byte[clr_dim * (this.n_skip / 2 + 1)];
            int lineClrCnt = 0;
            int lineCnt = 0;
            lineCoords[lineCnt++] = vv[0][0];
            lineCoords[lineCnt++] = vv[1][0];
            lineCoords[lineCnt++] = vv[2][0];
            for (cc2 = 0; cc2 < clr_dim; ++cc2) {
                lineColors[lineClrCnt++] = bb[cc2][0];
            }
            for (int t = 1; t < cnt; t += 2) {
                lineCoords[lineCnt++] = vv[0][t];
                lineCoords[lineCnt++] = vv[1][t];
                lineCoords[lineCnt++] = vv[2][t];
                for (int c = 0; c < clr_dim; ++c) {
                    lineColors[lineClrCnt++] = bb[c][t];
                }
            }
            s_pos = this.start_break;
            d_pos = 0;
            cnt = this.n_skip;
            fillLineCoords[0] = vv[0][s_pos];
            fillLineCoords[1] = vv[1][s_pos];
            fillLineCoords[2] = vv[2][s_pos];
            for (cc2 = 0; cc2 < clr_dim; ++cc2) {
                fillLineColors[cc2] = bb[cc2][s_pos];
            }
            int kk = 3;
            int nn = clr_dim;
            for (int t = 1; t < this.n_skip; t += 2) {
                fillLineCoords[kk++] = vv[0][s_pos + t];
                fillLineCoords[kk++] = vv[1][s_pos + t];
                fillLineCoords[kk++] = vv[2][s_pos + t];
                for (cc = 0; cc < clr_dim; ++cc) {
                    fillLineColors[nn++] = bb[cc][s_pos + t];
                }
            }
            VisADLineStripArray fillLineArray = new VisADLineStripArray();
            fillLineArray.stripVertexCounts = new int[]{this.n_skip / 2 + 1};
            fillLineArray.vertexCount = this.n_skip / 2 + 1;
            fillLineArray.coordinates = fillLineCoords;
            if (fillLineColors.length > 0) {
                fillLineArray.colors = fillLineColors;
            }
            if (this.isDashed) {
                this.css.fillLinesStyled.add(fillLineArray);
            } else {
                this.css.fillLines.add(fillLineArray);
            }
            s_pos = this.stop_break + 1;
            d_pos = this.start_break;
            cnt = vv[0].length - s_pos;
            lineCoords[lineCnt++] = vv[0][s_pos];
            lineCoords[lineCnt++] = vv[1][s_pos];
            lineCoords[lineCnt++] = vv[2][s_pos];
            for (cc = 0; cc < clr_dim; ++cc) {
                lineColors[lineClrCnt++] = bb[cc][s_pos];
            }
            for (int t = 1; t < totalPts * 2 - this.start_break - this.n_skip; t += 2) {
                lineCoords[lineCnt++] = vv[0][s_pos + t];
                lineCoords[lineCnt++] = vv[1][s_pos + t];
                lineCoords[lineCnt++] = vv[2][s_pos + t];
                for (int c = 0; c < clr_dim; ++c) {
                    lineColors[lineClrCnt++] = bb[c][s_pos + t];
                }
            }
            VisADLineStripArray lineArray = new VisADLineStripArray();
            lineArray.stripVertexCounts = new int[]{this.start_break / 2 + 1, (totalPts * 2 - this.start_break - this.n_skip) / 2 + 1};
            lineArray.vertexCount = lineArray.stripVertexCounts[0] + lineArray.stripVertexCounts[1];
            lineArray.coordinates = lineCoords;
            if (lineColors.length > 0) {
                lineArray.colors = lineColors;
            }
            if (this.isDashed) {
                this.css.cntrLinesStyled.add(lineArray);
            } else {
                this.css.cntrLines.add(lineArray);
            }
            s_pos = this.start_break;
            d_pos = 0;
            cnt = 2;
            float dx = vv[0][loc] - vv[0][s_pos];
            float dy = vv[1][loc] - vv[1][s_pos];
            float dz = vv[2][loc] - vv[2][s_pos];
            float dd = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
            dx /= dd;
            dy /= dd;
            dz /= dd;
            float mm = dd - (float)Math.abs((double)lbl_half);
            dx *= mm;
            dy *= mm;
            dz *= mm;
            byte[][] segColors = new byte[clr_dim][2];
            if (bb != null) {
                for (int cc3 = 0; cc3 < clr_dim; ++cc3) {
                    System.arraycopy(bb[cc3], s_pos, segColors[cc3], d_pos, cnt);
                }
            }
            VisADLineArray expSegLeft = new VisADLineArray();
            VisADLineArray segLeftAnchor = new VisADLineArray();
            SampledSet.setGeometryArray(expSegLeft, new float[][]{{vv[0][s_pos], vv[0][s_pos] + dx}, {vv[1][s_pos], vv[1][s_pos] + dy}, {vv[2][s_pos], vv[2][s_pos] + dz}}, clr_dim, segColors);
            SampledSet.setGeometryArray(segLeftAnchor, new float[][]{{vv[0][s_pos]}, {vv[1][s_pos]}, {vv[2][s_pos]}}, clr_dim, null);
            float[] segLeftScaleInfo = new float[]{lbl_half, dd};
            s_pos = this.stop_break - 1;
            d_pos = 0;
            cnt = 2;
            dx = vv[0][loc] - vv[0][this.stop_break];
            dy = vv[1][loc] - vv[1][this.stop_break];
            dz = vv[2][loc] - vv[2][this.stop_break];
            dd = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
            dx /= dd;
            dy /= dd;
            dz /= dd;
            mm = dd - (float)Math.abs((double)lbl_half);
            dx *= mm;
            dy *= mm;
            dz *= mm;
            segColors = new byte[clr_dim][2];
            if (bb != null) {
                for (int cc4 = 0; cc4 < clr_dim; ++cc4) {
                    System.arraycopy(bb[cc4], s_pos, segColors[cc4], d_pos, cnt);
                }
            }
            VisADLineArray expSegRight = new VisADLineArray();
            SampledSet.setGeometryArray(expSegRight, new float[][]{{vv[0][this.stop_break], vv[0][this.stop_break] + dx}, {vv[1][this.stop_break], vv[1][this.stop_break] + dy}, {vv[2][this.stop_break], vv[2][this.stop_break] + dz}}, clr_dim, segColors);
            VisADLineArray segRightAnchor = new VisADLineArray();
            SampledSet.setGeometryArray(segRightAnchor, new float[][]{{vv[0][this.stop_break]}, {vv[1][this.stop_break]}, {vv[2][this.stop_break]}}, clr_dim, null);
            float[] segRightScaleInfo = new float[]{lbl_half, dd};
            ContourLabelGeometry ctrLabel = new ContourLabelGeometry(label, labelAnchor, expSegLeft, segLeftAnchor, segLeftScaleInfo, expSegRight, segRightAnchor, segRightScaleInfo);
            ctrLabel.isStyled = this.isDashed;
            this.css.labels.add(ctrLabel);
        } else {
            float[] lineCoords = new float[3 * (totalPts + 1)];
            byte[] lineColors = new byte[clr_dim * (totalPts + 1)];
            int lineClrCnt = 0;
            int lineCnt = 0;
            lineCoords[lineCnt++] = vv[0][0];
            lineCoords[lineCnt++] = vv[1][0];
            lineCoords[lineCnt++] = vv[2][0];
            for (int cc = 0; cc < clr_dim; ++cc) {
                lineColors[lineClrCnt++] = bb[cc][0];
            }
            for (int t = 1; t < totalPts * 2; t += 2) {
                lineCoords[lineCnt++] = vv[0][t];
                lineCoords[lineCnt++] = vv[1][t];
                lineCoords[lineCnt++] = vv[2][t];
                for (int c = 0; c < clr_dim; ++c) {
                    lineColors[lineClrCnt++] = bb[c][t];
                }
            }
            VisADLineStripArray lineArray = new VisADLineStripArray();
            lineArray.stripVertexCounts = new int[]{totalPts + 1};
            lineArray.vertexCount = lineArray.stripVertexCounts[0];
            lineArray.coordinates = lineCoords;
            if (lineColors.length > 0) {
                lineArray.colors = lineColors;
            }
            if (totalPts >= 2) {
                if (this.isDashed) {
                    this.css.cntrLinesStyled.add(lineArray);
                } else {
                    this.css.cntrLines.add(lineArray);
                }
            }
        }
    }

    float[][] getLineArray(float[] vx, float[] vy) {
        if (vx == null || vy == null) {
            return null;
        }
        int[] idx_array = this.idxs.toArray();
        float[] vvx = new float[idx_array.length];
        float[] vvy = new float[vvx.length];
        for (int ii = 0; ii < idx_array.length; ++ii) {
            vvx[ii] = vx[idx_array[ii]];
            vvy[ii] = vy[idx_array[ii]];
        }
        return new float[][]{vvx, vvy};
    }

    float[][][] getLineStripArrays(float[] vx, float[] vy) {
        int[] idx_array = this.idxs.toArray();
        int count = idx_array.length;
        int lenBefore = this.start_break / 2 + 1;
        int lenAfter = (count - this.stop_break + 1) / 2;
        if (this.isLabeled && lenBefore >= 2 && lenAfter >= 2) {
            float[][] vvBefore = new float[2][lenBefore];
            vvBefore[0][0] = vx[idx_array[0]];
            vvBefore[1][0] = vy[idx_array[0]];
            int kk = 1;
            for (int ii = 1; ii < vvBefore[0].length; ++ii) {
                vvBefore[0][ii] = vx[idx_array[kk]];
                vvBefore[1][ii] = vy[idx_array[kk]];
                kk += 2;
            }
            float[][] vvAfter = new float[2][lenAfter];
            vvAfter[0][0] = vx[idx_array[kk += this.n_skip - 1]];
            vvAfter[1][0] = vy[idx_array[kk]];
            ++kk;
            for (int ii = 1; ii < vvAfter[0].length; ++ii) {
                vvAfter[0][ii] = vx[idx_array[kk]];
                vvAfter[1][ii] = vy[idx_array[kk]];
                kk += 2;
            }
            return new float[][][]{vvBefore, vvAfter};
        }
        float[][] vv = null;
        vv = count == 2 ? new float[2][count] : new float[2][count / 2 + 1];
        vv[0][0] = vx[idx_array[0]];
        vv[1][0] = vy[idx_array[0]];
        int kk = 1;
        for (int ii = 1; ii < vv[0].length; ++ii) {
            vv[0][ii] = vx[idx_array[kk]];
            vv[1][ii] = vy[idx_array[kk]];
            kk += 2;
        }
        return new float[][][]{vv};
    }

    byte[][] getColorArray(byte[][] colors) {
        if (colors == null) {
            return null;
        }
        int clr_dim = colors.length;
        int[] idx_array = this.idxs.toArray();
        byte[][] new_colors = new byte[clr_dim][idx_array.length];
        for (int ii = 0; ii < idx_array.length; ++ii) {
            for (int cc = 0; cc < clr_dim; ++cc) {
                new_colors[cc][ii] = colors[cc][idx_array[ii]];
            }
        }
        return new_colors;
    }

    byte[][][] getColorStripArrays(byte[][] colors) {
        int clrDim = colors.length;
        int[] idx_array = this.idxs.toArray();
        int count = idx_array.length;
        int lenBefore = this.start_break / 2 + 1;
        int lenAfter = (count - this.stop_break + 1) / 2;
        if (this.isLabeled && lenBefore >= 2 && lenAfter >= 2) {
            int cc;
            byte[][] colorsBefore = new byte[clrDim][this.start_break / 2 + 1];
            for (int cc2 = 0; cc2 < clrDim; ++cc2) {
                colorsBefore[cc2][0] = colors[cc2][idx_array[0]];
            }
            int kk = 1;
            for (int ii = 1; ii < colorsBefore[0].length; ++ii) {
                for (cc = 0; cc < clrDim; ++cc) {
                    colorsBefore[cc][ii] = colors[cc][idx_array[kk]];
                }
                kk += 2;
            }
            kk += this.n_skip - 1;
            byte[][] colorsAfter = new byte[clrDim][(count - this.stop_break + 1) / 2];
            for (cc = 0; cc < clrDim; ++cc) {
                colorsAfter[cc][0] = colors[cc][idx_array[kk]];
            }
            ++kk;
            for (int ii = 1; ii < colorsAfter[0].length; ++ii) {
                for (int cc3 = 0; cc3 < clrDim; ++cc3) {
                    colorsAfter[cc3][ii] = colors[cc3][idx_array[kk]];
                }
                kk += 2;
            }
            return new byte[][][]{colorsBefore, colorsAfter};
        }
        byte[][] bb = null;
        bb = count == 2 ? new byte[clrDim][count] : new byte[clrDim][count / 2 + 1];
        for (int cc = 0; cc < clrDim; ++cc) {
            bb[cc][0] = colors[cc][idx_array[0]];
        }
        int ii = 1;
        int kk = 1;
        while (kk < idx_array.length) {
            for (int cc = 0; cc < clrDim; ++cc) {
                bb[cc][ii] = colors[cc][idx_array[kk]];
            }
            kk += 2;
            ++ii;
        }
        return new byte[][][]{bb};
    }

    boolean isLabeled() {
        return this.isLabeled;
    }

    void merge(ContourStrip that) {
        if (this.lev_idx != that.lev_idx) {
            System.out.println("Contour2D.ContourStrip.merge: !BIG ATTENTION!");
        }
        int[] thisLo = new int[2];
        int[] thisHi = new int[2];
        int[] thatLo = new int[2];
        int[] thatHi = new int[2];
        thisLo[0] = this.idxs.first.idx0;
        thisLo[1] = this.idxs.first.idx1;
        thisHi[0] = this.idxs.last.idx1;
        thisHi[1] = this.idxs.last.idx0;
        thatLo[0] = that.idxs.first.idx0;
        thatLo[1] = that.idxs.first.idx1;
        thatHi[0] = that.idxs.last.idx1;
        thatHi[1] = that.idxs.last.idx0;
        if (thisLo[0] == thatLo[0] || thisLo[0] == thatLo[1] || thisLo[1] == thatLo[0] || thisLo[1] == thatLo[1]) {
            IndexPairList.Node n = that.idxs.first.next;
            while (n != null) {
                this.idxs.addFirst(n.idx1, n.idx0);
                n = n.next;
            }
        } else if (thisLo[0] == thatHi[0] || thisLo[0] == thatHi[1] || thisLo[1] == thatHi[0] || thisLo[1] == thatHi[1]) {
            this.idxs.first.prev = that.idxs.last.prev;
            this.idxs.first.prev.next = this.idxs.first;
            this.idxs.first = that.idxs.first;
            this.idxs.numIndices = this.idxs.numIndices + that.idxs.numIndices - 2;
        } else if (thisHi[0] == thatHi[0] || thisHi[0] == thatHi[1] || thisHi[1] == thatHi[0] || thisHi[1] == thatHi[1]) {
            IndexPairList.Node n = that.idxs.last.prev;
            while (n != null) {
                this.idxs.addLast(n.idx1, n.idx0);
                n = n.prev;
            }
        } else if (thisHi[0] == thatLo[0] || thisHi[0] == thatLo[1] || thisHi[1] == thatLo[0] || thisHi[1] == thatLo[1]) {
            this.idxs.last.next = that.idxs.first.next;
            this.idxs.last.next.prev = this.idxs.last;
            this.idxs.last = that.idxs.last;
            this.idxs.numIndices = this.idxs.numIndices + that.idxs.numIndices - 2;
        }
    }

    public String toString() {
        return "<" + this.getClass().getName() + "(" + this.idxs.first.idx0 + "," + this.idxs.first.idx1 + "), (" + this.idxs.last.idx0 + "," + this.idxs.first.idx1 + ")>";
    }
}

