/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribCollectionProto;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.TimeCoordUnion;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib1.Grib1CollectionBuilder;
import ucar.nc2.grib.grib2.Grib2CollectionBuilder;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;
import ucar.unidata.util.StringUtil2;

@ThreadSafe
public abstract class GribCollection
implements FileCacheable {
    private static final Logger logger = LoggerFactory.getLogger(GribCollection.class);
    public static final String NCX_IDX = ".ncx";
    public static final long MISSING_RECORD = -1L;
    private static FileCache dataRafCache;
    private static DiskCache2 cache;
    private static final FileFactory dataRafFactory;
    protected String name;
    protected File directory;
    protected FeatureCollectionConfig.GribConfig gribConfig;
    protected boolean isGrib1;
    public int version;
    public int center;
    public int subcenter;
    public int master;
    public int local;
    public int genProcessType;
    public int genProcessId;
    public int backProcessId;
    public List<String> filenames;
    public List<GroupHcs> groups;
    public List<Parameter> params;
    protected RandomAccessFile indexRaf;
    private File indexFile;
    protected FileCache fileCache = null;
    private Set<String> groupNames = new HashSet<String>(5);

    public static void initDataRafCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        dataRafCache = new FileCache("GribCollectionDataRafCache ", minElementsInMemory, maxElementsInMemory, -1, period);
    }

    public static FileCache getDataRafCache() {
        return dataRafCache;
    }

    public static void disableNetcdfFileCache() {
        if (null != dataRafCache) {
            dataRafCache.disable();
        }
        dataRafCache = null;
    }

    public static File getIndexFile(String path) {
        return cache.getFile(path);
    }

    public static File getIndexFile(CollectionManager dcm) {
        File idxFile = new File(new File(dcm.getRoot()), dcm.getCollectionName() + NCX_IDX);
        return GribCollection.getIndexFile(idxFile.getPath());
    }

    public static void setDiskCache2(DiskCache2 dc) {
        cache = dc;
    }

    public static DiskCache2 getDiskCache2() {
        return cache;
    }

    public static int calcIndex(int timeIdx, int ensIdx, int vertIdx, int nens, int nverts) {
        if (nens == 0) {
            nens = 1;
        }
        if (nverts == 0) {
            nverts = 1;
        }
        return vertIdx + ensIdx * nverts + timeIdx * nverts * nens;
    }

    public static int calcIndex(int timeIdx, int ensIdx, int vertIdx, int flag, EnsCoord ec, VertCoord vc, EnsCoord ecp, VertCoord vcp) {
        int want_ensIdx = ensIdx;
        if ((flag & 2) != 0 && (want_ensIdx = GribCollection.findEnsIndex(ensIdx, ec.getCoords(), ecp.getCoords())) == -1) {
            return -1;
        }
        int want_vertIdx = vertIdx;
        if ((flag & 1) != 0 && (want_vertIdx = GribCollection.findVertIndex(vertIdx, vc.getCoords(), vcp.getCoords())) == -1) {
            return -1;
        }
        return GribCollection.calcIndex(timeIdx, want_ensIdx, want_vertIdx, ec == null ? 0 : ec.getSize(), vc == null ? 0 : vc.getSize());
    }

    private static int findEnsIndex(int indexp, List<EnsCoord.Coord> coords, List<EnsCoord.Coord> coordsp) {
        EnsCoord.Coord want = coordsp.get(indexp);
        for (int i = 0; i < coords.size(); ++i) {
            EnsCoord.Coord have = coords.get(i);
            if (!have.equals(want)) continue;
            return i;
        }
        return -1;
    }

    private static int findVertIndex(int indexp, List<VertCoord.Level> coords, List<VertCoord.Level> coordsp) {
        VertCoord.Level want = coordsp.get(indexp);
        for (int i = 0; i < coords.size(); ++i) {
            VertCoord.Level have = coords.get(i);
            if (!have.equals(want)) continue;
            return i;
        }
        return -1;
    }

    public static GribCollection factory(boolean isGrib1, CollectionManager dcm, CollectionManager.Force force, Formatter f) throws IOException {
        if (isGrib1) {
            return Grib1CollectionBuilder.factory(dcm, force, f);
        }
        return Grib2CollectionBuilder.factory(dcm, force, f);
    }

    public static GribCollection createFromIndex(boolean isGrib1, String name, File directory, RandomAccessFile raf, FeatureCollectionConfig.GribConfig config) throws IOException {
        if (isGrib1) {
            return Grib1CollectionBuilder.createFromIndex(name, directory, raf, config);
        }
        return Grib2CollectionBuilder.createFromIndex(name, directory, raf, config);
    }

    public static boolean update(boolean isGrib1, CollectionManager dcm, Formatter f) throws IOException {
        if (isGrib1) {
            return Grib1CollectionBuilder.update(dcm, f);
        }
        return Grib2CollectionBuilder.update(dcm, f);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getFilenames() {
        return this.filenames;
    }

    public RandomAccessFile getIndexRaf() {
        return this.indexRaf;
    }

    public void setIndexRaf(RandomAccessFile indexRaf) {
        this.indexRaf = indexRaf;
    }

    public File getIndexFile() {
        if (this.indexFile == null) {
            String nameNoBlanks = StringUtil2.replace(this.name, ' ', "_");
            File f = new File(this.directory, nameNoBlanks + NCX_IDX);
            this.indexFile = cache.getFile(f.getPath());
        }
        return this.indexFile;
    }

    public File makeNewIndexFile() {
        if (this.indexFile != null && this.indexFile.exists() && !this.indexFile.delete()) {
            logger.warn("Failed to delete {}", (Object)this.indexFile.getPath());
        }
        this.indexFile = null;
        return this.getIndexFile();
    }

    public List<GroupHcs> getGroups() {
        return this.groups;
    }

    public List<Parameter> getParams() {
        return this.params;
    }

    public int getCenter() {
        return this.center;
    }

    public int getSubcenter() {
        return this.subcenter;
    }

    public int getMaster() {
        return this.master;
    }

    public int getLocal() {
        return this.local;
    }

    public int getGenProcessType() {
        return this.genProcessType;
    }

    public int getGenProcessId() {
        return this.genProcessId;
    }

    public int getBackProcessId() {
        return this.backProcessId;
    }

    public boolean isGrib1() {
        return this.isGrib1;
    }

    protected GribCollection(String name, File directory, FeatureCollectionConfig.GribConfig dcm, boolean isGrib1) {
        this.name = name;
        this.directory = directory;
        this.gribConfig = dcm;
        this.isGrib1 = isGrib1;
    }

    public abstract NetcdfDataset getNetcdfDataset(String var1, String var2, FeatureCollectionConfig.GribConfig var3) throws IOException;

    public abstract GridDataset getGridDataset(String var1, String var2, FeatureCollectionConfig.GribConfig var3) throws IOException;

    public GroupHcs getGroup(int index) {
        return this.groups.get(index);
    }

    public GroupHcs findGroupById(String id) {
        for (GroupHcs g : this.getGroups()) {
            if (!g.getId().equals(id)) continue;
            return g;
        }
        return null;
    }

    public int findGroupIdxById(String id) {
        for (int i = 0; i < this.groups.size(); ++i) {
            GroupHcs g = this.groups.get(i);
            if (!g.getId().equals(id)) continue;
            return i;
        }
        return -1;
    }

    public RandomAccessFile getDataRaf(int fileno) throws IOException {
        String filename = this.filenames.get(fileno);
        File dataFile = new File(filename);
        if (!dataFile.exists()) {
            dataFile = this.filenames.size() == 1 ? new File(this.directory, this.name) : new File(this.directory, dataFile.getName());
        }
        if (!dataFile.exists()) {
            throw new FileNotFoundException("data file not found = " + filename);
        }
        RandomAccessFile want = this.getDataRaf(dataFile.getPath());
        want.order(0);
        return want;
    }

    private RandomAccessFile getDataRaf(String location) throws IOException {
        if (dataRafCache != null) {
            return (RandomAccessFile)dataRafCache.acquire(dataRafFactory, location, null);
        }
        return new RandomAccessFile(location, "r");
    }

    @Override
    public void close() throws IOException {
        if (this.fileCache != null) {
            this.fileCache.release(this);
        } else if (this.indexRaf != null) {
            this.indexRaf.close();
            this.indexRaf = null;
        }
    }

    @Override
    public String getLocation() {
        if (this.indexRaf != null) {
            return this.indexRaf.getLocation();
        }
        return this.getIndexFile().getPath();
    }

    @Override
    public long getLastModified() {
        if (this.indexFile != null) {
            return this.indexFile.lastModified();
        }
        return 0L;
    }

    @Override
    public void setFileCache(FileCache fileCache) {
        this.fileCache = fileCache;
    }

    public VariableIndex makeVariableIndex(GroupHcs g, int tableVersion, int discipline, int category, int parameter, int levelType, boolean isLayer, int intvType, String intvName, int ensDerivedType, int probType, String probabilityName, int genProcessType, int cdmHash, int timeIdx, int vertIdx, int ensIdx, long recordsPos, int recordsLen) {
        return new VariableIndex(g, tableVersion, discipline, category, parameter, levelType, isLayer, intvType, intvName, ensDerivedType, probType, probabilityName, genProcessType, cdmHash, timeIdx, vertIdx, ensIdx, recordsPos, recordsLen);
    }

    public void showIndex(Formatter f) {
        f.format("%s%n%n", this.toString());
        f.format("Class (%s)%n", this.getClass().getName());
        f.format("Files (%d)%n", this.filenames.size());
        for (String file : this.filenames) {
            f.format("  %s%n", file);
        }
        f.format("%n", new Object[0]);
        for (GroupHcs g : this.groups) {
            f.format("Hcs = %s%n", g.hcs);
            f.format("%nVarIndex (%d)%n", g.varIndex.size());
            for (VariableIndex v : g.varIndex) {
                f.format("  %s%n", v.toStringComplete());
            }
            f.format("%nTimeCoords (%d)%n", g.timeCoords.size());
            for (int i = 0; i < g.timeCoords.size(); ++i) {
                TimeCoord tc = g.timeCoords.get(i);
                f.format(" %d: %s%n", i, tc);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GribCollection");
        sb.append("{\n name='").append(this.name).append('\'');
        sb.append("\n directory=").append(this.directory);
        sb.append("\n isGrib1=").append(this.isGrib1);
        sb.append("\n version=").append(this.version);
        sb.append("\n center=").append(this.center);
        sb.append("\n subcenter=").append(this.subcenter);
        sb.append("\n master=").append(this.master);
        sb.append("\n local=").append(this.local);
        sb.append("\n genProcessType=").append(this.genProcessType);
        sb.append("\n genProcessId=").append(this.genProcessId);
        sb.append("\n backProcessId=").append(this.backProcessId);
        sb.append("\n indexFile=").append(this.indexFile);
        sb.append('}');
        return sb.toString();
    }

    public GroupHcs makeGroup() {
        return new GroupHcs();
    }

    static {
        cache = new DiskCache2();
        dataRafFactory = new FileFactory(){

            @Override
            public FileCacheable open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
                return new RandomAccessFile(location, "r");
            }
        };
    }

    protected static class GcNetcdfFile
    extends NetcdfFile {
        public GcNetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
            super(spi, raf, location, cancelTask);
        }
    }

    public static class Record {
        public int fileno;
        public long pos;
        public long bmsPos;

        public Record(int fileno, long pos, long bmsPos, boolean missing) {
            this.fileno = fileno;
            this.pos = pos;
            this.bmsPos = bmsPos;
            if (missing) {
                this.pos = -1L;
            }
        }
    }

    public class VariableIndex
    implements Comparable<VariableIndex> {
        public final int tableVersion;
        public final int discipline;
        public final int category;
        public final int parameter;
        public final int levelType;
        public final int intvType;
        public final int ensDerivedType;
        public final int probType;
        public final String intvName;
        public final String probabilityName;
        public final boolean isLayer;
        public final int genProcessType;
        public final int cdmHash;
        public final int timeIdx;
        public final int vertIdx;
        public final int ensIdx;
        public final long recordsPos;
        public final int recordsLen;
        public final GroupHcs group;
        public int ntimes;
        public int nverts;
        public int nens;
        public Record[] records;
        public int partTimeCoordIdx;

        public VariableIndex(GroupHcs g, int tableVersion, int discipline, int category, int parameter, int levelType, boolean isLayer, int intvType, String intvName, int ensDerivedType, int probType, String probabilityName, int genProcessType, int cdmHash, int timeIdx, int vertIdx, int ensIdx, long recordsPos, int recordsLen) {
            this.group = g;
            this.tableVersion = tableVersion;
            this.discipline = discipline;
            this.category = category;
            this.parameter = parameter;
            this.levelType = levelType;
            this.isLayer = isLayer;
            this.intvType = intvType;
            this.intvName = intvName;
            this.ensDerivedType = ensDerivedType;
            this.probabilityName = probabilityName;
            this.probType = probType;
            this.genProcessType = genProcessType;
            this.cdmHash = cdmHash;
            this.timeIdx = timeIdx;
            this.vertIdx = vertIdx;
            this.ensIdx = ensIdx;
            this.recordsPos = recordsPos;
            this.recordsLen = recordsLen;
        }

        public TimeCoord getTimeCoord() {
            return this.timeIdx < 0 ? null : this.group.timeCoords.get(this.timeIdx);
        }

        public VertCoord getVertCoord() {
            return this.vertIdx < 0 ? null : this.group.vertCoords.get(this.vertIdx);
        }

        public EnsCoord getEnsCoord() {
            return this.ensIdx < 0 ? null : this.group.ensCoords.get(this.ensIdx);
        }

        public String id() {
            return this.discipline + "-" + this.category + "-" + this.parameter;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("VariableIndex");
            sb.append("{tableVersion=").append(this.tableVersion);
            sb.append(", discipline=").append(this.discipline);
            sb.append(", category=").append(this.category);
            sb.append(", parameter=").append(this.parameter);
            sb.append(", levelType=").append(this.levelType);
            sb.append(", intvType=").append(this.intvType);
            sb.append(", ensDerivedType=").append(this.ensDerivedType);
            sb.append(", probType=").append(this.probType);
            sb.append(", intvName='").append(this.intvName).append('\'');
            sb.append(", probabilityName='").append(this.probabilityName).append('\'');
            sb.append(", isLayer=").append(this.isLayer);
            sb.append(", genProcessType=").append(this.genProcessType);
            sb.append(", cdmHash=").append(this.cdmHash);
            sb.append(", timeIdx=").append(this.timeIdx);
            sb.append(", vertIdx=").append(this.vertIdx);
            sb.append(", ensIdx=").append(this.ensIdx);
            sb.append(", ntimes=").append(this.ntimes);
            sb.append(", nverts=").append(this.nverts);
            sb.append(", nens=").append(this.nens);
            sb.append(", partTimeCoordIdx=").append(this.partTimeCoordIdx);
            sb.append('}');
            return sb.toString();
        }

        public String toStringComplete() {
            StringBuilder sb = new StringBuilder();
            sb.append("VariableIndex");
            sb.append("{tableVersion=").append(this.tableVersion);
            sb.append(", discipline=").append(this.discipline);
            sb.append(", discipline=").append(this.discipline);
            sb.append(", category=").append(this.category);
            sb.append(", parameter=").append(this.parameter);
            sb.append(", levelType=").append(this.levelType);
            sb.append(", intvType=").append(this.intvType);
            sb.append(", ensDerivedType=").append(this.ensDerivedType);
            sb.append(", probType=").append(this.probType);
            sb.append(", intvName='").append(this.intvName).append('\'');
            sb.append(", probabilityName='").append(this.probabilityName).append('\'');
            sb.append(", isLayer=").append(this.isLayer);
            sb.append(", cdmHash=").append(this.cdmHash);
            sb.append(", timeIdx=").append(this.timeIdx);
            sb.append(", vertIdx=").append(this.vertIdx);
            sb.append(", ensIdx=").append(this.ensIdx);
            sb.append(", recordsPos=").append(this.recordsPos);
            sb.append(", recordsLen=").append(this.recordsLen);
            sb.append(", group=").append(this.group.getId());
            sb.append(", ntimes=").append(this.ntimes);
            sb.append(", nverts=").append(this.nverts);
            sb.append(", nens=").append(this.nens);
            sb.append(", records=").append(this.records == null ? "null" : Arrays.asList(this.records).toString());
            sb.append(", partTimeCoordIdx=").append(this.partTimeCoordIdx);
            sb.append('}');
            return sb.toString();
        }

        public Record[] getRecords() throws IOException {
            this.readRecords();
            return this.records;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readRecords() throws IOException {
            if (this.records != null) {
                return;
            }
            byte[] b = new byte[this.recordsLen];
            Object object = GribCollection.this.indexRaf;
            synchronized (object) {
                GribCollection.this.indexRaf.seek(this.recordsPos);
                GribCollection.this.indexRaf.readFully(b);
            }
            object = this;
            synchronized (object) {
                GribCollectionProto.VariableRecords proto = GribCollectionProto.VariableRecords.parseFrom(b);
                int cdmHash = proto.getCdmHash();
                if (cdmHash != this.cdmHash) {
                    throw new IllegalStateException("Corrupted index");
                }
                int n = proto.getRecordsCount();
                Record[] recordsTemp = new Record[n];
                for (int i = 0; i < n; ++i) {
                    GribCollectionProto.Record pr = proto.getRecords(i);
                    recordsTemp[i] = new Record(pr.getFileno(), pr.getPos(), pr.getBmsPos(), pr.getMissing());
                }
                this.records = recordsTemp;
            }
        }

        @Override
        public int compareTo(VariableIndex o) {
            int r = this.discipline - o.discipline;
            if (r != 0) {
                return r;
            }
            r = this.category - o.category;
            if (r != 0) {
                return r;
            }
            r = this.parameter - o.parameter;
            if (r != 0) {
                return r;
            }
            r = this.levelType - o.levelType;
            if (r != 0) {
                return r;
            }
            r = this.intvType - o.intvType;
            return r;
        }
    }

    public class GroupHcs
    implements Comparable<GroupHcs> {
        public GdsHorizCoordSys hcs;
        public byte[] rawGds;
        public int gdsHash;
        private String id;
        private String description;
        public List<VariableIndex> varIndex;
        public List<TimeCoord> timeCoords;
        public List<VertCoord> vertCoords;
        public List<EnsCoord> ensCoords;
        public int[] filenose;
        public List<TimeCoordUnion> timeCoordPartitions;

        public void setHorizCoordSystem(GdsHorizCoordSys hcs, byte[] rawGds, int gdsHash) {
            this.hcs = hcs;
            this.rawGds = rawGds;
            this.gdsHash = gdsHash;
        }

        private String makeId() {
            String base;
            String result = null;
            if (GribCollection.this.gribConfig != null && GribCollection.this.gribConfig.gdsNamer != null) {
                result = GribCollection.this.gribConfig.gdsNamer.get(this.gdsHash);
            }
            if (result != null) {
                StringBuilder sb = new StringBuilder(result);
                StringUtil2.replace(sb, ". :", "p--");
                return sb.toString();
            }
            if (GribCollection.this.gribConfig != null && GribCollection.this.gribConfig.groupNamer != null) {
                File firstFile = new File(GribCollection.this.filenames.get(this.filenose[0]));
                LatLonPoint centerPoint = this.hcs.getCenterLatLon();
                StringBuilder sb = new StringBuilder(firstFile.getName().substring(15, 26) + "-" + centerPoint.toString());
                StringUtil2.replace(sb, ". :", "p--");
                return sb.toString();
            }
            String tryit = base = this.hcs.makeId();
            int count = 1;
            while (GribCollection.this.groupNames.contains(tryit)) {
                tryit = base + "-" + ++count;
            }
            GribCollection.this.groupNames.add(tryit);
            return tryit;
        }

        private String makeDescription() {
            String result = null;
            if (GribCollection.this.gribConfig != null && GribCollection.this.gribConfig.gdsNamer != null) {
                result = GribCollection.this.gribConfig.gdsNamer.get(this.gdsHash);
            }
            if (result != null) {
                return result;
            }
            if (GribCollection.this.gribConfig != null && GribCollection.this.gribConfig.groupNamer != null) {
                File firstFile = new File(GribCollection.this.filenames.get(this.filenose[0]));
                LatLonPoint centerPoint = this.hcs.getCenterLatLon();
                return "First Run " + firstFile.getName().substring(15, 26) + ", Center " + centerPoint;
            }
            return this.hcs.makeDescription();
        }

        public GribCollection getGribCollection() {
            return GribCollection.this;
        }

        public String getId() {
            if (this.id == null) {
                this.id = this.makeId();
            }
            return this.id;
        }

        public String getDescription() {
            if (this.description == null) {
                this.description = this.makeDescription();
            }
            return this.description;
        }

        @Override
        public int compareTo(GroupHcs o) {
            return this.getDescription().compareTo(o.getDescription());
        }

        public List<String> getFilenames() {
            ArrayList<String> result = new ArrayList<String>();
            for (int fileno : this.filenose) {
                result.add(GribCollection.this.filenames.get(fileno));
            }
            Collections.sort(result);
            return result;
        }

        public VariableIndex findAnyVariableWithTime(int usesTimeIndex) {
            for (VariableIndex vi : this.varIndex) {
                if (vi.timeIdx != usesTimeIndex) continue;
                return vi;
            }
            return null;
        }

        public VariableIndex findVariableByHash(int cdmHash) {
            for (VariableIndex vi : this.varIndex) {
                if (vi.cdmHash != cdmHash) continue;
                return vi;
            }
            return null;
        }

        public CalendarDateRange getTimeCoverage() {
            TimeCoord useTc = null;
            for (TimeCoord tc : this.timeCoords) {
                if (useTc != null && useTc.getSize() >= tc.getSize()) continue;
                useTc = tc;
            }
            return useTc == null ? null : useTc.getCalendarRange();
        }
    }
}

