/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import thredds.catalog.ThreddsMetadata;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionUpdater;
import thredds.inventory.MFileCollectionManager;
import thredds.inventory.TimePartitionCollection;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.TimePartition;
import ucar.nc2.grib.grib1.Grib1Iosp;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Iosp;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;

@ThreadSafe
public class InvDatasetFcGrib
extends InvDatasetFeatureCollection {
    private static final Logger logger = LoggerFactory.getLogger(InvDatasetFcGrib.class);
    private static final String COLLECTION = "collection";
    private static final String BEST_DATASET = "best";
    protected static final String LATEST_DATASET = "latest";
    protected static final String LATEST_DATASET_NAME = "Latest Run";
    private final FeatureCollectionConfig.GribConfig gribConfig;
    private final AtomicBoolean needsUpdate = new AtomicBoolean();
    private final AtomicBoolean needsProto = new AtomicBoolean();
    private boolean first = true;
    private DataFormatType format;
    private String bestDatasetName = "Best Timeseries";
    private Map<Integer, ThreddsMetadata.Variable> map = null;
    private Grib1Customizer cust1 = null;
    private Grib2Customizer cust2 = null;

    public InvDatasetFcGrib(InvDatasetImpl parent, String name, String path, FeatureCollectionType fcType, FeatureCollectionConfig config) {
        super(parent, name, path, fcType, config);
        String errs;
        this.gribConfig = config.gribConfig;
        Formatter errlog = new Formatter();
        if (config.useIndexOnly) {
            this.dcm = TimePartitionCollection.fromExistingIndices(config, errlog);
        } else if (config.timePartition != null) {
            this.dcm = TimePartitionCollection.factory(config, errlog);
            this.dcm.setChangeChecker(GribIndex.getChangeChecker());
        } else {
            this.dcm = new MFileCollectionManager(config, errlog);
            this.dcm.setChangeChecker(GribIndex.getChangeChecker());
        }
        if (config.gribConfig != null) {
            this.dcm.putAuxInfo("gribConfig", config.gribConfig);
        }
        if ((errs = errlog.toString()).length() > 0) {
            logger.warn("{}: CollectionManager parse error = {} ", (Object)name, (Object)errs);
        }
        this.tmi.setDataType(FeatureType.GRID);
        if (config.gribConfig.bestNamer != null) {
            this.bestDatasetName = config.gribConfig.bestNamer;
        }
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(CollectionManager.Force force) {
        if (this.first) {
            Object object = this.lock;
            synchronized (object) {
                this.format = this.getDataFormatType();
                this.firstInit();
                this.first = false;
            }
        }
        StateGrib localState = new StateGrib((StateGrib)this.state);
        try {
            this.updateCollection(localState, force);
        }
        catch (Throwable e) {
            logger.error("Fail to create/update collection", e);
            return;
        }
        this.makeDatasetTop(localState);
        localState.lastInvChange = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            this.needsUpdate.set(false);
            this.needsProto.set(false);
            this.state = localState;
        }
    }

    @Override
    public void updateProto() {
        this.needsProto.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateGrib checkState() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.first) {
                this.format = this.getDataFormatType();
                this.firstInit();
                this.dcm.scanIfNeeded();
                this.first = false;
            } else if (!this.dcm.scanIfNeeded()) {
                return (StateGrib)this.state;
            }
            boolean tdsUsingTdm = !CollectionUpdater.INSTANCE.isTdm() && this.config.tdmConfig != null;
            CollectionManager.Force ff = tdsUsingTdm || this.config.updateConfig.isStatic() ? CollectionManager.Force.nocheck : CollectionManager.Force.test;
            StateGrib localState = new StateGrib((StateGrib)this.state);
            this.updateCollection(localState, ff);
            this.makeDatasetTop(localState);
            localState.lastInvChange = System.currentTimeMillis();
            this.needsUpdate.set(false);
            this.needsProto.set(false);
            this.state = localState;
            return localState;
        }
    }

    private void updateCollection(StateGrib localState, CollectionManager.Force force) throws IOException {
        if (this.config.timePartition != null) {
            TimePartition previous = localState.timePartition;
            localState.timePartition = TimePartition.factory(this.format == DataFormatType.GRIB1, (TimePartitionCollection)this.dcm, force, new Formatter());
            localState.gribCollection = null;
            if (previous != null) {
                previous.close();
            }
            logger.debug("{}: TimePartition object was recreated", (Object)this.getName());
        } else {
            GribCollection previous = localState.gribCollection;
            localState.gribCollection = GribCollection.factory(this.format == DataFormatType.GRIB1, this.dcm, force, new Formatter());
            localState.timePartition = null;
            if (previous != null) {
                previous.close();
            }
            logger.debug("{}: GribCollection object was recreated", (Object)this.getName());
        }
    }

    private void makeDatasetTop(StateGrib localState) {
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        InvDatasetImpl parent = (InvDatasetImpl)this.getParent();
        if (parent != null) {
            top.transferMetadata(parent, true);
        }
        String tpath = this.getPath() + "/" + COLLECTION;
        top.setID(tpath);
        GribCollection gc = localState.timePartition == null ? localState.gribCollection : localState.timePartition;
        ArrayList<GribCollection.GroupHcs> groups = new ArrayList<GribCollection.GroupHcs>(gc.getGroups());
        Collections.sort(groups);
        boolean isSingleGroup = groups.size() == 1;
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        tmi.addVariableMapLink(this.makeMetadataLink(tpath, "?metadata=variableMap"));
        tmi.setGeospatialCoverage(this.extractGeospatial(groups));
        tmi.setTimeCoverage(this.extractCalendarDateRange(groups));
        tmi.setServiceName(this.virtualService.getName());
        if (localState.timePartition == null) {
            for (GribCollection.GroupHcs group : groups) {
                String dpath;
                InvDatasetImpl ds = isSingleGroup ? top : new InvDatasetImpl(this, group.getDescription());
                String groupId = isSingleGroup ? null : group.getId();
                String string = dpath = isSingleGroup ? this.getPath() : this.getPath() + "/" + groupId;
                if (!isSingleGroup) {
                    ds.setID(dpath);
                    top.addDataset(ds);
                }
                ds.tmi.setGeospatialCoverage(this.extractGeospatial(group));
                ds.tmi.setTimeCoverage(this.extractCalendarDateRange(group));
                if (this.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Best)) {
                    InvDatasetImpl best = new InvDatasetImpl(this, this.getBestDatasetName());
                    String path = dpath + "/" + BEST_DATASET;
                    best.setUrlPath(path);
                    best.setID(path);
                    best.tmi.addVariableMapLink(this.makeMetadataLink(path, "?metadata=variableMap"));
                    ds.addDataset(best);
                }
                if (!this.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Files)) continue;
                String name = isSingleGroup ? "files" : groupId + "/" + "files";
                InvCatalogRef filesCat = new InvCatalogRef(this, "files", this.getCatalogHref(name));
                filesCat.finish();
                ds.addDataset(filesCat);
            }
        } else {
            if (isSingleGroup) {
                if (this.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Best)) {
                    InvDatasetImpl best = new InvDatasetImpl(this, this.getBestDatasetName());
                    String path = this.getPath() + "/" + BEST_DATASET;
                    best.setUrlPath(path);
                    best.setID(path);
                    best.tmi.addVariableMapLink(this.makeMetadataLink(path, "?metadata=variableMap"));
                    top.addDataset(best);
                }
                if (this.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.LatestFile)) {
                    InvDatasetImpl ds2 = new InvDatasetImpl(this, this.getLatestFileName());
                    ds2.setUrlPath("files/latest.xml");
                    ds2.setID("files/latest.xml");
                    ds2.setServiceName(LATEST_DATASET);
                    ds2.finish();
                    top.addDataset(ds2);
                }
            } else if (this.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Best)) {
                String dname = this.getPath() + "/" + BEST_DATASET;
                InvCatalogRef ds = new InvCatalogRef(this, this.getBestDatasetName(), this.getCatalogHref(dname));
                top.addDataset(ds);
            }
            for (TimePartition.Partition dc : localState.timePartition.getPartitions()) {
                String dname = dc.getName();
                InvCatalogRef ds = new InvCatalogRef(this, dname, this.getCatalogHref(dname));
                top.addDataset(ds);
            }
        }
        top.finish();
        localState.top = top;
    }

    @Override
    public InvCatalogImpl makeCatalog(String match, String reqPath, URI catURI) {
        StateGrib localState;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", e);
            return null;
        }
        try {
            if (match == null || match.length() == 0) {
                return this.makeCatalogTop(catURI, localState);
            }
            if (localState.timePartition == null) {
                GribCollection.GroupHcs group;
                String[] path = match.split("/");
                if (path.length == 1 && path[0].equals("files")) {
                    group = localState.gribCollection.getGroup(0);
                } else {
                    if (path.length < 2) {
                        return null;
                    }
                    group = localState.gribCollection.findGroupById(path[0]);
                }
                if (group != null) {
                    return this.makeCatalogFiles(localState.gribCollection, group, catURI, localState, false);
                }
            } else {
                if (match.endsWith(BEST_DATASET)) {
                    return this.makeCatalogPartition(localState.timePartition, catURI, localState);
                }
                TimePartition.Partition tpp = localState.timePartition.getPartitionByName(match);
                if (tpp != null) {
                    GribCollection gc = tpp.getGribCollection();
                    InvCatalogImpl result = this.makeCatalogPartition(gc, catURI, localState);
                    gc.close();
                    return result;
                }
                String[] path = match.split("/");
                if (path.length < 2) {
                    return null;
                }
                tpp = localState.timePartition.getPartitionByName(path[0]);
                if (tpp != null) {
                    InvCatalogImpl result;
                    GribCollection gc = tpp.getGribCollection();
                    if (path[1].equals("files")) {
                        GribCollection.GroupHcs group = gc.getGroup(0);
                        result = this.makeCatalogFiles(gc, group, catURI, localState, true);
                    } else {
                        GribCollection.GroupHcs group = gc.findGroupById(path[1]);
                        if (group == null) {
                            return null;
                        }
                        result = this.makeCatalogFiles(gc, group, catURI, localState, true);
                    }
                    gc.close();
                    return result;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error making catalog for " + this.path, e);
        }
        return null;
    }

    @Override
    protected InvCatalogImpl makeCatalogTop(URI catURI, InvDatasetFeatureCollection.State localState) throws IOException, URISyntaxException {
        InvCatalogImpl parentCatalog = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl mainCatalog = new InvCatalogImpl(this.getName(), parentCatalog.getVersion(), catURI);
        mainCatalog.addDataset(((StateGrib)localState).top);
        mainCatalog.addService(InvService.latest);
        mainCatalog.addService(this.virtualService);
        mainCatalog.finish();
        mainCatalog.finish();
        return mainCatalog;
    }

    private InvCatalogImpl makeCatalogPartition(GribCollection gribCollection, URI catURI, InvDatasetFeatureCollection.State localState) throws IOException {
        String partitionName = gribCollection.getName();
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl partCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), catURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(partitionName);
        top.setID(partitionName);
        partCatalog.addDataset(top);
        partCatalog.addService(this.virtualService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        ArrayList<GribCollection.GroupHcs> groups = new ArrayList<GribCollection.GroupHcs>(gribCollection.getGroups());
        Collections.sort(groups);
        boolean isSingleGroup = groups.size() == 1;
        boolean isBest = gribCollection instanceof TimePartition;
        String tpath = this.getPath() + "/" + partitionName;
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        tmi.addVariableMapLink(this.makeMetadataLink(tpath, "?metadata=variableMap"));
        tmi.setGeospatialCoverage(this.extractGeospatial(groups));
        tmi.setTimeCoverage(this.extractCalendarDateRange(groups));
        for (GribCollection.GroupHcs group : groups) {
            String groupId = group.getId();
            InvDatasetImpl container = top;
            if (!isSingleGroup && !isBest) {
                container = new InvDatasetImpl(this, group.getDescription());
                container.setID(group.getId());
                top.addDataset(container);
            }
            if (this.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Best)) {
                String dpath;
                InvDatasetImpl ds;
                if (isSingleGroup) {
                    ds = new InvDatasetImpl(this, this.getBestDatasetName() + " for " + partitionName);
                    dpath = this.path + "/" + partitionName + "/" + BEST_DATASET;
                } else if (isBest) {
                    ds = new InvDatasetImpl(this, this.getBestDatasetName() + " for " + groupId);
                    dpath = this.path + "/" + groupId + "/" + BEST_DATASET;
                } else {
                    ds = new InvDatasetImpl(this, this.getBestDatasetName() + " for " + partitionName + " and " + groupId);
                    dpath = this.path + "/" + partitionName + "/" + groupId + "/" + BEST_DATASET;
                }
                ds.setUrlPath(dpath);
                ds.setID(dpath);
                ds.tmi.addVariableMapLink(this.makeMetadataLink(dpath, "?metadata=variableMap"));
                ds.tmi.setGeospatialCoverage(this.extractGeospatial(group));
                CalendarDateRange cdr = this.extractCalendarDateRange(group);
                if (cdr != null) {
                    ds.tmi.setTimeCoverage(cdr);
                }
                ds.finish();
                container.addDataset(ds);
            }
            if (isBest || !this.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Files)) continue;
            String name = isSingleGroup ? partitionName + "/" + "files" : partitionName + "/" + groupId + "/" + "files";
            InvCatalogRef filesCat = new InvCatalogRef(this, "files", this.getCatalogHref(name));
            filesCat.finish();
            container.addDataset(filesCat);
        }
        partCatalog.finish();
        return partCatalog;
    }

    private InvCatalogImpl makeCatalogFiles(GribCollection gc, GribCollection.GroupHcs group, URI catURI, InvDatasetFeatureCollection.State localState, boolean isTimePartition) throws IOException {
        boolean isSingleGroup = gc.getGroups().size() == 1;
        List<String> filenames = isSingleGroup ? gc.getFilenames() : group.getFilenames();
        boolean addLatest = !isTimePartition && this.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.LatestFile);
        return this.makeCatalogFiles(catURI, localState, filenames, addLatest);
    }

    @Override
    public InvCatalogImpl makeLatest(String matchPath, String reqPath, URI catURI) {
        StateGrib localState;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", e);
            return null;
        }
        GribCollection gc = localState.timePartition == null ? localState.gribCollection : localState.timePartition;
        ArrayList<GribCollection.GroupHcs> groups = new ArrayList<GribCollection.GroupHcs>(gc.getGroups());
        String[] paths = matchPath.split("/");
        if (paths.length < 1) {
            return null;
        }
        try {
            if (localState.timePartition == null) {
                if (paths.length == 1 && paths[0].equals("files")) {
                    return this.makeLatestCatalog(gc, (GribCollection.GroupHcs)groups.get(0), catURI, localState);
                }
                if (paths.length == 2 && paths[1].equals("files")) {
                    return this.makeLatestCatalog(gc, gc.findGroupById(paths[0]), catURI, localState);
                }
            } else {
                if (paths.length == 1 && paths[0].equals("files")) {
                    TimePartition.Partition p = localState.timePartition.getPartitionLast();
                    return this.makeLatestCatalog(p.getGribCollection(), (GribCollection.GroupHcs)groups.get(0), catURI, localState);
                }
                if (paths.length == 2 && paths[1].equals("files")) {
                    TimePartition.Partition p = localState.timePartition.getPartitionByName(paths[0]);
                    return this.makeLatestCatalog(p.getGribCollection(), (GribCollection.GroupHcs)groups.get(0), catURI, localState);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error making catalog for " + this.path, e);
        }
        return null;
    }

    private InvCatalogImpl makeLatestCatalog(GribCollection gc, GribCollection.GroupHcs group, URI catURI, InvDatasetFeatureCollection.State localState) throws IOException {
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl result = new InvCatalogImpl(this.getFullName(), parent.getVersion(), catURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(this.getLatestFileName());
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        result.addDataset(top);
        result.addService(this.orgService);
        top.getLocalMetadataInheritable().setServiceName(this.orgService.getName());
        boolean isSingleGroup = gc.getGroups().size() == 1;
        List<String> filenames = isSingleGroup ? gc.getFilenames() : group.getFilenames();
        String f = filenames.get(filenames.size() - 1);
        if (!f.startsWith(this.topDirectory)) {
            logger.warn("File {} doesnt start with topDir {}", (Object)f, (Object)this.topDirectory);
        }
        String fname = f.substring(this.topDirectory.length() + 1);
        String path = "files/" + fname;
        top.setUrlPath(this.path + "/" + path);
        top.setID(this.path + "/" + path);
        top.tmi.addVariableMapLink(this.makeMetadataLink(this.path + "/" + path, "?metadata=variableMap"));
        File file = new File(f);
        top.tm.setDataSize(file.length());
        result.finish();
        return result;
    }

    private ThreddsMetadata.GeospatialCoverage extractGeospatial(List<GribCollection.GroupHcs> groups) {
        ThreddsMetadata.GeospatialCoverage gcAll = null;
        for (GribCollection.GroupHcs group : groups) {
            ThreddsMetadata.GeospatialCoverage gc = this.extractGeospatial(group);
            if (gcAll == null) {
                gcAll = gc;
                continue;
            }
            gcAll.extend(gc);
        }
        return gcAll;
    }

    private ThreddsMetadata.GeospatialCoverage extractGeospatial(GribCollection.GroupHcs group) {
        GdsHorizCoordSys gdsCoordSys = group.hcs;
        LatLonRect llbb = GridCoordSys.getLatLonBoundingBox(gdsCoordSys.proj, gdsCoordSys.getStartX(), gdsCoordSys.getStartY(), gdsCoordSys.getEndX(), gdsCoordSys.getEndY());
        ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
        if (llbb != null) {
            gc.setBoundingBox(llbb);
        }
        if (group.hcs.isLatLon()) {
            gc.setLonResolution(gdsCoordSys.dx);
            gc.setLatResolution(gdsCoordSys.dy);
        }
        return gc;
    }

    private CalendarDateRange extractCalendarDateRange(List<GribCollection.GroupHcs> groups) {
        CalendarDateRange gcAll = null;
        for (GribCollection.GroupHcs group : groups) {
            CalendarDateRange gc = this.extractCalendarDateRange(group);
            if (gcAll == null) {
                gcAll = gc;
                continue;
            }
            gcAll.extend(gc);
        }
        return gcAll;
    }

    private CalendarDateRange extractCalendarDateRange(GribCollection.GroupHcs group) {
        TimeCoord max = null;
        for (TimeCoord tc : group.timeCoords) {
            if (tc.isInterval() || max != null && max.getSize() >= tc.getSize()) continue;
            max = tc;
        }
        if (max == null) {
            for (TimeCoord tc : group.timeCoords) {
                if (!tc.isInterval() || max != null && max.getSize() >= tc.getSize()) continue;
                max = tc;
            }
        }
        return max == null ? null : max.getCalendarRange();
    }

    protected String getBestDatasetName() {
        return this.bestDatasetName;
    }

    @Override
    public GridDataset getGridDataset(String matchPath) throws IOException {
        StateGrib localState;
        GridDataset result = super.getGridDataset(matchPath);
        if (result != null) {
            return result;
        }
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", e);
            return null;
        }
        DatasetParse dp = this.parse(matchPath, localState);
        if (dp == null) {
            return null;
        }
        if (localState.timePartition == null) {
            return localState.gribCollection.getGridDataset(dp.group, dp.filename, this.gribConfig);
        }
        if (dp.partition != null) {
            return dp.partition.getGribCollection().getGridDataset(dp.group, dp.filename, this.gribConfig);
        }
        return localState.timePartition.getGridDataset(dp.group, dp.filename, this.gribConfig);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(String matchPath) throws IOException {
        StateGrib localState;
        NetcdfDataset result = super.getNetcdfDataset(matchPath);
        if (result != null) {
            return result;
        }
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", e);
            return null;
        }
        DatasetParse dp = this.parse(matchPath, localState);
        if (dp == null) {
            return null;
        }
        if (localState.timePartition == null) {
            return localState.gribCollection.getNetcdfDataset(dp.group, dp.filename, this.gribConfig);
        }
        if (dp.partition != null) {
            return dp.partition.getGribCollection().getNetcdfDataset(dp.group, dp.filename, this.gribConfig);
        }
        return localState.timePartition.getNetcdfDataset(dp.group, dp.filename, this.gribConfig);
    }

    private DatasetParse parse(String matchPath, StateGrib localState) {
        TimePartition.Partition tpp;
        boolean isBest;
        boolean isSingleGroup;
        if (matchPath == null || matchPath.length() == 0) {
            return null;
        }
        String[] paths = matchPath.split("/");
        if (paths.length < 1) {
            return null;
        }
        if (paths.length == 2 && paths[0].equals("files")) {
            return new DatasetParse(paths[1]);
        }
        if (localState.timePartition == null) {
            boolean isBest2 = paths[0].equals(BEST_DATASET) || paths[0].equals(COLLECTION);
            String groupName = isBest2 ? localState.gribCollection.getGroup(0).getId() : paths[0];
            return new DatasetParse(null, groupName);
        }
        List<GribCollection.GroupHcs> groups = localState.timePartition.getGroups();
        boolean bl = isSingleGroup = groups.size() == 1;
        if (paths.length == 1) {
            boolean bl2 = isBest = paths[0].equals(BEST_DATASET) || paths[0].equals(COLLECTION);
            if (isBest) {
                String groupName = localState.timePartition.getGroup(0).getId();
                return new DatasetParse(null, groupName);
            }
        }
        if (paths.length == 2) {
            boolean bl3 = isBest = paths[1].equals(BEST_DATASET) || paths[1].equals(COLLECTION);
            if (isSingleGroup) {
                tpp = localState.timePartition.getPartitionByName(paths[0]);
                if (tpp != null) {
                    return new DatasetParse(tpp, localState.timePartition.getGroup(0).getId());
                }
            } else {
                return new DatasetParse(null, paths[0]);
            }
        }
        if (paths.length == 3) {
            isBest = paths[2].equals(BEST_DATASET) || paths[2].equals(COLLECTION);
            tpp = localState.timePartition.getPartitionByName(paths[0]);
            String groupName = paths[1];
            return new DatasetParse(tpp, groupName);
        }
        return null;
    }

    private ThreddsMetadata.Variables extractThreddsVariables(GribCollection gribCollection, GribCollection.GroupHcs group) {
        ThreddsMetadata.Variables vars = new ThreddsMetadata.Variables(this.format.toString());
        for (GribCollection.VariableIndex vindex : group.varIndex) {
            vars.addVariable(this.extractThreddsVariables(gribCollection, vindex));
        }
        vars.sort();
        return vars;
    }

    public ThreddsMetadata.Variable extractThreddsVariables(GribCollection gc, GribCollection.VariableIndex vindex) {
        String paramCategory;
        ThreddsMetadata.Variable tv;
        if (this.map == null) {
            this.map = new HashMap<Integer, ThreddsMetadata.Variable>(100);
        }
        if ((tv = this.map.get(vindex.cdmHash)) != null) {
            return tv;
        }
        tv = new ThreddsMetadata.Variable();
        if (gc.isGrib1()) {
            if (this.cust1 == null) {
                this.cust1 = Grib1Customizer.factory(gc.getCenter(), gc.getSubcenter(), gc.getLocal(), null);
            }
            tv.setName(this.cust1.makeVariableName(gc, vindex));
            tv.setDescription(Grib1Iosp.makeVariableLongName(this.cust1, gc, vindex));
            tv.setUnits(Grib1Iosp.makeVariableUnits(this.cust1, gc, vindex));
            tv.setVocabularyId("1-" + vindex.discipline + "-" + vindex.category + "-" + vindex.parameter);
            this.map.put(vindex.cdmHash, tv);
            return tv;
        }
        if (this.cust2 == null) {
            this.cust2 = Grib2Customizer.factory(gc.getCenter(), gc.getSubcenter(), gc.getMaster(), gc.getLocal());
        }
        tv.setName(Grib2Iosp.makeVariableName(this.cust2, gc, vindex));
        tv.setDescription(Grib2Iosp.makeVariableLongName(this.cust2, vindex));
        tv.setUnits(Grib2Iosp.makeVariableUnits(this.cust2, vindex));
        tv.setVocabularyId("2-" + vindex.discipline + "-" + vindex.category + "-" + vindex.parameter);
        String paramDisc = this.cust2.getTableValue("0.0", vindex.discipline);
        if (paramDisc == null) {
            paramDisc = "Unknown";
        }
        if ((paramCategory = this.cust2.getCategory(vindex.discipline, vindex.category)) == null) {
            paramCategory = "Unknown";
        }
        String paramName = this.cust2.getVariableName(vindex.discipline, vindex.category, vindex.parameter);
        tv.setVocabularyName(paramDisc + " / " + paramCategory + " / " + paramName);
        this.map.put(vindex.cdmHash, tv);
        return tv;
    }

    private class DatasetParse {
        TimePartition.Partition partition;
        String group;
        String filename;

        private DatasetParse(TimePartition.Partition tpp, String group) {
            this.partition = tpp;
            this.group = group;
        }

        private DatasetParse(String filename) {
            this.filename = filename;
        }
    }

    protected class StateGrib
    extends InvDatasetFeatureCollection.State {
        TimePartition timePartition;
        GribCollection gribCollection;
        InvDatasetImpl top;

        protected StateGrib(StateGrib from) {
            super(InvDatasetFcGrib.this, from);
            if (from != null) {
                this.timePartition = from.timePartition;
                this.gribCollection = from.gribCollection;
                this.top = from.top;
            }
        }
    }
}

