!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  SPCPACK/ISPACK-F90 ƥȥץ
!      ݥݥƥ󥷥ζ
!
!  2002/02/13  ݹ
!
program yttest7

  use spcpack

  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)
  real(8),parameter  :: ri=0.5, ro=1.5      ! ⳰Ⱦ

  real(8), dimension(im,jm,0:km)     :: ggg_poloidal
  real(8), dimension(im,jm,0:km)     :: ggg_laplapol
  real(8), dimension(im,jm,0:km)     :: ggg_laplapol1

  real(8), parameter  :: pi=3.1415926535897932385D0
  real(8), parameter  :: eps=1D-10

  integer :: k, l, i, j

  write( 6,* ) 'Test for yg_laplapol2pol_yg'
  write( 6,* ) 'Output is displayed if computational error is larger than',eps

  call yt_initial(im,jm,km,nm,lm,ri,ro)

  ! P_10
  ggg_laplapol = sin(ggg_lat) * sin( pi*(ggg_rad-ri)/(ro-ri) )
  ! P_1_1
  !ggg_laplapol = cos(ggg_lat)*cos(ggg_lon)* sin( pi*(ggg_rad-ri)/(ro-ri) )
  !ggg_laplapol = 2*sin(ggg_lat)**2 * sin( pi*(ggg_rad-ri)/(ro-ri) )

  ggg_poloidal = ggg_yg(yg_laplapol2pol_yg(yg_ggg(ggg_laplapol),'FF'))

  ggg_laplapol1 = ggg_yt(yt_lapla_yt(yt_ggg(ggg_poloidal)))

  call gropn(1)
  call grfrm
  call grsvpt( 0.2, 0.8, 0.2, 0.8 )
  call grswnd( -90.0, 90.0, real(ri), real(ro) )
  call grstrf
  call uwsgxa(real(g_lat/pi*180),jm)
  call uwsgya(real(g_rad),km+1)
  call usdaxs
  call udcntr(real(ggg_laplapol(1,:,:)),jm,jm,km+1)

  call grfrm
  call grsvpt( 0.2, 0.8, 0.2, 0.8 )
  call grswnd( -90.0, 90.0, real(ri), real(ro) )
  call grstrf
  call uwsgxa(real(g_lat/pi*180),jm)
  call uwsgya(real(g_rad),km+1)
  call usdaxs
  call udcntr(real(ggg_poloidal(1,:,:)),jm,jm,km+1)

  call grfrm
  call grsvpt( 0.2, 0.8, 0.2, 0.8 )
  call grswnd( -90.0, 90.0, real(ri), real(ro) )
  call grstrf
  call uwsgxa(real(g_lat/pi*180),jm)
  call uwsgya(real(g_rad),km+1)
  call usdaxs
  call udcntr(real(ggg_laplapol1(1,:,:)),jm,jm,km+1)

  call grcls

end program yttest7
