!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  yt_module
!
!  2002/02/02  ݹ 
!      2002/03/30  ݹ  ⥸塼̾ѹ
!
module yt_module

  use lumatrix
  use ya_module
  use at_module, g_rad => g_x, t_dr_t => t_dx_t, at_dr_at => at_dx_at, &
                 g_rad_weight => g_x_weight
  implicit none
  private

  public yt_initial

  public g_lon, g_lat, g_lon_weight, g_lat_weight
  public l_nm, nm_l
  public gg_lon, gg_lat, g_rad, g_rad_weight
  public ggg_lon, ggg_lat, ggg_rad
  public yg_rad

  public y_gg, gg_y
  public at_dr_at, t_dr_t, ag_at, at_ag

  public ggg_yt, yt_ggg, ggg_yg, yg_ggg, yg_yt, yt_yg
  public yt_drad_yt, yt_divrad_yt, yt_rotrad_yt, yt_lapla_yt
  public ggg_gradlon_yt, ggg_gradlat_yt
  public yt_divlon_ggg, yt_divlat_ggg, yt_div_ggg_ggg_ggg
  public yt_kxrgrad_yt, ggg_kgrad_yt, yt_l2_yt, yt_l2inv_yt, yt_qoperator_yt
  public yt_radrot_ggg_ggg, yt_radrotrot_ggg_ggg_ggg
  public yt_potential2vector
  public yt_vgradv
  public ytboundaries, yt_torboundaries, yg_laplapol2pol_yg


  integer            :: im=64, jm=32, km=16  ! ʻ(, , ư)
  integer            :: nm=21, lm=16         ! ȿ(ʿ, ư)
  real(8)            :: ri=0.0, ro=1.0       ! ⳰Ⱦ
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), dimension(:,:,:), allocatable :: ggg_lon, ggg_lat, ggg_rad
  real(8), dimension(:,:), allocatable   :: yg_rad

  save im, jm, km, nm, lm, ri, ro

  contains
  !---------------  -----------------
    subroutine yt_initial(i,j,k,n,l,r_in,r_out)

     integer,intent(in) :: i, j, k        ! ʻ(, , ư)
     integer,intent(in) :: n, l           ! ȿ(ʿ, ư)

     real(8),intent(in) :: r_in, r_out    ! ⳰Ⱦ

     im = i  ; jm = j ; km = k
     nm = n  ; lm = l
     ri = r_in ; ro = r_out

     call ya_initial(nm,im,jm,km+1)
     call at_initial(km,lm,r_in,r_out)

     allocate(ggg_lon(im,jm,0:km))
     allocate(ggg_lat(im,jm,0:km))
     allocate(ggg_rad(im,jm,0:km))
     allocate(yg_rad((nm+1)*(nm+1),0:km))

     ggg_lon = spread(gg_lon,3,km+1)
     ggg_lat = spread(gg_lat,3,km+1)
     ggg_rad = spread(spread(g_rad,1,jm),1,im)

     yg_rad = spread(g_rad,1,(nm+1)*(nm+1))

   end subroutine yt_initial

  !--------------- Ѵ -----------------

    function ggg_yt(yt)  ! ڥȥ -> ʻ
      real(8), dimension(im,jm,0:km)                     :: ggg_yt
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: yt

      ggg_yt = gga_ya(ag_at(yt))

    end function ggg_yt

    function yt_ggg(ggg)  ! ʻ -> ڥȥ
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: yt_ggg
      real(8), dimension(im,jm,0:km), intent(in)         :: ggg

      yt_ggg = at_ag(ya_gga(ggg))

    end function yt_ggg

    function ggg_yg(yg)  ! ʿڥȥ -> ʻ
      real(8), dimension(im,jm,0:km)                     :: ggg_yg
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: yg

      ggg_yg = gga_ya(yg)

    end function ggg_yg

    function yg_ggg(ggg)  ! ʻ -> ʿڥȥ
      real(8), dimension((nm+1)*(nm+1),0:km)             :: yg_ggg
      real(8), dimension(im,jm,0:km), intent(in)         :: ggg

      yg_ggg = ya_gga(ggg)

    end function yg_ggg

    function yg_yt(yt)  ! ڥȥ -> ʿڥȥ
      real(8), dimension((nm+1)*(nm+1),0:km)             :: yg_yt
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: yt

      yg_yt = ag_at(yt)

    end function yg_yt

    function yt_yg(yg)  ! ʿڥȥ -> ڥȥ
      real(8), dimension((nm+1)*(nm+1),0:km)             :: yt_yg
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: yg

      yt_yg = at_ag(yg)

    end function yt_yg

  !--------------- ʬ׻ -----------------
    function yt_drad_yt(yt)     ! ưʬ
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: yt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: yt_drad_yt

      yt_drad_yt = at_dr_at(yt)

    end function yt_drad_yt

    function yt_divrad_yt(yt)    ! ưȯʬ 
                                 ! 1/r^2 /r r^2 = /r + 2/r 
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: yt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: yt_divrad_yt

      yt_divrad_yt = yt_drad_yt(yt) + yt_yg(2/yg_rad*yg_yt(yt))

    end function yt_divrad_yt

    function yt_rotrad_yt(yt)    ! ưȯʬ 
                                 ! 1/r /r r = /r + 1/r 
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: yt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: yt_rotrad_yt

      yt_rotrad_yt = yt_drad_yt(yt) + yt_yg(1/yg_rad*yg_yt(yt))

    end function yt_rotrad_yt

    function yt_lapla_yt(yt)     ! ץ饷
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: yt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: yt_lapla_yt

      yt_lapla_yt = yt_divrad_yt(yt_drad_yt(yt)) &
                   + yt_yg(yg_yt(ya_lapla_ya(yt))/yg_rad**2)

    end function yt_lapla_yt

    function ggg_gradlon_yt(yt) ! ڥȥ˺Ѥ۷ʬ
                                ! 1/rcosա/ߦ
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: yt
      real(8), dimension(im,jm,0:km)                     :: ggg_gradlon_yt

      ggg_gradlon_yt = gga_gradlon_ya(yg_yt(yt))/ggg_rad

    end function ggg_gradlon_yt

    function ggg_gradlat_yt(yt) ! ڥȥ˺Ѥ۷ʬ
                                ! 1/r /ߦ
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: yt
      real(8), dimension(im,jm,0:km)                     :: ggg_gradlat_yt

      ggg_gradlat_yt = gga_gradlat_ya(yg_yt(yt))/ggg_rad
    end function ggg_gradlat_yt

    function yt_divlon_ggg(ggg)   ! ʻҤ˺Ѥȯʬ 
                                  ! 1/rcosա/ߦ

      real(8), dimension(im,jm,0:km), intent(in)   :: ggg
      real(8), dimension((nm+1)*(nm+1),0:lm)       :: yt_divlon_ggg

      yt_divlon_ggg = yt_yg(ya_divlon_gga(ggg/ggg_rad))
    end function yt_divlon_ggg

    function yt_divlat_ggg(ggg)   ! ʻҤ˺Ѥȯʬ
                                  ! 1/rcosա(f cos)/ߦ

      real(8), dimension(im,jm,0:km), intent(in)   :: ggg
      real(8), dimension((nm+1)*(nm+1),0:lm)       :: yt_divlat_ggg

      yt_divlat_ggg = yt_yg(ya_divlat_gga(ggg/ggg_rad))
    end function yt_divlat_ggg

    function yt_div_ggg_ggg_ggg(ggg_vlon,ggg_vlat,ggg_vrad) ! ȯ

      real(8), dimension(im,jm,0:km), intent(in) :: ggg_vlon(:,:,:) ! ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: ggg_vlat(:,:,:) ! ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: ggg_vrad(:,:,:) ! ưʬ
      real(8), dimension((nm+1)*(nm+1),0:lm)     :: yt_div_ggg_ggg_ggg

      yt_div_ggg_ggg_ggg =   yt_divlon_ggg(ggg_vlon) &
                           + yt_divlat_ggg(ggg_vlat) &
                           + yt_divrad_yt(yt_ggg(ggg_vrad))

    end function yt_div_ggg_ggg_ggg


  !--------------- ݥ/ȥǥʬ -----------------

    function yt_kxrgrad_yt(yt)    ! kr = /ߦ
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: yt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: yt_kxrgrad_yt

      yt_kxrgrad_yt =  ya_dlon_ya(yt)
    end function yt_kxrgrad_yt

    function ggg_kgrad_yt(yt)    ! k = cos/r /ߦ + sinբ/r
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: yt
      real(8), dimension(im,jm,0:km)                     :: ggg_kgrad_yt

      ggg_kgrad_yt =  cos(ggg_lat)*ggg_gradlat_yt(yt) &
                    + sin(ggg_lat)*ggg_yt(yt_drad_yt(yt))
    end function ggg_kgrad_yt

    function yt_l2_yt(yt)    ! L2  = -ʿץ饷 
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: yt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: yt_l2_yt

      yt_l2_yt = -ya_lapla_ya(yt)
    end function yt_l2_yt

    function yt_l2inv_yt(yt)    ! L2 Ǥε = -տʿץ饷 
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: yt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: yt_l2inv_yt

      yt_l2inv_yt = -ya_laplainv_ya(yt)
    end function yt_l2inv_yt

    function yt_qoperator_yt(yt)    ! Q=(k-1/2(L2 k+ kL2))
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: yt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: yt_qoperator_yt

      yt_qoperator_yt = &
             yt_ggg(ggg_kgrad_yt(yt) - ggg_kgrad_yt(yt_l2_yt(yt))/2) &
           - yt_l2_yt(yt_ggg(ggg_kgrad_yt(yt)))/2

    end function yt_qoperator_yt

    function yt_radrot_ggg_ggg(ggg_vlon,ggg_vlat)  ! r(v)
      real(8), dimension(im,jm,0:km), intent(in) :: ggg_vlon
      real(8), dimension(im,jm,0:km), intent(in) :: ggg_vlat
      real(8), dimension((nm+1)*(nm+1),0:lm)     :: yt_radrot_ggg_ggg

      yt_radrot_ggg_ggg = yt_yg(ya_divlon_gga(ggg_vlat) &
                                - ya_divlat_gga(ggg_vlon))
      
    end function yt_radrot_ggg_ggg

    function yt_radrotrot_ggg_ggg_ggg(ggg_vlon,ggg_vlat,ggg_vrad) 
                                                  ! r(ߢv)
      real(8), dimension(im,jm,0:km), intent(in) :: ggg_vlon
      real(8), dimension(im,jm,0:km), intent(in) :: ggg_vlat
      real(8), dimension(im,jm,0:km), intent(in) :: ggg_vrad
      real(8), dimension((nm+1)*(nm+1),0:lm)     :: yt_radrotrot_ggg_ggg_ggg

      yt_radrotrot_ggg_ggg_ggg = &
               yt_rotrad_yt(yt_yg( &
                   (ya_divlon_gga(ggg_vlon)+ ya_divlat_gga(ggg_vlat)))) &
             + yt_l2_yt(yt_ggg(ggg_vrad/ggg_rad))

    end function yt_radrotrot_ggg_ggg_ggg

    subroutine yt_potential2vector(&
         ggg_vlon,ggg_vlat,ggg_vrad,yt_torpot,yt_polpot)

      real(8), dimension(im,jm,0:km)     :: ggg_vlon   ! ٥ȥ(ʬ)
      real(8), dimension(im,jm,0:km)     :: ggg_vlat   ! ٥ȥ(ʬ)
      real(8), dimension(im,jm,0:km)     :: ggg_vrad   ! ٥ȥ(ưʬ)
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) &
                                         :: yt_torpot ! ȥݥƥ󥷥
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) &
                                         :: yt_polpot ! ݥݥƥ󥷥

      ggg_vlon =   ggg_rad*ggg_gradlat_yt(yt_torpot) &
                 + gga_gradlon_ya(yg_yt(yt_rotrad_yt(yt_polpot)))
      ggg_vlat = - ggg_rad * ggg_gradlon_yt(yt_torpot) &
                 + gga_gradlat_ya(yg_yt(yt_rotrad_yt(yt_polpot)))
      ggg_vrad = ggg_yt(yt_l2_yt(yt_polpot))/ggg_rad

    end subroutine yt_potential2vector

 !------------------- ׻ ----------------------
  subroutine yt_vgradv(ggg_vgradv_lon,ggg_vgradv_lat,ggg_vgradv_rad, &
                       ggg_vlon,ggg_vlat,ggg_vrad )

    real(8), dimension(im,jm,0:km),intent(out)   :: ggg_vgradv_lon
    real(8), dimension(im,jm,0:km),intent(out)   :: ggg_vgradv_lat
    real(8), dimension(im,jm,0:km),intent(out)   :: ggg_vgradv_rad
    real(8), dimension(im,jm,0:km),intent(in)    :: ggg_vlon
    real(8), dimension(im,jm,0:km),intent(in)    :: ggg_vlat
    real(8), dimension(im,jm,0:km),intent(in)    :: ggg_vrad

    ggg_vgradv_lon = ggg_yt(    &
            yt_div_ggg_ggg_ggg( &
                ggg_vlon*ggg_vlon, ggg_vlon*ggg_vlat, ggg_vlon*ggg_vrad )) &
          + ggg_vlon*ggg_vrad/ggg_rad              &
          - ggg_vlon*ggg_vlat*tan(ggg_lat)/ggg_rad 

    ggg_vgradv_lat = ggg_yt(    &
            yt_div_ggg_ggg_ggg( &
                ggg_vlat*ggg_vlon, ggg_vlat*ggg_vlat, ggg_vlat*ggg_vrad )) &
          + ggg_vlat*ggg_vrad/ggg_rad        &
          + ggg_vlon**2*tan(ggg_lat)/ggg_rad 


    ggg_vgradv_rad = ggg_yt(    &
            yt_div_ggg_ggg_ggg( &
                ggg_vrad*ggg_vlon, ggg_vrad*ggg_vlat, ggg_vrad*ggg_vrad )) &
          - (ggg_vlon**2 + ggg_vlat**2)/ggg_rad 

  end subroutine yt_vgradv

  !---------------  -----------------

    subroutine ytboundaries(yt,values,cond)   ! ǥꥯ, Υޥ
      ! Chebyshev ֤ǤζŬ

      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)      :: yt
              ! ŬѤǡ. 줿֤ͤ. 

      real(8), dimension((nm+1)*(nm+1),2), intent(in), optional :: values
              ! Ǥ / ʬۤʿڥȥѴΤͿ. 
              ! ά/ 0 Ȥʤ. 

      character(len=2), intent(in), optional             :: cond
              ! . ά 'DD'
              !   DD : ξüǥꥯ
              !   DN,ND : ǥꥯ/Υޥ
              !   NN : ξüΥޥ

      if (.not. present(cond)) then
         if (present(values)) then
            call at_boundaries_DD(yt,values)
         else
            call at_boundaries_DD(yt)
         endif
         return
      endif

      select case(cond)
      case ('NN')
         if (present(values)) then
            call at_boundaries_NN(yt,values)
         else
            call at_boundaries_NN(yt)
         endif
      case ('DN')
         if (present(values)) then
            call at_boundaries_DN(yt,values)
         else
            call at_boundaries_DN(yt)
         endif
      case ('ND')
         if (present(values)) then
            call at_boundaries_ND(yt,values)
         else
            call at_boundaries_ND(yt)
         endif
      case ('DD')
         if (present(values)) then
            call at_boundaries_DD(yt,values)
         else
            call at_boundaries_DD(yt)
         endif
      case default
         call msgdmp('E','ytboundaries','B.C. not supported')
      end select

    end subroutine ytboundaries

    subroutine yt_torboundaries(yt_torpot,cond) ! ȥݥƥ󥷥붭
      ! Chebyshev ֤ǤζŬ
      !  ȥݥƥ󥷥 \psi ζŬ
      ! Ǵ
      !    \psi = 0  at boundaries
      ! Ϥʤ
      !    \DP{\psi/r}{r} = 0  at boundaries

      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)      :: yt_torpot
              ! ŬѤǡ. 줿֤ͤ. 

      character(len=2), intent(in), optional  :: cond
              ! 凉å. ά 'RR'
              !   RR : ξüǴ
              !   RF,FR : Ǵ/Ϥʤ
              !   FF : ξüϤʤ

      real(8), dimension(:,:), allocatable  :: alu
      integer, dimension(:), allocatable    :: kp
      real(8), dimension(0:lm,0:lm)         :: tt_data
      real(8), dimension(0:lm,0:km)         :: tg_data
      logical                               :: rigid1, rigid2   ! 

      logical :: first = .true.
      integer  :: l
      save     :: alu, kp, first

      if (.not. present(cond)) then
         rigid1=.TRUE. ; rigid2=.TRUE.
      else
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call msgdmp('E','yt_laplapol2pol_yt','B.C. not supported')
         end select
      endif

      if ( first ) then
         first = .false.

         allocate(alu(0:lm,0:lm),kp(0:lm))

         tt_data = 0
         do l=0,lm
            tt_data(l,l)=1
         enddo
         alu = tt_data

         ! ϳŪǴ 
         if ( rigid1 ) then
            tg_data = ag_at(tt_data)
         else
            tg_data = ag_at(at_dr_at(at_ag( &
                 ag_at(tt_data)/spread(g_rad,1,lm+1))))
         endif
         alu(lm-1,:) = tg_data(:,0)

         if ( rigid2 ) then
            tg_data = ag_at(tt_data)    
         else
            tg_data = ag_at(at_dr_at(at_ag( &
                 ag_at(tt_data)/spread(g_rad,1,lm+1))))
         endif
         alu(lm,:)   = tg_data(:,km)

         call ludecomp(alu,kp)
      endif

      yt_torpot(:,lm-1) = 0
      yt_torpot(:,lm)   = 0
      yt_torpot = lusolve(alu,kp,yt_torpot)

    end subroutine yt_torboundaries

    function yg_laplapol2pol_yg(yg,cond)        ! ^2 ݥ
                                                ! ǥեȤǴ
      ! Chebyshev-Collocation ˡˤ׻
      !  f=\nabla^2\phi Ϳƥݥݥƥ󥷥 \phi .
      !    \nabla^2 \phi = f
      !    \phi = const. at boundaries.
      ! Ǵ
      !    \DP{\phi}{r} = 0 at boundaries
      ! Ϥʤ
      !    \DP[2]{\phi}{r} = 0 at boundaries

      !  : ǽ˸ƤФȤζǰʸ׻(׻ѹ)

      real(8), dimension((nm+1)*(nm+1),0:km),intent(in)  :: yg
              ! Ϣ^2ʬ

      real(8), dimension((nm+1)*(nm+1),0:km)             :: yg_laplapol2pol_yg
              ! ϥݥݥƥ󥷥ʬ

      character(len=2), intent(in), optional  :: cond
              ! 凉å. ά 'RR'
              !   RR : ξüǴ
              !   RF,FR : Ǵ/Ϥʤ
              !   FF : ξüϤʤ

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((nm+1)*(nm+1),0:km)  :: yg_work
      real(8), dimension(0:km,0:km)           :: gg
      real(8), dimension(0:km,0:km)           :: gg_work
      logical                                 :: rigid1, rigid2   ! 

      logical :: first = .true.
      integer :: k,n
      save    :: alu, kp, first

      if (.not. present(cond)) then
         rigid1=.TRUE. ; rigid2=.TRUE.
      else
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call msgdmp('E','yt_laplapol2pol_yt','B.C. not supported')
         end select
      endif

      if ( first ) then
         first = .false.

         allocate(alu((nm+1)*(nm+1),0:km,0:km),kp((nm+1)*(nm+1),0:km))

         do k=0,km
            yg_work = 0 ; yg_work(:,k) = 1

            ! ƿʿȿ˴ؤΩμ
            alu(:,:,k) = yg_yt(yt_lapla_yt(yt_yg(yg_work)))
         enddo

         ! ưŪ. ή϶ǰ
         gg = 0
         do k=0,km
            gg(k,k)=1
         enddo
         do n=1,(nm+1)*(nm+1)
            alu(n,0,:)   = gg(:,0)
            alu(n,km,:)  = gg(:,km)
         enddo

         ! ϳŪǴ 
         if ( rigid1 ) then
            gg_work=ag_at(at_dr_at(at_ag(gg)))
         else
            gg_work=ag_at(at_dr_at(at_dr_at(at_ag(gg))))
         endif
         do n=1,(nm+1)*(nm+1)
            alu(n,1,:) = gg_work(:,0)
         enddo

         ! ϳŪǴ 
         if ( rigid2 ) then
            gg_work=ag_at(at_dr_at(at_ag(gg)))
         else
            gg_work=ag_at(at_dr_at(at_dr_at(at_ag(gg))))
         endif
         do n=1,(nm+1)*(nm+1)
            alu(n,km-1,:) = gg_work(:,km)
         enddo

         call ludecomp(alu,kp)
      endif

      yg_work         = yg
      yg_work(:,1)    = 0               ! ϳŪ
      yg_work(:,km-1) = 0               ! ϳŪ
      yg_work(:,0)    = 0               ! ưŪ
      yg_work(:,km)   = 0               ! ưŪ 

      yg_laplapol2pol_yg = lusolve(alu,kp,yg_work)

    end function yg_laplapol2pol_yg


  end module yt_module
