!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  et_module
!      2 ϩΰ, Fourier Ÿ + Chebyshev Ÿˡ
!
!  2002/01/27  ݹ
!      2002/03/30  ݹ  ⥸塼̾ѹ
!
module et_module

  use lumatrix
  use ae_module
  use at_module, g_y => g_x, g_y_weight => g_x_weight, &
                 t_dy_t => t_dx_t, at_dy_at => at_dx_at

  implicit none
  private
  public et_initial
  public gg_x, gg_y
  public gg_et, et_gg
  public et_dx_et, et_dy_et, et_lapla_et, et_jacobian_et_et
  public etboundaries
  public et_laplainv_et, eg_vor2strm_eg
  !public et_vor2strm_et, et_vor2strm1_et

  public g_x, g_y
  public e_g, g_e, e_dx_e
  public ae_ag, ag_ae, ae_dx_ae
  public t_g, g_t, t_dy_t
  public at_ag, ag_at, at_dy_at
  public at_boundaries_DD, at_boundaries_DN, at_boundaries_ND, at_boundaries_NN

  integer            :: im=32, jm=8      ! ʻ(X,Y)
  integer            :: km=10, lm=5      ! ȿ(X,Y)
  real(8)            :: xl=2.0, yl=1.0   ! ΰ礭
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), dimension(:,:), allocatable :: gg_x, gg_y

  save im, jm, km, lm, xl, yl

  contains
  !---------------  -----------------
    subroutine et_initial(i,j,k,l,xmin,xmax,ymin,ymax)

      integer,intent(in) :: i, j           ! ʻ(X,Y)
      integer,intent(in) :: k, l           ! ȿ(X,Y)

      real(8),intent(in) :: xmin, xmax     ! X ɸϰ
      real(8),intent(in) :: ymin, ymax     ! Y ɸϰ

      im = i       ; jm = j
      km = k       ; lm = l
      xl = xmax-xmin ; yl = ymax-ymin

      call ae_initial(im,km,xmax-xmin)
      call at_initial(jm,lm,ymin,ymax)

      allocate(gg_x(0:jm,0:im-1),gg_y(0:jm,0:im-1))
      g_x = g_x + xmin
      gg_x = spread(g_x,1,jm+1)
      gg_y = spread(g_y,2,im)

    end subroutine et_initial

  !--------------- Ѵ -----------------

    function gg_et(et)  ! ڥȥ -> ʻ
      real(8), dimension(0:jm,0:im-1)              :: gg_et
      real(8), dimension(-km:km,0:lm), intent(in)  :: et

      gg_et = ag_ae(transpose(ag_at(et)))

    end function gg_et

    function et_gg(gg)  ! ʻ -> ڥȥ
      real(8), dimension(-km:km,0:lm)              :: et_gg
      real(8), dimension(0:jm,0:im-1), intent(in)  :: gg

      et_gg = at_ag(transpose(ae_ag(gg)))

    end function et_gg

  !--------------- ʬ׻ -----------------

    function et_dx_et(et)   ! ڥȥ˺Ѥ x ʬ黻
      real(8), dimension(-km:km,0:lm)                :: et_dx_et
      real(8), dimension(-km:km,0:lm), intent(in)    :: et
      integer k

      do k=-km,km
         et_dx_et(k,:)  =  (-2*pi*k/xl)*et(-k,:)
      enddo
    end function et_dx_et

    function et_dy_et(et)   ! ڥȥ˺Ѥ y ʬ黻
      real(8), dimension(-km:km,0:lm)               :: et_dy_et
      real(8), dimension(-km:km,0:lm), intent(in)   :: et

      et_dy_et = at_dy_at(et)

    end function et_dy_et

    function et_lapla_et(et)   ! ڥȥ˺Ѥ Laplacian 黻
      real(8), dimension(-km:km,0:lm)                :: et_lapla_et
      real(8), dimension(-km:km,0:lm), intent(in)    :: et
      integer k

      do k=-km,km
         et_lapla_et(k,:) = -(2*pi*k/xl)**2*et(k,:)
      enddo

      et_lapla_et = et_lapla_et + et_dy_et(et_dy_et(et))

    end function et_lapla_et

    function et_jacobian_et_et(et_a,et_b) ! ڥȥ˺Ѥ Jacobian
      real(8), dimension(-km:km,0:lm)                :: et_jacobian_et_et
      real(8), dimension(-km:km,0:lm), intent(in)    :: et_a
      real(8), dimension(-km:km,0:lm), intent(in)    :: et_b
      integer k

      et_jacobian_et_et = et_gg(&
           gg_et(et_dx_et(et_a)) * gg_et(et_dy_et(et_b)) &
           -gg_et(et_dy_et(et_a)) * gg_et(et_dx_et(et_b)) )

    end function et_jacobian_et_et


  !---------------  -----------------

    subroutine etboundaries(et,values,cond)   ! ǥꥯ, Υޥ
      ! Chebyshev ֤ǤζŬ

      real(8), dimension(-km:km,0:lm),intent(inout)      :: et
              ! ŬѤǡ. 줿֤ͤ. 

      real(8), dimension(-km:km,2), intent(in), optional :: values
              ! Ǥ / ʬۤʿڥȥѴΤͿ. 
              ! ά/ 0 Ȥʤ. 

      character(len=2), intent(in), optional             :: cond
              ! . ά 'DD'
              !   DD : ξüǥꥯ
              !   DN,ND : ǥꥯ/Υޥ
              !   NN : ξüΥޥ

      if (.not. present(cond)) then
         if (present(values)) then
            call at_boundaries_DD(et,values)
         else
            call at_boundaries_DD(et)
         endif
         return
      endif

      select case(cond)
      case ('NN')
         if (present(values)) then
            call at_boundaries_NN(et,values)
         else
            call at_boundaries_NN(et)
         endif
      case ('DN')
         if (present(values)) then
            call at_boundaries_DN(et,values)
         else
            call at_boundaries_DN(et)
         endif
      case ('ND')
         if (present(values)) then
            call at_boundaries_ND(et,values)
         else
            call at_boundaries_ND(et)
         endif
      case ('DD')
         if (present(values)) then
            call at_boundaries_DD(et,values)
         else
            call at_boundaries_DD(et)
         endif
      case default
         call msgdmp('E','etboundaries','B.C. not supported')
      end select

    end subroutine etboundaries

    function et_laplainv_et(et,values) !  Laplacian, Dirichlet 
      ! Chebyshev-tau ˡˤ׻

      real(8), dimension(-km:km,0:lm),intent(in)  :: et
      real(8), dimension(-km:km,0:lm)             :: et_laplainv_et
      real(8), dimension(-km:km,2), intent(in), optional :: values   ! 

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(-km:km,0:lm)         :: et_work
      real(8), dimension(0:lm,0:lm)           :: tt_work
      real(8), dimension(0:lm,0:jm)           :: tg_work
      real(8), dimension(-km:km)              :: value1, value2   ! 

      logical :: first = .true.
      integer :: k,l
      save    :: alu, kp, first

      if (.not. present(values)) then
         value1=0 ; value2=0
      else
         value1 = values(:,1) ; value2 = values(:,2)
      endif

      if ( first ) then
         first = .false.

         allocate(alu(-km:km,0:lm,0:lm),kp(-km:km,0:lm))

         tt_work=0
         do l=0,lm
            tt_work(l,l)=1
         enddo
         tg_work=ag_at(tt_work)

         do k=-km,km
            alu(k,:,:) = transpose(at_dy_at(at_dy_at(tt_work)) &
                                   - (2*pi*k/xl)**2*tt_work)
            alu(k,lm-1,:) = tg_work(:,0)
            alu(k,lm,:)   = tg_work(:,jm)
         enddo

         call ludecomp(alu,kp)
      endif

      et_work = et
      et_work(:,lm-1) = value1
      et_work(:,lm)   = value2
      et_laplainv_et = lusolve(alu,kp,et_work)

    end function et_laplainv_et

    function eg_vor2strm_eg(eg,values,cond)    ! ٤ή. 
                                               ! ǥեȤǴ
      ! Chebyshev-Collocation ˡˤ׻
      !  \zeta Ϳή \psi .
      !    \nabla^2 \psi = \zeta, 
      !    \psi = const. at boundaries.
      ! Ǵ
      !    \DP{\psi}{y} = 0 at boundaries
      ! Ϥʤ
      !    \DP[2]{\psi}{y} = 0 at boundaries

      !  : ǽ˸ƤФȤζǰʸ׻(׻ѹ)

      real(8), dimension(-km:km,0:jm),intent(in)  :: eg
              ! ϱʬ

      real(8), dimension(-km:km,0:jm)             :: eg_vor2strm_eg
              ! ήʬ

      real(8), dimension(2), intent(in), optional :: values
              ! ή. ǰʤΤȿ 0 ʬΤ

      character(len=2), intent(in), optional  :: cond
              ! 凉å. ά 'RR'
              !   RR : ξüǴ
              !   RF,FR : Ǵ/Ϥʤ
              !   FF : ξüϤʤ

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(-km:km,0:jm)         :: eg_work
      real(8), dimension(0:jm,0:jm)           :: gg
      real(8), dimension(0:jm,0:jm)           :: gg_work
      real(8)                                 :: value1, value2   ! 
      logical                                 :: rigid1, rigid2   ! 

      logical :: first = .true.
      integer :: k,j
      save    :: alu, kp, first

      if (.not. present(values)) then
         value1=0 ; value2=0
      else
         value1 = values(1) ; value2 = values(2)
      endif

      if (.not. present(cond)) then
         rigid1=.TRUE. ; rigid2=.TRUE.
      else
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call msgdmp('E','eg_vor2strm_eg','B.C. not supported')
         end select
      endif

      if ( first ) then
         first = .false.

         allocate(alu(-km:km,0:jm,0:jm),kp(-km:km,0:jm))

         gg=0
         do j=0,jm
            gg(j,j)=1
         enddo
         do k=-km,km
            alu(k,:,:) = transpose( &
                 ag_at(at_dy_at(at_dy_at(at_ag(gg)))) &
                 - (2*pi*k/xl)** 2* gg )
         enddo

         ! ưŪ. ή϶ǰ
         gg_work=gg
         do k=-km,km
            alu(k,0,:)   = gg_work(:,0)
            alu(k,jm,:)  = gg_work(:,jm)
         enddo

         ! ϳŪǴ 
         if ( rigid1 ) then
            gg_work=ag_at(at_dy_at(at_ag(gg)))
         else
            gg_work=ag_at(at_dy_at(at_dy_at(at_ag(gg))))
         endif
         do k=-km,km
            alu(k,1,:) = gg_work(:,0)
         enddo

         ! ϳŪǴ 
         if ( rigid2 ) then
            gg_work=ag_at(at_dy_at(at_ag(gg)))
         else
            gg_work=ag_at(at_dy_at(at_dy_at(at_ag(gg))))
         endif
         do k=-km,km
            alu(k,jm-1,:) = gg_work(:,jm)
         enddo

         call ludecomp(alu,kp)
      endif

      eg_work = eg
      eg_work(:,1)    = 0               ! ϳŪ
      eg_work(:,jm-1) = 0               ! ϳŪ

      eg_work(:,0) = 0            ! ưŪ. ȿ 0 ʳ 0 
      eg_work(0,0) = value1*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      eg_work(:,jm)   = 0            ! ưŪ. ȿ 0 ʳ 0 
      eg_work(0,jm)   = value2*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      eg_vor2strm_eg = lusolve(alu,kp,eg_work)

    end function eg_vor2strm_eg

   !-----   : ׻ޤ. pending ---- 
    function et_vor2strm_et(et,values,rigid) ! ٤ή. 
                                             ! ǥեȤǴ
      ! Chebyshev-tau ˡˤ׻
      !  \zeta Ϳή \psi .
      !    \nabla^2 \psi = \zeta, 
      !    \psi = const. at boundaries.
      ! Ǵ
      !    \DP{\psi}{y} = 0 at boundaries
      ! Ϥʤ
      !    \DP[2]{\psi}{y} = 0 at boundaries
      !
      ! l=0,1,lm-1,lm ʬμ˶Ϳ. 
      ! ٤㼡ʬ̵뤹뤳Ȥ
      ! \nabla^4 \psi = \zeta^2 򤤤Ƥ뤳Ȥ. 
      ! 4 ʬˤ뤳ȤǶοȤĤĤޤ. 

      real(8), dimension(-km:km,0:lm),intent(in)  :: et
      real(8), dimension(-km:km,0:lm)             :: et_vor2strm_et

      ! ή. ǰʤΤȿ 0 ʬΤ
      real(8), dimension(2), intent(in), optional :: values
      ! 凉å
      logical, dimension(2), intent(in), optional :: rigid

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(-km:km,0:lm)         :: et_work
      real(8), dimension(0:lm,0:lm)           :: tt_work
      real(8), dimension(0:lm,0:jm)           :: tg_work
      real(8)                                 :: value1, value2   ! 
      logical                                 :: rigid1, rigid2   ! 

      logical :: first = .true.
      integer :: k,l
      save    :: alu, kp, first

      if (.not. present(values)) then
         value1=0 ; value2=0
      else
         value1 = values(1) ; value2 = values(2)
      endif

      if (.not. present(rigid)) then
         rigid1=.true. ; rigid2=.true.
      else
         rigid1 = rigid(1) ; rigid2 = rigid(2)
      endif

      if ( first ) then
         first = .false.

         allocate(alu(-km:km,0:lm,0:lm),kp(-km:km,0:lm))

         tt_work=0
         do l=0,lm
            tt_work(l,l)=1
         enddo
         do k=-km,km
            alu(k,:,:) = transpose(at_dy_at(at_dy_at(tt_work)) &
                                   - (2*pi*k/xl)**2*tt_work)
         enddo

         ! ưŪ. ή϶ǰ
         tg_work=ag_at(tt_work)
         do k=-km,km
            alu(k,lm-1,:) = tg_work(:,0)
            alu(k,lm,:)   = tg_work(:,jm)
         enddo

         ! ϳŪǴ 
         if ( rigid1 ) then
            tg_work=ag_at(at_dy_at(tt_work))
         else
            tg_work=ag_at(at_dy_at(at_dy_at(tt_work)))
         endif
         do k=-km,km
            alu(k,0,:) = tg_work(:,0)
         enddo

         ! ϳŪǴ 
         if ( rigid2 ) then
            tg_work=ag_at(at_dy_at(tt_work))
         else
            tg_work=ag_at(at_dy_at(at_dy_at(tt_work)))
         endif
         do k=-km,km
            alu(k,1,:) = tg_work(:,jm)
         enddo

         call ludecomp(alu,kp)
      endif

      et_work = et
      et_work(:,0) = 0               ! ϳŪ
      et_work(:,1) = 0               ! ϳŪ

      et_work(:,lm-1) = 0            ! ưŪ. ȿ 0 ʳ 0 
      et_work(0,lm-1) = value1*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      et_work(:,lm)   = 0            ! ưŪ. ȿ 0 ʳ 0 
      et_work(0,lm)   = value2*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      et_vor2strm_et = lusolve(alu,kp,et_work)

    end function et_vor2strm_et

   !-----   : ׻ޤ. pending ---- 
    function et_vor2strm1_et(et,values,rigid) ! ٤ή. 
                                              ! ǥեȤǴ
      ! Chebyshev-tau ˡˤ׻
      !  \zeta Ϳή \psi .
      !    \nabla^2 \psi = \zeta, 
      !    \psi = const. at boundaries.
      ! Ǵ
      !    \DP{\psi}{y} = 0 at boundaries
      ! Ϥʤ
      !    \DP[2]{\psi}{y} = 0 at boundaries
      !
      ! \nabla^4 \psi = \nabla^2\zeta 
      ! 4 ʬˤ뤳ȤǶοȤĤĤޤ. 

      real(8), dimension(-km:km,0:lm),intent(in)  :: et
      real(8), dimension(-km:km,0:lm)             :: et_vor2strm1_et

      ! ή. ǰʤΤȿ 0 ʬΤ
      real(8), dimension(2), intent(in), optional :: values
      ! 凉å
      logical, dimension(2), intent(in), optional :: rigid

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(-km:km,0:lm)         :: et_work
      real(8), dimension(0:lm,0:lm)           :: tt_work
      real(8), dimension(0:lm,0:jm)           :: tg_work
      real(8)                                 :: value1, value2   ! 
      logical                                 :: rigid1, rigid2   ! 

      logical :: first = .true.
      integer :: k,l
      save    :: alu, kp, first

      if (.not. present(values)) then
         value1=0 ; value2=0
      else
         value1 = values(1) ; value2 = values(2)
      endif

      if (.not. present(rigid)) then
         rigid1=.true. ; rigid2=.true.
      else
         rigid1 = rigid(1) ; rigid2 = rigid(2)
      endif

      if ( first ) then
         first = .false.

         allocate(alu(-km:km,0:lm,0:lm),kp(-km:km,0:lm))

         tt_work=0
         do l=0,lm
            tt_work(l,l)=1
         enddo
         do k=-km,km
            alu(k,:,:) = transpose( &
                 at_dy_at(at_dy_at(at_dy_at(at_dy_at(tt_work)))) &
                 - 2 * (2*pi*k/xl)**2 * at_dy_at(at_dy_at(tt_work)) &
                 + (2*pi*k/xl)**4*tt_work &
                 )
         enddo

         ! ưŪ. ή϶ǰ
         tg_work=ag_at(tt_work)
         do k=-km,km
            alu(k,lm-1,:) = tg_work(:,0)
            alu(k,lm,:)   = tg_work(:,jm)
         enddo

         ! ϳŪǴ 
         if ( rigid1 ) then
            tg_work=ag_at(at_dy_at(tt_work))
         else
            tg_work=ag_at(at_dy_at(at_dy_at(tt_work)))
         endif
         do k=-km,km
            alu(k,lm-3,:) = tg_work(:,0)
         enddo

         ! ϳŪǴ 
         if ( rigid2 ) then
            tg_work=ag_at(at_dy_at(tt_work))
         else
            tg_work=ag_at(at_dy_at(at_dy_at(tt_work)))
         endif
         do k=-km,km
            alu(k,lm-2,:) = tg_work(:,jm)
         enddo

         call ludecomp(alu,kp)
      endif

      et_work = et_lapla_et(et)
      et_work(:,lm-3) = 0               ! ϳŪ
      et_work(:,lm-2) = 0               ! ϳŪ

      et_work(:,lm-1) = 0            ! ưŪ. ȿ 0 ʳ 0 
      et_work(0,lm-1) = value1*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      et_work(:,lm)   = 0            ! ưŪ. ȿ 0 ʳ 0 
      et_work(0,lm)   = value2*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      et_vor2strm1_et = lusolve(alu,kp,et_work)

    end function et_vor2strm1_et

  end module et_module
