!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wghi_module 
!      ̾βٳȻ
!
!  2002/05/27  ݹ
!      
!
program wghi_diff1

  use wghi_module
  use gtool_history
  implicit none

 !---- ֲ ----
  integer,parameter  :: im=32, jm=16, km=10  ! ʻ(, , ľ)
  integer,parameter  :: nm=10                ! ȿ(ʿ)

 !---- ɸѿʤ ----
  real(8),parameter  :: ra=100.0                   ! Ⱦ
  real(8),parameter  :: zmin=0.0, zmax=1.0         ! ľɸϰ

 !---- ѿ ----
  real(8), dimension(im,jm,0:km)     :: xyg_temp   ! 
  real(8), dimension((nm+1)**2,0:km) :: wg_temp    ! 
!!$  real(8), dimension((nm+1)**2,km-1) :: wi_temp    ! 
!!$
!!$  real(8), dimension(im,jm,km-1)     :: xyi_temp   ! 
!!$  real(8), dimension((nm+1)**2,km-1) :: wi_temp    ! 
!!$
  real(8), dimension(im,jm,2)        :: xy_tempbndry     ! 
  real(8), dimension((nm+1)**2,2)    :: w_tempbndry      ! 

 !---- ʬѥ᥿ ----
  real(8), parameter :: dt=1e-3                    ! ֥ƥå״ֳ
  integer, parameter :: nt=100, ndisp=10           ! ʬ, ɽƥå

 !---- ʪѥ᥿ ----
  character(len=2), parameter :: tempbc='DN'    ! ٶ(DD/DN/ND/NN)
  real(8), parameter :: kappa=1.0               ! Ȼ

  real(8), parameter :: pi=3.1415926535897932385D0
  real(8), parameter :: lon1=pi                 ! ʬ۰ٺɸ
  real(8), parameter :: lat1=0.0                ! ʬ۷ٺɸ
  real(8), parameter :: z1=(zmin+zmax)/2.0      ! ʬưºɸ
  real(8), parameter :: sigma=0.1               ! ʬۤ礭

 !---- ¾ ----
  integer :: it, k

 !---------------- ɸͤ ---------------------
  call wghi_initial(im,jm,km,nm,ra, &
                 (/(zmin+(zmax-zmin)*k/km,k=0,km)/), &
                 (/(zmin+(zmax-zmin)*(k-0.5)/km,k=1,km)/))
  write(6,*) g_ver
  write(6,*) h_ver

 !-------------------  ----------------------
  xyg_temp =  exp(-((xyg_lon-lon1)**2+(xyg_lat-lat1)**2+(xyg_ver-z1)**2) &
                 /(2*sigma**2))
  xyg_temp(:,:,0) = 0.0 ; xyg_temp(:,:,km) = 0.0 
  wg_temp = wg_xyg(xyg_temp)

  call output_gtool4_init
  call output_gtool4

  do it=1,nt
     wg_temp = wg_temp + dt* kappa * wg_laplah_wg(wg_temp)
     if(mod(it,ndisp) .eq. 0)then                    ! 
        xyg_temp = xyg_wg(wg_temp)
        call output_gtool4
     endif
  enddo
  call output_gtool4_close

contains

 !-------------------  ----------------------
  subroutine output_gtool4_init
    call HistoryCreate( &                                  ! ҥȥ꡼
           file='wghi_diff1.nc', title='diff. eq. on a sphere', &
           source='Sample program of spmodel library',        &
           institution='GFD_Dennou Club SPMODEL project',     &
           dims=(/'lon','lat','zg ','zh ','t  '/), &
           dimsizes=(/im,jm,km+1,km,0/),           &
           longnames=(/'Longitude','Latitude ','Vertical ','Vertical ','time     '/), &
           units=(/'1','1','1','1','1'/),   &
           origin=0.0, interval=real(ndisp*dt) )

    call HistoryPut('lon',x_lon/pi*180)                       ! ѿ
    call HistoryPut('lat',y_lat/pi*180)                       ! ѿ
    call HistoryPut('zg ',g_ver)                            ! ѿ
    call HistoryPut('zh ',h_ver)                            ! ѿ
    call HistoryAddVariable( &                                ! ѿ
           varname='temp', dims=(/'lon','lat','zg ','t  '/), & 
           longname='temperature', units='1', xtype='double')
  end subroutine output_gtool4_init

  subroutine output_gtool4
    write(6,*) 'it = ',it
    call HistoryPut('t',real(it*dt))
    call HistoryPut('temp',xyg_temp)
  end subroutine output_gtool4

  subroutine output_gtool4_close
    call HistoryClose
  end subroutine output_gtool4_close

end program wghi_diff1
