!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_module
!      2 ̾γȻ
!           d\zeta/dt  = \nu\nabla^2\zeta
!
!  2002/08/21  ݹ
!
  program w_diff

    use w_module
    use gtool_history
    implicit none

  !---- ֲ ----
    integer, parameter :: im=64, jm=32            ! ʻ(X,Y)
    integer, parameter :: nm=21

  !---- ѿ ----
    real(8)            :: xy_Zeta(im,jm)          ! ʻǡ()
    real(8)            :: w_Zeta((nm+1)*(nm+1))   ! ڥȥ()

  !---- ɸѿʤ ----
    real(8), parameter :: R0=1.0

  !---- ʬѥ᥿ ----
    real(8), parameter :: dt = 1e-3                ! ֥ƥå״ֳ
    integer, parameter :: nt = 2000, ndisp = 200   ! ʬ, ɽƥå
 
  !---- ʪѥ᥿ ----
    real(8), parameter :: pi = 3.141592653589793   ! ߼Ψ
    real(8), parameter :: Nu = 1.0                 ! Ǵ

    real(8), parameter :: Zeta0 = 1.0              ! ζ
    real(8), parameter :: X0 = pi, y0 = pi/4       ! ΰ
    real(8), parameter :: AX = pi/10, AY = pi/10   ! 礭

  !------ ѿ ------
    integer             :: i, j, it=0

  !---------------- ɸͤ ---------------------
    call w_Initial(nm,im,jm)                ! ISPACK

  !-------------------  ----------------------
    xy_Zeta = Zeta0 * exp( -((xy_Lon-X0)/AX)**2 -((xy_Lat-Y0)/AY)**2 )
    w_Zeta = w_xy(xy_Zeta)

    call output_gtool4_init                        ! ҥȥ꡼
    call output_gtool4                             ! ͽ

 !------------------- ʬ ----------------------
    do it=1,nt
       w_Zeta = w_Zeta + dt * ( Nu * w_Lapla_w(w_Zeta) )

       if(mod(it,ndisp) .eq. 0)then                        ! 
          call output_gtool4
       endif
    enddo

    call output_gtool4_close
    stop

  contains
    subroutine output_gtool4_init
      call HistoryCreate( &                               ! ҥȥ꡼
           file='w_diff.nc', title='2D Diffusion equation on a sphere', &
           source='Sample program of gtool_history/gtool4',       &
           institution='GFD_Dennou Club davis/spmodel project',   &
           dims=(/'lon','lat','t  '/), dimsizes=(/im,jm,0/),            &
           longnames=(/'longitude','latitude ','time     '/),     &
           units=(/'1','1','1'/),                        &
           origin=0.0, interval=real(ndisp*dt) )

      call HistoryPut('lon',x_Lon*180/pi)                 ! ѿ
      call HistoryAddattr('x','topology','circular')      ! °
      call HistoryAddattr('x','modulo',360.0)             ! °
      call HistoryPut('lat',y_Lat*180/pi)                 ! ѿ

      call HistoryAddVariable( &                          ! ѿ
           varname='zeta', dims=(/'lon','lat','t  '/), & 
           longname='voticity', units='1', xtype='double')

    end subroutine output_gtool4_init

    subroutine output_gtool4
      xy_Zeta = xy_w(w_Zeta)

      write(6,*) 'it = ',it
      call HistoryPut('zeta',xy_Zeta)
    end subroutine output_gtool4

    subroutine output_gtool4_close
      call HistoryClose
    end subroutine output_gtool4_close

  end program w_diff
