!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wa_integral_module
!
!  2002/05/25  ݹ 
!
module wa_integral_module
  use w_base_module, only : im, jm, x_lon_weight, y_lat_weight

  implicit none

  private
 
  public a_intlonlat_xya                      ! ٷʬ
  public ya_intlon_xya, a_intlon_xa           ! ʬ    
  public xa_intlat_xya, a_intlat_ya           ! ʬ    
  public a_avrlonlat_xya                      ! ٷʿ
  public ya_avrlon_xya, a_avrlon_xa           ! ʿ    
  public xa_avrlat_xya, a_avrlat_ya           ! ʿ    

  contains

  !--------------- ʬ׻ -----------------
    function a_intlonlat_xya(xya_data)        ! ٷʬ
      real(8), intent(in)   :: xya_data(:,:,:)           ! ʻ(im,jm,*)
      real(8) :: a_intlonlat_xya(size(xya_data,3))       ! ʻ(*)

      a_intlonlat_xya = a_intlon_xa(xa_intlat_xya(xya_data))
    end function a_intlonlat_xya

    function xa_intlat_xya(xya_data)          ! ʬ
      real(8), intent(in) :: xya_data(:,:,:)              ! ʻ(im,jm,*)
      real(8)             :: xa_intlat_xya(im,size(xya_data,3)) ! ʻ(im,*)
      integer :: j

      xa_intlat_xya = 0
      do j=1,jm
         xa_intlat_xya = xa_intlat_xya + xya_data(:,j,:) * y_lat_weight(j)
      enddo

    end function xa_intlat_xya

    function ya_intlon_xya(xya_data)          ! ʬ
      real(8), intent(in) :: xya_data(:,:,:)               ! ʻ(im,jm,*)
      real(8)             :: ya_intlon_xya(jm,size(xya_data,3)) ! ʻ(jm,*)
      integer :: i

      ya_intlon_xya = 0
      do i=1,im
         ya_intlon_xya = ya_intlon_xya + xya_data(i,:,:) * x_lon_weight(i)
      enddo

    end function ya_intlon_xya

    function a_intlat_ya(ya_data)          ! ʬ
      real(8), intent(in) :: ya_data(:,:)                 ! ʻ(jm,*)
      real(8)             :: a_intlat_ya(size(ya_data,2)) ! ʻ(*)
      integer :: j

      a_intlat_ya = 0
      do j=1,jm
         a_intlat_ya = a_intlat_ya + ya_data(j,:) * y_lat_weight(j)
      enddo

    end function a_intlat_ya

    function a_intlon_xa(xa_data)          ! ʬ
      real(8), intent(in) :: xa_data(:,:)                 ! ʻ(im,*)
      real(8)             :: a_intlon_xa(size(xa_data,2)) ! ʻ(*)
      integer :: i

      a_intlon_xa = 0
      do i=1,im
         a_intlon_xa = a_intlon_xa + xa_data(i,:) * x_lon_weight(i)
      enddo

    end function a_intlon_xa

  !--------------- ʿѷ׻ -----------------
    function a_avrlonlat_xya(xya_data)        ! ٷʿ
      real(8), intent(in)   :: xya_data(:,:,:)         ! ʻ(im,jm,*)
      real(8) :: a_avrlonlat_xya(size(xya_data,3))       ! ʻ(*)

      a_avrlonlat_xya = a_avrlon_xa(xa_avrlat_xya(xya_data))
    end function a_avrlonlat_xya

    function xa_avrlat_xya(xya_data)          ! ʿ
      real(8), intent(in) :: xya_data(:,:,:)           ! ʻ(im,jm,*)
      real(8)             :: xa_avrlat_xya(im,size(xya_data,3)) ! ʻ(im,*)

      xa_avrlat_xya = xa_intlat_xya(xya_data)/sum(y_lat_weight)

    end function xa_avrlat_xya

    function ya_avrlon_xya(xya_data)          ! ʿ
      real(8), intent(in) :: xya_data(:,:,:)               ! ʻ(im,jm,*)
      real(8)             :: ya_avrlon_xya(jm,size(xya_data,3)) ! ʻ(jm,*)

      ya_avrlon_xya = ya_intlon_xya(xya_data)/sum(x_lon_weight)

    end function ya_avrlon_xya

    function a_avrlat_ya(ya_data)          ! ʿ
      real(8), intent(in) :: ya_data(:,:)                ! ʻ(jm,*)
      real(8)             :: a_avrlat_ya(size(ya_data,2)) ! ʻ(*)

      a_avrlat_ya = a_intlat_ya(ya_data)/sum(y_lat_weight)

    end function a_avrlat_ya

    function a_avrlon_xa(xa_data)          ! ʿ
      real(8), intent(in) :: xa_data(:,:)                ! ʻ(im,*)
      real(8)             :: a_avrlon_xa(size(xa_data,2)) ! ʻ(*)

      a_avrlon_xa = a_intlon_xa(xa_data)/sum(x_lon_weight)

    end function a_avrlon_xa

  end module wa_integral_module
