!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wt_module
!      ݥݥƥ󥷥Ȼ
!
!  2002/06/10  ݹ
!
program wt_diff5

  use lumatrix
  use wt_module
  use gtool_history
  implicit none

 !---- ֲ ----
  integer,parameter  :: im=32, jm=16, km=8  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=8         ! ȿ(ʿ, ư)

 !---- ɸѿʤ ----
  !real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ
  real(8),parameter  :: ri=0.1, ro=1.0       ! ⳰Ⱦ

 !---- ѿ ----
  real(8), dimension(im,jm,0:km)     :: xyz_PMAG   ! ݥ뼧
  real(8), dimension((nm+1)**2,0:lm) :: wt_PMAG    ! ݥ뼧

 !---- ʬѥ᥿ ----
  real(8), parameter :: dt=1e-4                 ! ֥ƥå״ֳ
  integer, parameter :: nt=20000, ndisp=1000    ! ʬ, ɽƥå

 !---- ʪѥ᥿ ----
  real(8), parameter :: eta=1.0                 ! Ǵ

  real(8), parameter :: pi=3.1415926535897932385D0
  real(8), parameter :: lon1=pi                 ! ʬ۰ٺɸ
  real(8), parameter :: lat1=0.0                ! ʬ۷ٺɸ
  real(8), parameter :: rad1=(ri+ro)/2.0        ! ʬưºɸ
  real(8), parameter :: sigma=0.2               ! ʬۤ礭

 !---- ¾ ----
  integer :: it

 !---------------- ɸͤ ---------------------
  call wt_Initial(im,jm,km,nm,lm,ri,ro)

 !-------------------  ----------------------
  !xyz_PMAG =  exp(-((xyz_LON-lon1)**2+(xyz_LAT-lat1)**2+(xyz_RAD-rad1)**2)&
  !               /(2*sigma**2))
  xyz_PMAG = sin(xyz_LAT) * sin( pi*(xyz_RAD-ri)/(ro-ri) )

  wt_PMAG = wt_xyz(xyz_PMAG)

  call output_gtool4_init
  call output_gtool4

 !------------------- ʬ ----------------------
  do it=1,nt                                         ! Euler ˡˤʬ
     wt_PMAG = wt_PMAG + dt *( eta * wt_Lapla_wt(wt_PMAG) )
     call wt_PolmagBoundaries(wt_PMAG)

     if(mod(it,ndisp) .eq. 0)then                    ! 
        xyz_PMAG = xyz_wt(wt_PMAG)
        call output_gtool4
     endif
  enddo
  call output_gtool4_close

contains

 !-------------------  ----------------------
  subroutine output_gtool4_init
    call HistoryCreate( &                                  ! ҥȥ꡼
           file='wt_diff5.nc', title='Diffusion model in a spherical shell', &
           source='Sample program of spmodel library', &
           institution='GFD_Dennou Club SPMODEL project',     &
           dims=(/'lon','lat','rad','t  '/), dimsizes=(/im,jm,km+1,0/),&
           longnames=(/'Longitude','Latitude ','Radius   ','time     '/),&
           units=(/'1','1','1','1'/),   &
           origin=0.0, interval=real(ndisp*dt) )

    call HistoryPut('lon',x_LON/pi*180)                       ! ѿ
    call HistoryPut('lat',y_LAT/pi*180)                       ! ѿ
    call HistoryPut('rad',z_RAD)                              ! ѿ

    call HistoryAddVariable( &                                ! ѿ
           varname='pmag', dims=(/'lon','lat','rad','t  '/), & 
           longname='magnetic poloidal potential', units='1', xtype='double')
    call HistoryAddVariable( &                                ! ѿ
           varname='Em', dims=(/'t  '/), & 
           longname='magnetic energy', units='1', xtype='double')
  end subroutine output_gtool4_init

  subroutine output_gtool4
    write(6,*) 'it = ',it
    call HistoryPut('t',real(it*dt))
    call HistoryPut('pmag',xyz_PMAG)
    call HistoryPut('Em',IntLonLatRad_xyz(xyz_PMAG**2/2))
  end subroutine output_gtool4

  subroutine output_gtool4_close
    call HistoryClose
  end subroutine output_gtool4_close

end program wt_diff5
