#include <ruby.h>
#include <math.h>
#include <stdio.h>
#include <narray.h>
#include "ssl2.h"

extern void celi1_(float*,float*,int*);
extern void celi2_(float*,float*,int*);
extern void expi_(float*,float*,int*);
extern void sini_(float*,float*,int*);
extern void cosi_(float*,float*,int*);
extern void sfri_(float*,float*,int*);
extern void cfri_(float*,float*,int*);
extern void igam1_(float*,float*,float*,int*);
extern void igam2_(float*,float*,float*,int*);
extern void ierf_(float*,float*,int*);
extern void ierfc_(float*,float*,int*);
extern void bj0_(float*,float*,int*);
extern void bj1_(float*,float*,int*);
extern void by0_(float*,float*,int*);
extern void by1_(float*,float*,int*);
extern void bi0_(float*,float*,int*);
extern void bi1_(float*,float*,int*);
extern void bk0_(float*,float*,int*);
extern void bk1_(float*,float*,int*);
extern void bjn_(float*,int*,float*,int*);
extern void byn_(float*,int*,float*,int*);
extern void bin_(float*,int*,float*,int*);
extern void bkn_(float*,int*,float*,int*);
extern void cbin_(scomplex*,int*,scomplex*,int*);
extern void cbkn_(scomplex*,int*,scomplex*,int*);
extern void cbjn_(scomplex*,int*,scomplex*,int*);
extern void cbyn_(scomplex*,int*,scomplex*,int*);
extern void bjr_(float*,float*,float*,int*);
extern void byr_(float*,float*,float*,int*);
extern void bir_(float*,float*,float*,int*);
extern void bkr_(float*,float*,float*,int*);
extern void cbjr_(scomplex*,float*,scomplex*,int*);
extern void ndf_(float*,float*,int*);
extern void ndfc_(float*,float*,int*);
extern void indf_(float*,float*,int*);
extern void indfc_(float*,float*,int*);


static VALUE
rb_celi1(self,x)
     VALUE self,x;
{
  float cx;
  float cceli;
  int icon;

  cx = NUM2FLT(x);
  if (cx<0) rb_raise(rb_eRuntimeError,"x<0");
  if (cx>=1) rb_raise(rb_eRuntimeError,"x>=1");

  celi1_(&cx,&cceli,&icon);

  ssl2_error(icon);
  return FLT2NUM(cceli);
}

static VALUE
rb_celi2(self,x)
     VALUE self,x;
{
  float cx;
  float cceli;
  int icon;

  cx = NUM2FLT(x);
  if (cx<0) rb_raise(rb_eRuntimeError,"x<0");
  if (cx>1) rb_raise(rb_eRuntimeError,"x>=1");

  celi2_(&cx,&cceli,&icon);

  ssl2_error(icon);
  return FLT2NUM(cceli);
}

static VALUE
rb_expi(self,x)
     VALUE self,x;
{
  float cx;
  float cei;
  int icon;

  cx = NUM2FLT(x);
  if (cx==0) rb_raise(rb_eRuntimeError,"x==0");

  expi_(&cx,&cei,&icon);

  ssl2_error(icon);
  return FLT2NUM(cei);
}

static VALUE
rb_sini(self,x)
     VALUE self,x;
{
  float cx;
  float csi;
  int icon;

  cx = NUM2FLT(x);
  if (cx==0) rb_raise(rb_eRuntimeError,"x==0");

  sini_(&cx,&csi,&icon);

  ssl2_error(icon);
  return FLT2NUM(csi);
}

static VALUE
rb_cosi(self,x)
     VALUE self,x;
{
  float cx;
  float cci;
  int icon;

  cx = NUM2FLT(x);
  if (cx==0) rb_raise(rb_eRuntimeError,"x==0");

  cosi_(&cx,&cci,&icon);

  ssl2_error(icon);
  return FLT2NUM(cci);
}

static VALUE
rb_sfri(self,x)
     VALUE self,x;
{
  float cx;
  float csf;
  int icon;

  cx = NUM2FLT(x);
  if (cx<0) rb_raise(rb_eRuntimeError,"x<0");

  sfri_(&cx,&csf,&icon);

  ssl2_error(icon);
  return FLT2NUM(csf);
}

static VALUE
rb_cfri(self,x)
     VALUE self,x;
{
  float cx;
  float ccf;
  int icon;

  cx = NUM2FLT(x);
  if (cx<0) rb_raise(rb_eRuntimeError,"x<0");

  cfri_(&cx,&ccf,&icon);

  ssl2_error(icon);
  return FLT2NUM(ccf);
}

static VALUE
rb_igam1(self,v,x)
     VALUE self,v,x;
{
  float cv,cx;
  float cf;
  int icon;

  cv = NUM2FLT(v);
  if (cv<=0) rb_raise(rb_eRuntimeError,"v<=0");
  cx = NUM2FLT(x);
  if (cx<0) rb_raise(rb_eRuntimeError,"x<0");

  igam1_(&cv,&cx,&cf,&icon);

  ssl2_error(icon);
  return FLT2NUM(cf);
}

static VALUE
rb_igam2(self,v,x)
     VALUE self,v,x;
{
  float cv,cx;
  float cf;
  int icon;

  cv = NUM2FLT(v);
  if (cv<0) rb_raise(rb_eRuntimeError,"v<0");
  cx = NUM2FLT(x);
  if (cx<0) rb_raise(rb_eRuntimeError,"x<0");
  if (cv==0&&cx==0) rb_raise(rb_eRuntimeError,"v==0 && x==0");

  igam2_(&cv,&cx,&cf,&icon);

  ssl2_error(icon);
  return FLT2NUM(cf);
}

static VALUE
rb_ierf(self,x)
     VALUE self,x;
{
  float cx;
  float cf;
  int icon;

  cx = NUM2FLT(x);
  if (cx>=1&&cx<=-1) rb_raise(rb_eRuntimeError,"|x|>=1");

  ierf_(&cx,&cf,&icon);

  ssl2_error(icon);
  return FLT2NUM(cf);
}

static VALUE
rb_ierfc(self,x)
     VALUE self,x;
{
  float cx;
  float cf;
  int icon;

  cx = NUM2FLT(x);
  if (cx<=0) rb_raise(rb_eRuntimeError,"x<=0");
  if (cx>=2) rb_raise(rb_eRuntimeError,"x>=2");

  ierfc_(&cx,&cf,&icon);

  ssl2_error(icon);
  return FLT2NUM(cf);
}

static VALUE
rb_bj0(self,x)
     VALUE self,x;
{
  float cx;
  float cbj;
  int icon;

  cx = NUM2FLT(x);

  bj0_(&cx,&cbj,&icon);

  ssl2_error(icon);
  return FLT2NUM(cbj);
}

static VALUE
rb_bj1(self,x)
     VALUE self,x;
{
  float cx;
  float cbj;
  int icon;

  cx = NUM2FLT(x);

  bj1_(&cx,&cbj,&icon);

  ssl2_error(icon);
  return FLT2NUM(cbj);
}

static VALUE
rb_by0(self,x)
     VALUE self,x;
{
  float cx;
  float cby;
  int icon;

  cx = NUM2FLT(x);
  if (cx<=0) rb_raise(rb_eRuntimeError,"x<=0");

  by0_(&cx,&cby,&icon);

  ssl2_error(icon);
  return FLT2NUM(cby);
}

static VALUE
rb_by1(self,x)
     VALUE self,x;
{
  float cx;
  float cby;
  int icon;

  cx = NUM2FLT(x);
  if (cx<=0) rb_raise(rb_eRuntimeError,"x<=0");

  by1_(&cx,&cby,&icon);

  ssl2_error(icon);
  return FLT2NUM(cby);
}

static VALUE
rb_bi0(self,x)
     VALUE self,x;
{
  float cx;
  float cbi;
  int icon;

  cx = NUM2FLT(x);

  bi0_(&cx,&cbi,&icon);

  ssl2_error(icon);
  return FLT2NUM(cbi);
}

static VALUE
rb_bi1(self,x)
     VALUE self,x;
{
  float cx;
  float cbi;
  int icon;

  cx = NUM2FLT(x);

  bi1_(&cx,&cbi,&icon);

  ssl2_error(icon);
  return FLT2NUM(cbi);
}

static VALUE
rb_bk0(self,x)
     VALUE self,x;
{
  float cx;
  float cbk;
  int icon;

  cx = NUM2FLT(x);
  if (cx<=0) rb_raise(rb_eRuntimeError,"x<=0");

  bk0_(&cx,&cbk,&icon);

  ssl2_error(icon);
  return FLT2NUM(cbk);
}

static VALUE
rb_bk1(self,x)
     VALUE self,x;
{
  float cx;
  float cbk;
  int icon;

  cx = NUM2FLT(x);
  if (cx<=0) rb_raise(rb_eRuntimeError,"x<=0");

  bk1_(&cx,&cbk,&icon);

  ssl2_error(icon);
  return FLT2NUM(cbk);
}

static VALUE
rb_bjn(self,x,n)
     VALUE self,x,n;
{
  float cx;
  int cn;
  float cbj;
  int icon;

  cx = NUM2FLT(x);
  if (abs(cx)>100) rb_raise(rb_eRuntimeError,"|x|>100");
  cn = NUM2INT(n);
  if ((1.0/8)<=abs(cx)&&abs(cx)<1&&abs(cn)>=19*abs(cx)+29)
    rb_raise(rb_eRuntimeError,"1/8<=|x|<1 && |n|>=19|x|+29");
  if (1<=abs(cx)&&abs(cx)<10&&abs(cn)>=4.7*abs(cx)+43)
    rb_raise(rb_eRuntimeError,"1<=|x|<10 && |n|>=4.7|x|+43");
  if (10<=abs(cx)&&abs(cx)<100&&abs(cn)>=1.83*abs(cx)+71)
    rb_raise(rb_eRuntimeError,"10<=|x|<100 && |n|>=1.83|x|+71");

  bjn_(&cx,&cn,&cbj,&icon);

  ssl2_error(icon);
  return FLT2NUM(cbj);
}

static VALUE
rb_byn(self,x,n)
     VALUE self,x,n;
{
  float cx;
  int cn;
  float cby;
  int icon;

  cx = NUM2FLT(x);
  if (cx<=0) rb_raise(rb_eRuntimeError,"x<=0");
  cn = NUM2INT(n);

  byn_(&cx,&cn,&cby,&icon);

  ssl2_error(icon);
  return FLT2NUM(cby);
}

static VALUE
rb_bin(self,x,n)
     VALUE self,x,n;
{
  float cx;
  int cn;
  float cbi;
  int icon;

  cx = NUM2FLT(x);
  if (cx<=0) rb_raise(rb_eRuntimeError,"x<=0");
  cn = NUM2INT(n);
  if ((1.0/8)<=abs(cx)&&abs(cx)<1&&abs(cn)>=19*abs(cx)+29)
    rb_raise(rb_eRuntimeError,"1/8<=|x|<1 && |n|>=19|x|+29");
  if (1<=abs(cx)&&abs(cx)<10&&abs(cn)>=4.7*abs(cx)+43)
    rb_raise(rb_eRuntimeError,"1<=|x|<10 && |n|>=4.7|x|+43");
  if (10<=abs(cx)&&abs(cx)<100&&abs(cn)>=1.83*abs(cx)+71)
    rb_raise(rb_eRuntimeError,"10<=|x|<100 && |n|>=1.83|x|+71");

  bin_(&cx,&cn,&cbi,&icon);

  ssl2_error(icon);
  return FLT2NUM(cbi);
}

static VALUE
rb_bkn(self,x,n)
     VALUE self,x,n;
{
  float cx;
  int cn;
  float cbk;
  int icon;

  cx = NUM2FLT(x);
  if (cx<=0) rb_raise(rb_eRuntimeError,"x<=0");
  cn = NUM2INT(n);

  bkn_(&cx,&cn,&cbk,&icon);

  ssl2_error(icon);
  return FLT2NUM(cbk);
}

static VALUE
rb_cbin(self,z,n)
     VALUE self,z,n;
{
  scomplex cz;
  int cn;
  scomplex czbi;
  int icon;

  cz = NUM2SCMP(z);
  cn = NUM2INT(n);

  cbin_(&cz,&cn,&czbi,&icon);

  ssl2_error(icon);
  return CMP2NUM(czbi);
}

static VALUE
rb_cbkn(self,z,n)
     VALUE self,z,n;
{
  scomplex cz;
  int cn;
  scomplex czbk;
  int icon;

  cz = NUM2SCMP(z);
  if (cz.r==0&&cz.i==0) rb_raise(rb_eRuntimeError,"|z|==0");
  cn = NUM2INT(n);

  cbkn_(&cz,&cn,&czbk,&icon);

  ssl2_error(icon);
  return CMP2NUM(czbk);
}

static VALUE
rb_cbjn(self,z,n)
     VALUE self,z,n;
{
  scomplex cz;
  int cn;
  scomplex czbj;
  int icon;

  cz = NUM2SCMP(z);
  cn = NUM2INT(n);

  cbjn_(&cz,&cn,&czbj,&icon);

  ssl2_error(icon);
  return CMP2NUM(czbj);
}

static VALUE
rb_cbyn(self,z,n)
     VALUE self,z,n;
{
  scomplex cz;
  int cn;
  scomplex czby;
  int icon;

  cz = NUM2SCMP(z);
  if (cz.r==0&&cz.i==0) rb_raise(rb_eRuntimeError,"|z|==0");
  cn = NUM2INT(n);

  cbyn_(&cz,&cn,&czby,&icon);

  ssl2_error(icon);
  return CMP2NUM(czby);
}

static VALUE
rb_bjr(self,x,v)
     VALUE self,x,v;
{
  float cx,cv;
  float cbj;
  int icon;

  cx = NUM2FLT(x);
  if (cx<0) rb_raise(rb_eRuntimeError,"x<0");
  cv = NUM2FLT(v);
  if (cv<0) rb_raise(rb_eRuntimeError,"v<0");
  if (cx>100&&cv>15) rb_raise(rb_eRuntimeError,"x>100 && v>15");

  bjr_(&cx,&cv,&cbj,&icon);

  ssl2_error(icon);
  return FLT2NUM(cbj);
}

static VALUE
rb_byr(self,x,v)
     VALUE self,x,v;
{
  float cx,cv;
  float cby;
  int icon;

  cx = NUM2FLT(x);
  if (cx<0) rb_raise(rb_eRuntimeError,"x<0");
  cv = NUM2FLT(v);
  if (cv<0) rb_raise(rb_eRuntimeError,"v<0");

  byr_(&cx,&cv,&cby,&icon);

  ssl2_error(icon);
  return FLT2NUM(cby);
}

static VALUE
rb_bir(self,x,v)
     VALUE self,x,v;
{
  float cx,cv;
  float cbi;
  int icon;

  cx = NUM2FLT(x);
  if (cx<0) rb_raise(rb_eRuntimeError,"x<0");
  cv = NUM2FLT(v);
  if (cv<0) rb_raise(rb_eRuntimeError,"v<0");

  bir_(&cx,&cv,&cbi,&icon);

  ssl2_error(icon);
  return FLT2NUM(cbi);
}

static VALUE
rb_bkr(self,x,v)
     VALUE self,x,v;
{
  float cx,cv;
  float cbk;
  int icon;

  cx = NUM2FLT(x);
  if (cx<0) rb_raise(rb_eRuntimeError,"x<0");
  cv = NUM2FLT(v);

  bkr_(&cx,&cv,&cbk,&icon);

  ssl2_error(icon);
  return FLT2NUM(cbk);
}

static VALUE
rb_cbjr(self,z,v)
     VALUE self,z,v;
{
  scomplex cz;
  float cv;
  scomplex czbj;
  int icon;

  cz = NUM2SCMP(z);
  cv = NUM2FLT(v);
  if (cv<0) rb_raise(rb_eRuntimeError,"v<0");

  cbjr_(&cz,&cv,&czbj,&icon);

  ssl2_error(icon);
  return CMP2NUM(czbj);
}

static VALUE
rb_ndf(self,x)
     VALUE self,x;
{
  float cx;
  float cf;
  int icon;

  cx = NUM2FLT(x);

  ndf_(&cx,&cf,&icon);

  ssl2_error(icon);
  return FLT2NUM(cf);
}

static VALUE
rb_ndfc(self,x)
     VALUE self,x;
{
  float cx;
  float cf;
  int icon;

  cx = NUM2FLT(x);

  ndfc_(&cx,&cf,&icon);

  ssl2_error(icon);
  return FLT2NUM(cf);
}

static VALUE
rb_indf(self,x)
     VALUE self,x;
{
  float cx;
  float cf;
  int icon;

  cx = NUM2FLT(x);
  if (abs(cx)>=0.5) rb_raise(rb_eRuntimeError,"|x|>=1/2");

  indf_(&cx,&cf,&icon);

  ssl2_error(icon);
  return FLT2NUM(cf);
}

static VALUE
rb_indfc(self,x)
     VALUE self,x;
{
  float cx;
  float cf;
  int icon;

  cx = NUM2FLT(x);
  if (cx<=0) rb_raise(rb_eRuntimeError,"x<=0");
  if (cx>=1) rb_raise(rb_eRuntimeError,"x>=1");

  indfc_(&cx,&cf,&icon);

  ssl2_error(icon);
  return FLT2NUM(cf);
}


void init_special_functions(mSSL2)
     VALUE mSSL2;
{
  rb_define_module_function(mSSL2, "celi1", rb_celi1, 1);
  rb_define_module_function(mSSL2, "celi2", rb_celi2, 1);
  rb_define_module_function(mSSL2, "expi", rb_expi, 1);
  rb_define_module_function(mSSL2, "sini", rb_sini, 1);
  rb_define_module_function(mSSL2, "cosi", rb_cosi, 1);
  rb_define_module_function(mSSL2, "sfri", rb_sfri, 1);
  rb_define_module_function(mSSL2, "cfri", rb_cfri, 1);
  rb_define_module_function(mSSL2, "igam1", rb_igam1, 2);
  rb_define_module_function(mSSL2, "igam2", rb_igam2, 2);
  rb_define_module_function(mSSL2, "ierf", rb_ierf, 1);
  rb_define_module_function(mSSL2, "ierfc", rb_ierfc, 1);
  rb_define_module_function(mSSL2, "bj0", rb_bj0, 1);
  rb_define_module_function(mSSL2, "bj1", rb_bj1, 1);
  rb_define_module_function(mSSL2, "by0", rb_by0, 1);
  rb_define_module_function(mSSL2, "by1", rb_by1, 1);
  rb_define_module_function(mSSL2, "bi0", rb_bi0, 1);
  rb_define_module_function(mSSL2, "bi1", rb_bi1, 1);
  rb_define_module_function(mSSL2, "bk0", rb_bk0, 1);
  rb_define_module_function(mSSL2, "bk1", rb_bk1, 1);
  rb_define_module_function(mSSL2, "bjn", rb_bjn, 2);
  rb_define_module_function(mSSL2, "byn", rb_byn, 2);
  rb_define_module_function(mSSL2, "bin", rb_bin, 2);
  rb_define_module_function(mSSL2, "bkn", rb_bkn, 2);
  rb_define_module_function(mSSL2, "cbin", rb_cbin, 2);
  rb_define_module_function(mSSL2, "cbin", rb_cbkn, 2);
  rb_define_module_function(mSSL2, "cbin", rb_cbjn, 2);
  rb_define_module_function(mSSL2, "cbin", rb_cbyn, 2);
  rb_define_module_function(mSSL2, "bjr", rb_bjr, 2);
  rb_define_module_function(mSSL2, "byr", rb_byr, 2);
  rb_define_module_function(mSSL2, "bir", rb_bir, 2);
  rb_define_module_function(mSSL2, "bkr", rb_bkr, 2);
  rb_define_module_function(mSSL2, "cbjr", rb_cbjr, 2);
  rb_define_module_function(mSSL2, "ndf", rb_ndf, 1);
  rb_define_module_function(mSSL2, "ndfc", rb_ndfc, 1);
  rb_define_module_function(mSSL2, "indf", rb_indf, 1);
  rb_define_module_function(mSSL2, "indfc", rb_indfc, 1);
}
