#include <ruby.h>
#include <math.h>
#include <stdio.h>
#include <narray.h>
#include "ssl2.h"

extern void simp1_(float*,int*,float*,float*,int*);
extern void trap_(float*,float*,int*,float*,int*);
extern void simp2_(float*,float*,float(*)(float*),float*,float*,int*);
extern void aqn9_(float*,float*,float(*)(float*),float*,float*,int*,int*,float*,float*,int*,int*);
extern void aqc8_(float*,float*,float(*)(float*),float*,float*,int*,int*,float*,float*,int*,int*);
extern void aqe_(float*,float*,float(*)(float*),float*,float*,int*,int*,float*,float*,int*,int*);
extern void aqeh_(float(*)(float*),float*,float*,int*,int*,float*,float*,int*,int*);
extern void aqei_(float(*)(float*),float*,float*,int*,int*,float*,float*,int*,int*);
extern void aqmc8_();
extern void aqme_();

static VALUE
rb_simp1(self,y,h)
     VALUE self,y,h;
{
  float *cy;
  int n;
  float ch;
  float cs;
  int icon;

  cy = ssl2_getcary(y,&n);
  if (n<3) rb_raise(rb_eRuntimeError,"n<3");
  ch = NUM2FLT(h);
  if (ch<=0) rb_raise(rb_eRuntimeError,"h <= 0");

  simp1_(cy,&n,&ch,&cs,&icon);
  free(cy);

  ssl2_error(icon);
  return FLT2NUM(cs);
}

static VALUE
rb_trap(self,x,y)
     VALUE self,x,y;
{
  float *cx,*cy;
  int n;
  float cs;
  int icon;

  int nn;

  cx = ssl2_getcary(x,&n);
  if (n<2) rb_raise(rb_eRuntimeError,"x.length<2");
  cy = ssl2_getcary(y,&nn);
  if (nn!=n) rb_raise(rb_eRuntimeError,"y.length != x.length");

  trap_(cx,cy,&n,&cs,&icon);
  free(cx);
  free(cy);

  ssl2_error(icon);
  return FLT2NUM(cs);
}

static VALUE
rb_simp2(self,a,b,eps)
     VALUE self,a,b,eps;
{
  float ca,cb;
  float ceps;
  float cs;
  int icon;

  ca = NUM2FLT(a);
  cb = NUM2FLT(b);
  ceps = NUM2FLT(eps);
  if (ceps<0) rb_raise(rb_eRuntimeError,"eps<0");

  simp2_(&ca,&cb,&ssl2_func,&ceps,&cs,&icon);

  ssl2_error(icon);
  return FLT2NUM(cs);
}

static VALUE
rb_aqn9(self,a,b,epsa,epsr,nmin,nmax)
     VALUE self,a,b,epsa,epsr,nmin,nmax;
{
  float ca,cb;
  float cepsa,cepsr;
  int cnmin,cnmax;
  float cs,cerr;
  int cn;
  int icon;

  ca = NUM2FLT(a);
  cb = NUM2FLT(b);
  cepsa = NUM2FLT(epsa);
  if (cepsa<0) rb_raise(rb_eRuntimeError,"epsa<0");
  cepsr = NUM2FLT(epsr);
  if (cepsr<0) rb_raise(rb_eRuntimeError,"epsr<0");
  cnmin = NUM2INT(nmin);
  if (cnmin<0) rb_raise(rb_eRuntimeError,"nmin<0");
  if (cnmin>=150) rb_raise(rb_eRuntimeError,"nmin>=150");
  cnmax = NUM2INT(nmax);
  if (cnmax<=cnmin+8) rb_raise(rb_eRuntimeError,"nmax <= nmin+8");

  aqn9_(&ca,&cb,&ssl2_func,&cepsa,&cepsr,&cnmin,&cnmax,&cs,&cerr,&cn,&icon);

  ssl2_error(icon);
  return rb_ary_new3(3,FLT2NUM(cs),FLT2NUM(cerr),INT2NUM(cn));
}

static VALUE
rb_aqc8(self,a,b,epsa,epsr,nmin,nmax)
     VALUE self,a,b,epsa,epsr,nmin,nmax;
{
  float ca,cb;
  float cepsa,cepsr;
  int cnmin,cnmax;
  float cs,cerr;
  int cn;
  int icon;

  ca = NUM2FLT(a);
  cb = NUM2FLT(b);
  cepsa = NUM2FLT(epsa);
  if (cepsa<0) rb_raise(rb_eRuntimeError,"epsa<0");
  cepsr = NUM2FLT(epsr);
  if (cepsr<0) rb_raise(rb_eRuntimeError,"epsr<0");
  cnmin = NUM2INT(nmin);
  if (cnmin<0) rb_raise(rb_eRuntimeError,"nmin<0");
  cnmax = NUM2INT(nmax);
  if (cnmax<cnmin) rb_raise(rb_eRuntimeError,"nmax<nmin");

  aqc8_(&ca,&cb,&ssl2_func,&cepsa,&cepsr,&cnmin,&cnmax,&cs,&cerr,&cn,&icon);

  ssl2_error(icon);
  return rb_ary_new3(3,FLT2NUM(cs),FLT2NUM(cerr),INT2NUM(cn));
}

static VALUE
rb_aqe(self,a,b,epsa,epsr,nmin,nmax)
     VALUE self,a,b,epsa,epsr,nmin,nmax;
{
  float ca,cb;
  float cepsa,cepsr;
  int cnmin,cnmax;
  float cs,cerr;
  int cn;
  int icon;

  ca = NUM2FLT(a);
  cb = NUM2FLT(b);
  cepsa = NUM2FLT(epsa);
  if (cepsa<0) rb_raise(rb_eRuntimeError,"epsa<0");
  cepsr = NUM2FLT(epsr);
  if (cepsr<0) rb_raise(rb_eRuntimeError,"epsr<0");
  cnmin = NUM2INT(nmin);
  if (cnmin<0) rb_raise(rb_eRuntimeError,"nmin<0");
  cnmax = NUM2INT(nmax);
  if (cnmax<cnmin) rb_raise(rb_eRuntimeError,"nmax<nmin");

  aqe_(&ca,&cb,&ssl2_func,&cepsa,&cepsr,&cnmin,&cnmax,&cs,&cerr,&cn,&icon);

  ssl2_error(icon);
  return rb_ary_new3(3,FLT2NUM(cs),FLT2NUM(cerr),INT2NUM(cn));
}

static VALUE
rb_aqeh(self,epsa,epsr,nmin,nmax)
     VALUE self,epsa,epsr,nmin,nmax;
{
  float cepsa,cepsr;
  int cnmin,cnmax;
  float cs,cerr;
  int cn;
  int icon;

  cepsa = NUM2FLT(epsa);
  if (cepsa<0) rb_raise(rb_eRuntimeError,"epsa<0");
  cepsr = NUM2FLT(epsr);
  if (cepsr<0) rb_raise(rb_eRuntimeError,"epsr<0");
  cnmin = NUM2INT(nmin);
  if (cnmin<0) rb_raise(rb_eRuntimeError,"nmin<0");
  cnmax = NUM2INT(nmax);
  if (cnmax<cnmin) rb_raise(rb_eRuntimeError,"nmax<nmin");

  aqeh_(&ssl2_func,&cepsa,&cepsr,&cnmin,&cnmax,&cs,&cerr,&cn,&icon);

  ssl2_error(icon);
  return rb_ary_new3(3,FLT2NUM(cs),FLT2NUM(cerr),INT2NUM(cn));
}

static VALUE
rb_aqei(self,epsa,epsr,nmin,nmax)
     VALUE self,epsa,epsr,nmin,nmax;
{
  float cepsa,cepsr;
  int cnmin,cnmax;
  float cs,cerr;
  int cn;
  int icon;

  cepsa = NUM2FLT(epsa);
  if (cepsa<0) rb_raise(rb_eRuntimeError,"epsa<0");
  cepsr = NUM2FLT(epsr);
  if (cepsr<0) rb_raise(rb_eRuntimeError,"epsr<0");
  cnmin = NUM2INT(nmin);
  if (cnmin<0) rb_raise(rb_eRuntimeError,"nmin<0");
  cnmax = NUM2INT(nmax);
  if (cnmax<cnmin) rb_raise(rb_eRuntimeError,"nmax<nmin");

  aqei_(&ssl2_func,&cepsa,&cepsr,&cnmin,&cnmax,&cs,&cerr,&cn,&icon);

  ssl2_error(icon);
  return rb_ary_new3(3,FLT2NUM(cs),FLT2NUM(cerr),INT2NUM(cn));
}


void init_numerical_differentiation_quadrature(mSSL2)
     VALUE mSSL2;
{
  rb_define_module_function(mSSL2, "simp1", rb_simp1, 2);
  rb_define_module_function(mSSL2, "trap", rb_trap, 2);
  rb_define_module_function(mSSL2, "simp2", rb_simp2, 3);
  rb_define_module_function(mSSL2, "aqn9", rb_aqn9, 6);
  rb_define_module_function(mSSL2, "aqc8", rb_aqc8, 6);
  rb_define_module_function(mSSL2, "aqe", rb_aqe, 6);
  rb_define_module_function(mSSL2, "aqeh", rb_aqeh, 4);
  rb_define_module_function(mSSL2, "aqei", rb_aqei, 4);
}
