#include <ruby.h>
#include <math.h>
#include <stdio.h>
#include <narray.h>
#include "ssl2.h"

extern void aklag_(float*,float*,int*,float*,int*,float*,float*,float*,int*);
extern void akher_(float*,float*,float*,int*,float*,int*,float*,float*,float*,int*);
extern void splv_(float*,float*,int*,int*,float*,float*,int*,float*,int*,float*,int*);
extern void bif1_(float*,int*,int*,float*,int*,float*,int*,float*,float*,int*);
extern void bif2_(float*,int*,int*,float*,int*,float*,int*,float*,float*,int*);
extern void bif3_(float*,int*,int*,float*,float*,int*,float*,int*,float*,float*,int*);
extern void bif4_(float*,int*,int*,float*,int*,float*,int*,float*,float*,int*);
extern void bifd1_(float*,int*,float*,int*,int*,float*,int*,int*,float*,int*,int*,float*,int*,float*,float*,int*);
extern void bifd3_(float*,int*,float*,int*,int*,float*,int*,float*,int*,float*,int*,int*,float*,int*,float*,float*,int*);
extern void akmid_(float*,int*,float*,int*,float*,int*,int*,float*,int*,float*,int*,float*,float*,int*);
extern void inspl(float*,float*,float*,int*,float*,float*,float*,int*);
extern void akmin(float*,float*,int*,float*,float*,float*,int*);
extern void bic1_(float*,float*,float*,int*,int*,float*,float*,int*);
extern void bic2_(float*,float*,float*,int*,int*,float*,float*,int*);
extern void bic3_(float*,float*,int*,int*,float*,float*,float*,int*);
extern void bic4_(float*,float*,int*,int*,float*,float*,int*);
extern void bicd1_(float*,int*,float*,int*,float*,int*,int*,float*,float*,int*);
extern void bicd3_(float*,int*,float*,int*,float*,int*,int*,float*,float*,float*,int*);

extern void lesq1_(float*,float*,int*,int*,float*,float*,float*,int*);

extern void smle1_(float*,int*,int*,int*,float*,int*);
extern void smle2_(float*,float*,int*,int*,int*,float*,float*,float*,int*);
extern void bsf1_(int*,float*,int*,float*,int*,float*,int*,float*,float*,int*);
extern void bsc1_(float*,float*,float*,int*,int*,float*,int*,float*,float*,float*,float*,int*,int*);
extern void bsc2_(float*,float*,float*,int*,int*,float*,int*,int*,float*,float*,float*,float*,int*,int*);
extern void bsfd1_(int*,float*,int*,float*,int*,float*,int*,int*,float*,int*,int*,float*,int*,float*,float*,int*);
extern void bscd2_(float*,int*,float*,int*,float*,int*,float*,float*,int*,float*,int*,float*,int*,int*,int*,float*,float*,int*,float*,float*,int*,int*);

extern void fcosf_(float*,float(*)(float*),float*,float*,int*,int*,float*,int*,float*,float*,int*);
extern void ecosp_(float*,float*,int*,float*,float*,int*);
extern void fsinf_(float*,float(*)(float*),float*,float*,int*,int*,float*,int*,float*,float*,int*);
extern void esinp_(float*,float*,int*,float*,float*,int*);
extern void fcheb_(float*,float*,float(*)(float*),float*,float*,int*,int*,float*,int*,float*,float*,int*);
extern void echeb_(float*,float*,float*,int*,float*,float*,int*);
extern void gcheb_(float*,float*,float*,int*,int*);
extern void icheb_(float*,float*,float*,int*,int*);

static VALUE
rb_aklag(self, x, y, v, m, eps)
     VALUE self, x, y, v, m, eps;
{
  float *cx;
  float *cy;
  int n;
  float cv;
  int cm;
  float ceps;
  float f;
  float *vw;
  int icon;

  int nn;

  cm = NUM2INT(m);
  cv = (float)NUM2DBL(v);
  ceps = (float)NUM2DBL(eps);

  cx = ssl2_getcary(x,&n);

  cy = ssl2_getcary(y,&nn);
  if ( n!=nn )
    rb_raise(rb_eRuntimeError, "y.length must be = x.length");

  if ( cm>n )
    rb_raise(rb_eRuntimeError, "m must be <= n");

  vw = ALLOC_N(float,4*n);

  aklag_(cx,cy,&n,&cv,&cm,&ceps,&f,vw,&icon);
  free(vw);
  free(cx);
  free(cy);

  ssl2_error(icon);
  return rb_ary_new3(3,rb_float_new((double)f),INT2NUM(cm),rb_float_new((double)ceps));
}


static VALUE
rb_akher(self, x, y, dy, v, m, eps)
     VALUE self, x, y, dy, v, m, eps;
{
  float *cx;
  float *cy;
  float *cdy;
  int n;
  float cv;
  int cm;
  float ceps;
  float f;
  float *vw;
  int icon;

  int nn;

  cm = NUM2INT(m);
  cv = (float)NUM2DBL(v);
  ceps = (float)NUM2DBL(eps);

  cx = ssl2_getcary(x,&n);

  cy = ssl2_getcary(y,&nn);
  if ( n!=nn )
    rb_raise(rb_eRuntimeError, "y.length must be = x.length");

  cdy = ssl2_getcary(dy,&nn);
  if ( n!=nn )
    rb_raise(rb_eRuntimeError, "dy.length must be = x.length");

  if ( cm>n )
    rb_raise(rb_eRuntimeError, "m must be <= n");

  vw = ALLOC_N(float,5*n);

  akher_(cx,cy,cdy,&n,&cv,&cm,&ceps,&f,vw,&icon);
  free(vw);
  free(cx);
  free(cy);

  ssl2_error(icon);
  return rb_ary_new3(3,rb_float_new((double)f),INT2NUM(cm),rb_float_new((double)ceps));
}


static VALUE
rb_splv(self, x, y, isw, dy, v)
     VALUE self, x, y, isw, dy, v;
{
  float *cx;
  float *cy;
  int n;
  int *cisw;
  float *cdy;
  float *cv;
  int m;
  float *dv;
  float *vw;
  int icon;

  VALUE ndv;
  int *shape;
  int nn;

  cx = ssl2_getcary(x,&n);
  if ( n<3 )
    rb_raise(rb_eRuntimeError, "x.length must be >= 3");

  cy = ssl2_getcary(y,&nn);
  if ( nn!=n )
    rb_raise(rb_eRuntimeError, "y.length must be = x.length");

  cisw = ssl2_getcaryi(isw,&nn);
  if ( nn!=2 )
    rb_raise(rb_eRuntimeError, "isw.length must be = 2");
  if ( cisw[0]<1 || 4<cisw[0] )
    rb_raise(rb_eRuntimeError, "isw[0] must be 1, 2, 3 or 4");
  if ( cisw[1]<1 || 4<cisw[1] )
    rb_raise(rb_eRuntimeError, "isw[1] must be 1, 2, 3 or 4");

  cdy = ssl2_getcary(dy,&nn);
  if ( nn!=2 )
    rb_raise(rb_eRuntimeError, "dy.length must be = 2");

  cv = ssl2_getcary(v,&m);

  dv = ALLOC_N(float,m*3);
  vw = ALLOC_N(float,2*n);

  splv_(cx,cy,&n,cisw,cdy,cv,&m,dv,&m,vw,&icon);
  free(vw);
  free(cx);
  free(cy);
  free(cisw);
  free(cdy);
  free(cv);

  shape = ALLOC_N(int,2);
  shape[0] = m;
  shape[1] = 3;
  ndv = ssl2_getary(dv,2,shape);
  free(shape);
  free(dv);

  ssl2_error(icon);
  return ndv;
}


static VALUE
rb_bif1(argc, argv, self)
     int argc; VALUE *argv, self;
{
  VALUE x, m, c, isw, v, i;

  float *cx;
  int n;
  int cm;
  float *cc;
  int cisw;
  float cv;
  int ci;
  float f;
  float *vw;
  int icon;

  int ic;

  rb_scan_args(argc, argv, "51", &x, &m, &c, &isw, &v, &i);

  cv = (float)NUM2DBL(v);
  cisw = NUM2INT(isw);
  cm = NUM2INT(m);
  if ( cm/2*2 == cm )
    rb_raise(rb_eRuntimeError, "m must be odd");
  if ( cm<3 )
    rb_raise(rb_eRuntimeError, "m must be >= 3");

  cx = ssl2_getcary(x,&n);
  if ( n<2 )
    rb_raise(rb_eRuntimeError, "x.length must be >= 2");

  cc = ssl2_getcary(c,&ic);
  if ( ic!=n+cm-1 )
    rb_raise(rb_eRuntimeError, "c.length must be n+m-1");

  if ( TYPE(isw)!=T_FIXNUM )
    rb_raise(rb_eTypeError, "isw is invalid type");

  if ( cisw>cm )
    rb_raise(rb_eRuntimeError, "isw must be < m");
  else if ( cisw<-1 )
    rb_raise(rb_eRuntimeError, "isw must be >= -1");

  if ( cv<cx[0] )
    rb_raise(rb_eRuntimeError, "v must be >= x[0]");
  else if ( cv>cx[n-1] )
    rb_raise(rb_eRuntimeError, "v must be <= x[-1]");

  if ( i==Qnil )
    ci = ssl2_where(cv,cx,n);
  else
    ci = NUM2INT(i);

  vw = ALLOC_N(float,cm+1);

  bif1_(cx,&n,&cm,cc,&cisw,&cv,&ci,&f,vw,&icon);
  free(vw);
  free(cx);
  free(cc);

  ssl2_error(icon);
  return rb_ary_new3(2,rb_float_new((double)f),INT2NUM(ci));
}


static VALUE
rb_bif2(argc, argv, self)
     int argc; VALUE *argv, self;
{
  VALUE x, m, c, isw, v, i;

  float *cx;
  int n;
  int cm;
  float *cc;
  int cisw;
  float cv;
  int ci;
  float f;
  float *vw;
  int icon;

  int ic;

  rb_scan_args(argc, argv, "51", &x, &m, &c, &isw, &v, &i);

  cv = (float)NUM2DBL(v);
  cisw = NUM2INT(isw);
  cm = NUM2INT(m);
  if ( cm/2*2 == cm )
    rb_raise(rb_eRuntimeError, "m must be odd");

  if ( cm<3 )
    rb_raise(rb_eRuntimeError, "m must be >= 3");

  cx = ssl2_getcary(x,&n);
  if ( n<(cm+1)/2 )
    rb_raise(rb_eRuntimeError, "x.length must be >= (m+1)/2");

  cc = ssl2_getcary(c,&ic);
  if ( ic!=n+cm-1 )
    rb_raise(rb_eRuntimeError, "c.length must be n+m-1");

  if ( TYPE(isw)!=T_FIXNUM )
    rb_raise(rb_eTypeError, "isw is invalid type");

  if ( cisw>cm )
    rb_raise(rb_eRuntimeError, "isw must be < m");
  else if ( cisw<-1 )
    rb_raise(rb_eRuntimeError, "isw must be >= -1");

  if ( cv<cx[0] )
    rb_raise(rb_eRuntimeError, "v must be >= x[0]");
  else if ( cv>cx[n-1] )
    rb_raise(rb_eRuntimeError, "v must be <= x[-1]");

  if ( i==Qnil )
    ci = ssl2_where(cv,cx,n);
  else
    ci = NUM2INT(i);

  vw = ALLOC_N(float,cm+1);

  bif2_(cx,&n,&cm,cc,&cisw,&cv,&ci,&f,vw,&icon);
  free(vw);
  free(cx);
  free(cc);

  ssl2_error(icon);
  return rb_ary_new3(2, rb_float_new((double)f), INT2NUM(ci));
}


static VALUE
rb_bif3(argc, argv, self)
     int argc; VALUE *argv, self;
{
  VALUE x, m, c, xt, isw, v, i;

  float *cx;
  int n;
  int cm;
  float *cc;
  float *cxt;
  int cisw;
  float cv;
  int ci;
  float f;
  float *vw;
  int icon;

  int ic;

  rb_scan_args(argc, argv, "61", &x, &m, &c, &xt, &isw, &v, &i);

  cv = (float)NUM2DBL(v);
  cisw = NUM2INT(isw);
  cm = NUM2INT(m);
  if ( cm/2*2 == cm )
    rb_raise(rb_eRuntimeError, "m must be odd");
  if ( cm<3 )
    rb_raise(rb_eRuntimeError, "m must be >= 3");

  cx = ssl2_getcary(x,&n);
  if ( n<cm+2 )
    rb_raise(rb_eRuntimeError, "x.length must be >= m+2");

  cc = ssl2_getcary(c,&ic);
  if ( ic!=n )
    rb_raise(rb_eRuntimeError, "c.length must be n");

  cxt = ssl2_getcary(xt,&ic);
  if ( ic!=n-cm+1 )
    rb_raise(rb_eRuntimeError, "xt.length must be c-m+1");

  if ( TYPE(isw)!=T_FIXNUM )
    rb_raise(rb_eTypeError, "isw is invalid type");

  if ( cisw>cm )
    rb_raise(rb_eRuntimeError, "isw must be < m");
  else if ( cisw<-1 )
    rb_raise(rb_eRuntimeError, "isw must be >= -1");

  if ( cv<cx[0] )
    rb_raise(rb_eRuntimeError, "v must be >= x[0]");
  else if ( cv>cx[n-1] )
    rb_raise(rb_eRuntimeError, "v must be <= x[-1]");

  if ( i==Qnil )
    ci = ssl2_where(cv,cx,n);
  else
    ci = NUM2INT(i);

  vw = ALLOC_N(float,2*cm+2);

  bif3_(cx,&n,&cm,cc,cxt,&cisw,&cv,&ci,&f,vw,&icon);
  free(vw);
  free(cx);
  free(cc);
  free(cxt);

  ssl2_error(icon);
  return rb_ary_new3(2, rb_float_new((double)f), INT2NUM(ci));
}


static VALUE
rb_bif4(argc, argv, self)
     int argc; VALUE *argv, self;
{
  VALUE  x, m, c, isw, v, i;

  float *cx;
  int n;
  int cm;
  float *cc;
  int cisw;
  float cv;
  int ci;
  float f;
  float *vw;
  int icon;

  int ic;

  rb_scan_args(argc, argv, "51", &x, &m, &c, &isw, &v, &i);

  cv = (float)NUM2DBL(v);
  cisw = NUM2INT(isw);
  cm = NUM2INT(m);
  if ( cm/2*2 == cm )
    rb_raise(rb_eRuntimeError, "m must be odd");
  if ( cm<3 )
    rb_raise(rb_eRuntimeError, "m must be >= 3");

  cx = ssl2_getcary(x,&n);
  if ( n<cm+2 )
    rb_raise(rb_eRuntimeError, "x.length must be >= m+2");

  cc = ssl2_getcary(c,&ic);
  if ( ic!=n+cm-1 )
    rb_raise(rb_eRuntimeError, "c.length must be n+m-1");

  if ( TYPE(isw)!=T_FIXNUM )
    rb_raise(rb_eTypeError, "isw is invalid type");

  if ( cisw>cm )
    rb_raise(rb_eRuntimeError, "isw must be < m");
  else if ( cisw<-1 )
    rb_raise(rb_eRuntimeError, "isw must be >= -1");

  if ( cv<cx[0] )
    rb_raise(rb_eRuntimeError, "v must be >= x[0]");
  else if ( cv>cx[n-1] )
    rb_raise(rb_eRuntimeError, "v must be <= x[-1]");

  if ( i==Qnil )
    ci = ssl2_where(cv,cx,n);
  else
    ci = NUM2INT(i);

  vw = ALLOC_N(float,cm+1);

  bif4_(cx,&n,&cm,cc,&cisw,&cv,&ci,&f,vw,&icon);
  free(vw);
  free(cx);
  free(cc);

  ssl2_error(icon);
  return rb_ary_new3(2, rb_float_new((double)f), INT2NUM(ci));
}


static VALUE
rb_bifd1(self, x, y, m, c, iswx, vx, ix, iswy, vy, iy)
     VALUE self, x, y, m, c, iswx, vx, ix, iswy, vy, iy;
{
  float *cx;
  int nx;
  float *cy;
  int ny;
  int cm;
  float *cc;
  int k;
  int ciswx;
  float *cvx;
  int cix;
  int ciswy;
  float *cvy;
  int ciy;
  float *f;
  float *vw;
  int icon;
  int i;
  int nvx,nvy;
  int *shape,rank;
  VALUE rf;

  int nn;

  cx = ssl2_getcary(x,&nx);
  if ( nx<2 )
    rb_raise(rb_eRuntimeError, "x.length must be >=2");

  cy = ssl2_getcary(y,&ny);
  if ( ny<2 )
    rb_raise(rb_eRuntimeError, "y.length must be >=2");

  cm = NUM2INT(m);
  if ( cm<3 )
    rb_raise(rb_eRuntimeError, "m must be >= 3");
  if ( (cm/2)*2==cm )
    rb_raise(rb_eRuntimeError, "m must be odd");

  cc = ssl2_getcary(c,&nn);
  k = nn/(ny+cm-1);
  if ( nn!=(nx+cm-1)*(ny+cm-1) )
    rb_raise(rb_eRuntimeError, "c.length must be (nx+m-1)*(ny+m-1)");

  ciswx = NUM2INT(iswx);
  if ( ciswx<-1 )
    rb_raise(rb_eRuntimeError, "iswx must be >= -1");
  if ( ciswx>cm )
    rb_raise(rb_eRuntimeError, "iswx must be <= m");

  cvx = ssl2_getcary_withshape(vx,&shape,&rank);
  for (i=1,nvx=shape[0]; i<rank; i++){
    nvx *= shape[i];
  }

  if (ix==Qnil)
    cix = ssl2_where(cvx[0],cx,nx);
  else
    cix = NUM2INT(ix);

  ciswy = NUM2INT(iswy);
  if ( ciswy<-1 )
    rb_raise(rb_eRuntimeError, "iswy must be >= -1");
  if ( ciswy>cm )
    rb_raise(rb_eRuntimeError, "iswy must be <= m");

  cvy = ssl2_getcary(vy,&nvy);
  if ( nvy != nvx )
    rb_raise(rb_eRuntimeError, "vx and vy must have the same length");

  if (iy==Qnil)
    ciy = ssl2_where(cvy[0],cy,ny);
  else
    ciy = NUM2INT(iy);

  vw = ALLOC_N(float,4*(cm+1)+MAX(nx,ny)+cm-1);

  f = ALLOC_N(float,nvx);

  for (i=0; i<nvx; i++){
    if ( cvx[i] < cx[0] )
      rb_raise(rb_eRuntimeError, "vx must be >= x[0]==%g (vx[%d]==%g)",
	       cx[0],i,cvx[i]);
    if ( cvx[i] > cx[nx-1] )
      rb_raise(rb_eRuntimeError, "vx must be <= x[-1]==%g (vx[%d]==%g)",
	       cx[nx-1],i,cvx[i]);
    if ( cvy[i] < cy[0] )
      rb_raise(rb_eRuntimeError, "vy must be >= y[0]==%g (vy[%d]==%g)",
	       cy[0],i,cvy[i]);
    if ( cvy[i] > cy[ny-1] )
      rb_raise(rb_eRuntimeError, "vy must be <= y[-1]==%g (vy[%d]==%g)",
	       cy[ny-1],i,cvy[i]);
    bifd1_(cx,&nx,cy,&ny,&cm,cc,&k,&ciswx,&cvx[i],&cix,&ciswy,&cvy[i],
	  &ciy,&f[i],vw,&icon);
    ssl2_error(icon);
  }

  free(cx);
  free(cy);
  free(cc);
  free(vw);
  free(cvx);
  free(cvy);

  switch (TYPE(vx)) {
    case T_FIXNUM:
    case T_BIGNUM:
    case T_FLOAT:
      rf = rb_float_new((double)f[0]);
      break;
    default:
      rf = ssl2_getary(f,rank,shape);
      break;
  }

  free(shape);
  free(f);

  return rb_ary_new3(3, INT2NUM(cix), INT2NUM(ciy), rf);
}


static VALUE
rb_bifd3(self, x, y, m, c, xt, iswx, vx, ix, iswy, vy, iy)
     VALUE  self, x, y, m, c, xt, iswx, vx, ix, iswy, vy, iy;
{
  float *cx;
  int nx;
  float *cy;
  int ny;
  int cm;
  float *cc;
  float *cxt;
  int ciswx;
  float *cvx;
  int cix;
  int ciswy;
  float *cvy;
  int ciy;
  float *f;
  float *vw;
  int icon;
  int i;
  int nvx,nvy;
  int *shape,rank;
  VALUE rf;

  int nn;

  cx = ssl2_getcary(x,&nx);
  if ( nx<2 )
    rb_raise(rb_eRuntimeError, "x.length must be >=2");

  cy = ssl2_getcary(y,&ny);
  if ( ny<2 )
    rb_raise(rb_eRuntimeError, "y.length must be >=2");

  cm = NUM2INT(m);
  if ( cm<3 )
    rb_raise(rb_eRuntimeError, "m must be >= 3");
  if ( (cm/2)*2==cm )
    rb_raise(rb_eRuntimeError, "m must be odd");

  cc = ssl2_getcary(c,&nn);
  if ( nn!=nx*ny )
    rb_raise(rb_eRuntimeError, "c.length must be nx*ny");

  cxt = ssl2_getcary(xt,&nn);
  if ( nn!=(nx+cm-1)*(ny+cm-1) )
    rb_raise(rb_eRuntimeError, "xt.length must be (nx+m-1)*(ny+m-1)");

  ciswx = NUM2INT(iswx);
  if ( ciswx<-1 )
    rb_raise(rb_eRuntimeError, "iswx must be >= -1");
  if ( ciswx>cm )
    rb_raise(rb_eRuntimeError, "iswx must be <= m");

  cvx = ssl2_getcary_withshape(vx,&shape,&rank);
  for (i=1,nvx=shape[0]; i<rank; i++){
    nvx *= shape[i];
  }

  if (ix==Qnil)
    cix = ssl2_where(cvx[0],cx,nx);
  else
    cix = NUM2INT(ix);

  ciswy = NUM2INT(iswy);
  if ( ciswy<-1 )
    rb_raise(rb_eRuntimeError, "iswy must be >= -1");
  if ( ciswy>cm )
    rb_raise(rb_eRuntimeError, "iswy must be <= m");

  cvy = ssl2_getcary(vy,&nvy);
  if ( nvy != nvx )
    rb_raise(rb_eRuntimeError, "vx and vy must have the same length");

  if (iy==Qnil)
    ciy = ssl2_where(cvy[0],cy,ny);
  else
    ciy = NUM2INT(iy);

  vw = ALLOC_N(float,4*(cm+1)+MAX(nx,ny));
  f = ALLOC_N(float,nvx);

  for (i=0; i<nvx; i++){
    if ( cvx[i] < cx[0] )
      rb_raise(rb_eRuntimeError, "vx must be >= x[0]==%g (vx[%d]==%g)",
	       cx[0],i,cvx[i]);
    if ( cvx[i] > cx[nx-1] )
      rb_raise(rb_eRuntimeError, "vx must be <= x[-1]==%g (vx[%d]==%g)",
	       cx[nx-1],i,cvx[i]);
    if ( cvy[i] < cy[0] )
      rb_raise(rb_eRuntimeError, "vy must be >= y[0]==%g (vy[%d]==%g)",
	       cy[0],i,cvy[i]);
    if ( cvy[i] > cy[ny-1] )
      rb_raise(rb_eRuntimeError, "vy must be <= y[-1]==%g (vy[%d]==%g)",
	       cy[ny-1],i,cvy[i]);
    bifd3_(cx,&nx,cy,&ny,&cm,cc,&nx,cxt,&ciswx,&cvx[i],&cix,&ciswy,&cvy[i],
	   &ciy,&f[i],vw,&icon);
    ssl2_error(icon);
  }

  free(cx);
  free(cy);
  free(cc);
  free(cxt);
  free(vw);
  free(cvx);
  free(cvy);

  switch (TYPE(vx)) {
    case T_FIXNUM:
    case T_BIGNUM:
    case T_FLOAT:
      rf = rb_float_new((double)f[0]);
      break;
    default:
      rf = ssl2_getary(f,rank,shape);
      break;
  }

  free(shape);
  free(f);

  return rb_ary_new3(3, INT2NUM(cix), INT2NUM(ciy), rf);
}


static VALUE
rb_akmid(self, x, y, fxy, vx, vy, vw, isw)
     VALUE self, x, y, fxy, vx, vy, vw, isw;
{
  float *cx;
  int nx;
  float *cy;
  int ny;
  float *cfxy;
  int cisw;
  float cvx;
  int ix;
  float cvy;
  int iy;
  float f;
  float *cvw;
  int icon;

  VALUE nvw;
  int shape[1];

  int nn;

  cx = ssl2_getcary(x,&nx);
  if ( nx<3 )
    rb_raise(rb_eRuntimeError, "nx must be >=3 ");

  cy = ssl2_getcary(y,&ny);
  if ( ny<3 )
    rb_raise(rb_eRuntimeError, "ny must be >=3 ");

  cfxy = ssl2_getcary(fxy,&nn);
  if ( nn!=nx*ny )
    rb_raise(rb_eRuntimeError, "fxy.length must be nx*ny");

  cisw = NUM2INT(isw);

  cvx = (float) NUM2DBL(vx);
  if ( cvx<cx[0] )
    rb_raise(rb_eRuntimeError, "vx must be >= x[0]");
  if ( cvx>cx[nx-1] )
    rb_raise(rb_eRuntimeError, "vx must be <= x[-1]");

  for ( ix=0; ix<nx; ix++ ){
    if ( cvx<cx[ix] ) break;
  }

  cvy = (float) NUM2DBL(vy);
  if ( cvy<cy[0] )
    rb_raise(rb_eRuntimeError, "vy must be >= y[0]");
  if ( cvy>cy[ny-1] )
    rb_raise(rb_eRuntimeError, "vy must be <= y[-1]");

  for ( iy=0; iy<ny; iy++ ){
    if ( cvy<cy[iy] ) break;
  }

  cvw = ssl2_getcary(vw,&nn);
  if ( nn!=50 )
    rb_raise(rb_eRuntimeError, "vw.length must be 50");


  akmid_(cx,&nx,cy,&ny,cfxy,&nx,&cisw,&cvx,&ix,&cvy,&iy,&f,cvw,&icon);
  free(cx);
  free(cy);
  free(cfxy);

  shape[0] = 50;
  nvw = ssl2_getary(cvw,1,shape);
  free(cvw);

  ssl2_error(icon);
  return rb_ary_new3(2,rb_float_new((double)f),nvw);
}


static VALUE
rb_inspl(self, x, y, dy)
     VALUE self, x, y, dy;
{
  float *cx;
  float *cy;
  float *cdy;
  int n;
  float *c;
  float *d;
  float *e;
  int icon;

  VALUE nc, nd, ne;
  int shape[1];

  int nn;

  cx = ssl2_getcary(x,&n);
  if ( n<2 )
    rb_raise(rb_eRuntimeError, "x.length must be >= 2");

  cy = ssl2_getcary(y,&nn);
  if ( nn!=n )
    rb_raise(rb_eRuntimeError, "y.length must be x.length");

  cdy = ssl2_getcary(dy,&nn);
  if ( nn!=n )
    rb_raise(rb_eRuntimeError, "dy.length must be x.length");


  c = ALLOC_N(float,n);
  d = ALLOC_N(float,n);
  e = ALLOC_N(float,n);
  inspl_(cx,cy,cdy,&n,c,d,e,&icon);
  free(cx);
  free(cy);
  free(cdy);

  shape[0]=n;
  nc = ssl2_getary(c,1,shape);
  nd = ssl2_getary(d,1,shape);
  ne = ssl2_getary(e,1,shape);
  free(c);
  free(d);
  free(e);

  ssl2_error(icon);
  return rb_ary_new3(3,nc,nd,ne);
}


static VALUE
rb_akmin(self, x, y)
     VALUE self, x, y;
{
  float *cx;
  float *cy;
  int n;
  float *c;
  float *d;
  float *e;
  int icon;

  VALUE nc, nd, ne;
  int shape[1];

  int nn;

  cx = ssl2_getcary(x,&n);
  if ( n<3 )
    rb_raise(rb_eRuntimeError, "x.length must be >= 3");

  cy = ssl2_getcary(y,&nn);
  if ( nn!=n )
    rb_raise(rb_eRuntimeError, "y.length must be x.length");


  c = ALLOC_N(float,n-1);
  d = ALLOC_N(float,n-1);
  e = ALLOC_N(float,n-1);
  akmin_(cx,cy,&n,c,d,e,&icon);
  free(cx);
  free(cy);

  shape[0]=n-1;
  nc = ssl2_getary(c,1,shape);
  nd = ssl2_getary(d,1,shape);
  ne = ssl2_getary(e,1,shape);
  free(c);
  free(d);
  free(e);

  ssl2_error(icon);
  return rb_ary_new3(3,nc,nd,ne);
}


static VALUE
rb_bic1(self, x, y, dy, m)
     VALUE self, x, y, dy, m;
{
  float *cx;
  float *cy;
  float *cdy;
  int n;
  int cm;
  float *c;
  float *vw;
  int icon;

  VALUE nc;
  int *shape;

  int nn;

  cm = NUM2INT(m);
  if ( cm/2*2 == cm )
    rb_raise(rb_eRuntimeError, "m must be odd");
  if ( cm<3 )
    rb_raise(rb_eRuntimeError, "m must be >= 3");

  cx = ssl2_getcary(x,&n);

  if ( n<2 )
    rb_raise(rb_eRuntimeError, "x.length must be >= 2");

  cy = ssl2_getcary(y,&nn);

  if ( nn!=n )
    rb_raise(rb_eRuntimeError, "y.length must be x.length");

  cdy = ssl2_getcary(dy,&nn);

  if ( nn!=(cm-1) )
    rb_raise(rb_eRuntimeError, "dy.length must be m-1");

  vw =  ALLOC_N(float,(n-1)*cm+(cm+1)*(cm+1)/2+(cm+1));
  c = ALLOC_N(float,n+cm-1);

  bic1_(cx,cy,cdy,&n,&cm,c,vw,&icon);
  free(vw);
  free(cx);
  free(cy);
  free(cdy);

  shape = ALLOC_N(int,1);
  shape[0] = n+cm-1;
  nc = ssl2_getary(c,1,shape);
  free(shape);

  ssl2_error(icon);
  return nc;
}


static VALUE
rb_bic2(self, x, y, dy, m)
     VALUE self, x, y, dy, m;
{
  float *cx;
  float *cy;
  float *cdy;
  int n;
  int cm;
  float *c;
  float *vw;
  int icon;

  VALUE nc;
  int *shape;

  int nn;

  cm = NUM2INT(m);
  if ( cm/2*2 == cm )
    rb_raise(rb_eRuntimeError, "m must be odd");
  if ( cm<3 )
    rb_raise(rb_eRuntimeError, "m must be >= 3");

  cx = ssl2_getcary(x,&n);

  if ( n<(cm+1)/2 )
    rb_raise(rb_eRuntimeError, "x.length must be >= (m+1)/2");

  cy = ssl2_getcary(y,&nn);

  if ( nn!=n )
    rb_raise(rb_eRuntimeError, "y.length must be x.length");

  cdy = ssl2_getcary(dy,&nn);

  if ( nn!=(cm-1) )
    rb_raise(rb_eRuntimeError, "dy.length must be m-1");

  vw = ALLOC_N(float,cm*(n+cm-3)+2*(cm+1));
  c = ALLOC_N(float,n+cm-1);

  bic2_(cx,cy,cdy,&n,&cm,c,vw,&icon);
  free(vw);
  free(cx);
  free(cy);
  free(cdy);

  shape = ALLOC_N(int,1);
  shape[0] = n+cm-1;
  nc = ssl2_getary(c,1,shape);
  free(shape);
  free(c);

  ssl2_error(icon);
  return nc;
}


static VALUE
rb_bic3(self, x, y, m)
     VALUE self, x, y, m;
{
  float *cx;
  float *cy;
  int n;
  int cm;
  float *c;
  float *xt;
  float *vw;
  int icon;

  VALUE nc, nxt;
  int shape[1];

  int nn;

  cm = NUM2INT(m);
  if ( cm/2*2 == cm )
    rb_raise(rb_eRuntimeError, "m must be odd");
  if ( cm<3 )
    rb_raise(rb_eRuntimeError, "m must be >= 3");

  cx = ssl2_getcary(x,&n);
  if ( n<cm+2 )
    rb_raise(rb_eRuntimeError, "x.length must be >= (m+1)/2");

  cy = ssl2_getcary(y,&nn);
  if ( nn!=n )
    rb_raise(rb_eRuntimeError, "y.length must be x.length");



  c = ALLOC_N(float,n);
  xt = ALLOC_N(float,n-cm+1);
  vw = ALLOC_N(float,cm*n+2);

  bic3_(cx,cy,&n,&cm,c,xt,vw,&icon);
  free(cx);
  free(cy);
  free(vw);

  shape[0] = n;
  nc = ssl2_getary(c,1,shape);
  free(c);
  shape[0] = n-cm+1;
  nxt = ssl2_getary(xt,1,shape);
  free(xt);

  ssl2_error(icon);
  return rb_ary_new3(2,nc,nxt);
}


static VALUE
rb_bic4(self, x, y, m)
     VALUE self, x, y, m;
{
  float *cx;
  float *cy;
  int n;
  int cm;
  float *c;
  float *vw;
  int icon;

  VALUE nc, nxt;
  int shape[1];

  int nn;

  cm = NUM2INT(m);
  if ( cm/2*2 == cm )
    rb_raise(rb_eRuntimeError, "m must be odd");
  if ( cm<3 )
    rb_raise(rb_eRuntimeError, "m must be >= 3");

  cx = ssl2_getcary(x,&n);
  if ( n<cm+2 )
    rb_raise(rb_eRuntimeError, "x.length must be >= (m+1)/2");

  cy = ssl2_getcary(y,&nn);
  if ( nn!=n )
    rb_raise(rb_eRuntimeError, "y.length must be x.length");


  c = ALLOC_N(float,n+cm-1);
  vw = ALLOC_N(float,(n-1)*(2*cm-1)+cm+1);

  bic4_(cx,cy,&n,&cm,c,vw,&icon);
  free(cx);
  free(cy);
  free(vw);

  shape[0] = n+cm-1;
  nc = ssl2_getary(c,1,shape);
  free(c);

  ssl2_error(icon);
  return nc;
}


static VALUE
rb_bicd1(self, x, y, fxy, m)
     VALUE self, x, y, fxy, m;
{
  float *cx;
  int nx;
  float *cy;
  int ny;
  float *cfxy;
  int k;
  int cm;
  float *c;
  float *vw;
  int icon;

  VALUE nc;
  int shape[2];

  int nn;

  cm = NUM2INT(m);
  if ( cm<3 )
    rb_raise(rb_eRuntimeError, "m must be >= 3");

  cx = ssl2_getcary(x,&nx);
  if ( nx<2 )
    rb_raise(rb_eRuntimeError, "x.length must be >= 2");

  cy = ssl2_getcary(y,&ny);
  if ( ny<2 )
    rb_raise(rb_eRuntimeError, "y.length must be >= 2");

  cfxy = ssl2_getcary(fxy,&nn);
  k = nn/(ny+cm-1);
  if ( nn!=(nx+cm-1)*(ny+cm-1) )
    rb_raise(rb_eRuntimeError, "fxy.length must be (nx+m-1)*(ny+m-1)");


  c = ALLOC_N(float,(nx+cm-1)*(ny+cm-1));
  vw = ALLOC_N(float,(MAX(nx,ny)+1)*(cm*2)-3+(cm+1)*(cm+1)/2);
  bicd1_(cx,&nx,cy,&ny,cfxy,&k,&cm,c,vw,&icon);
  free(cx);
  free(cy);
  free(cfxy);
  free(vw);

  shape[0] = nx+cm-1;
  shape[1] = ny+cm-1;
  nc = ssl2_getary(c,2,shape);
  free(c);

  ssl2_error(icon);
  return nc;
}


static VALUE
rb_bicd3(self, x, y, fxy, m)
     VALUE self, x, y, fxy, m;
{
  float *cx;
  int nx;
  float *cy;
  int ny;
  float *cfxy;
  int cm;
  float *c;
  float *xt;
  float *vw;
  int icon;

  VALUE nc, nxt;
  int *shape;

  int nn;

  cx = ssl2_getcary(x,&nx);
  if ( nx<2 )
    rb_raise(rb_eRuntimeError, "x.length must be >= 2");

  cy = ssl2_getcary(y,&ny);
  if ( ny<2 )
    rb_raise(rb_eRuntimeError, "y.length must be >= 2");

  cfxy = ssl2_getcary(fxy,&nn);
  if ( nn!=nx*ny )
    rb_raise(rb_eRuntimeError, "fxy.length must be nx*ny");

  cm = NUM2INT(m);
  if ( cm<3 )
    rb_raise(rb_eRuntimeError, "m must be >= 3");

  c = ALLOC_N(float,nx*ny);
  xt = ALLOC_N(float,(nx+cm-1)*(ny+cm-1));
  vw = ALLOC_N(float,(MAX(nx,ny)-2)*cm+2*(cm+1)+2*MAX(nx,ny));
  bicd3_(cx,&nx,cy,&ny,cfxy,&nx,&cm,c,xt,vw,&icon);
  free(cx);
  free(cy);
  free(cfxy);
  free(vw);

  shape = ALLOC_N(int,2);
  shape[0] = nx;
  shape[1] = ny;
  nc = ssl2_getary(c,2,shape);
  free(c);
  free(shape);
  shape = ALLOC_N(int,1);
  shape[0]=(nx+cm-1)*(ny+cm-1);
  nxt = ssl2_getary(xt,1,shape);
  free(xt);
  free(shape);

  ssl2_error(icon);
  return rb_ary_new3(2,nc,nxt);
}

static VALUE
rb_lesq1(self,x,y,m,w)
     VALUE self,x,y,m,w;
{
  float *cx, *cy;
  int n;
  int cm;
  float *cw;
  float *cc;
  float *vw;
  int icon;

  VALUE c;
  int shape[1];

  int nn;
  int i;

  cx = ssl2_getcary(x,&n);
  if (n<2) rb_raise(rb_eRuntimeError,"n<2");
  cy = ssl2_getcary(y,&nn);
  if (nn!=n) rb_raise(rb_eRuntimeError,"y.length != x.length");
  cm = NUM2INT(m);
  if (abs(cm)>n-1) rb_raise(rb_eRuntimeError,"abs(m)>n-1");
  cw = ssl2_getcary(w,&nn);
  if (nn!=n) rb_raise(rb_eRuntimeError,"w.length != x.lenth");
  for (i=0;i<n;i++)
    if (cw[i]<0) rb_raise(rb_eRuntimeError,"w[%d]<0",i);
  
  cc = ALLOC_N(float,abs(cm)+1);
  vw = ALLOC_N(float,7*n);
  lesq1_(cx,cy,&n,&cm,cw,cc,vw,&icon);
  free(cx);
  free(cy);
  free(cw);
  free(vw);

  shape[0]=abs(cm+1);
  c = ssl2_getary(cc,1,shape);
  free(cc);

  ssl2_error(icon);
  return c;
}

static VALUE
rb_smle1(self,y,m,l)
     VALUE self,y,m,l;
{
  float *cy;
  int n;
  int cm,cl;
  float *cf;
  int icon;

  VALUE f;
  int shape[1];

  cy = ssl2_getcary(y,&n);
  cm = NUM2INT(m);
  cl = NUM2INT(l);
  if (n<l) rb_raise(rb_eRuntimeError,"n<l");
  if (cm!=1&&cm!=3) rb_raise(rb_eRuntimeError,"m must be 1 or 3");
  if (cm==1&&(cl!=3&&cl!=5)) rb_raise(rb_eRuntimeError,"l must be 3 or 5 when m==1");
  if (cm==3&&(cl!=5&&cl!=7)) rb_raise(rb_eRuntimeError,"l must be 5 or 7 when m==3");

  cf = ALLOC_N(float,n);
  smle1_(cy,&n,&cm,&cl,cf,&icon);
  free(cy);

  shape[0]=n;
  f = ssl2_getary(cf,1,shape);
  free(cf);

  ssl2_error(icon);
  return f;
}

static VALUE
rb_smle2(self,x,y,m,l,w)
     VALUE self,x,y,m,l,w;
{
  float *cx,*cy;
  int n;
  int cm,cl;
  float *cw;
  float *cf;
  float *vw;
  int icon;

  VALUE f;
  int shape[1];

  int nn;
  int i;

  cx = ssl2_getcary(x,&n);
  for (i=0;i<n-1;i++)
    if (cx[i]>cx[i+1]) rb_raise(rb_eRuntimeError,"x[%d]>x[%d]",i,i+1);
  cy = ssl2_getcary(x,&nn);
  if (nn!=n) rb_raise(rb_eRuntimeError,"y.length != x.length");
  cm = NUM2INT(m);
  if (m<1) rb_raise(rb_eRuntimeError,"m<1");
  cl = NUM2INT(l);
  if (n<l) rb_raise(rb_eRuntimeError,"n<l");
  if ((l/2)*2==l) rb_raise(rb_eRuntimeError,"l must be odd");
  if (m+2>2) rb_raise(rb_eRuntimeError,"m+2>l");
  cw = ssl2_getcary(w,&nn);
  if (nn!=n) rb_raise(rb_eRuntimeError,"w.length != x.length");
  for (i=0;i<n;i++)
    if (cw[i]<0) rb_raise(rb_eRuntimeError,"w[%d]<0",i);

  cf = ALLOC_N(float,n);
  vw = ALLOC_N(float,2*cl);
  smle2_(cx,cy,&n,&cm,&cl,cw,cf,vw,&icon);
  free(cx);
  free(cy);
  free(cw);
  free(vw);

  shape[0]=n;
  f = ssl2_getary(cf,1,shape);
  free(cf);

  ssl2_error(icon);
  return f;
}

static VALUE
rb_bsf1(self,m,xt,c,isw,v)
     VALUE self,m,xt,c,isw,v;
{
  int cm;
  float *cxt;
  int nt;
  float *cc;
  int cisw;
  float cv;
  int i;
  float cf;
  float *vw;
  int icon;

  int nn;

  cm = NUM2INT(m);
  if (cm<1) rb_raise(rb_eRuntimeError,"m<1");
  cxt = ssl2_getcary(xt,&nt);
  if (nt<3) rb_raise(rb_eRuntimeError,"nt<3");
  for (i=0;i<nt-1;i++)
    if (cxt[i]>cxt[i+1]) rb_raise(rb_eRuntimeError,"xt[%d]>xt[%d]",i,i+1);
  cc = ssl2_getcary(c,&nn);
  if (nn!=nt+cm-1) rb_raise(rb_eRuntimeError,"nn!=nt+m-1");
  cisw = NUM2INT(isw);
  if (cisw<-1) rb_raise(rb_eRuntimeError,"isw<-1");
  if (cisw>cm) rb_raise(rb_eRuntimeError,"isw>m");
  cv = NUM2FLT(v);
  if (cv<cxt[0]) rb_raise(rb_eRuntimeError,"v<xt[0]");
  if (cv>cxt[nt-1]) rb_raise(rb_eRuntimeError,"v>xt[-1]");
  for (i=0;i<nt-1;i++)
    if (cv<cxt[i+1]) break;

  vw = ALLOC_N(float,cm+1);
  bsf1_(&cm,cxt,&nt,cc,&cisw,&cv,&i,&cf,vw,&icon);
  free(cxt);
  free(cc);
  free(vw);

  ssl2_error(icon);
  return rb_float_new((double)cf);
}

static VALUE
rb_bsc1(self,x,y,w,m,xt)
     VALUE self,x,y,w,m,xt;
{
  float *cx,*cy;
  float *cw;
  int n;
  int cm;
  float *cxt;
  int nt;
  float *cc;
  float *cr;
  float crnor;
  float *vw;
  int *ivw;
  int icon;

  VALUE c,r;
  int shape[1];

  int nn;
  int i;

  cx = ssl2_getcary(x,&n);
  cy = ssl2_getcary(y,&nn);
  if (nn!=n) rb_raise(rb_eRuntimeError,"y.length != x.length");
  cw = ssl2_getcary(w,&nn);
  if (nn!=n) rb_raise(rb_eRuntimeError,"w.length != x.length");
  for (i=0;i<n;i++)
    if (cw[i]<0) rb_raise(rb_eRuntimeError,"w[%d]<0",i);
  cm = NUM2INT(m);
  if (m<1) rb_raise(rb_eRuntimeError,"m<1");
  cxt = ssl2_getcary(xt,&nt);
  if (nt<3) rb_raise(rb_eRuntimeError,"xt.length < 3");

  cc = ALLOC_N(float,nt+cm-1);
  cr = ALLOC_N(float,n);
  vw = ALLOC_N(float,(nt+cm)*(cm+1));
  ivw = ALLOC_N(int,n);
  bsc1_(cx,cy,cw,&n,&cm,cxt,&nt,cc,cr,&crnor,vw,ivw,&icon);
  free(cx);
  free(cy);
  free(cw);
  free(cxt);
  free(vw);
  free(ivw);

  shape[0] = nt+cm-1;
  c = ssl2_getary(cc,1,shape);
  free(cc);
  shape[0] = n;
  r = ssh2_getary(cr,1,shape);
  free(cr);

  ssl2_error(icon);
  return rb_ary_new3(3,c,r,FLT2NUM(crnor));
}

static VALUE
rb_bsc2(self,x,y,s,m,xt,nl,rnot)
     VALUE self,x,y,s,m,xt,nl,rnot;
{
  float *cx,*cy,*cs;
  int n;
  int cm;
  float *cxt;
  int nt;
  int cnl;
  float crnot;
  float *cc;
  float *crnor;
  float *vw;
  int *ivw;
  int icon;

  VALUE c,rnor;
  int shape[2];

  int ns;

  int nn;
  int i;

  cx = ssl2_getcary(x,&n);
  cy = ssl2_getcary(y,&nn);
  if (nn!=n) rb_raise(rb_eRuntimeError,"y.length != x.length");
  cs = ssl2_getcary(s,&nn);
  if (nn!=n) rb_raise(rb_eRuntimeError,"s.length != x.length");
  for (i=0;i<n;i++)
    if (cs[i]<=0) rb_raise(rb_eRuntimeError,"s[%d] <= 0",i);
  cm = NUM2INT(m);
  if (cm<1) rb_raise(rb_eRuntimeError,"m<1");
  cxt = ssl2_getcary(xt,&nt);
  ns = nt;
  if (ns<2) rb_raise(rb_eRuntimeError,"nt<2");
  cnl = NUM2INT(nl);
  if (cnl<ns) rb_raise(rb_eRuntimeError,"nl<nt");
  crnot = NUM2FLT(rnot);

  cc = ALLOC_N(float,cnl+cm-1);
  crnor = ALLOC_N(float,3*(cnl-ns+1));
  vw = ALLOC_N(float,(cm+1)*(cm+2)*(cnl+cm));
  ivw = ALLOC_N(int,n+cnl+cm);
  bsc2_(cx,cy,cs,&n,&cm,cxt,&nt,&cnl,&crnot,cc,crnor,vw,ivw,&icon);
  free(cx);
  free(cy);
  free(cs);
  free(vw);
  free(ivw);

  shape[0] = nt;
  xt = ssl_getary(cxt,1,shape);
  free(cxt);
  shape[0] = nt+cm-1;
  c = ssl2_getary(cc,1,shape);
  free(cc);
  shape[0] = 3;
  shape[1] = nt-ns+1;
  rnor = ssl2_getary(crnor,2,shape);
  free(crnor);

  ssl2_error(icon);
  return rb_ary_new3(3,xt,c,rnor);
}

static VALUE
rb_bsfd1(self,m,xt,yt,c,iswx,vx,iswy,vy)
     VALUE self,m,xt,yt,c,iswx,vx,iswy,vy;
{
  int cm;
  float *cxt,*cyt;
  int nxt,nyt;
  float *cc;
  int kc;
  int ciswx,ciswy;
  float cvx,cvy;
  int ix,iy;
  float cf;
  float *vw;
  int icon;

  int rank;
  int *shape;

  cm = NUM2INT(m);
  if (m<1) rb_raise(rb_eRuntimeError,"m<1");
  cxt = ssl2_getcary(xt,&nxt);
  cyt = ssl2_getcary(yt,&nyt);
  cc = ssl2_getcary_withshape(c,&shape,&rank);
  if (rank!=2) rb_raise(rb_eRuntimeError,"c.rank != 2");
  kc = shape[0];
  if (shape[1]!=nyt+cm-1) rb_raise(rb_eRuntimeError,"c.shape[1] != yt.length+m-1");
  free(shape);
  ciswx = NUM2INT(iswx);
  if (ciswx<-1) rb_raise(rb_eRuntimeError,"iswx < -1");
  if (ciswx>cm) rb_raise(rb_eRuntimeError,"iswx > m");
  cvx = NUM2FLT(vx);
  if (cvx<cxt[0]) rb_raise(rb_eRuntimeError,"vx < xt[0]");
  if (cvx>cxt[nxt-1]) rb_raise(rb_eRuntimeError,"vx < xt[-1]");
  for (ix=0;ix<nxt-1;ix++)
    if (cvx<cxt[ix+1]) break;
  ciswy = NUM2INT(iswy);
  if (ciswy<-1) rb_raise(rb_eRuntimeError,"iswy < -1");
  if (ciswy>cm) rb_raise(rb_eRuntimeError,"iswy > m");
  cvy = NUM2FLT(vy);
  if (cvy<cyt[0]) rb_raise(rb_eRuntimeError,"vy < yt[0]");
  if (cvy>cyt[nyt-1]) rb_raise(rb_eRuntimeError,"vy < yt[-1]");
  for (iy=0;iy<nyt-1;iy++)
    if (cvy<cyt[iy+1]) break;

  vw = ALLOC_N(float,5*(cm+1)+MAX(nxt,nyt));
  bsfd1_(&cm,cxt,&nxt,cyt,&nyt,cc,&kc,&ciswx,&cvx,&ix,&ciswy,&cvy,&iy,&cf,vw,&icon);
  free(cxt);
  free(cyt);
  free(cc);
  free(vw);

  ssl2_error(icon);
  return FLT2NUM(cf);
}

static VALUE
rb_bscd2(self,x,y,fxy,sx,sy,m,xt,yt,nxl,nyl,rnot)
     VALUE self,x,y,fxy,sx,sy,m,xt,yt,nxl,nyl,rnot;
{
  float *cx,*cy;
  int nx,ny;
  float *cfxy;
  float *csx,*csy;
  int cm;
  float *cxt,*cyt;
  int nxt,nyt;
  int cnxl,cnyl;
  float crnot;
  float *cc;
  float *crnor;
  float *vw;
  int *ivw;
  int icon;

  VALUE c,rnor;
  int *shape;
  int rank;

  int nxs,nys;
  int kc;

  float *cc2;
  int nn;
  int i,j;

  cx = ssl2_getcary(x,&nx);
  cy = ssl2_getcary(y,&ny);
  cfxy = ssl2_getcary_withshape(fxy,&shape,&rank);
  if (rank!=2) rb_raise(rb_eRuntimeError,"fxy.rank != 2");
  if (shape[0]!=nx) rb_raise(rb_eRuntimeError,"fxy.shape[0] != x.length");
  if (shape[1]!=ny) rb_raise(rb_eRuntimeError,"fxy.shape[1] != y.length");
  free(shape);
  csx = ssl2_getcary(sx,&nn);
  if (nn!=nx) rb_raies(rb_eRuntimeError,"sx.length != x.length");
  for (i=0;i<nx;i++)
    if (csx[i]<=0) rb_raies(rb_eRuntimeError,"sx[%d] <= 0",i);
  csy = ssl2_getcary(sy,&nn);
  if (nn!=ny) rb_raies(rb_eRuntimeError,"sy.length != y.length");
  for (i=0;i<ny;i++)
    if (csy[i]<=0) rb_raies(rb_eRuntimeError,"sy[%d] <= 0",i);
  cm = NUM2INT(m);
  if (cm<1) rb_raise(rb_eRuntimeError,"m<1");
  cxt = ssl2_getcary(xt,&nxt);
  nxs = nxt;
  if (nxs<2) rb_raise(rb_eRuntimeError,"xt.length < 2");
  cyt = ssl2_getcary(yt,&nyt);
  nys = nyt;
  if (nys<2) rb_raise(rb_eRuntimeError,"yt.length < 2");
  cnxl = NUM2INT(nxl);
  if (cnxl>nxs) rb_raise(rb_eRuntimeError,"nxl > xt.length");
  cnyl = NUM2INT(nyl);
  if (cnyl>nys) rb_raise(rb_eRuntimeError,"nyl > yt.length");
  crnot = NUM2FLT(rnot);

  kc = cnxl+cm-1;
  cc = ALLOC_N(float,kc*(cnyl+cm-1));
  crnor = ALLOC_N(float,3*((cnxl-nxs)+(cnyl-nys)+1));
  vw = ALLOC_N(float,MAX((nx+ny+2*cm)*(cm+1)+MAX(MAX(nx+cm,ny+cm),2*MIN(nx+cm,ny+cm)*(cm+1)),(MIN(nx,ny)+3)*(cm+1)+nx+ny+cnxl+cnyl+2));
  ivw = ALLOC_N(int,nx+ny+MAX(cnxl,cnyl)*cm);
  bscd2_(cx,&nx,cy,&ny,cfxy,&nx,csx,csy,&cm,cxt,&nxt,cyt,&nyt,&cnxl,&cnyl,&crnot,cc,&kc,crnor,vw,ivw,&icon);
  free(cx);
  free(cy);
  free(cfxy);
  free(csx);
  free(csy);
  free(vw);
  free(ivw);

  cc2 = ALLOC_N(float,(nxt+cm-1)*(nyt+cm-1));
  for (j=0;j<nyt;j++)
    for (i=0;i<nxt;i++)
      cc2[i+j*nxt] = cc[i+j*cnyl];
  free(cc);
  shape = ALLOC_N(int,2);
  shape[0] = nxt+cm-1;
  shape[1] = nyt+cm-1;
  c = ssl2_getary(cc2,2,shape);
  free(cc2);
  shape[0] = 3;
  shape[1] = (nxt-nxs)+(nyt-nys)+1;
  rnor = ssl2_getary(crnor,2,shape);
  free(crnor);
  shape[0] = nxt;
  xt = ssl2_getary(cxt,1,shape);
  free(cxt);
  shape[0] = nyt;
  yt = ssl2_getary(cyt,1,shape);
  free(cyt);
  free(shape);

  ssl2_error(icon);
  return rb_ary_new3(4,xt,yt,c,rnor);
}

static VALUE
rb_fcosf(self,th,epsa,epsr,nmin,nmax)
     VALUE self,th,epsa,epsr,nmin,nmax;
{
  float cth;
  float cepsa,cepsr;
  int cnmin,cnmax;
  float *ca;
  int cn;
  float cerr;
  float *ctab;
  int icon;

  VALUE a,tab;
  int shape[1];

  cth = NUM2FLT(th);
  if (cth<=0) rb_raise(rb_eRuntimeError,"th<=0");
  cepsa = NUM2FLT(epsa);
  if (cepsa<0) rb_raise(rb_eRuntimeError,"epsa<0");
  cepsr = NUM2FLT(epsr);
  if (cepsr<0) rb_raise(rb_eRuntimeError,"epsr<0");
  cnmin = NUM2INT(nmin);
  if (cnmin<0) rb_raise(rb_eRuntimeError,"nmin<0");
  cnmax = NUM2INT(nmax);
  if (cnmax<nmin) rb_raise(rb_eRuntimeError,"nmax<nmin");

  ca = ALLOC_N(float,cnmax);
  ctab = ALLOC_N(float,MAX(3,(cnmax-3)/2));
  fcosf_(&cth,&ssl2_func,&cepsa,&cepsr,&cnmin,&cnmax,ca,&cn,&cerr,ctab,&icon);

  shape[0] = cnmax;
  a = ssl2_getary(ca,1,shape);
  free(ca);
  shape[0] = MAX(3,(cnmax-3)/2);
  tab = ssl2_getary(ctab,1,shape);
  free(ctab);

  ssl2_error(icon);
  return rb_ary_new3(4,a,INT2NUM(cn),FLT2NUM(cerr),tab);
}

static VALUE
rb_ecosp(self,th,a,v)
     VALUE self,th,a,v;
{
  float cth;
  float *ca;
  int n;
  float cv;
  float cf;
  int icon;

  cth = NUM2FLT(th);
  if (cth<=0) rb_raise(rb_eRuntimeError,"th<=0");
  ca = ssl2_getcary(a,&n);
  if (n<1) rb_raise(rb_eRuntimeError,"n<1");
  cv = NUM2FLT(v);

  ecosp_(&cth,ca,&n,&cv,&cf,&icon);
  free(ca);

  ssl2_error(icon);
  return FLT2NUM(cf);
}

static VALUE
rb_fsinf(self,th,epsa,epsr,nmin,nmax)
     VALUE self,th,epsa,epsr,nmin,nmax;
{
  float cth;
  float cepsa,cepsr;
  int cnmin,cnmax;
  float *cb;
  int cn;
  float cerr;
  float *ctab;
  int icon;

  VALUE b,tab;
  int shape[1];

  cth = NUM2FLT(th);
  if (cth<=0) rb_raise(rb_eRuntimeError,"th<=0");
  cepsa = NUM2FLT(epsa);
  if (cepsa<0) rb_raise(rb_eRuntimeError,"epsa<0");
  cepsr = NUM2FLT(epsr);
  if (cepsr<0) rb_raise(rb_eRuntimeError,"epsr<0");
  cnmin = NUM2INT(nmin);
  if (cnmin<0) rb_raise(rb_eRuntimeError,"nmin<0");
  cnmax = NUM2INT(nmax);
  if (cnmax<nmin) rb_raise(rb_eRuntimeError,"nmax<nmin");

  cb = ALLOC_N(float,cnmax);
  ctab = ALLOC_N(float,MAX(3,cnmax/2-1));
  fsinf_(&cth,&ssl2_func,&cepsa,&cepsr,&cnmin,&cnmax,cb,&cn,&cerr,ctab,&icon);

  shape[0] = cnmax;
  b = ssl2_getary(cb,1,shape);
  free(cb);
  shape[0] = MAX(3,cnmax/2-1);
  tab = ssl2_getary(ctab,1,shape);
  free(ctab);

  ssl2_error(icon);
  return rb_ary_new3(4,b,INT2NUM(cn),FLT2NUM(cerr),tab);
}

static VALUE
rb_esinp(self,th,b,v)
     VALUE self,th,b,v;
{
  float cth;
  float *cb;
  int n;
  float cv;
  float cf;
  int icon;

  cth = NUM2FLT(th);
  if (cth<=0) rb_raise(rb_eRuntimeError,"th<=0");
  cb = ssl2_getcary(b,&n);
  if (n<1) rb_raise(rb_eRuntimeError,"n<1");
  cv = NUM2FLT(v);

  esinp_(&cth,cb,&n,&cv,&cf,&icon);
  free(cb);

  ssl2_error(icon);
  return FLT2NUM(cf);
}

static VALUE
rb_fcheb(self,a,b,epsa,epsr,nmin,nmax)
     VALUE self,a,b,epsa,epsr,nmin,nmax;
{
  float ca,cb;
  float cepsa,cepsr;
  int cnmin,cnmax;
  float *cc;
  int cn;
  float cerr;
  float *ctab;
  int icon;

  VALUE c,tab;
  int shape[1];

  ca = NUM2FLT(a);
  cb = NUM2FLT(b);
  if (ca==cb) rb_raise(rb_eRuntimeError,"a==b");
  cepsa = NUM2FLT(epsa);
  if (cepsa<0) rb_raise(rb_eRuntimeError,"epsa<0");
  cepsr = NUM2FLT(epsr);
  if (cepsr<0) rb_raise(rb_eRuntimeError,"epsr<0");
  cnmin = NUM2INT(nmin);
  if (cnmin<0) rb_raise(rb_eRuntimeError,"nmin<0");
  cnmax = NUM2INT(nmax);
  if (cnmax<nmin) rb_raise(rb_eRuntimeError,"nmax<nmin");

  cc = ALLOC_N(float,cnmax);
  if (ca==0)
    ctab = ALLOC_N(float,MAX(3,cnmax-2));
  else
    ctab = ALLOC_N(float,MAX(3,(cnmax-3)/2));
  fcheb_(&ca,&cb,&ssl2_func,&cepsa,&cepsr,&cnmin,&cnmax,cc,&cn,&cerr,ctab,&icon);

  shape[0] = cnmax;
  c = ssl2_getary(cc,1,shape);
  free(cc);
  if (ca==0)
    shape[0] = MAX(3,cnmax-2);
  else
    shape[0] = MAX(3,(cnmax-3)/2);
  tab = ssl2_getary(ctab,1,shape);
  free(ctab);

  ssl2_error(icon);
  return rb_ary_new3(4,c,INT2NUM(cn),FLT2NUM(cerr),tab);
}

static VALUE
rb_echeb(self,a,b,c,v)
     VALUE self,a,b,c,v;
{
  float ca,cb;
  float *cc;
  int n;
  float cv;
  float cf;
  int icon;

  ca = NUM2FLT(a);
  cb = NUM2FLT(b);
  if (ca==cb) rb_raise(rb_eRuntimeError,"a==b");
  cc = ssl2_getcary(c,&n);
  if (n<1) rb_raise(rb_eRuntimeError,"n<1");
  cv = NUM2FLT(v);
  if (cv<a||cv>b) rb_raise(rb_eRuntimeError,"c<a || c>b");

  echeb_(&ca,&cb,cc,&n,&cv,&cf,&icon);
  free(cc);

  ssl2_error(icon);
  return FLT2NUM(cf);
}

static VALUE
rb_gcheb(self,a,b,c)
     VALUE self,a,b,c;
{
  float ca,cb;
  float *cc;
  int n;
  int icon;

  int shape[1];

  ca = NUM2FLT(a);
  cb = NUM2FLT(b);
  if (ca==cb) rb_raise(rb_eRuntimeError,"a==b");
  cc = ssl2_getcary(c,&n);
  if (n<1) rb_raise(rb_eRuntimeError,"n<1");

  gcheb_(&ca,&cb,cc,&n,&icon);

  shape[0] = n-1;
  c = ssl2_getary(cc,1,shape);
  free(cc);

  ssl2_error(icon);
  return c;
}

static VALUE
rb_icheb(self,a,b,c)
     VALUE self,a,b,c;
{
  float ca,cb;
  float *cc;
  int n;
  int icon;

  int shape[1];

  float *cc2;
  int i;

  ca = NUM2FLT(a);
  cb = NUM2FLT(b);
  if (ca==cb) rb_raise(rb_eRuntimeError,"a==b");
  cc = ssl2_getcary(c,&n);
  if (n<0) rb_raise(rb_eRuntimeError,"n<0");
  cc2 = ALLOC_N(float,n+1);
  for (i=0;i<n;i++) cc2[i] = cc[i];
  free(cc);
  n = n+1;

  icheb_(&ca,&cb,cc2,&n,&icon);

  shape[0] = n;
  c = ssl2_getary(cc2,1,shape);
  free(cc2);

  ssl2_error(icon);
  return c;
}


void init_interpolation_approximation(mSSL2)
     VALUE mSSL2;
{
  rb_define_module_function(mSSL2, "aklag", rb_aklag, 5);
  rb_define_module_function(mSSL2, "akher", rb_akher, 6);
  rb_define_module_function(mSSL2, "splv", rb_splv, 5);
  rb_define_module_function(mSSL2, "bif1", rb_bif1, -1);
  rb_define_module_function(mSSL2, "bif2", rb_bif2, -1);
  rb_define_module_function(mSSL2, "bif3", rb_bif3, -1);
  rb_define_module_function(mSSL2, "bif4", rb_bif4, -1);
  rb_define_module_function(mSSL2, "bifd1", rb_bifd1, 10);
  rb_define_module_function(mSSL2, "bifd3", rb_bifd3, 11);
  rb_define_module_function(mSSL2, "akmid", rb_akmid, 7);
  rb_define_module_function(mSSL2, "inspl", rb_inspl, 3);
  rb_define_module_function(mSSL2, "akmin", rb_akmin, 2);
  rb_define_module_function(mSSL2, "bic1", rb_bic1, 4);
  rb_define_module_function(mSSL2, "bic2", rb_bic2, 4);
  rb_define_module_function(mSSL2, "bic3", rb_bic3, 3);
  rb_define_module_function(mSSL2, "bic4", rb_bic4, 3);
  rb_define_module_function(mSSL2, "bicd1", rb_bicd1, 4);
  rb_define_module_function(mSSL2, "bicd3", rb_bicd3, 4);

  rb_define_module_function(mSSL2, "lesq1", rb_lesq1, 4);

  rb_define_module_function(mSSL2, "smle1", rb_smle1, 3);
  rb_define_module_function(mSSL2, "smle2", rb_smle2, 5);
  rb_define_module_function(mSSL2, "bsf1", rb_bsf1, 5);
  rb_define_module_function(mSSL2, "bsc1", rb_bsc1, 5);
  rb_define_module_function(mSSL2, "bsc2", rb_bsc2, 7);
  rb_define_module_function(mSSL2, "bsfd1", rb_bsfd1, 8);
  rb_define_module_function(mSSL2, "bscd2", rb_bscd2, 11);

  rb_define_module_function(mSSL2, "fcosf", rb_fcosf, 5);
  rb_define_module_function(mSSL2, "ecosp", rb_ecosp, 3);
  rb_define_module_function(mSSL2, "fsinf", rb_fsinf, 5);
  rb_define_module_function(mSSL2, "esinp", rb_ecosp, 3);
  rb_define_module_function(mSSL2, "fcheb", rb_fcheb, 6);
  rb_define_module_function(mSSL2, "echeb", rb_echeb, 4);
  rb_define_module_function(mSSL2, "gcheb", rb_gcheb, 3);
  rb_define_module_function(mSSL2, "icheb", rb_icheb, 3);
}
