#include <ruby.h>
#include <math.h>
#include <stdio.h>
#include <narray.h>
#include "ssl2.h"

extern void lminf(float*,float*,float(*)(float*),float*,int*,float*,int*);
extern void lming(float*,float*,float(*)(float*),void(*)(float*,float*),float*,int*,float*,int*);
extern void minf1(float*,int*,float(*)(float*),float*,int*,float*,float*,float*,float*,int*);
extern void ming1(float*,int*,float(*)(float*),void(*)(float*,float*),float*,int*,float*,float*,float*,float*,int*);
extern void nolf1(float*,int*,void(*)(float*,float*),int*,float*,int*,float*,float*,float*,int*,int*);
extern void nolg1(float*,int*,void(*)(float*,float*),void(*)(float*,float*),int*,float*,int*,float*,float*,float*,int*,int*);
extern void lprs1(float*,int*,int*,int*,float*,int*,int*,int*,float*,float*,int*,int*);
extern void nlpg1(float*,int*,float(*)(float*),void(*)(float*,float*),void(*)(float*,float*),void(*)(float*,float*,int*),int*,float*,int*,float*,float*,int*,int*,int*);


static VALUE
rb_lminf(self,a,b,epsr,max)
     VALUE self,a,b,epsr,max;
{
  float ca,cb;
  float cepsr;
  int cmax;
  float cf;
  int icon;

  ca = NUM2FLT(a);
  cb = NUM2FLT(b);
  cepsr = NUM2FLT(epsr);
  if (cepsr<0)
    rb_raise(rb_eRuntimeError, "epsr<0");
  cmax = NUM2INT(max);
  if (cmax==0)
    rb_raise(rb_eRuntimeError, "max==0");

  lminf_(&ca,&cb,&ssl2_func,&cepsr,&cmax,&cf,&icon);

  ssl2_error(icon);
  return rb_ary_new3(2,rb_float_new((double)ca),INT2NUM(cmax));
}

static VALUE
rb_minf1(self,x,epsr,max)
     VALUE self,x,epsr,max;
{
  float *cx;
  int n;
  float cepsr;
  int cmax;
  float cf;
  float *cg,*ch;
  float *vw;
  int icon;

  VALUE g,h;
  int shape[1];

  cx = ssl2_getcary(x,&n);
  if (n<1)
    rb_raise(rb_eRuntimeError, "n<1");
  cepsr = NUM2FLT(epsr);
  if (cepsr<0)
    rb_raise(rb_eRuntimeError, "epsr<0");
  cmax = NUM2INT(max);
  if (cmax==0)
    rb_raise(rb_eRuntimeError, "max==0");

  cg = ALLOC_N(float,n);
  ch = ALLOC_N(float,n*(n+1)/2);
  vw = ALLOC_N(float,3*n+1);
  minf1_(cx,&n,&ssl2_func,&cepsr,&cmax,&cf,cg,ch,vw,&icon);
  free(vw);

  shape[0]=n;
  x = ssl2_getary(cx,1,shape);
  free(cx);
  g = ssl2_getary(cg,1,shape);
  free(cg);
  shape[0]=n*(n+1)/2;
  h = ssl2_getary(ch,1,shape);
  free(ch);

  ssl2_error(icon);
  return rb_ary_new3(5,x,rb_float_new((double)cf),g,h,INT2NUM(cmax));
}

static VALUE
rb_nolf1(self,x,m,epsr,max)
     VALUE self,x,m,epsr,max;
{
  float *cx;
  int n;
  int cm;
  float cepsr;
  int cmax;
  float *cf;
  float csums;
  float *vw;
  int k;
  int icon;

  VALUE f;
  int shape[1];

  cx = ssl2_getcary(x,&n);
  if (n<1)
    rb_raise(rb_eRuntimeError, "n<1");
  cm = NUM2INT(m);
  if (cm<n)
    rb_raise(rb_eRuntimeError, "m<n");
  cepsr = NUM2FLT(epsr);
  if (cepsr<0)
    rb_raise(rb_eRuntimeError, "epsr<0");
  cmax = NUM2INT(max);
  if (cmax==0)
    rb_raise(rb_eRuntimeError, "max==0");

  k = m+n;
  vw = ALLOC_N(float,k*(n+2));
  nolf1_(cx,&n,&ssl2_sub,&m,&cepsr,&cmax,cf,&csums,vw,&k,&icon);
  free(vw);

  shape[0]=n;
  x = ssl2_getary(cx,1,shape);
  free(cx);
  shape[0]=m;
  f = ssh2_getary(cf,1,shape);
  free(cf);

  ssl2_error(icon);
  return rb_ary_new3(4,x,f,rb_float_new((double)csums),INT2NUM(cmax));
}

static VALUE
rb_lprs1(self,a,m,epsz,imax,isw,nbv)
     VALUE self,a,m,epsz,imax,isw,nbv;
{
  float *ca;
  int k;
  int *cm;
  int n;
  float cepsz;
  int cimax,cisw;
  int *cnbv;
  float *cb;
  float *vw;
  int *ivw;
  int icon;

  VALUE b;
  int shape[2];
  int ma;
  int nn;

  cm = ssl2_getcaryi(m,&nn);
  if (nn!=3)
    rb_raise(rb_eRuntimeError, "m.length!=3");
  ma = cm[0]+cm[1]+cm[2];
  if (ma<1)
    rb_raise(rb_eRuntimeError, "m.sum<1");
  ca = ssl2_getcary(a,&nn);
  n = nn/ma;
  if (nn=!ma*n)
    rb_raise(rb_eRuntimeError, "a.length!=n*m.sum");
  if (n<1)
    rb_raise(rb_eRuntimeError, "n<1");
  cepsz = NUM2FLT(epsz);
  if (cepsz<0)
    rb_raise(rb_eRuntimeError, "epsz<0");
  cimax = NUM2INT(imax);
  if (cimax==0)
    rb_raise(rb_eRuntimeError, "imax==0");
  cisw = NUM2INT(isw);
  if (cisw!=0&&cisw!=1&&cisw!=10&&cisw!=11)
    rb_raise(rb_eRuntimeError, "isw must be 0,1,10,or11");
  cnbv = ssl2_getcaryi(nbv,&nn);
  if (nn!=ma)
    rb_raise(rb_eRuntimeError, "nbv.length!=m.sum");

  k=ma+1;
  cb = ALLOC_N(float,k*(ma+1));
  vw = ALLOC_N(float,2*n+ma+cm[0]+cm[1]+1);
  ivw = ALLOC_N(int,n+cm[0]+cm[2]);
  lprs1_(ca,&k,cm,&n,&cepsz,&cimax,&cisw,cnbv,cb,vw,ivw,&icon);
  free(ca);
  free(cm);
  free(vw);
  free(ivw);

  shape[0]=ma;
  nbv = ssl2_getaryi(cnbv,1,shape);
  free(cnbv);
  shape[0]=k;
  shape[1]=k;
  b = ssl2_getary(cb,2,shape);

  ssl2_error(icon);
  return rb_ary_new3(3,nbv,b,INT2NUM(cimax));
}


void init_extrema(mSSL2)
     VALUE mSSL2;
{
  rb_define_module_function(mSSL2, "lminf", rb_lminf, 4);
  rb_define_module_function(mSSL2, "minf1", rb_minf1, 3);
  rb_define_module_function(mSSL2, "nolf1", rb_nolf1, 4);
  rb_define_module_function(mSSL2, "lprs1", rb_lprs1, 6);
}
