#include <ruby.h>

#define NUM2FLT(x) ((float)NUM2DBL(x))
#define FLT2NUM(x) (rb_float_new((double)x))
#define NUM2SCMP(x) (num2scomplex(x))
#define NUM2CMP(x) (num2complex(x))
#define CMP2NUM(x) (rb_funcall(cComplex,rb_intern("new"),2,rb_float_new((double)x.r),rb_float_new((double)x.i)))
#define MAX(x,y) (((x)>(y))?(x):(y))
#define MIN(x,y) (((x)<(y))?(x):(y))

extern VALUE cComplex, cNArray;

#ifndef HAVE_NARRAY_H
typedef struct{ float r,i; } scomplex;
typedef struct{ double r,i; } dcomplex;
#endif

extern scomplex num2scomplex(VALUE);
extern dcomplex num2complex(VALUE);

extern int *ssl2_getcaryi(VALUE, int*);
extern long *ssl2_getcaryl(VALUE, int*);
extern float *ssl2_getcary(VALUE, int*);
extern scomplex *ssl2_getcaryc(VALUE, int*);
extern float *ssl2_getcary_withshape(VALUE, int**, int*);
extern scomplex *ssl2_getcaryc_withshape(VALUE, int**, int*);
extern VALUE ssl2_getaryi(int*, int, int*);
extern VALUE ssl2_getaryl(long*, int, int*);
extern VALUE ssl2_getary(float*, int, int*);
extern VALUE ssl2_getaryc(scomplex*, int, int*);

extern float ssl2_func(float*);
extern void ssl2_sub(float*, float*);

extern void ssl2_error(int);

extern int ssl2_where(float, float*, int);
