require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n = 5
nh = 2

ij = 0
if narray then
  as = NArray.sfloat(n*(n+1)/2)
else
  as = Array.new(n*(n+1)/2)
end
for i in 0..n-1
  for j in 0..i
    if (i-j).abs <= nh then
      as[ij] = i-j+1
    else
      as[ij] = 0
    end
    ij += 1
  end
end

asb = SSL2.cssbm(as,nh)

printf("as: \n")
printf("symmetric matrix format\n")
ij = 0
for i in 0..n-1
  for j in 0..i
    printf("%7.2f  ",as[ij])
    ij += 1
  end
  printf("\n")
end
printf("asb: \n")
printf("symmetric band matrix format\n")
ij = 0
for i in 0..n-1
  jmin = [i-nh,0].max
  for j in jmin..i
    printf("%7.2f  ",asb[ij])
    ij += 1
  end
  printf("\n")
end
