require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n = 5

ij = 0
if narray then
  as = NArray.sfloat(n*(n+1)/2)
else
  as = Array.new(n*(n+1)/2)
end
for i in 0..n-1
  for j in 0..i
    as[ij] = n-i
    ij += 1
  end
end

ag = SSL2.csgm(as)


printf("symmetric matrix format\n")
ij = 0
for i in 0..n-1
  for j in 0..i
    printf("%7.2f  ",as[ij])
    ij += 1
  end
  printf("\n")
end
printf("\n")
printf("general matrix format\n")
for i in 0..n-1
  for j in 0..n-1
    if narray then
      printf("%7.2f  ",ag[j,i])
    else
      printf("%7.2f  ",ag[i][j])
    end
  end
  printf("\n")
end
