require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n = 5
nh = 2
if narray then
  asb = NArray.sfloat(n*(nh+1)-nh*(nh+1)/2)
else
  asb = Array.new(n*(nh+1)-nh*(nh+1)/2)
end
ij = 0
for i in 0..n-1
  jmin = [i-nh,0].max
  for j in jmin..i
    asb[ij] = i-j+1
    ij += 1
  end
end

as = SSL2.csbsm(asb,nh)

printf("asb: \n")
printf("symmetric band matrix format\n")
ij = 0
for i in 0..n-1
  jmin = [i-nh,0].max
  for j in jmin..i
    printf("%7.2f  ",asb[ij])
    ij += 1
  end
  printf("\n")
end
printf("as: \n")
printf("symmetric matrix format\n")
ij = 0
for i in 0..n-1
  for j in 0..i
    printf("%7.2f  ",as[ij])
    ij += 1
  end
  printf("\n")
end
