require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n = 5
nh = 2

ij = 0
if narray then
  asb = NArray.sfloat(n*(nh+1)-nh*(nh+1)/2)
else
  asb = Array.new(n*(nh+1)-nh*(nh+1)/2)
end
for i in 0..n-1
  jmin = [i-nh,0].max
  for j in jmin..i
    asb[ij] = i-j+1
    ij += 1
  end
end

ag = SSL2.csbgm(asb,nh)

printf("asb: \n")
printf("symmetric band matrix\n")
ij = 0
for i in 0..n-1
  jmin = [i-nh,0].max
  for j in jmin..i
    printf("%7.2f  ",asb[ij])
    ij += 1
  end
  printf("\n")
end
printf("ag: \n")
printf("general matrix format\n")
for i in 0..n-1
  for j in 0..n-1
    if narray then
      printf("%7.2f  ",ag[j,i])
    else
      printf("%7.2f  ",ag[i][j])
    end
  end
  printf("\n")
end
