require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n = 5

if narray then
  ag = NArray.sfloat(n,n)
  for i in 0..n-1
    for j in i..n-1
      ag[j,i] = n - i
    end
  end
else
  ag = Array.new(n)
  for i in 0..n-1
    ag[i] = Array.new(n)
  end
  for i in 0..n-1
    for j in 0..n-1
      ag[i][j] = n - i
    end
  end
end

as = SSL2.cgsm(ag)

printf("general matrix format\n")
for i in 0..n-1
  for j in 0..n-1
    if narray then
      printf("%7.2f  ",ag[j,i])
    else
      printf("%7.2f  ",ag[i][j])
    end
  end
  printf("\n")
end
printf("\n")
printf("symmetric matrix format\n")
ij = 0
for i in 0..n-1
  for j in 0..i
    printf("%7.2f  ",as[ij])
    ij += 1
  end
  printf("\n")
end
