require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?


n = 5
nh = 2

if narray then
  ag = NArray.sfloat(n,n).fill(0)
  for i in 0..n-1
    jmax = [i+nh,n-1].min
    for j in i..jmax
      ag[j,i] = j-i+1
    end
  end
else
  ag = Array.new(n)
  for i in 0..n-1
    ag[i] = Array.new(n)
    for j in 0..n-1
      ag[i][j] = 0
    end
    jmax = [i+nh,n-1].min
    for j in i..jmax
      ag[i][j] = j-i+1
    end
  end
end

asb = SSL2.cgsbm(ag,nh)

printf("ag: \n")
printf("general matrix format\n")
for i in 0..n-1
  for j in 0..n-1
    if narray then
      printf("%7.2f  ",ag[j,i])
    else
      printf("%7.2f  ",ag[i][j])
    end
  end
  printf("\n")
end
printf("asb: \n")
printf("symmetric band matrix format\n")
ij = 0;
for i in 0..n-1
  jmin = [i-nh,0].max
  for j in jmin..i
    printf("%7.2f  ",asb[ij])
    ij += 1
  end
  printf("\n")
end
