require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n = 100

if narray then
  a = NArray.sfloat(n,n)
  b = NArray.sfloat(n,n)
  for i in 0..n-1
    for j in 0..n-1
      a[j,i] = n-i-j
      b[j,i] = i+j
    end
  end
else
  a = Array.new(n)
  b = Array.new(n)
  for i in 0..n-1
    a[i] = Array.new(n)
    b[i] = Array.new(n)
    for j in 0..n-1
      a[i][j] = n-i-j
      b[i][j] = i+j
    end
  end
end

c = SSL2.aggm(a,b)

eps = 1e-6
for i in 0..n-1
  for j in 0..n-1
    if narray then
      err = (c[i,j]-n).abs/n
    else
      err = (c[j][i]-n).abs/n
    end
    if err > eps then
      raise("WARNING: result inaccurate")
    end
  end
end
printf("Result OK\n")

  
