require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?


nx=10
ny=10
m=3
if narray then
  x = NArray.sfloat(nx)
  y = NArray.sfloat(nx)
  fxy = NArray.sfloat(nx,ny)
else
  x = Array.new(nx)
  y = Array.new(nx)
  fxy = Array.new(ny)
  for i in 0..fxy.length-1
    fxy[i] = Array.new(nx)
  end
end

px=0
hx=1.0/(nx-1)
for i in 0..nx-1
  x[i] = px
  px += hx
end
py=0
hy=1.0/(ny-1)
for j in 0..ny-1
  y[j] = py
  py += hy
end

for i in 0..nx-1
  for j in 0..ny-1
    px = x[i]
    py = y[j]
    if narray then
      fxy[i,j] = Math::sin(px*py)*Math::sqrt(px*py)
    else
      fxy[j][i] = Math::sin(px*py)*Math::sqrt(px*py)
    end
  end
end


c,xt = SSL2.bicd3(x,y,fxy,m)


ix=nx/2
vx=x[ix]+(x[ix+1]-x[ix])/2
iy=ny/2
vy=y[iy]+(y[iy+1]-y[iy])/2
for iswx in -1..m
  iswy=iswx
  ix,iy,f = SSL2.bifd3(x,y,m,c,xt,iswx,vx,ix,iswy,vy,iy) # ix and iy can be nil
  case iswx
  when -1
    printf("integral = %12.6e\n",f)
  when 0
    printf("value = %12.6e\n",f)
  else
    printf("derivative %i = %12.6e\n",iswx,f)
  end
end

vx = vy = NArray.sfloat(3,2).indgen!.mul!(0.1)
iswy= iswx = 0
ix,iy,f = SSL2.bifd3(x,y,m,c,xt,iswx,vx,nil,iswy,vy,nil)
puts "multiple interpolation:"
p f
