require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n=10
m=3
if narray then
  x = NArray.sfloat(n)
  y = NArray.sfloat(n)
else
  x = Array.new(n)
  y = Array.new(n)
end

pi = Math::PI
p=0
h=2*pi/(n-1)
for i in 0..n-1
  x[i] = p+i*h
  y[i] = Math::sin(x[i])
end


c = SSL2.bic4(x,y,m)


i=4
v=pi
for isw in -1..m
  f, = SSL2.bif4(x,m,c,isw,v)
  case isw
  when -1
    printf("integral = %12.6e\n",f)
  when 0
    printf("value = %12.6e\n",f)
  else
    printf("derivative %i = %12.6e\n",isw,f)
  end
end
