require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n=10
m=3
if narray then
  x = NArray.sfloat(n)
  y = NArray.sfloat(n)
  dy = NArray.sfloat(2,(m-1)/2)
else
  x = Array.new(n)
  y = Array.new(n)
  dy = Array.new((m-1)/2)
  for i in 0..(m-1)/2-1
    dy[i] = Array.new(2)
  end
end

p=0
h=1.0/(n-1)
for i in 0..n-1
  x[i] = p+i*h
  y[i] = x[i]*x[i]*x[i]
end

if narray then
  dy[0,0] = 3*x[0]*x[0]
  dy[1,0] = 3*x[n-1]*x[n-1]
else
  dy[0][0] = 3*x[0]*x[0]
  dy[0][1] = 3*x[n-1]*x[n-1]
end



c = SSL2.bic2(x,y,dy,m)

i=4
v=0.5
for isw in -1..m
  f, = SSL2.bif2(x,m,c,isw,v)
  case isw
  when -1
    printf("integral = %12.6e\n",f)
  when 0
    printf("value = %12.6e\n",f)
  else
    printf("derivative %i = %12.6e\n",isw,f)
  end
end
