require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n=10
m=3
if narray then
  x = NArray.sfloat(n)
  y = NArray.sfloat(n)
else
  x = Array.new(n)
  y = Array.new(n)
end

p=0
h=1.0/n
for i in 0..n-1
  x[i] = p
  y[i] = Math::sin(p)*Math::sqrt(p)
  p += h
end


c,xt = SSL2.bic3(x,y,m)


i=n/2
v=x[i]+(x[i+1]-x[i])/2
for isw in -1..m
  f, = SSL2.bif3(x,m,c,xt,isw,v)
  case isw
  when -1
    printf("integral = %12.6e\n",f)
  when 0
    printf("value = %12.6e\n",f)
  else
    printf("derivative %i = %12.6e\n",isw,f)
  end
end
