require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n=10
if narray then
  x = NArray.sfloat(n)
  y = NArray.sfloat(n)
else
  x = Array.new(n)
  y = Array.new(n)
end

p=0
h=1.0/n
for i in 0..n-1
  x[i] = p
  y[i] = Math::sin(p)*Math::sqrt(p)
  p += h
end


c,d,e = SSL2.akmin(x,y)
k=n/2
v = x[k]+(x[k+1]-x[k])/2
exact = Math::sin(v)*Math::sqrt(v)
h = v-x[k]
f = y[k]+c[k]*h+d[k]*h**2+e[k]*h**3
printf("calculated = %12.6e  exact = %12.6e\n",f,exact)
eps=1e-4
if (f-exact)/exact > eps then
  printf("Inaccurate result\n")
else
  printf("Result OK\n")
end
