require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

nx=10
ny=10
if narray then
  x = NArray.sfloat(nx)
  y = NArray.sfloat(nx)
  fxy = NArray.sfloat(nx,ny)
  vw = NArray.sfloat(50)
else
  x = Array.new(nx)
  y = Array.new(nx)
  fxy = Array.new(ny)
  for i in 0..fxy.length-1
    fxy[i] = Array.new(nx)
  end
  vw = Array.new(50)
end

px=0
hx=1.0/(nx-1)
for i in 0..nx-1
  x[i] = px
  px += hx
end
py=0
hy=1.0/(ny-1)
for j in 0..ny-1
  y[j] = py
  py += hy
end

for i in 0..nx-1
  for j in 0..ny-1
    px = x[i]
    py = y[j]
    if narray then
      fxy[i,j] = Math::sin(px*py)*Math::sqrt(px*py)
    else
      fxy[i][j] = Math::sin(px*py)*Math::sqrt(px*py)
    end
  end
end


ix=nx/2
vx=x[ix]+(x[ix+1]-x[ix])/2
iy=ny/2
vy=y[iy]+(y[iy+1]-y[iy])/2
isw=0
f,vw = SSL2.akmid(x,y,fxy,vx,vy,vw,isw)
printf("f = %12.6e\n",f)
exact = Math::sin(vx*vy)*Math::sqrt(vx*vy)
eps=1e-4
if ((f-exact)/exact) > eps then
  printf("Inaccurate result\n")
else
  printf("Result OK\n");
end
